<?php
/**
 * Footer options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

// Footer Section
$wp_customize->add_section( 'travel_insight_pro_section_footer',
	array(
		'title'      			=> esc_html__( 'Footer Options', 'travel-insight-pro' ),
		'priority'   			=> 900,
		'panel'      			=> 'travel_insight_pro_theme_options_panel',
	)
);

// footer text
$wp_customize->add_setting( 'travel_insight_pro_theme_options[copyright_text]',
	array(
		'default'       		=> $options['copyright_text'],
		'sanitize_callback'		=> 'travel_insight_pro_santize_allow_tag',
		'transport'				=> 'postMessage',
	)
);
$wp_customize->add_control( 'travel_insight_pro_theme_options[copyright_text]',
    array(
		'label'      			=> esc_html__( 'Footer Text', 'travel-insight-pro' ),
		'section'    			=> 'travel_insight_pro_section_footer',
		'type'		 			=> 'textarea',
    )
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'travel_insight_pro_theme_options[copyright_text]', array(
		'selector'            => 'footer#colophon .wrapper .pull-left .site-info p.copyright',
		'settings'            => 'travel_insight_pro_theme_options[copyright_text]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'travel_insight_pro_footer_site_info_copyright',
    ) );
}

// scroll top visible
$wp_customize->add_setting( 'travel_insight_pro_theme_options[scroll_top_visible]',
	array(
		'default'       		=> $options['scroll_top_visible'],
		'sanitize_callback'		=> 'travel_insight_pro_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'travel_insight_pro_theme_options[scroll_top_visible]',
    array(
		'label'      			=> esc_html__( 'Display Scroll Top Button', 'travel-insight-pro' ),
		'section'    			=> 'travel_insight_pro_section_footer',
		'type'		 			=> 'checkbox',
    )
);

// footer logo visible
$wp_customize->add_setting( 'travel_insight_pro_theme_options[footer_logo_enable]',
	array(
		'default'       		=> $options['footer_logo_enable'],
		'sanitize_callback'		=> 'travel_insight_pro_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'travel_insight_pro_theme_options[footer_logo_enable]',
    array(
		'label'      			=> esc_html__( 'Enable Footer Logo', 'travel-insight-pro' ),
		'section'    			=> 'travel_insight_pro_section_footer',
		'type'		 			=> 'checkbox',
    )
);

// About us Template Slider setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[footer_logo]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_image',
) );

$wp_customize->add_control(
	new WP_Customize_Image_Control( $wp_customize, 'travel_insight_pro_theme_options[footer_logo]',
		array(
		'label'       		=> esc_html__( 'Select Footer Logo', 'travel-insight-pro' ),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'travel-insight-pro' ), 115, 60 ),
		'section'     		=> 'travel_insight_pro_section_footer',
		'active_callback'   => 'travel_insight_pro_is_footer_logo_enable',
) ) );

// About us Template Slider setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[footer_background]', array(
	'sanitize_callback' => 'travel_insight_pro_sanitize_image',
	'default'          	=> $options['footer_background'],
) );

$wp_customize->add_control(
	new WP_Customize_Image_Control( $wp_customize, 'travel_insight_pro_theme_options[footer_background]',
		array(
		'label'       		=> esc_html__( 'Select Footer Background', 'travel-insight-pro' ),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'travel-insight-pro' ), 1920, 1080 ),
		'section'     		=> 'travel_insight_pro_section_footer',
) ) );