<?php
/**
 * Reset options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

/**
* Reset section
*/
// Add reset enable section
$wp_customize->add_section( 'travel_insight_pro_reset_section', array(
	'title'             => esc_html__('Reset all settings','travel-insight-pro'),
	'description'       => esc_html__( 'Caution: All customizer settings will be reset to default. Refresh the page after clicking Save & Publish.', 'travel-insight-pro' ),
) );

// Add reset enable setting and control.
$wp_customize->add_setting( 'travel_insight_pro_theme_options[reset_options]', array(
	'default'           => $options['reset_options'],
	'sanitize_callback' => 'travel_insight_pro_sanitize_checkbox',
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'travel_insight_pro_theme_options[reset_options]', array(
	'label'             => esc_html__( 'Check to reset all settings', 'travel-insight-pro' ),
	'section'           => 'travel_insight_pro_reset_section',
	'type'              => 'checkbox',
) );
