<?php
/**
 * Typography options
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

// Typography Section
$wp_customize->add_section( 'travel_insight_pro_section_typography',
	array(
		'title'      		=> esc_html__( 'Typography', 'travel-insight-pro' ),
		'priority'   		=> 600,
		'panel'      		=> 'travel_insight_pro_theme_options_panel',
	)
);

$wp_customize->add_setting( 'travel_insight_pro_theme_options[theme_typography]',
	array(
		'default'    		=> $options['theme_typography'],
		'sanitize_callback'	=> 'travel_insight_pro_sanitize_select',
	)
);
$wp_customize->add_control( 'travel_insight_pro_theme_options[theme_typography]',
    array(
		'label'       		=> esc_html__( 'Choose Heading Typography', 'travel-insight-pro' ),
		'section'     		=> 'travel_insight_pro_section_typography',
		'settings'    		=> 'travel_insight_pro_theme_options[theme_typography]',
		'type'		  		=> 'select',
		'choices'			=> travel_insight_pro_typography_options(),
    )
);

$wp_customize->add_setting( 'travel_insight_pro_theme_options[theme_body_typography]',
	array(
		'default'    		=> $options['theme_body_typography'],
		'sanitize_callback'	=> 'travel_insight_pro_sanitize_select',
	)
);
$wp_customize->add_control( 'travel_insight_pro_theme_options[theme_body_typography]',
    array(
		'label'       		=> esc_html__( 'Choose Paragraph Typography', 'travel-insight-pro' ),
		'section'     		=> 'travel_insight_pro_section_typography',
		'settings'    		=> 'travel_insight_pro_theme_options[theme_body_typography]',
		'type'		  		=> 'select',
		'choices'			=> travel_insight_pro_body_typography_options(),
    )
);
