<?php
/**
 * themepalace OCDI plugin compatible functions
 *
 * @package themepalace
 */

function travel_insight_pro_ctdi_plugin_page_setup( $default_settings ) {
    $default_settings['menu_title']  = esc_html__( 'Theme Palace Demo Import' , 'travel-insight-pro' );

    return $default_settings;
}
add_filter( 'cp-ctdi/plugin_page_setup', 'travel_insight_pro_ctdi_plugin_page_setup' );


function travel_insight_pro_ctdi_import_files() {
    return array(
        array(
            'import_file_name'             => esc_html__( 'Free', 'travel-insight-pro' ),
            'categories'                   => array( ),
            'local_import_file'            => get_template_directory() . '/assets/demo/free/content.xml',
            'local_import_widget_file'     => get_template_directory() . '/assets/demo/free/widgets.wie',
            'local_import_customizer_file' => get_template_directory() . '/assets/demo/free/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/assets/demo/free/screenshot.png',
            'import_notice'                => esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported.', 'travel-insight-pro' ),
            'preview_url'                  => 'https://themepalacedemo.com/travel_insight',
        ),
        array(
            'import_file_name'             => esc_html__( 'Pro', 'travel-insight-pro' ),
            'categories'                   => array( ),
            'local_import_file'            => get_template_directory() . '/assets/demo/pro/content.xml',
            'local_import_widget_file'     => get_template_directory() . '/assets/demo/pro/widgets.wie',
            'local_import_customizer_file' => get_template_directory() . '/assets/demo/pro/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/assets/demo/pro/screenshot.png',
            'import_notice'                => esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported.', 'travel-insight-pro' ),
            'preview_url'                  => 'https://themepalacedemo.com/travel-insight-pro',
        ),
        array(
            'import_file_name'             => esc_html__( 'Dark', 'travel-insight-pro' ),
            'categories'                   => array( ),
            'local_import_file'            => get_template_directory() . '/assets/demo/dark/content.xml',
            'local_import_widget_file'     => get_template_directory() . '/assets/demo/dark/widgets.wie',
            'local_import_customizer_file' => get_template_directory() . '/assets/demo/dark/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/assets/demo/dark/screenshot.png',
            'import_notice'                => esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported.', 'travel-insight-pro' ),
            'preview_url'                  => 'https://themepalacedemo.com/travel-insight-pro-dark',
        ),
        array(
            'import_file_name'             => esc_html__( 'Business', 'travel-insight-pro' ),
            'categories'                   => array( ),
            'local_import_file'            => get_template_directory() . '/assets/demo/business/content.xml',
            'local_import_widget_file'     => get_template_directory() . '/assets/demo/business/widgets.wie',
            'local_import_customizer_file' => get_template_directory() . '/assets/demo/business/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/assets/demo/business/screenshot.png',
            'import_notice'                => esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported.', 'travel-insight-pro' ),
            'preview_url'                  => 'https://themepalacedemo.com/travel-insight-business',
        ),
        array(
            'import_file_name'             => esc_html__( 'Magazine', 'travel-insight-pro' ),
            'categories'                   => array( ),
            'local_import_file'            => get_template_directory() . '/assets/demo/magazine/content.xml',
            'local_import_widget_file'     => get_template_directory() . '/assets/demo/magazine/widgets.wie',
            'local_import_customizer_file' => get_template_directory() . '/assets/demo/magazine/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/assets/demo/magazine/screenshot.png',
            'import_notice'                => esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported.', 'travel-insight-pro' ),
            'preview_url'                  => 'https://themepalacedemo.com/travel-insight-magazine',
        ),
        array(
            'import_file_name'             => esc_html__( 'Blog', 'travel-insight-pro' ),
            'categories'                   => array( ),
            'local_import_file'            => get_template_directory() . '/assets/demo/blog/content.xml',
            'local_import_widget_file'     => get_template_directory() . '/assets/demo/blog/widgets.wie',
            'local_import_customizer_file' => get_template_directory() . '/assets/demo/blog/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/assets/demo/blog/screenshot.png',
            'import_notice'                => esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported.', 'travel-insight-pro' ),
            'preview_url'                  => 'https://themepalacedemo.com/travel-insight-blog',
        ),
       array(
            'import_file_name'             => esc_html__( 'Shop', 'travel-insight-pro' ),
            'categories'                   => array( ),
            'local_import_file'            => get_template_directory() . '/assets/demo/shop/content.xml',
            'local_import_widget_file'     => get_template_directory() . '/assets/demo/shop/widgets.wie',
            'local_import_customizer_file' => get_template_directory() . '/assets/demo/shop/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/assets/demo/shop/screenshot.png',
            'import_notice'                => esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported.', 'travel-insight-pro' ),
            'preview_url'                  => 'https://themepalacedemo.com/travel-insight-shop',
        ),
       array(
            'import_file_name'             => esc_html__( 'education', 'travel-insight-pro' ),
            'categories'                   => array( ),
            'local_import_file'            => get_template_directory() . '/assets/demo/education/content.xml',
            'local_import_widget_file'     => get_template_directory() . '/assets/demo/education/widgets.wie',
            'local_import_customizer_file' => get_template_directory() . '/assets/demo/education/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/assets/demo/education/screenshot.png',
            'import_notice'                => esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported.', 'travel-insight-pro' ),
            'preview_url'                  => 'https://themepalacedemo.com/travel-insight-education',
        ),
        array(
            'import_file_name'             => esc_html__( 'charity', 'travel-insight-pro' ),
            'categories'                   => array( ),
            'local_import_file'            => get_template_directory() . '/assets/demo/charity/content.xml',
            'local_import_widget_file'     => get_template_directory() . '/assets/demo/charity/widgets.wie',
            'local_import_customizer_file' => get_template_directory() . '/assets/demo/charity/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/assets/demo/charity/screenshot.png',
            'import_notice'                => esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported.', 'travel-insight-pro' ),
            'preview_url'                  => 'https://themepalacedemo.com/travel-insight-charity',
        ),
    );
}
add_filter( 'cp-ctdi/import_files', 'travel_insight_pro_ctdi_import_files' );



function travel_insight_pro_ctdi_after_import_setup() {
    // Assign menus to their locations.
    $main_menu = get_term_by( 'name', 'Primary', 'nav_menu' );
    $social = get_term_by('name', 'Social', 'nav_menu');
    $footer = get_term_by('name', 'Footer', 'nav_menu');

    set_theme_mod( 'nav_menu_locations', array(
            'primary' => $main_menu->term_id,
            'social' => $social->term_id,
            'footer' => $footer->term_id,
        )
    );

    // Assign front page and posts page (blog page).
    $front_page_id = get_page_by_title( 'Home' );
    $blog_page_id  = get_page_by_title( 'Blog' );

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'page_for_posts', $blog_page_id->ID );

}
add_action( 'cp-ctdi/after_import', 'travel_insight_pro_ctdi_after_import_setup' );
