<?php
/**
 * Travel Insight Pro category metabox file.
 *
 * This is the template that includes all the other files for metaboxes of Travel Insight Pro theme
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

/**
 * Add meta box to the new category page.
 */
// Add term page
function travel_insight_pro_taxonomy_add_new_meta_field() {
    // this will add the custom meta field to the add new term page
    ?>
    <div class="form-field">
        <label for="term_meta[custom_term_meta]"><?php esc_html_e( 'Select Icon', 'travel-insight-pro' ); ?></label>
        <select name="term_meta[custom_term_meta]" id="term_meta[custom_term_meta]">
            <?php $icon_options = travel_insight_pro_icons_options();
            foreach ( $icon_options as $field => $value ) : ?>
                <option value="<?php echo esc_attr( $field ); ?>">
                    <?php echo esc_html( $value ); ?>
                </option>
            <?php endforeach; ?>
        </select>
        <p class="description"><?php esc_html_e( 'Select appropriate icon for the category.', 'travel-insight-pro' ); ?></p>
    </div>
<?php
}
add_action( 'category_add_form_fields', 'travel_insight_pro_taxonomy_add_new_meta_field', 10, 2 );


/**
 * Edit meta box to the term category page.
 */
function travel_insight_pro_taxonomy_edit_meta_field($term) {
 
    // put the term ID into a variable
    $t_id = $term->term_id;

    // retrieve the existing value(s) for this meta field. This returns an array
    $term_meta = get_term_meta( $t_id, 'custom_term_meta', true );
    $selected = isset( $term_meta ) ? $term_meta : '';
    ?>
    <tr class="form-field">
    <th scope="row" valign="top"><label for="custom_term_meta"><?php esc_html_e( 'Icon', 'travel-insight-pro' ); ?></label></th>
        <td>
            <select name="custom_term_meta" id="custom_term_meta">
                <?php $icon_options = travel_insight_pro_icons_options();
                foreach ( $icon_options as $field => $value ) : ?>
                    <option value="<?php echo esc_attr( $field ); ?>" <?php selected( $selected, $field, true ) ?>><?php echo esc_html( $value ); ?></option>
                <?php endforeach; ?>
            </select>
            <p class="description"><?php esc_html_e( 'Select appropriate icon for the category.', 'travel-insight-pro' ); ?></p>
        </td>
    </tr>
<?php
}
add_action( 'category_edit_form_fields', 'travel_insight_pro_taxonomy_edit_meta_field', 10, 2 );

/**
 * Save meta data callback function.
 */
function travel_insight_pro_save_taxonomy_custom_meta( $term_id ) {
    if ( isset( $_POST['custom_term_meta'] ) ) {
        $t_id = $term_id;
        $term_meta = get_term_meta( $t_id, 'custom_term_meta', true );
        $term_meta = sanitize_text_field( wp_unslash( $_POST['custom_term_meta'] ) );

        // Save the option array.
        update_term_meta( $t_id, 'custom_term_meta', $term_meta );
        if ( $a){  var_dump('dome');die();}
    }
}  

add_action( 'edited_category', 'travel_insight_pro_save_taxonomy_custom_meta', 10, 2 );  
add_action( 'create_category', 'travel_insight_pro_save_taxonomy_custom_meta', 10, 2 );

if ( class_exists( 'TP_Travel_Package' ) ) :
    add_action( 'tp-package-category_add_form_fields', 'travel_insight_pro_taxonomy_add_new_meta_field', 10, 2 );
    add_action( 'tp-package-category_edit_form_fields', 'travel_insight_pro_taxonomy_edit_meta_field', 10, 2 );
    add_action( 'edited_tp-package-category', 'travel_insight_pro_save_taxonomy_custom_meta', 10, 2 );  
    add_action( 'create_tp-package-category', 'travel_insight_pro_save_taxonomy_custom_meta', 10, 2 );
endif;

if ( class_exists( 'WP_Travel' ) ) :
    add_action( 'itinerary_types_add_form_fields', 'travel_insight_pro_taxonomy_add_new_meta_field', 10, 2 );
    add_action( 'itinerary_types_edit_form_fields', 'travel_insight_pro_taxonomy_edit_meta_field', 10, 2 );
    add_action( 'edited_itinerary_types', 'travel_insight_pro_save_taxonomy_custom_meta', 10, 2 );  
    add_action( 'create_itinerary_types', 'travel_insight_pro_save_taxonomy_custom_meta', 10, 2 );

    add_action( 'activity_add_form_fields', 'travel_insight_pro_taxonomy_add_new_meta_field', 10, 2 );
    add_action( 'activity_edit_form_fields', 'travel_insight_pro_taxonomy_edit_meta_field', 10, 2 );
    add_action( 'edited_activity', 'travel_insight_pro_save_taxonomy_custom_meta', 10, 2 );  
    add_action( 'create_activity', 'travel_insight_pro_save_taxonomy_custom_meta', 10, 2 );

    add_action( 'travel_locations_add_form_fields', 'travel_insight_pro_taxonomy_add_new_meta_field', 10, 2 );
    add_action( 'travel_locations_edit_form_fields', 'travel_insight_pro_taxonomy_edit_meta_field', 10, 2 );
    add_action( 'edited_travel_locations', 'travel_insight_pro_save_taxonomy_custom_meta', 10, 2 );  
    add_action( 'create_travel_locations', 'travel_insight_pro_save_taxonomy_custom_meta', 10, 2 );
endif;