<?php 
/**
 * Articles section
 *
 * This is the template for the content of articles section
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */
if ( ! function_exists( 'travel_insight_pro_add_articles_section' ) ) :
    /**
    * Add articles section
    *
    *@since Travel Insight Pro 1.0
    */
    function travel_insight_pro_add_articles_section() {
        $options = travel_insight_pro_get_theme_options();

        // Check if articles is enabled
        $enable_articles = apply_filters( 'travel_insight_pro_section_status', true, 'articles_enable' );

        if ( true !== $enable_articles ) {
            return false;
        }

        // Get articles section details
        $section_details = array();
        $section_details = apply_filters( 'travel_insight_pro_filter_articles_section_details', $section_details );
        if ( empty( $section_details ) ) {
            return;
        }
        // Render articles section now.
        travel_insight_pro_render_articles_section( $section_details );
    }
endif;



if ( ! function_exists( 'travel_insight_pro_get_articles_section_details' ) ) :
    /**
    * articles section details.
    *
    * @since Travel Insight Pro 1.0
    * @param array $input articles section details.
    */
    function travel_insight_pro_get_articles_section_details( $input ) {
        $options = travel_insight_pro_get_theme_options();

        // articles type
        $articles_content_type  = $options['articles_content_type'];

        $content = array();
        switch ( $articles_content_type ) {
            case 'demo':
                for ( $i = 1; $i <= 3; $i++ ) {
                    $content[$i][2]['id'] = $content[$i][1]['id'] = '';
                    $content[$i][2]['title'] = $content[$i][1]['title'] = esc_html__( 'Make the most of your life time a great adventure.', 'travel-insight-pro' );
                    $content[$i][2]['url'] = $content[$i][1]['url'] = '#';
                    $content[$i][2]['date_url'] = $content[$i][1]['date_url'] = '#';
                    $content[$i][2]['date'] = $content[$i][1]['date'] = esc_html__( '13 Dec 2016', 'travel-insight-pro' );
                    $content[$i][2]['excerpt'] = $content[$i][1]['excerpt'] = esc_html__( 'Nunc convallis risus at ultricies sodales. Donec volutpat sed enim sed finibus. Proin vehicula, ligula vitae feugiat porta, magna dui viverra odio, nec fermentum mi ex eu nisl. Ut sed arcu nunc. In ullamcorper tincidunt est, ac interdum enim luctus quis. Morbi imperdiet magna in lacinia porttitor. Donec vitae consectetur neque. In commodo eros quis elit varius pellentesque. Nunc convallis risus at ultricies sodales. Donec volutpat sed enim sed finibus. Proin vehicula, ligula vitae feugiat porta, magna dui viverra odio, nec fermentum mi ex eu nisl. Ut sed arcu nunc. In ullamcorper tincidunt est, ac interdum enim luctus quis. Morbi imperdiet magna in lacinia porttitor. Donec vitae consectetur neque. In commodo eros quis elit varius pellentesque.', 'travel-insight-pro' );
                }
                
            break;     

            case 'category':
                $cat_ids = array();
                for ( $i = 1; $i <= $options['no_of_articles_category']; $i++ ) {
                    if ( ! empty( $options['articles_content_category_' . $i] ) ) {
                        $cat_ids[] = $options['articles_content_category_' . $i];
                    }
                }

                // Bail if no valid pages are selected.
                if ( empty( $cat_ids ) ) {
                    return $input;
                } else {
                    $cat_ids = ( array ) $cat_ids;
                }

                $index = 1;

                foreach ( $cat_ids as $cat_id ) :
                    $args = array(
                        'no_found_rows'  => true,
                        'cat'            => $cat_id,
                        'post_type'      => 'post',
                        'posts_per_page'  => absint( $options['no_of_articles'] ),
                    );

                    $posts = get_posts( $args );
                    if ( ! empty( $posts ) ) :
                        $i = 1;
                        foreach ( $posts as $post ) :
                            $post_id = $post->ID;
                            $year  = get_the_time( 'Y', $post_id );
                            $month = get_the_time( 'm', $post_id );
                            $content[$index][$i]['id']          = $post_id;
                            $content[$index][$i]['title']       = get_the_title( $post_id );
                            $content[$index][$i]['url']         = get_the_permalink( $post_id );
                            $content[$index][$i]['date_url']    = get_month_link( $year, $month );
                            $content[$index][$i]['date']        = get_the_date( 'd M Y', $post_id );
                            $content[$index][$i]['excerpt']     = travel_insight_pro_trim_content( 150, $post );
                            $i++;
                        endforeach;
                    endif;
                    $index++;
                endforeach;
            break;
        }
        // var_dump($content);
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// articles section content details.
add_filter( 'travel_insight_pro_filter_articles_section_details', 'travel_insight_pro_get_articles_section_details' );

if ( ! function_exists( 'travel_insight_pro_article_id' ) ) :
    /**
    * Add articles section
    *
    *@since Travel Insight Pro 1.0
    */
    function travel_insight_pro_article_id( $i = '' ) {
        $options = travel_insight_pro_get_theme_options();

        // articles type
        $articles_content_type  = $options['articles_content_type'];

            if ( 'demo' == $articles_content_type ) :
                if ( $i == 1 ) :
                    return 'articles';
                elseif ( $i == 2 ) :
                    return 'history';
                elseif ( $i == 3 ) :
                    return 'testimonials';
                endif;
             elseif ( 'category' == $articles_content_type ) :
                for ( $val = 1; $val <= $options['no_of_articles_category']; $val++ ) {
                    if ( ! empty( $options['articles_content_category_' . $val] ) ) {
                        $category = get_category( $options['articles_content_category_' . $val] );
                        $category_slug[] = $category->slug;
                    }
                }
                return $category_slug[$i - 1];
            endif;
            
    }
endif;

if ( ! function_exists( 'travel_insight_pro_render_articles_section' ) ) :
    /**
    * Start articles section
    *
    * @return string articles content
    * @since Travel Insight Pro 1.0
    *
    */
    function travel_insight_pro_render_articles_section( $content_details ) {
        $options = travel_insight_pro_get_theme_options();
        $articles_content_type  = $options['articles_content_type'];
        $image_alignment = ! empty( $options['articles_alignment'] ) ? $options['articles_alignment'] : 'align-left';
        $background_image = ! empty( $options['articles_background'] ) ? $options['articles_background'] : get_template_directory_uri() . '/assets/uploads/background-02.jpg';
      
        if ( empty( $content_details ) ) {
            return;
        }

        $i = 1;
        ?>
        <section id="adventure" class="page-section no-padding-bottom">
            <div class="wrapper">
                <div class="tab-menu">
                    <ul class="nav-tabs clear">
                        <?php if ( 'demo' == $articles_content_type ) : ?>
                            <li class="active"><a href="#articles"><?php esc_html_e( '01.Articles', 'travel-insight-pro' ); ?></a></li>
                            <li><a href="#history"><?php esc_html_e( '02.History', 'travel-insight-pro' ); ?></a></li>
                            <li><a href="#testimonials"><?php esc_html_e( '03.Testimonials', 'travel-insight-pro' ); ?></a></li>
                        <?php elseif ( 'category' == $articles_content_type ) : 
                            for ( $val = 1; $val <= $options['no_of_articles_category']; $val++ ) {
                                if ( ! empty( $options['articles_content_category_' . $val] ) ) {
                                    $category_list = get_category( $options['articles_content_category_' . $val] );
                                    ?>
                                    <li class="<?php echo ( $val == 1 ) ? 'active' : ''; ?>"><a href="#<?php echo esc_attr( $category_list->slug ); ?>">
                                        <?php 
                                        printf( esc_html__( '0%d. ', 'travel-insight-pro' ), $val );
                                        echo esc_html( $category_list->name ); 
                                        ?>
                                    </a></li>
                                <?php }
                            }
                        endif; ?>
                    </ul><!--.tabs-->
                </div><!-- .tab-menu -->
                <div class="tab-content-wrapper">
                    <?php foreach ( $content_details as $content_detail ) : 
                        $count = 1;
                        if ( ! empty( $content_detail[$count] ) ) : ?>
                            <div id="<?php echo esc_attr( travel_insight_pro_article_id( $i ) ); ?>" class="tab-pane <?php echo ( $i == 1 ) ? 'active' : ''; ?>">
                                <div class="tab-slider" data-slick='{"slidesToShow": 1, "slidesToScroll": 1, "infinite": false, "speed": 800, "dots": false, "arrows":true, "autoplay": false, "fade": false, "draggable":true}'>
                                    <?php foreach ( $content_detail as $content ) : ?>
                                        <div class="tab-slider-item">    
                                            <a href="<?php echo esc_url( $content['date_url'] ); ?>">
                                                <time><?php echo esc_html( $content['date'] ); ?></time>
                                            </a>
                                            <?php  
                                            $tags = get_the_tags( $content['id'] );
                                            if ( ! empty( $tags ) ) : ?>
                                                <div class="article-tags">
                                                    <?php foreach ( $tags as $tag ) : ?>
                                                        <a href="<?php echo esc_url( get_tag_link( $tag->term_id ) ); ?>" rel="tag"><?php echo esc_html( $tag->name ); ?></a>
                                                    <?php endforeach; ?>
                                                </div>
                                            <?php endif; ?>

                                            <header class="entry-header">
                                                <h2 class="entry-title">
                                                <a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                            </header><!-- .entry-header -->

                                            <div class="entry-content">
                                                <p><?php echo esc_html( $content['excerpt'] ); ?></p>
                                            </div><!-- .entry-content -->
                                        </div><!-- .tab-slider-item -->
                                    <?php $count++; endforeach; ?>
                                </div><!-- .tab-slider -->
                            </div><!--.tab-1-->
                        <?php $i++; endif; 
                    endforeach; ?>
                </div><!--.tab-content-wrapper-->
            </div><!-- .wrapper -->

            <div class="parallax" style="background-image: url('<?php echo esc_url( $background_image ); ?>">
            </div>
        </section><!-- #adventure -->

    <?php }
endif;