<?php 
/**
 * Counter section
 *
 * This is the template for the content of counter section
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */
if ( ! function_exists( 'travel_insight_pro_add_counter_section' ) ) :
    /**
    * Add counter section
    *
    *@since Travel Insight Pro 1.0
    */
    function travel_insight_pro_add_counter_section() {
        $options = travel_insight_pro_get_theme_options();

        // Check if counter is enabled
        $enable_counter = apply_filters( 'travel_insight_pro_section_status', true, 'counter_enable' );

        if ( true !== $enable_counter ) {
            return false;
        }

        // Get counter section details
        $section_details = array();
        $section_details = apply_filters( 'travel_insight_pro_filter_counter_section_details', $section_details );
        if ( empty( $section_details ) ) {
            return;
        }
        // Render counter section now.
        travel_insight_pro_render_counter_section( $section_details );
    }
endif;



if ( ! function_exists( 'travel_insight_pro_get_counter_section_details' ) ) :
    /**
    * counter section details.
    *
    * @since Travel Insight Pro 1.0
    * @param array $input counter section details.
    */
    function travel_insight_pro_get_counter_section_details( $input ) {
        $options = travel_insight_pro_get_theme_options();

        // counter type
        $counter_content_type  = $options['counter_content_type'];

        $content = array();
        switch ( $counter_content_type ) {
            case 'demo':
                $title = array(
                    1 => esc_html__( 'Discerning Travelers', 'travel-insight-pro' ),
                    2 => esc_html__( 'Amazing Tours', 'travel-insight-pro' ),
                    3 => esc_html__( 'Holiday Packages', 'travel-insight-pro' ),
                    4 => esc_html__( 'Our team', 'travel-insight-pro' ),
                    );
                $value = array(
                    1 => esc_html__( '715', 'travel-insight-pro' ),
                    2 => esc_html__( '208', 'travel-insight-pro' ),
                    3 => esc_html__( '329', 'travel-insight-pro' ),
                    4 => esc_html__( '71', 'travel-insight-pro' ),
                    );
                for ( $i = 1; $i <= 4; $i++ ) {
                    $content[$i]['title']    = $title[$i];
                    $content[$i]['value']    = $value[$i];
                }
            break;     

            case 'custom':
                for ( $i = 1; $i <= 4; $i++ ) {
                    $content[$i]['title']    = ! empty( $options['counter_title_' . $i] ) ? $options['counter_title_' . $i] : $options['counter_title'];
                    $content[$i]['value']    = ! empty( $options['counter_value_' . $i] ) ? (int) $options['counter_value_' . $i] : (int) $options['counter_value'];
                }
            break;    

        }

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// counter section content details.
add_filter( 'travel_insight_pro_filter_counter_section_details', 'travel_insight_pro_get_counter_section_details' );


if ( ! function_exists( 'travel_insight_pro_render_counter_section' ) ) :
    /**
    * Start counter section
    *
    * @return string counter content
    * @since Travel Insight Pro 1.0
    *
    */
    function travel_insight_pro_render_counter_section( $content_details ) {
        $options = travel_insight_pro_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        }
        ?>
        <section id="counter" class="col-4 text-center page-section">
            <div class="wrapper">
                <?php foreach ( $content_details as $content_detail ) : ?>
                    <div class="column-wrapper">
                        <div class="statwrap">
                            <span class="stat-count"><?php echo absint( $content_detail['value'] ); ?></span>
                            <small><?php echo esc_html( $content_detail['title'] ); ?></small>
                        </div><!-- .statwrap -->
                    </div><!-- .column-wrapper-->
                <?php endforeach; ?>
            </div><!-- .wrapper -->
        </section><!-- #counter -->
    <?php }
endif;