<?php 
/**
 * Gallery section
 *
 * This is the template for the content of gallery section
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */
if ( ! function_exists( 'travel_insight_pro_add_gallery_section' ) ) :
    /**
    * Add gallery section
    *
    *@since Travel Insight Pro 1.0
    */
    function travel_insight_pro_add_gallery_section() {
        $options = travel_insight_pro_get_theme_options();

        // Check if gallery is enabled
        $enable_gallery = apply_filters( 'travel_insight_pro_section_status', true, 'gallery_enable' );

        if ( true !== $enable_gallery ) {
            return false;
        }

        // Get gallery section details
        $section_details = array();
        $section_details = apply_filters( 'travel_insight_pro_filter_gallery_section_details', $section_details );

        // Render gallery section now.
        travel_insight_pro_render_gallery_section( $section_details );
    }
endif;



if ( ! function_exists( 'travel_insight_pro_get_gallery_section_details' ) ) :
    /**
    * gallery section details.
    *
    * @since Travel Insight Pro 1.0
    * @param array $input gallery section details.
    */
    function travel_insight_pro_get_gallery_section_details( $input ) {
        $options = travel_insight_pro_get_theme_options();

        // gallery type
        $gallery_content_type  = $options['gallery_content_type'];

        $content = array();
        switch ( $gallery_content_type ) {
            case 'demo':
                for ($i = 1; $i <=13; $i++) { 
                    $terms = array( 'cat2', 'cat3', 'cat4', 'cat5', 'cat6' );
                    $terms_rand = array_rand( $terms, 3 );
                    $content[$i]['img_array'][0]       = get_template_directory_uri().'/assets/uploads/gallery-0'. str_replace( array( 5, 6, 7, 8, 9, 10, 11, 12, 13 ) , array( 2, 3, 4, 2, 3, 4, 2, 3, 4 ), $i ) .'.jpg';
                    $content[$i]['img_array_large'][0] = get_template_directory_uri().'/assets/uploads/gallery-0'. str_replace( array( 5, 6, 7, 8, 9, 10, 11, 12, 13 ) , array( 2, 3, 4, 2, 3, 4, 2, 3, 4 ), $i ) .'.jpg';
                    $content[$i]['url']         = '#';
                    $content[$i]['title']       = sprintf( esc_html__( 'Gallery Image %d', 'travel-insight-pro' ), $i );
                    $content[$i]['terms']       = ( 1 == $i ) ? esc_attr__( 'cat1 cat3 cat5', 'travel-insight-pro' ) : $terms[$terms_rand[0]] . ' ' . $terms[$terms_rand[1]] . ' ' . $terms[$terms_rand[2]];
                }

            break;

            case 'category':
                $cat_ids = ! empty( $options['gallery_content_category'] ) ? $options['gallery_content_category'] : array();

                // Bail if no valid pages are selected.
                if ( empty( $cat_ids ) ) {
                    return $input;
                } else {
                    $cat_ids = ( array ) $cat_ids;
                }
                 $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => -1,
                    'category__in'      => $cat_ids,
                );

            break;
        }

        if( $gallery_content_type != 'demo' ) :
            $i = 1; 
            $posts = get_posts( $args );
            foreach ( $posts as $post ) :
                $post_id = $post->ID;
                $img_array = null;
                if ( ! has_post_thumbnail( $post_id ) ) $i = $i-1;
                if ( has_post_thumbnail( $post_id ) ) {
                    if ( $i == 1 ) {
                        $img_array = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), 'medium_large' );
                    }
                    else {
                        $img_array = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), 'post-thumbnail' );
                    }

                    $cats = '';
                    $categories = get_the_category( $post_id );
                    foreach ( $categories as $category ) {
                        $cats .= $category->slug . ' '; 
                    }

                    $img_array_large = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), 'full' );

                    $content[$i]['img_array']       = $img_array;
                    $content[$i]['img_array_large'] = $img_array_large;
                    $content[$i]['title']           = get_the_title( $post_id );
                    $content[$i]['url']             = get_the_permalink( $post_id );
                    $content[$i]['terms']           = $cats;
                }

                $i++;
            endforeach;
        endif;

        $input = $content;
        return $input;
    }
endif;
// gallery section content details.
add_filter( 'travel_insight_pro_filter_gallery_section_details', 'travel_insight_pro_get_gallery_section_details' );


if ( ! function_exists( 'travel_insight_pro_render_gallery_section' ) ) :
    /**
    * Start gallery section
    *
    * @return string gallery content
    * @since Travel Insight Pro 1.0
    *
    */
    function travel_insight_pro_render_gallery_section( $content_details ) {
        $options = travel_insight_pro_get_theme_options();
        $gallery_content_type  = $options['gallery_content_type'];
        $title = ! empty( $options['gallery_title'] ) ? $options['gallery_title'] : ''; 
        $sub_title = ! empty( $options['gallery_sub_title'] ) ? $options['gallery_sub_title'] : ''; 
      
        $i = 1;
        ?>
        <section id="portfolio-gallery" class="col-2 page-section">
            <?php if ( ! empty( $title ) || ! empty( $sub_title ) ) : ?>
                <div class="wrapper">
                    <header class="entry-header text-center">
                        <?php if ( ! empty( $title ) ) : ?>
                            <h2 class="entry-title"><?php echo esc_html( $title ); ?></h2>
                        <?php endif; 
                        if ( ! empty( $sub_title ) ) : ?>
                            <h3 class="sub-title"><?php echo esc_html( $sub_title ); ?></h3>
                        <?php endif; ?>
                    </header><!-- .entry-header -->
                </div><!-- .wrapper -->
            <?php endif; ?>

            <div class="entry-content">
                <div class="wrapper">
                    <div class="portfolio-wrapper">
                        <nav class="portfolio-filter">
                            <ul>
                                <li><a href="#" data-filter="*" class="active"><?php esc_html_e( 'All', 'travel-insight-pro' ); ?></a>
                                    <button class="portfolio-dropdown"><?php echo travel_insight_pro_get_svg( array( 'icon' => 'angle-down' ) ); ?></button>
                                </li>
                                <?php if ( 'demo' == $gallery_content_type ) : ?>
                                    <li><a href="#" data-filter=".cat1"><?php esc_html_e( 'wildlife', 'travel-insight-pro' ); ?></a></li>
                                    <li><a href="#" data-filter=".cat2"><?php esc_html_e( 'branding', 'travel-insight-pro' ); ?></a></li>
                                    <li><a href="#" data-filter=".cat3"><?php esc_html_e( 'Travel', 'travel-insight-pro' ); ?></a></li>
                                    <li><a href="#" data-filter=".cat4"><?php esc_html_e( 'Adventure', 'travel-insight-pro' ); ?></a></li>
                                    <li><a href="#" data-filter=".cat5"><?php esc_html_e( 'People', 'travel-insight-pro' ); ?></a></li>
                                    <li><a href="#" data-filter=".cat6"><?php esc_html_e( 'Cruise', 'travel-insight-pro' ); ?></a></li>
                                <?php elseif ( 'category' == $gallery_content_type ) : 
                                    $cats = ! empty( $options['gallery_content_category'] ) ? $options['gallery_content_category'] : array();
                                    foreach ( $cats as $cat ) :
                                        $category_list = get_category( $cat ); ?>
                                        <li><a href="#" data-filter=".<?php echo esc_attr( $category_list->slug ); ?>"><?php echo esc_html( $category_list->name ); ?></a></li>
                                    <?php endforeach;
                                endif; ?>
                            </ul>
                        </nav><!-- .portfolio-filter -->

                        <div id="gallery-wrapper" class="<?php echo empty( $content_details ) ? 'no-gallery-img' : ''; ?>">
                            <div id="twocol" class="portfolio gallery-popup">
                                <?php if ( empty( $content_details ) ) : ?>
                                    <h3 class="gallery-empty"><?php esc_html_e( 'OOPS..! No post found with featured image.', 'travel-insight-pro' ) ?></h3>
                                <?php else :
                                    foreach( $content_details as $content_detail ) : ?>
                                        <div class="portfolio-item <?php echo ( 1 == $i ) ? 'item-w2' : 'item-w1'; ?> <?php echo esc_attr( $content_detail['terms'] ); ?>">
                                            <div class="featured-image">
                                                <a href="<?php echo esc_url( $content_detail['img_array_large'][0] ); ?>" class="popup">
                                                    <img src="<?php echo esc_url( $content_detail['img_array'][0] ); ?>" alt="<?php echo esc_attr( $content_detail['title'] ); ?>">
                                                </a>
                                                <div class="portfolio-hover-effect">
                                                    <p><a href="<?php echo esc_url( $content_detail['url'] ); ?>"><?php echo esc_html( $content_detail['title'] ); ?></a></p>
                                                </div><!-- .portfolio-hover-effect -->
                                            </div><!-- .featured-image -->
                                        </div><!-- .portfolio-item -->
                                    <?php $i++;
                                    endforeach; 
                                endif; ?>
                            </div><!-- .portfolio -->
                        </div><!-- #gallery -->
                    </div><!-- .portfolio-wrapper -->
                </div><!-- .wrapper -->
            </div><!-- .entry-content -->
        </section><!-- #gallery -->

    <?php }
endif;