<?php
/**
 * masonry section
 *
 * This is the template for the content of masonry section
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0.0
 */
if ( ! function_exists( 'travel_insight_pro_add_masonry_section' ) ) :
    /**
    * Add masonry section
    *
    *@since Travel Insight Pro 1.0.0
    */
    function travel_insight_pro_add_masonry_section() {
        $options = travel_insight_pro_get_theme_options();
        // Check if masonry is enabled on frontpage
        $masonry_enable = apply_filters( 'travel_insight_pro_section_status', true, 'masonry_section_enable' );

        if ( ( true !== $masonry_enable) || ! class_exists( 'WooCommerce' ) ) {
            return false;
        }

        // Render masonry section now.
        travel_insight_pro_render_masonry_section();
    }
endif;

if ( ! function_exists( 'travel_insight_pro_render_masonry_section' ) ) :
  /**
   * Start masonry section
   *
   * @return string masonry content
   * @since Travel Insight Pro 1.0.0
   *
   */
   function travel_insight_pro_render_masonry_section() {
        $options = travel_insight_pro_get_theme_options();

    ?>

    <section id="masonry" class="relative">
        <div class="grid clear">

            <?php for ( $i=1; $i <= 4 ; $i++ ) { 
                if ( empty($options['masonry_content_masonry_category_'.$i]) ) {
                    continue;
                }
                $thumbnail_id = get_term_meta( $options['masonry_content_masonry_category_'.$i], 'thumbnail_id', true );
                $image = wp_get_attachment_url( $thumbnail_id );
                $cat_name = get_term_by( 'id', $options['masonry_content_masonry_category_'.$i], 'product_cat' )->name;
                $cat_link = get_category_link( $options['masonry_content_masonry_category_'.$i] );
                ?>

                <article class="grid-item">
                    <div class="featured-image" style="background-image: url('<?php echo esc_url( $image ); ?>');">
                        <div class="entry-container">
                            <header class="entry-header">
                                <h2 class="entry-title"><a href="<?php echo esc_url( $cat_link ) ?>"><?php echo esc_html( $cat_name ); ?></a></h2>
                            </header>
                        </div><!-- .entry-container -->
                    </div><!-- .featured-image -->
                </article>

                <?php } ?>

            </div><!-- .grid --> 
        </section>

    <?php }
endif;
