<?php 
/**
 * Medical Reasons section
 *
 * This is the template for the content of medical_reasons section
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */
if ( ! function_exists( 'travel_insight_pro_add_medical_reasons_section' ) ) :
    /**
    * Add medical_reasons section
    *
    *@since Travel Insight Pro 1.0
    */
    function travel_insight_pro_add_medical_reasons_section() {
        $options = travel_insight_pro_get_theme_options();

        // Check if medical_reasons is enabled
        $enable_medical_reasons = apply_filters( 'travel_insight_pro_section_status', true, 'medical_reasons_enable' );

        if ( true !== $enable_medical_reasons ) {
            return false;
        }

        // Get medical_reasons section details
        $section_details = array();
        $section_details = apply_filters( 'travel_insight_pro_filter_medical_reasons_section_details', $section_details );
        if ( empty( $section_details ) ) {
            return;
        }
        // Render medical_reasons section now.
        travel_insight_pro_render_medical_reasons_section( $section_details );
    }
endif;


if ( ! function_exists( 'travel_insight_pro_get_medical_reasons_section_details' ) ) :
    /**
    * medical_reasons section details.
    *
    * @since Travel Insight Pro 1.0
    * @param array $input medical_reasons section details.
    */
    function travel_insight_pro_get_medical_reasons_section_details( $input ) {
        $options = travel_insight_pro_get_theme_options();

        // medical_reasons type
        $medical_reasons_content_type  = $options['medical_reasons_content_type'];

        $content = array();
        switch ( $medical_reasons_content_type ) {   

            case 'custom':
                $content[0]['title']        = ! empty( $options['medical_reasons_title'] ) ? $options['medical_reasons_title'] : '';
                $content[0]['excerpt']      = ! empty( $options['medical_reasons_description'] ) ? $options['medical_reasons_description'] : '';
                $content[0]['img_array'][0] = ! empty( $options['about_us_content_image'] ) ? $options['about_us_content_image'] : '';
                $content[0]['url']          = ! empty( $options['reason_btn_link'] ) ? $options['reason_btn_link'] : '';
            break;    

            case 'page':
                $page_id = '';
                
                if ( ! empty( $options['medical_reasons_content_page'] ) )
                    $page_id = absint( $options['medical_reasons_content_page'] );

                // Bail if no valid pages are selected.
                if ( empty( $page_id ) ) {
                    return $input;
                }

                $img_array = null;
                if ( has_post_thumbnail( $page_id ) ) {
                    $img_array = wp_get_attachment_image_src( get_post_thumbnail_id( $page_id ), 'post-thumbnail' );
                } 

                if ( isset( $img_array ) ) {
                    $content[0]['img_array'] = $img_array;
                }

                $content[0]['title']        = get_the_title( $page_id );
                $content[0]['url']          = get_the_permalink( $page_id );
                $content[0]['excerpt']      = travel_insight_pro_trim_content( 75, get_post( $page_id ) );

            break;


            case 'post':
                if ( ! empty( $options['medical_reasons_content_post'] ) )
                    $post_id = absint( $options['medical_reasons_content_post'] );

                // Bail if no valid pages are selected.
                if ( empty( $post_id ) ) {
                    return $input;
                }

                $img_array = null;
                if ( has_post_thumbnail( $post_id ) ) {
                    $img_array = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), 'post-thumbnail' );
                } 

                if ( isset( $img_array ) ) {
                    $content[0]['img_array'] = $img_array;
                }

                $content[0]['title']        = get_the_title( $post_id );
                $content[0]['url']          = get_the_permalink( $post_id );
                $content[0]['excerpt']      = travel_insight_pro_trim_content( 75, get_post( $post_id ) );               
            break;
        }

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// medical_reasons section content details.
add_filter( 'travel_insight_pro_filter_medical_reasons_section_details', 'travel_insight_pro_get_medical_reasons_section_details' );


if ( ! function_exists( 'travel_insight_pro_render_medical_reasons_section' ) ) :
    /**
    * Start medical_reasons section
    *
    * @return string medical_reasons content
    * @since Travel Insight Pro 1.0
    *
    */
    function travel_insight_pro_render_medical_reasons_section( $content_details ) {
        $options = travel_insight_pro_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        }
        ?>
        <?php foreach ( $content_details as $content_detail ) : ?>
        <section id="medical-reasons" class="relative page-section">
            <div class="wrapper">
                <article class="has-post-thumbnail">
                <?php //if ( ! empty( $content_detail['img_array'] ) ) : ?>
                    <div class="featured-image" style="background-image: url('<?php echo esc_url( $content_detail['img_array'][0] ); ?>');">
                        <a href="<?php echo esc_url( $content_detail['url'] ); ?>" class="post-thumbnail-link"></a>
                    </div><!-- .featured-image -->
                <?php //endif; ?>

                    <div class="entry-container" style="background-image: url('assets/uploads/medical-reasons-bg.png');">
                    <?php if ( ! empty( $content_detail['title'] ) ) : ?>
                        <header class="entry-header">
                            <h2 class="entry-title"><a href="<?php echo esc_url( $content_detail['url'] ); ?>"><?php echo esc_html( $content_detail['title'] ); ?></a></h2>
                        </header>
                    <?php endif; ?>

                        <?php if ( ! empty( $content_detail['excerpt'] ) ) : ?>
                        <div class="entry-content">
                            <p><?php echo wp_kses_post( $content_detail['excerpt'] ); ?></p>
                        </div><!-- .entry-content -->
                    <?php endif; ?>

                        <ul>
                            <?php 
                            $reason_lists = ! empty( $options['reason_list'] ) ? explode( '|', $options['reason_list'] ) : array(); 

                            foreach ( $reason_lists as $reason_list ) : ?>
                            <li><?php echo esc_html( $reason_list ); ?></li>
                        <?php endforeach; ?>
                        </ul>
                    </div><!-- .entry-container -->
                </article>
            </div>
        </section>
        <?php endforeach; ?>

    <?php }
endif;