<?php 
/**
 * Packages section
 *
 * This is the template for the content of packages section
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */
if ( ! function_exists( 'travel_insight_pro_add_packages_section' ) ) :
    /**
    * Add packages section
    *
    *@since Travel Insight Pro 1.0
    */
    function travel_insight_pro_add_packages_section() {
        $options = travel_insight_pro_get_theme_options();

        // Check if packages is enabled
        $enable_packages = apply_filters( 'travel_insight_pro_section_status', true, 'packages_enable' );

        if ( true !== $enable_packages ) {
            return false;
        }

        // Get packages section details
        $section_details = array();
        $section_details = apply_filters( 'travel_insight_pro_filter_packages_section_details', $section_details );
        if ( empty( $section_details ) ) {
            return;
        }
        // Render packages section now.
        travel_insight_pro_render_packages_section( $section_details );
    }
endif;



if ( ! function_exists( 'travel_insight_pro_get_packages_section_details' ) ) :
    /**
    * packages section details.
    *
    * @since Travel Insight Pro 1.0
    * @param array $input packages section details.
    */
    function travel_insight_pro_get_packages_section_details( $input ) {
        $options = travel_insight_pro_get_theme_options();

        // packages type
        $packages_content_type  = $options['packages_content_type'];
        $count = ! empty( $options['no_of_packages'] ) ? $options['no_of_packages'] : 3;

        $content = array();
        switch ( $packages_content_type ) {

            case 'category':
                $cat_id = '';
                if ( ! empty( $options['packages_content_category'] ) ) {
                    $cat_id = $options['packages_content_category'];
                }

                // Bail if no valid pages are selected.
                if ( empty( $cat_id ) ) {
                    return $input;
                }else{
                    $cat_id = absint( $cat_id );
                }

                $args = array(
                    'post_type'      => 'post',
                    'cat'            => $cat_id,
                    'posts_per_page'  => absint( $count ),
                    'ignore_sticky_posts' => true,
                );
            break;  

            case 'activity':
                $cat_id = '';
                if ( ! empty( $options['packages_content_activity'] ) ) {
                    $cat_id = $options['packages_content_activity'];
                }

                // Bail if no valid pages are selected.
                if ( empty( $cat_id ) ) {
                    return $input;
                }else{
                    $cat_id = absint( $cat_id );
                }

                $args = array(
                    'post_type'      => 'itineraries',
                    'tax_query' => array(
                        array(
                            'taxonomy' => 'activity',
                            'field'    => 'id',
                            'terms'    => $cat_id,
                        ),
                    ),
                    'posts_per_page'  => absint( $count ),
                );
            break;   

            case 'destination':
                $cat_id = '';
                if ( ! empty( $options['packages_content_destination'] ) ) {
                    $cat_id = $options['packages_content_destination'];
                }

                // Bail if no valid pages are selected.
                if ( empty( $cat_id ) ) {
                    return $input;
                }else{
                    $cat_id = absint( $cat_id );
                }

                $args = array(
                    'post_type'      => 'itineraries',
                    'tax_query' => array(
                        array(
                            'taxonomy' => 'travel_locations',
                            'field'    => 'id',
                            'terms'    => $cat_id,
                        ),
                    ),
                    'posts_per_page'  => absint( $count ),
                );
            break;   

            case 'trip-types':
                $cat_id = '';
                if ( ! empty( $options['packages_content_trip_types'] ) ) {
                    $cat_id = $options['packages_content_trip_types'];
                }

                // Bail if no valid pages are selected.
                if ( empty( $cat_id ) ) {
                    return $input;
                }else{
                    $cat_id = absint( $cat_id );
                }

                $args = array(
                    'post_type'      => 'itineraries',
                    'tax_query' => array(
                        array(
                            'taxonomy' => 'itinerary_types',
                            'field'    => 'id',
                            'terms'    => $cat_id,
                        ),
                    ),
                    'posts_per_page'  => absint( $count ),
                );
            break;   

            default:
            break;

        }

        $posts = New WP_Query( $args );
        if ( $posts -> have_posts() ) :
            $i = 1;
            while ( $posts -> have_posts() ) : $posts -> the_post();
                $post_id = get_the_id();
                $img_array = null;
                if ( has_post_thumbnail( $post_id ) ) {
                    $img_array = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), 'full' );
                } else {
                    $img_array[0] =  get_template_directory_uri().'/assets/uploads/no-featured-image-150x150.jpg';
                }

                if ( isset( $img_array ) ) {
                    $content['loop'][$i]['img_array'] = $img_array;
                }

                $content['loop'][$i]['id']     = $post_id;
                $content['loop'][$i]['title']  = get_the_title();
                $content['loop'][$i]['url']    = get_the_permalink();
                if ( 'category' !== $packages_content_type ) {
                    $content['loop'][$i]['rating'] = travel_insight_pro_wptravel_get_average_rating();
                }
                $i++;
            endwhile;
        endif;

        if ( 'category' == $packages_content_type ) : 
            $highlighted_post = ! empty( $options['packages_content_post'] ) ? $options['packages_content_post'] : ''; 
        else :
            $highlighted_post = ! empty( $options['packages_content_trip_id'] ) ? $options['packages_content_trip_id'] : '';
        endif;

        switch ( $packages_content_type ) {
            case 'category':
                $args_2 = array(
                    'post_type'      => 'post',
                    'p'              => $highlighted_post,
                    'posts_per_page'  => 1,
                    'ignore_sticky_posts' => true,
                );
            break;  

            default:
                $args_2 = array(
                    'post_type'      => 'itineraries',
                    'p'              => $highlighted_post,
                    'posts_per_page'  => 1,
                );
            break;
        }

        $posts = New WP_Query( $args_2 );
        $i = 1;
        if ( $posts -> have_posts() ) :
            while ( $posts -> have_posts() ) : $posts -> the_post();
                $img_array = null;
                if ( has_post_thumbnail() ) {
                    $img_array = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_id() ) , 'full' );
                } else {
                    $img_array[0] =  get_template_directory_uri().'/assets/uploads/no-featured-image-500x500.jpg';
                }

                if ( isset( $img_array ) ) {
                    $content['highlight'][$i]['img_array'] = $img_array;
                }
                $content['highlight'][$i]['id']     = get_the_id();
                $content['highlight'][$i]['title']  = get_the_title();
                $content['highlight'][$i]['url']    = get_the_permalink();
                if ( 'category' !== $packages_content_type ) {
                    $content['highlight'][$i]['rating'] = travel_insight_pro_wptravel_get_average_rating();
                }
                $i++;
            endwhile;
        endif;
        


        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// packages section content details.
add_filter( 'travel_insight_pro_filter_packages_section_details', 'travel_insight_pro_get_packages_section_details' );


if ( ! function_exists( 'travel_insight_pro_render_packages_section' ) ) :
    /**
    * Start packages section
    *
    * @return string packages content
    * @since Travel Insight Pro 1.0
    *
    */
    function travel_insight_pro_render_packages_section( $content_details ) {
        $options = travel_insight_pro_get_theme_options();
        if ( empty( $content_details ) ) {
            return;
        }
        ?>
        <section id="trip-packages" class="page-section">
            <div class="wrapper">
                <?php if ( ! empty( $options['packages_title'] ) && ! empty( $options['packages_sub_title'] ) ) : ?>
                    <header class="entry-header text-center">
                        <?php if ( ! empty( $options['packages_title'] ) ) : ?>
                            <h2 class="entry-title"><?php echo esc_html( $options['packages_title'] ); ?></h2>
                        <?php endif; 

                        if ( ! empty( $options['packages_sub_title'] ) ) : ?>
                            <h3 class="sub-title"><?php echo esc_html( $options['packages_sub_title'] ); ?></h3>
                        <?php endif; ?>
                    </header>
                <?php endif; ?>

                <div class="section-content clear col-2">
                    <div class="hentry">
                        <div class="package-slider" data-slick='{"slidesToShow": 3, "slidesToScroll": 1, "infinite": true, "vertical": true, "speed": 1000, "dots": false, "arrows":true, "autoplay": true, "fade": false }'>
                            <?php foreach ( $content_details['loop'] as $content ) : 
                                if ( 'category' !== $options['packages_content_type'] ) :
                                    $enable_sale     = get_post_meta( $content['id'], 'wp_travel_enable_sale', true );
                                    $trip_price      = WP_Travel_Helpers_Pricings::get_price(array('trip_id'=>$content['id']));
 
                                    $trip_duration   = get_post_meta( $content['id'], 'wp_travel_trip_duration', true );
                                    $settings        = travel_insight_pro_wptravel_get_settings();
                                    $currency_code   = ( isset( $settings['currency'] ) ) ? $settings['currency'] : '';
                                    $currency_symbol = travel_insight_pro_wptravel_get_currency_symbol( $currency_code );
                                    $destinations     = get_the_terms( $content['id'], 'travel_locations' );
                                endif;
                                ?>
                                <article>
                                    <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['img_array'][0] ); ?>');">
                                        <?php if ( 'category' !== $options['packages_content_type'] ) : ?>
                                            <span class="trip-price">                       
                                                <span class="sale-price">
                                                    <?php 
                                                    echo travel_insight_pro_wptravel_get_formated_price_currency( $trip_price );
                                                    
                                                    ?>
                                                </span>
                                            </span><!-- .trip-price -->
                                        <?php endif; ?>
                                    </div>

                                    <div class="entry-container">
                                        <?php if ( 'category' !== $options['packages_content_type'] && ! empty( $destinations ) ) : ?>
                                            <span class="location">
                                                <?php foreach ( $destinations as $destination ) : ?>
                                                    <a href="<?php echo esc_url( get_term_link( $destination->term_id ) ); ?>"><?php echo esc_html( $destination->name ); ?></a>
                                                <?php endforeach; ?>
                                            </span>
                                        <?php endif; ?>

                                        <h4 class="post-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h4>

                                        <?php if ( 'category' !== $options['packages_content_type'] ) : ?>
                                            <div class="clearfix">
                                                <div class="wp-travel-average-review" title="<?php printf( esc_attr__( 'Rated %s out of 5', 'travel-insight-pro' ), $content['rating'] ); ?>">
                                                    <span style="width:<?php echo esc_attr( ( $content['rating'] / 5 ) * 100 ); ?>%">
                                                    <strong itemprop="ratingValue" class="rating"><?php echo esc_html( $content['rating'] ); ?></strong> <?php printf( esc_html__( 'out of %1$s5%2$s', 'travel-insight-pro' ), '<span itemprop="bestRating">', '</span>' ); ?>
                                                </div><!-- .wp-travel-average-review -->
                                            </div><!-- .clearfix -->
                                        <?php endif; 

                                        if ( 'category' !== $options['packages_content_type'] ) : ?>
                                            <div class="wp-travel-trip-time trip-fixed-departure">
                                                <?php travel_insight_pro_wptravel_get_trip_duration( $content['id'] ); ?>
                                            </div><!-- .wp-travel-trip-time -->
                                        <?php endif; ?>
                                    </div><!-- .entry-container -->
                                </article>
                            <?php endforeach; ?>
                        </div><!-- .package-slider -->
                    </div><!-- .hentry -->

                    <?php if ( ! empty( $content_details['highlight'] ) ) : 
                        foreach ( $content_details['highlight'] as $content ) : 
                            if ( 'category' !== $options['packages_content_type'] ) :
                                $enable_sale     = get_post_meta( $content['id'], 'wp_travel_enable_sale', true );
                                $trip_price      = WP_Travel_Helpers_Pricings::get_price(array('trip_id'=>$content['id']));
                                $trip_duration   = get_post_meta( $content['id'], 'wp_travel_trip_duration', true );
                                $settings        = travel_insight_pro_wptravel_get_settings();
                                $currency_code   = ( isset( $settings['currency'] ) ) ? $settings['currency'] : '';
                                $currency_symbol = travel_insight_pro_wptravel_get_currency_symbol( $currency_code );
                                $destinations     = get_the_terms( $content['id'], 'travel_locations' );
                            endif;
                            ?>
                            <div class="hentry">
                                <article class="full-width" style="background-image: url('<?php echo esc_url( $content['img_array'][0] ); ?>');">
                                    <div class="trip-metas">
                                        <?php if ( 'category' !== $options['packages_content_type'] ) : ?>
                                            <div class="entry-meta">
                                                <div class="wp-travel-trip-time trip-fixed-departure">
                                                    <?php travel_insight_pro_wptravel_get_trip_duration( $content['id'] ); ?>
                                                </div><!-- .wp-travel-trip-time -->

                                                <div class="clearfix">
                                                    <div class="wp-travel-average-review" title="<?php printf( esc_attr__( 'Rated %s out of 5', 'travel-insight-pro' ), $content['rating'] ); ?>">
                                                        <span style="width:<?php echo esc_attr( ( $content['rating'] / 5 ) * 100 ); ?>%">
                                                        <strong itemprop="ratingValue" class="rating"><?php echo esc_html( $content['rating'] ); ?></strong> <?php printf( esc_html__( 'out of %1$s5%2$s', 'travel-insight-pro' ), '<span itemprop="bestRating">', '</span>' ); ?>
                                                    </div><!-- .wp-travel-average-review -->
                                                </div>
                                            </div><!-- .entry-meta -->
                                        <?php endif; ?>

                                        <div class="title-price-wrapper">
                                            <div class="title-location-wrapper">
                                                <?php if ( 'category' !== $options['packages_content_type'] && ! empty( $destinations ) ) : ?>
                                                    <span class="location">
                                                        <?php foreach ( $destinations as $destination ) : ?>
                                                            <a href="<?php echo esc_url( get_term_link( $destination->term_id ) ); ?>"><?php echo esc_html( $destination->name ); ?></a>
                                                        <?php endforeach; ?>
                                                    </span>
                                                <?php endif; ?>

                                                <h4 class="post-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h4>
                                            </div><!-- .title-location-wrapper -->

                                            <?php if ('category' !== $options['packages_content_type']): ?>
                                                <span class="trip-price">                       
                                                    <?php 
                                                    echo travel_insight_pro_wptravel_get_formated_price_currency( $trip_price );
                                                    ?>
                                                </span><!-- .trip-price -->
                                            <?php endif ?>
                                            
                                        </div><!-- .title-price-wrapper -->
                                    </div><!-- .trip-metas -->
                                </article>
                            </div><!-- .hentry -->
                        <?php endforeach; 
                    endif; ?>
                </div>
            </div><!-- .wrapper -->
        </section><!-- #trip-packages -->
    <?php }
endif;