<?php
/**
 * Recent Product section
 *
 * This is the template for the content of recent product section
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0.0
 */
if ( ! function_exists( 'travel_insight_pro_add_recent_product_section' ) ) :
    /**
    * Add recent product section
    *
    *@since Travel Insight Pro 1.0.0
    */
    function travel_insight_pro_add_recent_product_section() {
    	$options = travel_insight_pro_get_theme_options();
        // Check if recent product is enabled on frontpage
        $recent_product_enable = apply_filters( 'travel_insight_pro_section_status', true, 'recent_product_enable' );

        if ( true !== $recent_product_enable ) {
            return false;
        }
        // Get recent product section details
        $section_details = array();
        $section_details = apply_filters( 'travel_insight_pro_filter_recent_product_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }
        if ( !class_exists('WooCommerce') ) {
            return;
        }
        // Render recent product section now.
        travel_insight_pro_render_recent_product_section( $section_details );
    }
endif;

if ( ! function_exists( 'travel_insight_pro_get_recent_product_section_details' ) ) :
    /**
    * recent product section details.
    *
    * @since Travel Insight Pro 1.0.0
    * @param array $input recent product section details.
    */
    function travel_insight_pro_get_recent_product_section_details( $input ) {
        $options = travel_insight_pro_get_theme_options();

        // Content type.
        $recent_product_content_type  = $options['recent_product_content_type'];        
        
        $content = array();
        $content = array();
        switch ( $recent_product_content_type ) {


            case 'product':
                $post_ids = ! empty( $options['recent_product_content_product'] ) ? $options['recent_product_content_product'] : array();

                if ( empty( $post_ids ) ) {
                    return $input;
                }

                $args = array(
                    'post_type'         => 'product',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => count( $post_ids ),
                    'orderby'           => 'post__in',
                    );
            break;
            
            case 'product-category':
                $cat_id = ! empty( $options['recent_product_content_product_category'] ) ? $options['recent_product_content_product_category'] : '';

                $args = array(
                'post_type'         => 'product',
                'posts_per_page'  => absint( $options['no_of_recent_product'] ),
                'tax_query'         => array(
                    array(
                        'taxonomy'  => 'product_cat',
                        'field'     => 'id',
                        'terms'     => $cat_id
                    )
                ) );
            break;

            default:
            break;
        }


        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'large' ) : '';

                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        
    
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// recent product section content details.
add_filter( 'travel_insight_pro_filter_recent_product_section_details', 'travel_insight_pro_get_recent_product_section_details' );


if ( ! function_exists( 'travel_insight_pro_render_recent_product_section' ) ) :
  /**
   * Start recent product section
   *
   * @return string recent product content
   * @since Travel Insight Pro 1.0.0
   *
   */
   function travel_insight_pro_render_recent_product_section( $content_details = array() ) {
        $options = travel_insight_pro_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } ?>
      
        <section id="recent-products" class="relative page-section same-background">
            <div class="wrapper">
                <div class="section-header">
                <?php if( !empty( $options['recent_product_title'] ) ): ?>
                    <h2 class="shop-section-title"><?php echo esc_html( $options['recent_product_title'] ); ?></h2>
                <?php endif; 
                if( !empty( $options['recent_product_subtitle'] ) ): ?>
                    <p class="shop-subtitle"><?php echo esc_html( $options['recent_product_subtitle'] ); ?></p>
                <?php endif; ?>
                </div><!-- .section-header -->

                <div class="section-content">
                    <ul class="products col-4">
                        <?php foreach ( $content_details as $content ): ?>
                        <li class="product featured-products">
                            <a href="<?php echo esc_url( $content['url'] ) ; ?>" class="woocommerce-LoopProduct-link woocommerce-loop-product__link">
                                <?php 
                                $recent_product = new WC_Product( $content['id'] );
                                if ( $recent_product->get_sale_price() ): 
                                    ?>
                                <span class="onsale">
                                        <?php esc_html_e('Sale!', 'travel-insight-pro'); ?>
                                    </span>
                                <?php endif ?>
                                <img src="<?php echo esc_url( $content['image'] ) ?>">
                                <h2 class="woocommerce-loop-product__title"><?php echo esc_html( $content['title'] ) ?></h2>
                                <span class="price">
                                    <ins><span class="woocommerce-Price-amount amount"><span class="woocommerce-Price-currencySymbol"><?php 
                                            $recent_product = new WC_Product( $content['id'] );
                                            echo $recent_product->get_price_html();
                                            ?></span></span></ins>
                                </span>
                            </a>
                        </li>
                        <?php endforeach; ?>

                    </ul><!-- .product-recent_product -->
                </div><!-- .section-content -->
            </div><!-- .wrapper -->
        </section>

    <?php }
endif;
