<?php 
/**
 * Slider section
 *
 * This is the template for the content of slider section
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */
if ( ! function_exists( 'travel_insight_pro_add_slider_section' ) ) :
    /**
    * Add slider section
    *
    *@since Travel Insight Pro 1.0
    */
    function travel_insight_pro_add_slider_section() {
        $options = travel_insight_pro_get_theme_options();

        // Check if slider is enabled
        $enable_slider = apply_filters( 'travel_insight_pro_section_status', true, 'slider_enable' );

        if ( true !== $enable_slider ) {
            return false;
        }

        // Get slider section details
        $section_details = array();
        $section_details = apply_filters( 'travel_insight_pro_filter_slider_section_details', $section_details );
        if ( empty( $section_details ) ) {
            return;
        }
        // Render slider section now.
        travel_insight_pro_render_slider_section( $section_details );
    }
endif;


if ( ! function_exists( 'travel_insight_pro_get_slider_section_details' ) ) :
    /**
    * slider section details.
    *
    * @since Travel Insight Pro 1.0
    * @param array $input slider section details.
    */
    function travel_insight_pro_get_slider_section_details( $input ) {
        $options = travel_insight_pro_get_theme_options();

        // slider type
        $slider_content_type  = $options['slider_content_type'];

        $content = array();
        switch ( $slider_content_type ) {
            case 'demo':
                for ( $i = 1; $i <= 2; $i++ ) :
                    $content[$i]['title']   = esc_html__( 'Exploring', 'travel-insight-pro' );
                    $content[$i]['sub_title'] = esc_html__( 'Never Stop', 'travel-insight-pro' );
                    $content[$i]['url']     = '#';
                    $content[$i]['img_array'][0] = get_template_directory_uri() . '/assets/uploads/slider-0'.$i.'.jpg';
                endfor;
            break;     

            case 'custom':
                for ( $i = 1; $i <= $options['no_of_slider']; $i++ ) :
                    $content[$i]['title']   = ! empty( $options['slider_content_custom_title_'. $i] ) ? $options['slider_content_custom_title_'. $i] : '';
                    $content[$i]['sub_title'] = ! empty( $options['slider_content_custom_sub_title_'. $i] ) ? $options['slider_content_custom_sub_title_'. $i] : '';
                    $content[$i]['url']     = ! empty( $options['slider_content_custom_url_'. $i] ) ? $options['slider_content_custom_url_'. $i] : '';
                    $content[$i]['img_array'][0] = ! empty( $options['slider_content_image_'. $i] ) ? $options['slider_content_image_'. $i] : '';
                endfor;
            break;    

            case 'page':
                $ids = array();

                for ( $i = 1; $i <= $options['no_of_slider']; $i++ ) {
                    $id = null;
                    if ( isset( $options[ 'slider_content_page_'.$i ] ) ) {
                        $id = $options[ 'slider_content_page_'.$i ];
                    }
                    if ( ! empty( $id ) ) {
                        $ids[] = absint( $id );
                    }
                }

                // Bail if no valid pages are selected.
                if ( empty( $ids ) ) {
                    return $input;
                }

                $args = array(
                    'no_found_rows'  => true,
                    'orderby'        => 'post__in',
                    'post_type'      => 'page',
                    'post__in'       => $ids,
                    'posts_per_page' => absint( $options['no_of_slider'] ),
                );
            break;

            case 'category':
                $cat_id = '';
                if ( ! empty( $options['slider_content_category'] ) ) {
                    $cat_id = $options['slider_content_category'];
                }

                // Bail if no valid pages are selected.
                if ( empty( $cat_id ) ) {
                    return $input;
                }else{
                    $cat_id = absint( $cat_id );
                }

                $args = array(
                    'no_found_rows'  => true,
                    'cat'            => $cat_id,
                    'post_type'      => 'post',
                    'posts_per_page'  => absint( $options['no_of_slider'] ),
                );
            break;

            case 'post':
                $ids = array();
                
                if ( ! empty( $options['slider_content_post'] ) )
                    $ids = ( array ) $options['slider_content_post'];

                // Bail if no valid pages are selected.
                if ( empty( $ids ) ) {
                    return $input;
                }

                $args = array(
                    'no_found_rows'  => true,
                    'orderby'        => 'post__in',
                    'post_type'      => 'post',
                    'post__in'       => $ids,
                    'posts_per_page' => count( $ids ),
                );                             
            break;

            case 'product':
                $post_ids = ! empty( $options['slider_content_product'] ) ? $options['slider_content_product'] : array();

                if ( empty( $post_ids ) ) {
                    return $input;
                }

                $args = array(
                    'post_type'         => 'product',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => count( $post_ids ),
                    'orderby'           => 'post__in',
                    );
            break;

            case 'product-category':
                $cat_id = ! empty( $options['slider_content_product_category'] ) ? $options['slider_content_product_category'] : '';

                $args = array(
                'post_type'         => 'product',
                'posts_per_page'  => absint( $options['no_of_slider'] ),
                'tax_query'         => array(
                    array(
                        'taxonomy'  => 'product_cat',
                        'field'     => 'id',
                        'terms'     => $cat_id
                    )
                ) );
            break;
        }

        if ( ! in_array( $slider_content_type, array( 'demo', 'custom' ) ) ) {
            $posts = get_posts( $args );
            if ( ! empty( $posts ) ) :
                $i = 1;
                foreach ( $posts as $post ) :
                    $post_id = $post->ID;
                    $img_array = null;
                    if ( has_post_thumbnail( $post_id ) ) {
                        $img_array = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), 'full' );
                    } else {
                        $img_array[0] =  get_template_directory_uri().'/assets/uploads/no-featured-image-1920x1080.jpg';
                    }

                    if ( isset( $img_array ) ) {
                        $content[$i]['img_array'] = $img_array;
                    }

                    $sub_title = '';
                    if ( function_exists( 'get_the_subtitle' ) ) {
                        $sub_title = get_the_subtitle( $post_id );
                        $sub_title = ! empty( $sub_title ) ? $sub_title : '';
                    }

                    $content[$i]['title']       = get_the_title( $post_id );
                    $content[$i]['sub_title']   = $sub_title;
                    $content[$i]['url']         = get_the_permalink( $post_id );
                    $i++;
                endforeach;
            endif;
        }

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// slider section content details.
add_filter( 'travel_insight_pro_filter_slider_section_details', 'travel_insight_pro_get_slider_section_details' );


if ( ! function_exists( 'travel_insight_pro_render_slider_section' ) ) :
    /**
    * Start slider section
    *
    * @return string slider content
    * @since Travel Insight Pro 1.0
    *
    */
    function travel_insight_pro_render_slider_section( $content_details ) {
        $options = travel_insight_pro_get_theme_options();
        $btn_label = ! empty( $options['slider_btn_label'] ) ? $options['slider_btn_label'] : esc_html__( 'Start Learning', 'travel-insight-pro' );
        $slider_effect    = ( $options['slider_effect'] == 'fade' ) ? 'linear' : $options['slider_effect'];
        $slider_fade      = ( $options['slider_effect'] == 'fade' ) ? 'true' : 'false';
        $slider_control   = ( $options['enable_slider_controls'] == true ) ? 'true' : 'false';
        $slider_dragable  = ( $options['enable_slider_dragable'] == true ) ? 'true' : 'false';
        $slider_pause     = ( $options['slider_pause_on_hover'] == true ) ? 'true' : 'false';
        $slider_autoplay  = ( $options['slider_autoplay'] == true ) ? 'true' : 'false';
        $slider_speed     = ( $options['slider_transition_duration'] ) ? $options['slider_transition_duration'] : 1000;

        if ( empty( $content_details ) ) {
            return;
        }

        $slider_layout = ( 'sticky-slider' == $options['slider_layout'] ) ? 'slide-text-only' : 'default-slider';
        $slider_background = ! empty( $options['slider_background'] ) ? $options['slider_background'] : get_template_directory_uri() . '/assets/uploads/slider-01.jpg';
        $i = 1;
        ?>
        <section id="main-slider-section" class="<?php echo esc_attr( $slider_layout ); ?>" <?php if( $options['slider_layout'] == 'sticky-slider' ) { ?> style="background-image: url('<?php echo esc_url( $slider_background ); ?>');" <?php } ?>>
            <div class="main-slider">
                <div class="regular" data-effect="<?php echo esc_attr( $slider_effect ); ?>" data-slick='{"slidesToShow": 1, "slidesToScroll": 1, "infinite": true, "speed": <?php echo esc_attr( $slider_speed ); ?>, "dots": false, "arrows":<?php echo esc_attr( $slider_control ); ?>, "autoplay": <?php echo esc_attr( $slider_autoplay ); ?>, "fade": <?php echo esc_attr( $slider_fade ); ?>, "draggable": <?php echo esc_attr( $slider_dragable ); ?>, "pauseOnHover": <?php echo esc_attr( $slider_pause ); ?> }'>
                    <?php foreach( $content_details as $content_detail ) : ?>
                        <div class="slider-item <?php echo ( $i == 1 ) ? 'display-block' : 'display-none'; ?>" style="background-image: url('<?php echo esc_url( $content_detail['img_array'][0] ); ?>')">
                            <?php if ( true === $options['slider_caption_enable'] ) : ?>
                                <div class="main-slider-contents">
                                    <?php if ( ! empty( $content_detail['sub_title']  ) ) : ?>
                                        <h1><?php echo esc_html( $content_detail['sub_title'] ); ?></h1>
                                    <?php endif; ?>
                                    <h2><a href="<?php echo esc_url( $content_detail['url'] ); ?>"><?php echo esc_html( $content_detail['title'] ); ?></a></h2>
                                </div><!-- .main-slider-contents -->
                            <?php endif; ?>
                        </div><!-- .slider-item -->
                    <?php $i++; endforeach; ?>
                </div><!-- .regular -->
                <?php if ( true === $options['slider_search_enable'] ) : ?>
                    <div id="search">
                        <?php get_search_form(); ?>
                    </div>
                <?php endif; ?>
            </div><!-- #main-slider -->
            
            <?php if ( has_nav_menu( 'social' ) && $options['slider_social_menu_enable'] == true ): ?>
                <div class="slider-icon">
                    <?php wp_nav_menu( array( 'theme_location' => 'social',  'menu_class'  => 'social-icons', 'container'  => 'div', 'container_class' => 'wrapper' ) ) ; ?>
                </div>
            <?php endif ?>
            

        </section><!-- #video-background -->
        
        <?php if ( class_exists( 'WP_Travel' ) && $options['slider_wp_travel_filter_enable'] ) : ?>
            <div class="wp-travel-filter">
                <?php wp_travel_search_form(); ?>
            </div>
        <?php endif; ?>

<?php }
endif;