<?php 
/**
 * Team section
 *
 * This is the template for the content of team section
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */
if ( ! function_exists( 'travel_insight_pro_add_team_section' ) ) :
    /**
    * Add team section
    *
    *@since Travel Insight Pro 1.0
    */
    function travel_insight_pro_add_team_section() {
        $options = travel_insight_pro_get_theme_options();

        // Check if team is enabled
        $enable_team = apply_filters( 'travel_insight_pro_section_status', true, 'team_section_enable' );
        
        if ( true !== $enable_team ) {
            return false;
        }

        // Get team section details
        $section_details = array();
        $section_details = apply_filters( 'travel_insight_pro_filter_team_section_details', $section_details );
        if ( empty( $section_details ) ) {
            return;
        }
        // Render team section now.
        travel_insight_pro_render_team_section( $section_details );
    }
endif;


if ( ! function_exists( 'travel_insight_pro_get_team_section_details' ) ) :
    /**
    * team section details.
    *
    * @since Travel Insight Pro 1.0
    * @param array $input team section details.
    */
    function travel_insight_pro_get_team_section_details( $input ) {
        $options = travel_insight_pro_get_theme_options();

        // team type
        $team_content_type  = $options['team_content_type'];

        $content = array();
        switch ( $team_content_type ) {

            case 'page':
                $ids = array();

                for ( $i = 1; $i <= $options['team_count']; $i++ ) {
                    $id = null;
                    if ( isset( $options[ 'team_content_page_'.$i ] ) ) {
                        $id = $options[ 'team_content_page_'.$i ];
                    }
                    if ( ! empty( $id ) ) {
                        $ids[] = absint( $id );
                    }
                }

                // Bail if no valid pages are selected.
                if ( empty( $ids ) ) {
                    return $input;
                }

                $args = array(
                    'no_found_rows'  => true,
                    'orderby'        => 'post__in',
                    'post_type'      => 'page',
                    'post__in'       => $ids,
                    'posts_per_page' => absint( $options['team_count'] ),
                );
            break;

            case 'category':
                $cat_id = '';
                if ( ! empty( $options['team_content_category'] ) ) {
                    $cat_id = $options['team_content_category'];
                }

                $args = array(
                    'no_found_rows'  => true,
                    'cat'            => $cat_id,
                    'post_type'      => 'post',
                    'posts_per_page'  => absint( $options['team_count'] ),
                );
            break;

            case 'post':
                $ids = array();
                
                if ( ! empty( $options['team_content_post'] ) )
                    $ids = ( array ) $options['team_content_post'];

                // Bail if no valid pages are selected.
                if ( empty( $ids ) ) {
                    return $input;
                }

                $args = array(
                    'no_found_rows'  => true,
                    'orderby'        => 'post__in',
                    'post_type'      => 'post',
                    'post__in'       => $ids,
                    'posts_per_page' => absint( $options['team_count'] ),
                );                             
            break;
        }

        $posts = get_posts( $args );
        if ( ! empty( $posts ) ) :
            $i = 1;
            foreach ( $posts as $post ) :
                $post_id = $post->ID;
 
                $content[$i]['title']       = get_the_title( $post_id );
                $content[$i]['url']         = get_the_permalink( $post_id );
                $content[$i]['image']       = has_post_thumbnail($post_id) ? get_the_post_thumbnail_url( $post_id, 'post-thumbnail' ) : get_template_directory_uri().'/assets/uploads/no-featured-image-500x500.jpg';

                $i++;
            endforeach;
        endif;

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// team section content details.
add_filter( 'travel_insight_pro_filter_team_section_details', 'travel_insight_pro_get_team_section_details' );


if ( ! function_exists( 'travel_insight_pro_render_team_section' ) ) :
    /**
    * Start team section
    *
    * @return string team content
    * @since Travel Insight Pro 1.0
    *
    */
    function travel_insight_pro_render_team_section( $content_details ) {
        $options = travel_insight_pro_get_theme_options(); ?>
    
        <section id="business-team" class="relative page-section">
            <div class="wrapper">
                <div class="business-section-header">
                    <h2 class="business-section-title"><?php echo esc_html( $options['team_title'] ) ; ?></h2>
                    <p class="business-section-subtitle"><?php echo esc_html( $options['team_sub_title'] ) ; ?></p>
                </div><!-- .business-section-header -->

                <div class="business-section-content clear <?php echo esc_attr($options['team_column_layout']); ?>">
                    <?php foreach( $content_details as $i=>$content ) : ?>
                        <article>
                            <div class="business-team-item">
                                <div class="featured-image">
                                    <a href="<?php echo esc_url( $content['url'] ) ; ?>"><img src="<?php echo esc_url( $content['image'] ) ; ?>" alt="business-team-<?php echo $i; ?>"></a>
                                </div><!-- .featured-image -->

                                <div class="entry-container">
                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ) ; ?>"><?php echo esc_html( $content['title'] ) ; ?></a>
                                        </h2>
                                    </header>

                                    <div class="entry-content">
                                        <?php if ( ! empty( $options['team_position_'.$i ] ) ): ?>
                                            <p>
                                                <?php echo esc_html( $options['team_position_'.$i ] ) ; ?>
                                            </p>
                                        <?php endif; ?>  
                                    </div><!-- .entry-content -->

                                    <div class="social-icons">
                                        <ul>
                                            <?php 
                                            $team_socials = ! empty( $options['team_social_' . $i ] ) ? explode( '|', $options['team_social_' . $i ] ) : array(); 

                                            foreach ( $team_socials as $team_social ) : ?>
                                            <li>
                                                <a href="<?php echo esc_url( $team_social ); ?>"><?php echo travel_insight_pro_return_social_icon( $team_social ); ?></a>
                                            </li>
                                        <?php endforeach; 
                                        ?>
                                    </ul><!-- .social-icons -->
                                </div><!-- .social-icons -->
                            </div><!-- .entry-container -->
                        </div><!-- .business-team-item -->
                    </article>
                <?php endforeach; ?>
            </div><!-- .business-section-content -->
        </div><!-- .wrapper -->
    </section><!-- #business-team -->
    <?php }
endif;