<?php
/**
 * option functions
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

if ( ! function_exists( 'travel_insight_pro_post_choices' ) ) :
/**
 * List of posts for post choices.
 * @return Array Array of post ids and name.
 */
function travel_insight_pro_post_choices() {
    $posts = get_posts( array( 'numberposts' => -1 ) );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'travel-insight-pro' );
    foreach ( $posts as $post ) {
        $choices[ $post->ID ] = $post->post_title;
    }
    return  $choices;
}
endif;


if ( ! function_exists( 'travel_insight_pro_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function travel_insight_pro_typography_options(){

        $choices = array(
            'default'         => esc_html__( 'DEFAULT', 'travel-insight-pro' ),
            'header-font-1'   => esc_html__( 'Rajdhani', 'travel-insight-pro' ),
            'header-font-2'   => esc_html__( 'Cherry Swash', 'travel-insight-pro' ),
            'header-font-3'   => esc_html__( 'Philosopher', 'travel-insight-pro' ),
            'header-font-4'   => esc_html__( 'Slabo 27px', 'travel-insight-pro' ),
            'header-font-5'   => esc_html__( 'Dosis', 'travel-insight-pro' ),
        );
        $output = apply_filters( 'travel_insight_pro_typography_options', $choices );

        return $output;

    }
endif;

if ( ! function_exists( 'travel_insight_pro_body_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function travel_insight_pro_body_typography_options(){

        $choices = array(
            'default'         => esc_html__( 'DEFAULT', 'travel-insight-pro' ),
            'body-font-1'     => esc_html__( 'News Cycle', 'travel-insight-pro' ),
            'body-font-2'     => esc_html__( 'Pontano Sans', 'travel-insight-pro' ),
            'body-font-3'     => esc_html__( 'Gudea', 'travel-insight-pro' ),
            'body-font-4'     => esc_html__( 'Quattrocento', 'travel-insight-pro' ),
            'body-font-5'     => esc_html__( 'Khand', 'travel-insight-pro' ),
        );
        $output = apply_filters( 'travel_insight_pro_body_typography_options', $choices );

        return $output;

    }
endif;

if ( ! function_exists( 'travel_insight_pro_theme_color' ) ) :
    /**
     * theme color
     * @return array site layout options
     */
    function travel_insight_pro_theme_color() {
        $travel_insight_pro_theme_color = array(
            'blue'      => esc_html__( 'Blue', 'travel-insight-pro' ),
            'red'       => esc_html__( 'Red', 'travel-insight-pro' ),
            'green'     => esc_html__( 'Green', 'travel-insight-pro' ),
            'black'     => esc_html__( 'Black', 'travel-insight-pro' ),
            'yellow'    => esc_html__( 'Yellow', 'travel-insight-pro' ),
        );

        $output = apply_filters( 'travel_insight_pro_theme_color', $travel_insight_pro_theme_color );

        return $output;
    }
endif;


if ( ! function_exists( 'travel_insight_pro_site_layout' ) ) :
    /**
     * Site Layout
     * @return array site layout options
     */
    function travel_insight_pro_site_layout() {
        $travel_insight_pro_site_layout = array(
            'wide'  => esc_html__( 'Wide', 'travel-insight-pro' ),
            'boxed' => esc_html__( 'Boxed', 'travel-insight-pro' ),
        );

        $output = apply_filters( 'travel_insight_pro_site_layout', $travel_insight_pro_site_layout );

        return $output;
    }
endif;


if ( ! function_exists( 'travel_insight_pro_sidebar_position' ) ) :
    /**
     * Sidebar position
     * @return array Sidbar positions
     */
    function travel_insight_pro_sidebar_position() {
        $travel_insight_pro_sidebar_position = array(
            'right-sidebar' => esc_html__( 'Right', 'travel-insight-pro' ),
            'left-sidebar'  => esc_html__( 'Left', 'travel-insight-pro' ),
            'no-sidebar'    => esc_html__( 'No Sidebar', 'travel-insight-pro' ),
        );

        $output = apply_filters( 'travel_insight_pro_sidebar_position', $travel_insight_pro_sidebar_position );

        return $output;
    }
endif;

if ( ! function_exists( 'travel_insight_pro_single_content_width' ) ) :
    /**
     * content width
     * @return array content width
     */
    function travel_insight_pro_single_content_width() {
        $travel_insight_pro_single_content_width = array(
            'content-width' => esc_html__( 'Content Width', 'travel-insight-pro' ),
            'full-width'    => esc_html__( 'Full Width', 'travel-insight-pro' ),
        );

        $output = apply_filters( 'travel_insight_pro_single_content_width', $travel_insight_pro_single_content_width );

        return $output;
    }
endif;


if ( ! function_exists( 'travel_insight_pro_pagination_options' ) ) :
    /**
     * Pagination
     * @return array site pagination options
     */
    function travel_insight_pro_pagination_options() {
        $travel_insight_pro_pagination_options = array(
            'default'   => esc_html__( 'Default(Older/Newer)', 'travel-insight-pro' ),
            'numeric'   => esc_html__( 'Numeric', 'travel-insight-pro' ),
            'infinite'  => esc_html__( 'Infinite', 'travel-insight-pro' ),
        );

        $output = apply_filters( 'travel_insight_pro_pagination_options', $travel_insight_pro_pagination_options );

        return $output;
    }
endif;

if ( ! function_exists( 'travel_insight_pro_icons_options' ) ) :
    /**
     * Pagination
     * @return array site pagination options
     */
    function travel_insight_pro_icons_options() {
        $travel_insight_pro_icons_options = array(
        'drop'                      => esc_html__( 'Drop', 'travel-insight-pro' ),
        'behance'                   => esc_html__( 'Behance', 'travel-insight-pro' ),
        'deviantart'                => esc_html__( 'Deviantart', 'travel-insight-pro' ),
        'medium'                    => esc_html__( 'Medium', 'travel-insight-pro' ),
        'slideshare'                => esc_html__( 'Slideshare', 'travel-insight-pro' ),
        'snapchat-ghost'            => esc_html__( 'Snapchat Ghost', 'travel-insight-pro' ),
        'yelp'                      => esc_html__( 'Yelp', 'travel-insight-pro' ),
        'vine'                      => esc_html__( 'Vine', 'travel-insight-pro' ),
        'vk'                        => esc_html__( 'VK', 'travel-insight-pro' ),
        'search'                    => esc_html__( 'Search', 'travel-insight-pro' ),
        'envelope-o'                => esc_html__( 'Envelope O', 'travel-insight-pro' ),
        'close'                     => esc_html__( 'Close', 'travel-insight-pro' ),
        'angle-down'                => esc_html__( 'Angle Down', 'travel-insight-pro' ),
        'folder-open'               => esc_html__( 'Folder Open', 'travel-insight-pro' ),
        'twitter'                   => esc_html__( 'Twitter', 'travel-insight-pro' ),
        'whatsapp'                   => esc_html__( 'Whatsapp', 'travel-insight-pro' ),
        'facebook'                  => esc_html__( 'Facebook', 'travel-insight-pro' ),
        'github'                    => esc_html__( 'Github', 'travel-insight-pro' ),
        'bars'                      => esc_html__( 'Bars', 'travel-insight-pro' ),
        'google-plus'               => esc_html__( 'Google Plus', 'travel-insight-pro' ),
        'linkedin'                  => esc_html__( 'Linkedin', 'travel-insight-pro' ),
        'quote-right'               => esc_html__( 'Quote Right', 'travel-insight-pro' ),
        'mail-reply'                => esc_html__( 'Mail Reply', 'travel-insight-pro' ),
        'youtube'                   => esc_html__( 'Youtube', 'travel-insight-pro' ),
        'dropbox'                   => esc_html__( 'Dropbox', 'travel-insight-pro' ),
        'instagram'                 => esc_html__( 'Instagram', 'travel-insight-pro' ),
        'flickr'                    => esc_html__( 'Flickr', 'travel-insight-pro' ),
        'tumblr'                    => esc_html__( 'Tumblr', 'travel-insight-pro' ),
        'dribbble'                  => esc_html__( 'Dribbble', 'travel-insight-pro' ),
        'skype'                     => esc_html__( 'Skype', 'travel-insight-pro' ),
        'foursquare'                => esc_html__( 'Foursquare', 'travel-insight-pro' ),
        'wordpress'                 => esc_html__( 'WordPress', 'travel-insight-pro' ),
        'stumbleupon'               => esc_html__( 'Stumbleupon', 'travel-insight-pro' ),
        'digg'                      => esc_html__( 'Digg', 'travel-insight-pro' ),
        'spotify'                   => esc_html__( 'Spotify', 'travel-insight-pro' ),
        'soundcloud'                => esc_html__( 'Soundcloud', 'travel-insight-pro' ),
        'codepen'                   => esc_html__( 'Codepen', 'travel-insight-pro' ),
        'twitch'                    => esc_html__( 'Twitch', 'travel-insight-pro' ),
        'meanpath'                  => esc_html__( 'Meanpath', 'travel-insight-pro' ),
        'pinterest-p'               => esc_html__( 'Pinterest', 'travel-insight-pro' ),
        'get-pocket'                => esc_html__( 'Get Pocket', 'travel-insight-pro' ),
        'vimeo'                     => esc_html__( 'Vimeo', 'travel-insight-pro' ),
        'reddit-alien'              => esc_html__( 'Reddit Alien', 'travel-insight-pro' ),
        'hashtag'                   => esc_html__( 'Hashtag', 'travel-insight-pro' ),
        'chain'                     => esc_html__( 'Chain', 'travel-insight-pro' ),
        'thumb-tack'                => esc_html__( 'Thumb Tack', 'travel-insight-pro' ),
        'arrow-left'                => esc_html__( 'Arrow Left', 'travel-insight-pro' ),
        'arrow-right'               => esc_html__( 'Arrow Right', 'travel-insight-pro' ),
        'play'                      => esc_html__( 'Play', 'travel-insight-pro' ),
        'pause'                     => esc_html__( 'Pause', 'travel-insight-pro' ),
        'tripadvisor'               => esc_html__( 'Tripadvisor', 'travel-insight-pro' ),
        'notebook'                  => esc_html__( 'Notebook', 'travel-insight-pro' ),
        'phone-call'                => esc_html__( 'Phone Call', 'travel-insight-pro' ),
        'ambulance'                 => esc_html__( 'Ambulance', 'travel-insight-pro' ),
        'mountain'                  => esc_html__( 'Mountain', 'travel-insight-pro' ),
        'mountain-1'                => esc_html__( 'Mountain 1', 'travel-insight-pro' ),
        'mountain-2'                => esc_html__( 'Mountain 2', 'travel-insight-pro' ),
        'mountain-3'                => esc_html__( 'Mountain 3', 'travel-insight-pro' ),
        'mountain-4'                => esc_html__( 'Mountain 4', 'travel-insight-pro' ),
        'mountain-5'                => esc_html__( 'Mountain 5', 'travel-insight-pro' ),
        'mountain-6'                => esc_html__( 'Mountain 6', 'travel-insight-pro' ),
        'pills'                     => esc_html__( 'Pills', 'travel-insight-pro' ),
        'pills-1'                   => esc_html__( 'Pills 1', 'travel-insight-pro' ),
        'stethoscope'               => esc_html__( 'Stethoscope', 'travel-insight-pro' ),
        'medical-result'            => esc_html__( 'Medical Result', 'travel-insight-pro' ),
        'calendar-1'                => esc_html__( 'Calendar 1', 'travel-insight-pro' ),
        'calendar-2'                => esc_html__( 'Calendar 2', 'travel-insight-pro' ),
        'calendar-3'                => esc_html__( 'Calendar 3', 'travel-insight-pro' ),
        'calendar-4'                => esc_html__( 'Calendar 4', 'travel-insight-pro' ),
        'calendar-5'                => esc_html__( 'Calendar 5', 'travel-insight-pro' ),
        'mountains'                 => esc_html__( 'Mountains', 'travel-insight-pro' ),
        'mountains-1'               => esc_html__( 'Mountains 1', 'travel-insight-pro' ),
        'goal'                      => esc_html__( 'Goal', 'travel-insight-pro' ),
        'fish'                      => esc_html__( 'Fish', 'travel-insight-pro' ),
        'fish-1'                    => esc_html__( 'Fish 1', 'travel-insight-pro' ),
        'fish-2'                    => esc_html__( 'Fish 2', 'travel-insight-pro' ),
        'lighthouse'                => esc_html__( 'Lighthouse', 'travel-insight-pro' ),
        'lighthouse-1'              => esc_html__( 'Lighthouse 1', 'travel-insight-pro' ),
        'transport'                 => esc_html__( 'Transport', 'travel-insight-pro' ),
        'transport-1'               => esc_html__( 'Transport 1', 'travel-insight-pro' ),
        'transport-2'               => esc_html__( 'Transport 2', 'travel-insight-pro' ),
        'transport-3'               => esc_html__( 'Transport 3', 'travel-insight-pro' ),
        'transport-4'               => esc_html__( 'Transport 4', 'travel-insight-pro' ),
        'transport-5'               => esc_html__( 'Transport 5', 'travel-insight-pro' ),
        'transport-6'               => esc_html__( 'Transport 6', 'travel-insight-pro' ),
        'transport-7'               => esc_html__( 'Transport 7', 'travel-insight-pro' ),
        'transport-8'               => esc_html__( 'Transport 8', 'travel-insight-pro' ),
        'coffee-cup'                => esc_html__( 'Coffee Cup', 'travel-insight-pro' ),
        'coffee-cup-1'              => esc_html__( 'Coffee Cup 1', 'travel-insight-pro' ),
        'coffee-cup-2'              => esc_html__( 'Coffee Cup 2', 'travel-insight-pro' ),
        'ferry-facing-right'        => esc_html__( 'Ferry Facing Right', 'travel-insight-pro' ),
        'aeroplane'                 => esc_html__( 'Aeroplane', 'travel-insight-pro' ),
        'aeroplane-1'               => esc_html__( 'Aeroplane 1', 'travel-insight-pro' ),
        'tea'                       => esc_html__( 'Tea', 'travel-insight-pro' ),
        'nature'                    => esc_html__( 'Nature', 'travel-insight-pro' ),
        'nature-1'                  => esc_html__( 'Nature 1', 'travel-insight-pro' ),
        'sun'                       => esc_html__( 'Sun', 'travel-insight-pro' ),
        'tree-with-many-leaves'     => esc_html__( 'Tree With Many Leaves', 'travel-insight-pro' ),
        'umbrella'                  => esc_html__( 'Umbrella', 'travel-insight-pro' ),
        'rain'                      => esc_html__( 'Rain', 'travel-insight-pro' ),
        'ballons'                   => esc_html__( 'Ballons', 'travel-insight-pro' ),
        'cloud-1'                   => esc_html__( 'Cloud 1', 'travel-insight-pro' ),
        'travel'                    => esc_html__( 'Travel', 'travel-insight-pro' ),
        'car'                       => esc_html__( 'Car', 'travel-insight-pro' ),
        'double-bed'                => esc_html__( 'Double Bed', 'travel-insight-pro' ),
        'angle-arrow-pointing-to-right' => esc_html__( 'Angle Arrow Pointing To Right', 'travel-insight-pro' ),
        'star'                      => esc_html__( 'Star', 'travel-insight-pro' ),
        'man-user'                  => esc_html__( 'Man User', 'travel-insight-pro' ),
        'flag'                      => esc_html__( 'Flag', 'travel-insight-pro' ),
        'chat'                      => esc_html__( 'Chat', 'travel-insight-pro' ),
        'commenting'                => esc_html__( 'Commenting', 'travel-insight-pro' ),
        'eye-open'                  => esc_html__( 'Eye Open', 'travel-insight-pro' ),
        'forest'                    => esc_html__( 'Forest', 'travel-insight-pro' ),
        'sunbed'                    => esc_html__( 'Sunbed', 'travel-insight-pro' ),
        'angle-arrow-down'          => esc_html__( 'Angle Arrow Down', 'travel-insight-pro' ),
        'up-arrow'                  => esc_html__( 'Up Arrow', 'travel-insight-pro' ),
        'wallet-filled-money-tool'  => esc_html__( 'Wallet Filled Money Tool', 'travel-insight-pro' ),
        'cloud'                     => esc_html__( 'Cloud', 'travel-insight-pro' ),
        'calendar'                  => esc_html__( 'Calendar', 'travel-insight-pro' ),
        'deer'                      => esc_html__( 'Deer', 'travel-insight-pro' ),
        'hiking-sticks'             => esc_html__( 'Hiking Sticks', 'travel-insight-pro' ),
        'ship'                      => esc_html__( 'Ship', 'travel-insight-pro' ),
        'balloon-flying'            => esc_html__( 'Balloon Flying', 'travel-insight-pro' ),
        'zoom-in'                   => esc_html__( 'Zoom In', 'travel-insight-pro' ),
        'magnifying-glass'          => esc_html__( 'Magnifying Glass', 'travel-insight-pro' ),
        'passport'                  => esc_html__( 'Passport', 'travel-insight-pro' ),
        'menu-bar'                  => esc_html__( 'Menu Bar', 'travel-insight-pro' ),
      );

      $output = apply_filters( 'travel_insight_pro_icons_options', $travel_insight_pro_icons_options );

      return $output;
    }
endif;

if ( ! function_exists( 'travel_insight_pro_selected_sidebar' ) ) :
    /**
     * Sidebar selected
     * @return array Sidbar selected
     */
    function travel_insight_pro_selected_sidebar() {
        $travel_insight_pro_selected_sidebar = array(
            'sidebar-1'                                   => esc_html__( 'Primary Sidebar', 'travel-insight-pro' ),
            'travel-insight-pro-optional-sidebar'    => esc_html__( 'Optional Sidebar 1', 'travel-insight-pro' ),
            'travel-insight-pro-optional-sidebar-2'  => esc_html__( 'Optional Sidebar 2', 'travel-insight-pro' ),
            'travel-insight-pro-optional-sidebar-3'  => esc_html__( 'Optional Sidebar 3', 'travel-insight-pro' ),
        );

        $output = apply_filters( 'travel_insight_pro_selected_sidebar', $travel_insight_pro_selected_sidebar );

        return $output;
    }
endif;

if ( ! function_exists( 'travel_insight_pro_header_image' ) ) :
    /**
     * Header image options
     * @return array Header image options
     */
    function travel_insight_pro_header_image() {
        $travel_insight_pro_header_image = array(
            'show-both' => esc_html__( 'Show Both( Featured and Header Image )', 'travel-insight-pro' ),
            'enable'    => esc_html__( 'Enable( Featured Image )', 'travel-insight-pro' ),
            'default'   => esc_html__( 'Default ( Customizer Header Image )', 'travel-insight-pro' ),
        );

        $output = apply_filters( 'travel_insight_pro_header_image', $travel_insight_pro_header_image );

        return $output;
    }
endif;

if ( ! function_exists( 'travel_insight_pro_slider_effect' ) ) :
    /**
     * Slider effects
     * @return array Slider effects
     */
    function travel_insight_pro_slider_effect() {
      $travel_insight_pro_slider_effect = array(
            'fade'                                        => esc_html__( 'Fade', 'travel-insight-pro' ),
            'cubic-bezier(0.250, 0.250, 0.750, 0.750)'    => esc_html__( 'Linear', 'travel-insight-pro' ),
            'cubic-bezier(0.250, 0.100, 0.250, 1.000)'    => esc_html__( 'Ease', 'travel-insight-pro' ),
            'cubic-bezier(0.950, 0.050, 0.795, 0.035)'    => esc_html__( 'cubic', 'travel-insight-pro' ),
            'cubic-bezier(0.600, -0.280, 0.735, 0.045)'   => esc_html__( 'Ease In Back', 'travel-insight-pro' ),
            'cubic-bezier(0.785, 0.135, 0.150, 0.860)'    => esc_html__( 'EaseInOutCirc', 'travel-insight-pro' ),
            'cubic-bezier(0.680, -0.550, 0.265, 1.550)'   => esc_html__( 'EaseInOutBack', 'travel-insight-pro' ),
        );

        $output =  apply_filters( 'travel_insight_pro_slider_effect', $travel_insight_pro_slider_effect );

        return $output;
    }
endif;

if ( ! function_exists( 'travel_insight_pro_slider_transition_duration' ) ) :
    /**
     * Slider transition duration
     * @return array Slider transition duration
     */
    function travel_insight_pro_slider_transition_duration() {
        $travel_insight_pro_slider_transition_duration = array(
            '1000'    => esc_html__( '1 sec', 'travel-insight-pro' ),
            '2000'    => esc_html__( '2 sec', 'travel-insight-pro' ),
            '3000'    => esc_html__( '3 sec', 'travel-insight-pro' ),
            '4000'    => esc_html__( '4 sec', 'travel-insight-pro' ),
            '5000'    => esc_html__( '5 sec', 'travel-insight-pro' ),
        );

        $output =  apply_filters( 'travel_insight_pro_slider_transition_duration', $travel_insight_pro_slider_transition_duration );

        return $output;
    }
endif;

if ( ! function_exists( 'travel_insight_pro_slider_layout' ) ) :
    /**
     * Slider content type
     * @return array Slider content type
     */
    function travel_insight_pro_slider_layout() {
        $travel_insight_pro_slider_layout = array(
            'sticky-slider'    => esc_html__( 'Single Background', 'travel-insight-pro' ),
            'normal-slider'    => esc_html__( 'Normal Slider', 'travel-insight-pro' ),
        );

        $output =  apply_filters( 'travel_insight_pro_slider_layout', $travel_insight_pro_slider_layout );

        return $output;
    }
endif;

if ( ! function_exists( 'travel_insight_pro_slider_content_type' ) ) :
    /**
     * Slider content type
     * @return array Slider content type
     */
    function travel_insight_pro_slider_content_type() {
        $travel_insight_pro_slider_content_type = array(
            'demo'      => esc_html__( 'Demo', 'travel-insight-pro' ),
            'custom'    => esc_html__( 'Custom', 'travel-insight-pro' ),
            'page'      => esc_html__( 'Page', 'travel-insight-pro' ),
            'post'      => esc_html__( 'Post', 'travel-insight-pro' ),
            'category'  => esc_html__( 'Category', 'travel-insight-pro' ),
        );

        if ( class_exists( 'WooCommerce' ) ) {
            $travel_insight_pro_slider_content_type = array_merge( $travel_insight_pro_slider_content_type, array(
                'product'   => esc_html__( 'Product', 'travel-insight-pro' ),
                'product-category'   => esc_html__( 'Product Category', 'travel-insight-pro' ),
                ) );
        }

        $output =  apply_filters( 'travel_insight_pro_slider_content_type', $travel_insight_pro_slider_content_type );

        return $output;
    }
endif;


if ( ! function_exists( 'travel_insight_pro_popular_destination_content_type' ) ) :
    /**
     * Popular Destination content type
     * @return array Popular Destination content type
     */
    function travel_insight_pro_popular_destination_content_type() {
        $travel_insight_pro_popular_destination_content_type = array(
            'demo'              => esc_html__( 'Demo', 'travel-insight-pro' ),
            'page'              => esc_html__( 'Page', 'travel-insight-pro' ),
            'post'              => esc_html__( 'Post', 'travel-insight-pro' ),
            'category'          => esc_html__( 'Category', 'travel-insight-pro' ),
        );

        if ( class_exists('TP_Travel_Package') ) {
            $travel_insight_pro_popular_destination_content_type = array_merge( 
                $travel_insight_pro_popular_destination_content_type, 
                array(
                    'destination'       => esc_html__( 'Destination', 'travel-insight-pro' ),
                    'package'           => esc_html__( 'Package', 'travel-insight-pro' ),
                    'package-category'  => esc_html__( 'Package Category', 'travel-insight-pro' ),
                    ) );
        }

        if ( class_exists('WP_Travel') ) {
            $travel_insight_pro_popular_destination_content_type = array_merge( 
                $travel_insight_pro_popular_destination_content_type, 
                array(
                    'trips'    => esc_html__( 'Trips', 'travel-insight-pro' ),
                    'trip-types'    => esc_html__( 'Trip Types', 'travel-insight-pro' ),
                    ) );
        }

        $output =  apply_filters( 'travel_insight_pro_popular_destination_content_type', $travel_insight_pro_popular_destination_content_type );

        return $output;
    }
endif;


if ( ! function_exists( 'travel_insight_pro_about_us_content_type' ) ) :
    /**
     * About Us content type
     * @return array About Us content type
     */
    function travel_insight_pro_about_us_content_type() {
        $travel_insight_pro_about_us_content_type = array(
            'demo'      => esc_html__( 'Demo', 'travel-insight-pro' ),
            'custom'    => esc_html__( 'Custom', 'travel-insight-pro' ),
            'page'      => esc_html__( 'Page', 'travel-insight-pro' ),
            'post'      => esc_html__( 'Post', 'travel-insight-pro' ),
        );

        $output =  apply_filters( 'travel_insight_pro_about_us_content_type', $travel_insight_pro_about_us_content_type );

        return $output;
    }
endif;

if ( ! function_exists( 'travel_insight_pro_about_us_image_alignment' ) ) :
    /**
     * About Us image alignment
     * @return array About Us image alignment
     */
    function travel_insight_pro_about_us_image_alignment() {
        $travel_insight_pro_about_us_image_alignment = array(
            'align-left'  => esc_html__( 'Left Alignment', 'travel-insight-pro' ),
            'align-right' => esc_html__( 'Right Alignment', 'travel-insight-pro' ),
        );

        $output =  apply_filters( 'travel_insight_pro_about_us_image_alignment', $travel_insight_pro_about_us_image_alignment );

        return $output;
    }
endif;

if ( ! function_exists( 'travel_insight_pro_articles_content_type' ) ) :
    /**
     * Articles content type
     * @return array Articles content type
     */
    function travel_insight_pro_articles_content_type() {
        $travel_insight_pro_articles_content_type = array(
            'demo'      => esc_html__( 'Demo', 'travel-insight-pro' ),
            'category'  => esc_html__( 'Category', 'travel-insight-pro' ),
        );

        $output =  apply_filters( 'travel_insight_pro_articles_content_type', $travel_insight_pro_articles_content_type );

        return $output;
    }
endif;

if ( ! function_exists( 'travel_insight_pro_tours_content_type' ) ) :
    /**
     * Tours content type
     * @return array Tours content type
     */
    function travel_insight_pro_tours_content_type() {
        $travel_insight_pro_tours_content_type = array(
            'demo'              => esc_html__( 'Demo', 'travel-insight-pro' ),
            'custom'            => esc_html__( 'Custom', 'travel-insight-pro' ),
            'category'          => esc_html__( 'Category', 'travel-insight-pro' ),
        );

        if ( class_exists('TP_Travel_Package') ) {
            $travel_insight_pro_tours_content_type = array_merge( 
                $travel_insight_pro_tours_content_type, 
                array(
                    'package-category'  => esc_html__( 'Package Category', 'travel-insight-pro' ),
                    ) );
        }

        if ( class_exists('WP_Travel') ) {
            $travel_insight_pro_tours_content_type = array_merge( 
                $travel_insight_pro_tours_content_type, 
                array(
                    'destination'   => esc_html__( 'Destination', 'travel-insight-pro' ),
                    'activity'      => esc_html__( 'Activity', 'travel-insight-pro' ),
                    'trip-types'    => esc_html__( 'Trip Types', 'travel-insight-pro' ),
                    ) );
        }

        $output =  apply_filters( 'travel_insight_pro_tours_content_type', $travel_insight_pro_tours_content_type );

        return $output;
    }
endif;

if ( ! function_exists( 'travel_insight_pro_packages_content_type' ) ) :
    /**
     * Tours content type
     * @return array Tours content type
     */
    function travel_insight_pro_packages_content_type() {
        $travel_insight_pro_packages_content_type = array(
            'category'          => esc_html__( 'Category', 'travel-insight-pro' ),
        );

        if ( class_exists('WP_Travel') ) {
            $travel_insight_pro_packages_content_type = array_merge( 
                $travel_insight_pro_packages_content_type, 
                array(
                    'destination'   => esc_html__( 'Destination', 'travel-insight-pro' ),
                    'activity'      => esc_html__( 'Activity', 'travel-insight-pro' ),
                    'trip-types'    => esc_html__( 'Trip Types', 'travel-insight-pro' ),
                    ) );
        }

        $output =  apply_filters( 'travel_insight_pro_packages_content_type', $travel_insight_pro_packages_content_type );

        return $output;
    }
endif;

if ( ! function_exists( 'travel_insight_pro_tours_icon_type' ) ) :
    /**
     * Tours content type
     * @return array Tours content type
     */
    function travel_insight_pro_tours_icon_type() {
        $travel_insight_pro_tours_icon_type = array(
            'icon'  => esc_html__( 'Icon', 'travel-insight-pro' ),
            'image' => esc_html__( 'Image', 'travel-insight-pro' ),
        );

        $output =  apply_filters( 'travel_insight_pro_tours_icon_type', $travel_insight_pro_tours_icon_type );

        return $output;
    }
endif;

if ( ! function_exists( 'travel_insight_pro_counter_content_type' ) ) :
    /**
     * Counter content type
     * @return array Counter content type
     */
    function travel_insight_pro_counter_content_type() {
        $travel_insight_pro_counter_content_type = array(
            'demo'      => esc_html__( 'Demo', 'travel-insight-pro' ),
            'custom'    => esc_html__( 'Custom', 'travel-insight-pro' ),
        );

        $output =  apply_filters( 'travel_insight_pro_counter_content_type', $travel_insight_pro_counter_content_type );

        return $output;
    }
endif;

if ( ! function_exists( 'travel_insight_pro_recent_product_content_type' ) ) :
    /**
     * Product Options
     * @return array site product options
     */
    function travel_insight_pro_recent_product_content_type() {
        $travel_insight_pro_recent_product_content_type = array(
            'product'   => esc_html__( 'Product', 'travel-insight-pro' ),
            'product-category'   => esc_html__( 'Product Category', 'travel-insight-pro' ),
        );

        $output = apply_filters( 'travel_insight_pro_recent_product_content_type', $travel_insight_pro_recent_product_content_type );

        return $output;
    }
endif;

if ( ! function_exists( 'travel_insight_pro_latest_product_content_type' ) ) :
    /**
     * Product Options
     * @return array site product options
     */
    function travel_insight_pro_latest_product_content_type() {
        $travel_insight_pro_latest_product_content_type = array(
            'product'   => esc_html__( 'Product', 'travel-insight-pro' ),
            'product-category'   => esc_html__( 'Product Category', 'travel-insight-pro' ),
        );

        $output = apply_filters( 'travel_insight_pro_latest_product_content_type', $travel_insight_pro_latest_product_content_type );

        return $output;
    }
endif;

/*
 * Custom Template
 */

if ( ! function_exists( 'travel_insight_pro_about_us_template_slider_type' ) ) :
    /**
     * About Us template slider type
     * @return array About Us template slider type
     */
    function travel_insight_pro_about_us_template_slider_type() {
        $travel_insight_pro_about_us_template_slider_type = array(
            'custom'    => esc_html__( 'Custom', 'travel-insight-pro' ),
            'page'      => esc_html__( 'Page', 'travel-insight-pro' ),
            'post'      => esc_html__( 'Post', 'travel-insight-pro' ),
        );

        $output =  apply_filters( 'travel_insight_pro_about_us_template_slider_type', $travel_insight_pro_about_us_template_slider_type );

        return $output;
    }
endif;

if ( ! function_exists( 'travel_insight_pro_map' ) ) :
    /**
     * map content types
     * @return array Content types
     */
    function travel_insight_pro_map() {
        $travel_insight_pro_content_type = array(
            'shortcode' => esc_html__( 'Shortcode', 'travel-insight-pro' ),
            'embed'     => esc_html__( 'Embed Code', 'travel-insight-pro' ),
        ); 

        $output = apply_filters( 'travel_insight_pro_map', $travel_insight_pro_content_type );

        return $output;
    }
endif;

if ( ! function_exists( 'travel_insight_pro_sortable' ) ) :
    /**
     * sections sortable option
     * @return array
     */
    function travel_insight_pro_sortable(){

        $sections = array(
            'slider'                => esc_html__( 'Featured Slider', 'travel-insight-pro' ),
            'popular_destination'   => esc_html__( 'Popular Destination', 'travel-insight-pro' ),
            'about_us'              => esc_html__( 'About', 'travel-insight-pro' ),
            'articles'              => esc_html__( 'Articles', 'travel-insight-pro' ),
            'gallery'               => esc_html__( 'Gallery', 'travel-insight-pro' ),
            'tours'                 => esc_html__( 'Tours', 'travel-insight-pro' ),
            'guide'                 => esc_html__( 'Guide', 'travel-insight-pro' ),
            'call_to_action'        => esc_html__( 'Call to Action', 'travel-insight-pro' ),
            'counter'               => esc_html__( 'Counter', 'travel-insight-pro' ),
            'packages'              => esc_html__( 'Packages', 'travel-insight-pro' ),
            );

        $output = apply_filters( 'travel_insight_pro_sortable', $sections );
        
        return $output ;
    }
endif;