<?php
/**
 * Custom Info Widget
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

if ( ! class_exists( 'Travel_Insight_Pro_Custom_Page_Widget' ) ) :
	/**
	 * Custom Info class.
	 *
	 * @since 1.0
	 */
	class Travel_Insight_Pro_Custom_Page_Widget extends WP_Widget {

		/**
		 * Sets up the widgets name etc
		 */
		public function __construct() {
			$widget_ops = array(
				'classname' => 'custom_page_widget',
				'description' => esc_html__( 'A widget to show basic informations with icons and social menu.', 'travel-insight-pro' ),
			);
			parent::__construct( 'custom_page_widget', esc_html__( 'TP : Custom Page Info', 'travel-insight-pro' ), $widget_ops );
		}

		/**
		 * Outputs the content of the widget
		 *
		 * @param array $args
		 * @param array $instance
		 */
		public function widget( $args, $instance ) {
			// outputs the content of the widget
			if ( ! isset( $args['widget_id'] ) ) {
				$args['widget_id'] = $this->id;
			}
			$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : '';
			$icon = ( ! empty( $instance['icon'] ) ) ? $instance['icon'] : '';
			$contact_value = ( ! empty( $instance['contact_value'] ) ) ? $instance['contact_value'] : '';
			$display_social_menu = $instance['display_social_menu'];
			echo $args['before_widget'];
			 
			if ( ! empty( $icon ) ) {
				echo '<span>' . travel_insight_pro_get_svg( array( 'icon' => esc_attr( $icon ) ) ) . '</span>';
			}

			if ( ! empty( $title ) ) {
				echo $args['before_title'] . esc_html( $title ) . $args['after_title'];
			}

			if ( ! empty( $contact_value ) ) {
				echo '<p>' . wp_kses_post( $contact_value ) . '</p>';
			}

			if ( $display_social_menu ) {
				wp_nav_menu( array( 
	                'theme_location' => 'social', 
	                'menu_id'        => 'social-menu', 
	                'menu_class'     => 'social-icons', 
	                'fallback_cb'    => false,
	                'depth'    		 => 1,
	                'link_before'    => '<span class="screen-reader-text">',
					'link_after'     => '</span>' . travel_insight_pro_get_svg( array( 'icon' => 'chain' ) ),
	            ) ); 
			}
				
			echo $args['after_widget'];
		}

		/**
		 * Outputs the options form on admin
		 *
		 * @param array $instance The widget options
		 */
		public function form( $instance ) {
			$title = isset( $instance['title'] ) ? esc_html( $instance['title'] ) : '';
		   	?>

			<p>
			   	<label for="<?php echo esc_attr( $this->get_field_id('title') ); ?>"><?php esc_html_e( 'Title:', 'travel-insight-pro' ); ?></label>
			   	<input class="widefat" id="<?php echo esc_attr( $this->get_field_id('title') ); ?>" name="<?php echo esc_attr( $this->get_field_name('title') ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
			</p>

		   	<?php 
		   	$icons = travel_insight_pro_icons_options();
	   		$icon_selected = isset( $instance['icon'] ) ? $instance['icon'] : ''; ?>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'icon' ) ); ?>"><?php esc_html_e( 'Select Icon', 'travel-insight-pro' ); ?></label>

				<select id="<?php echo esc_attr( $this->get_field_id( 'icon' ) ); ?>" class="widefat" name="<?php echo esc_attr( $this->get_field_name( 'icon' ) ); ?>">
					<?php foreach ( $icons as $field => $value ) : ?>
						<option value="<?php echo esc_attr( $field ); ?>" <?php selected( $field, $icon_selected ); ?>><?php echo esc_html( $value ); ?></option>
					<?php endforeach; ?>
				</select>
				<small><?php esc_html_e( 'Please select icon for detail', 'travel-insight-pro' ); ?></small>
			</p>
		   <?php $contact_value = ! empty( $instance['contact_value'] ) ? $instance['contact_value'] : ''; ?>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'contact_value' ) ); ?>"><?php esc_html_e( 'Content', 'travel-insight-pro' ); ?></label>
				<textarea class="widefat" rows="2" cols="10" id="<?php echo esc_attr( $this->get_field_id('contact_value' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name('contact_value') ); ?>"><?php echo esc_textarea( $contact_value ); ?></textarea>
			</p>

			<?php $display_social_menu = ! empty( $instance['display_social_menu'] ) ? $instance['display_social_menu'] : ''; ?>
			<p>
	        	<input class="checkbox" type="checkbox" <?php checked( $display_social_menu, true ) ?> id="<?php echo esc_attr( $this->get_field_id( 'display_social_menu' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'display_social_menu' ) ); ?>" />
	        	<label for="<?php echo esc_attr( $this->get_field_id( 'display_social_menu' ) ); ?>"><?php esc_html_e( 'Check to diplay social menu.', 'travel-insight-pro' ); ?></label><br />
	        </p>
   		<?php
		}

		/**
		 * Processing widget options on save
		 *
		 * @param array $new_instance The new options
		 * @param array $old_instance The previous options
		 */
		public function update( $new_instance, $old_instance ) {
			// processes widget options to be saved
			$instance = $old_instance;
			$instance['title'] 	= sanitize_text_field( $new_instance['title'] );
			$instance['icon'] 	= esc_attr( $new_instance['icon'] );
			$instance['display_social_menu'] = travel_insight_pro_sanitize_checkbox( $new_instance['display_social_menu'] );
			$instance['contact_value'] = wp_kses_post( $new_instance['contact_value'] );
			
			return $instance;
		}
	}
endif;

function travel_insight_pro_register_Custom_Page_Widget() {
	register_widget( 'Travel_Insight_Pro_Custom_Page_Widget' );
}
add_action( 'widgets_init', 'travel_insight_pro_register_Custom_Page_Widget' );