<?php
/**
 * Theme Palace widgets inclusion
 *
 * This is the template that includes all custom widgets of Theme Palace
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function travel_insight_pro_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'travel-insight-pro' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'travel-insight-pro' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	
	register_sidebar( array(
		'name'          => esc_html__( 'Two column Sidebar', 'travel-insight-pro' ),
		'id'            => 'two-column-sidebar',
		'description'   => esc_html__( 'Add widgets here.', 'travel-insight-pro' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	// Optional Sidebar Widget Area
	register_sidebars( 3, array(
		'name'          => esc_html__( 'Optional Sidebar %d', 'travel-insight-pro' ),
		'id'            => 'travel-insight-pro-optional-sidebar',
		'description'   => esc_html__( 'Add widgets here.', 'travel-insight-pro' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	// Footer Widget Area
	register_sidebars( 4, array(
		'name'          => esc_html__( 'Footer Widget Area %d', 'travel-insight-pro' ),
		'id'            => 'travel-insight-pro-footer-widget-area',
		'description'   => esc_html__( 'This Widget Area is for Footer Section.', 'travel-insight-pro' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4 class="widget-title">',
		'after_title'   => '</h4>',
	) );

	// Contact Page Widget Area
	register_sidebar( array(
		'name'          => esc_html__( 'Contact Page Widget Area', 'travel-insight-pro' ),
		'id'            => 'travel-insight-pro-contact-sidebar',
		'description'   => esc_html__( 'Add widgets here.', 'travel-insight-pro' ),
		'before_widget' => '<div id="%1$s" class="widget column-wrapper %2$s"><div class="contact-details clear">',
		'after_widget'  => '</div></div>',
		'before_title'  => '<h4>',
		'after_title'   => '</h4>',
	) );

}
add_action( 'widgets_init', 'travel_insight_pro_widgets_init' );

/*
 * Add Ad image widget
 */
require get_template_directory() . '/inc/widgets/ad-image-widget.php';
/*
 * Add Contact info widget
 */
require get_template_directory() . '/inc/widgets/contact-info-widget.php';
/*
 * Add Contact page widget
 */
require get_template_directory() . '/inc/widgets/contact-page-widget.php';
/*
 * Add instagram widget
 */
require get_template_directory() . '/inc/widgets/instagram-widget.php';
/*
 * Add Latest Posts widget
 */
require get_template_directory() . '/inc/widgets/latest-posts-widget.php';
/*
 * Add popular post meta
 */
require get_template_directory() . '/inc/widgets/popular-post/popular-post-meta.php';
/*
 * Add popular post widget
 */
require get_template_directory() . '/inc/widgets/popular-post/popular-post-widget.php';
/*
 * Add gallery slider widget
 */
require get_template_directory() . '/inc/widgets/gallery-slider-widget.php';
/*
 * Add steps slider widget
 */
require get_template_directory() . '/inc/widgets/steps-slider-widget.php';
/*
 * Add steps slider widget
 */
require get_template_directory() . '/inc/widgets/about-info-widget.php';

