<?php
/**
 * Woocommerce
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

/**
 * Make theme WooCommerce ready
 */
remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);
remove_action( 'woocommerce_before_main_content','woocommerce_breadcrumb', 20 );

add_filter( 'woocommerce_show_page_title', 'travel_insight_pro_show_title' );
if ( ! function_exists( 'travel_insight_pro_show_title' ) ) :
	function travel_insight_pro_show_title() {
	  return;
	}
endif;

add_action('woocommerce_before_main_content', 'travel_insight_pro_primary_content_start', 20);
if ( ! function_exists( 'travel_insight_pro_primary_content_start' ) ) :
	function travel_insight_pro_primary_content_start() {
	  echo '<div class="wrapper page-section no-padding-bottom">
	  			<div id="primary" class="content-area">
					<main id="main" class="site-main" role="main">';
	}
endif;

add_action('woocommerce_after_main_content', 'travel_insight_pro_primary_content_end', 10);
add_action('woocommerce_sidebar', 'travel_insight_pro_page_section_end', 20);

if ( ! function_exists( 'travel_insight_pro_primary_content_end' ) ) :
	function travel_insight_pro_primary_content_end() {
	  echo '</main>
	  </div>';
	}
endif;

if ( ! function_exists( 'travel_insight_pro_page_section_end' ) ) :
	function travel_insight_pro_page_section_end() {
	  echo '</div>';
	}
endif;
