<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">

		<?php if ( 'post' === get_post_type() ) : ?>
			<div class="entry-meta">
				<?php travel_insight_pro_posted_on(); ?>
			</div><!-- .entry-meta -->
		<?php elseif ( 'tp-package-category' ) : ?>
			<div class="entry-meta">
				<?php travel_insight_pro_single_terms(); ?>
			</div><!-- .entry-meta -->
		<?php endif; 

	    $header_image_meta = travel_insight_pro_header_image_meta_option();
		if ( is_array( $header_image_meta ) ) {
			$header_image_meta = $header_image_meta[1];
		} 
		
		if ( 'show-both' == $header_image_meta ) { 
			if ( has_post_thumbnail() ) : ?>
				<figure class="featured-image">
					<?php the_post_thumbnail( 'full', array( 'alt' => the_title_attribute( 'echo=0' ) ) ); ?>
				</figure>
			<?php endif; 
		} ?>

	</header><!-- .entry-header -->

	<div class="entry-content">
		<?php
			the_content( sprintf(
				/* translators: %s: Name of current post. */
				wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'travel-insight-pro' ), array( 'span' => array( 'class' => array() ) ) ),
				the_title( '<span class="screen-reader-text">"', '"</span>', false )
			) );

			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'travel-insight-pro' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<?php travel_insight_pro_entry_footer(); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->
