<?php
/**
 * The template for displaying destination single posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Theme Palace
 * @subpackage Travel Insight Pro
 * @since Travel Insight Pro 1.0
 */

get_header(); 

while ( have_posts() ) : the_post();
?>

	<section id="destinations-details" class="page-section">
		<div class="wrapper">
			<div class="entry-content col-2">
				<div class="column-wrapper">
					<div class="slogan">
						<?php if ( function_exists( 'tp_destination_quote' ) ) : ?>
							<h2><?php echo esc_html( tp_destination_quote( get_the_id() ) ); ?></h2>
						<?php endif; ?>
					</div><!-- .slogan -->
				</div><!-- .column-wrapper -->

				<div class="column-wrapper">
					<?php the_content(); ?>
				</div><!-- .column-wrapper -->
			</div><!-- .entry-content -->
		</div><!-- .wrapper -->
	</section><!-- #destinations -->

<?php 
endwhile; 

$options = travel_insight_pro_get_theme_options();
$destination_background = ! empty( $options['destination_content_background'] ) ? $options['destination_content_background'] : get_template_directory_uri() . '/assets/uploads/background-03.jpg'; 
?>

<section id="travel-booking" class="col-2 page-section" style="background-image: url('<?php echo esc_url( $destination_background ); ?>');" data-stellar-background-ratio="0.5" data-stellar-vertical-offset="-400">
	<div class="blue-overlay"></div>
	<div class="wrapper">
		<div class="column-wrapper">
			<div class="promotion">
				<div class="rating">
					<span><?php esc_html_e( 'Overall Rating:', 'travel-insight-pro' ); ?></span>
					<?php 
						if ( function_exists( 'tp_destination_rating' ) ) : 
							tp_destination_rating( get_the_id() );
						endif; 
						if ( function_exists( 'tp_destination_rating_value' ) ) : 
							echo '<small>' . esc_html( tp_destination_rating_value( get_the_id() ) ) . '</small>';
						endif;
					?>
				</div><!-- .rating -->
				<header class="entry-header">
					<h2 class="entry-title"><?php the_title(); ?></h2>
				</header><!-- .entry-header -->
			</div><!-- .promotione -->
		</div><!-- .column-wrapper -->

		<?php  
		$args_1 = array(
			'post_type' => 'tp-package',
			'posts_per_page' => -1,
			'meta_query' => array(                  
				array(
					'key' => 'tp_package_featured_value',
					'value' => 'yes',
				),
				array(
					'key' => 'tp_package_destination_value',
					'value' => get_the_id(),
				)
	       	)
		);
		$args_2 = array(
			'post_type' => 'tp-package',
			'posts_per_page' => 5,
			'meta_query' => array(                  
				array(
					'key' => 'tp_package_destination_value',
					'value' => get_the_id(),
				)
	       	)
		);
		$posts = ! empty( get_posts( $args_1 ) ) ? get_posts( $args_1 ) : get_posts( $args_2 );
		if ( ! empty( $posts ) ) :
		?>

			<div class="column-wrapper">
				<div class="booking-details">
					<div class="travel-slider" data-slick='{"slidesToShow": 1, "slidesToScroll": 1, "infinite": false, "speed": 600, "dots": true, "arrows":false, "autoplay": true, "fade": false }'>

						<?php
						foreach ( $posts as $post ) : 
							$post_id = $post->ID; 
							$image = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), 'travel-insight-pro-package' );
							$image_thumbnail = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), 'post-thumbnail' );
						?>
							<div class="slider-item" data-thumb="<?php echo esc_url( $image_thumbnail[0] ); ?>" data-title="<?php echo esc_attr( $post->post_title ); ?>" data-price="<?php echo esc_html( tp_package_price( $post_id ) ); ?>">
								<div class="thumb-contents-wrapper">
									<?php if ( has_post_thumbnail( $post_id ) ) : ?>
										<div class="thumb-image">
											<a href="<?php echo esc_url( get_the_permalink( $post_id ) ); ?>">
												<img src="<?php echo esc_url( $image[0] ) ?>" width="<?php echo esc_attr( $image[1] ); ?>" height="<?php echo esc_attr( $image[2] ) ?>" alt="<?php echo esc_attr( $post->post_title ); ?>">
											</a>
											<?php if ( function_exists( 'tp_package_price' ) ) : ?>
												<span class="price"><?php echo esc_html( tp_package_price( $post_id ) ); ?></span>
											<?php endif; ?>
										</div><!-- thumb-image -->
									<?php endif; ?>

									<div class="thumb-contents">
										<?php if ( function_exists( 'tp_package_difficulty' ) ) : ?>
											<span class="medium"><?php echo esc_html( tp_package_difficulty( $post_id ) ); ?></span>
										<?php endif; ?>
										<h2><a href="<?php echo esc_url( get_the_permalink( $post_id ) ); ?>">
											<?php echo esc_html( $post->post_title ); ?>
										</a></h2>
										<div class="duration">
											<?php if ( function_exists( 'tp_package_date' ) ) : ?>
												<time><?php echo esc_html( tp_package_date( $post_id ) ); ?></time>
											<?php endif;
											if ( function_exists( 'tp_package_duration' ) ) : ?>
												<span><?php echo esc_html( tp_package_duration( $post_id ) ) . ' ' . esc_html__( 'Days', 'travel-insight-pro' ); ?></span>
											<?php endif;
											if ( function_exists( 'tp_package_pax' ) ) : ?>
												<span><?php echo esc_html( tp_package_pax( $post_id ) ) . ' ' . esc_html__( 'People', 'travel-insight-pro' ); ?></span>
											<?php endif; ?>
										</div><!-- .duration -->
										<p><?php echo esc_html( travel_insight_pro_trim_content( 25, $post ) ); ?></p>
										<a href="<?php echo esc_url( get_the_permalink( $post_id ) ); ?>" class="btn btn-transparent"><?php esc_html_e( 'Details', 'travel-insight-pro' ); ?></a>
									</div><!-- .thumb-contents -->
								</div><!-- .thumb-contents-wrapper -->
							</div><!-- .slider-item -->
						<?php endforeach; 
						wp_reset_postdata(); ?>
					</div><!-- end .regular -->
					<a href="<?php echo esc_url( get_post_type_archive_link( 'tp-package' ) ); ?>?package-destination=<?php echo get_the_id(); ?>" class="more-link"><?php echo esc_html__( 'See All Packages', 'travel-insight-pro' ) . travel_insight_pro_get_svg( array( 'icon' => 'angle-arrow-pointing-to-right') ); ?></a>
				</div><!-- .travel-slider -->
			</div><!-- .column-wrapper -->
		<?php endif; ?>
	</div><!-- .wrapper -->
</section><!-- #travel-booking -->

<?php  
$related_destination_title = ! empty( $options['related_destination_title'] ) ? $options['related_destination_title'] : '';
$related_destination_sub_title = ! empty( $options['related_destination_sub_title'] ) ? $options['related_destination_sub_title'] : '';

$args = array(
	'post_type'	=> 'tp-destination',
	'posts_per_page' => 4,
	'orderby'	=> 'rand',
	'post__not_in' => array( get_the_id() ),
	);
$posts = get_posts( $args );
if ( ! empty( $posts ) ) :
?>

	<section id="top-places" class="page-section no-padding-bottom">
		<div class="wrapper">
			<?php if ( ! empty( $related_destination_title ) || ! empty( $related_destination_sub_title ) ) : ?>
				<header class="entry-header text-center">
					<?php if ( ! empty( $related_destination_title ) ) : ?>
						<h2 class="entry-title"><?php echo esc_html( $related_destination_title ); ?></h2>
					<?php endif; 
					if ( ! empty( $related_destination_sub_title ) ) : ?>
						<h3 class="sub-title"><?php echo esc_html( $related_destination_sub_title ); ?></h3>
					<?php endif; ?>
				</header><!-- .entry-header -->
			<?php endif; ?>

			<div class="entry-content col-2">
				<?php foreach ( $posts as $post ) : 
					$post_id = $post->ID; 
					$image_thumbnail = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), 'post-thumbnail' );
					?>
					<div class="column-wrapper">
						<div class="featured-image">
							<a href="<?php echo esc_url( get_the_permalink( $post_id ) ); ?>">
								<img src="<?php echo esc_url( $image_thumbnail[0] ); ?>" width="<?php echo esc_attr( $image_thumbnail[1] ); ?>" height="<?php echo esc_attr( $image_thumbnail[2] ); ?>" alt="<?php echo esc_attr( $post->post_title ); ?>">
							</a>
						</div><!-- .featured-image -->

						<div class="top-places-content">
							<h4><a href="<?php echo esc_url( get_the_permalink( $post_id ) ); ?>"><?php echo esc_html( $post->post_title ); ?></a></h4>
							<p><?php echo esc_html( travel_insight_pro_trim_content( 15, $post ) ); ?></p>
							<a href="<?php echo esc_url( get_the_permalink( $post_id ) ); ?>" class="more-link"><?php echo esc_html__( 'View Detail', 'travel-insight-pro' ) . travel_insight_pro_get_svg( array( 'icon' => 'angle-arrow-pointing-to-right') ); ?></a>
						</div><!-- .top-places-content -->
					</div><!-- .column-wrapper -->
				<?php endforeach;; ?>
				<div class="text-center clear">
					<a href="<?php echo esc_url( get_post_type_archive_link( 'tp-destination' ) ); ?>" class="more-link"><?php echo esc_html__( 'See All Destinations', 'travel-insight-pro' ) . travel_insight_pro_get_svg( array( 'icon' => 'angle-arrow-pointing-to-right') ); ?></i></a>
				</div><!-- .text-center -->

			</div><!-- .entry-content -->
		</div><!-- .wrapper -->
	</section><!-- #top-places -->
<?php endif;

get_footer();