<?php
/**
 * Default theme options.
 *
 * @package Photo_Perfect
 */

if ( ! function_exists( 'photo_perfect_get_default_theme_options' ) ) :

	/**
	 * Get default theme options
	 *
	 * @since 1.0.0
	 *
	 * @return array Default theme options.
	 */
	function photo_perfect_get_default_theme_options() {

		$defaults = array();

		// Header.
		$defaults['show_title']                    = true;
		$defaults['show_tagline']                  = true;
		$defaults['header_sticky_menu_enabled']    = false;
		$defaults['header_menu_text']              = esc_html__( 'Menu', 'photo-perfect-pro' );
		$defaults['show_category_dropdown']        = true;
		$defaults['show_categories_as_navigation'] = false;
		$defaults['header_category_text']          = esc_html__( 'Category', 'photo-perfect-pro' );
		$defaults['header_category_number']        = 5;
		$defaults['header_category_depth']         = 1;
		$defaults['header_category_exclude']       = '';
		$defaults['show_search_form']              = false;
		$defaults['enable_shrunk_header']          = false;

		// Search.
		$defaults['search_placeholder'] = esc_html__( 'Search...', 'photo-perfect-pro' );

		// Custom Header.
		$defaults['ch_status']              = 'entire-site';
		$defaults['ch_image_alt']           = '';
		$defaults['ch_link_url']            = '';
		$defaults['ch_link_url_open']       = false;
		$defaults['ch_shrunk_header_image'] = get_template_directory_uri() . '/images/banner-image-2.jpg';

		// Slider Options.
		$defaults['featured_slider_status']              = 'disabled';
		$defaults['featured_slider_transition_effect']   = 'fadeout';
		$defaults['featured_slider_transition_delay']    = 3;
		$defaults['featured_slider_transition_duration'] = 1;
		$defaults['featured_slider_enable_arrow']        = true;
		$defaults['featured_slider_enable_pager']        = false;
		$defaults['featured_slider_enable_autoplay']     = true;
		$defaults['featured_slider_type']                = 'featured-image';
		$defaults['featured_slider_number']              = 2;

		// Layout.
		$defaults['site_layout']            = 'fluid';
		$defaults['global_layout']          = 'no-sidebar';
		$defaults['archive_layout']         = 'masonry';
		$defaults['single_image']           = 'large';
		$defaults['single_image_alignment'] = 'center';

		// Home page.
		$defaults['home_disable_swirl_design']     = false;
		$defaults['home_swirl_image']              = '';
		$defaults['home_replace_front_page_title'] = false;

		// Masonry.
		$defaults['masonry_column']                 = 3;
		$defaults['disable_masonry_popup_icon']     = false;
		$defaults['disable_masonry_link_icon']      = false;
		$defaults['disable_masonry_popup_in_image'] = false;

		// Effect.
		$defaults['disable_zoom_effect'] = false;

		// Breadcrumb.
		$defaults['breadcrumb_type'] = 'disabled';

		// Load fonts from CDN
		$defaults['load_font_cdn']        = false;	

		// Pagination.
		$defaults['pagination_type'] = 'default';

		// Footer.
		$defaults['copyright_text']  = esc_html__( 'Copyright &copy; [the-year] [the-site-link]. All rights reserved.', 'photo-perfect-pro' );
		$defaults['powered_by_text'] = esc_html__( 'Photo Perfect Pro by ', 'photo-perfect-pro' ). '<a target="_blank" rel="designer" href="https://wenthemes.com/">WEN Themes</a>';
		$defaults['go_to_top']       = true;

		// Blog.
		$defaults['excerpt_length'] = 40;
		$defaults['read_more_text'] = esc_html__( 'Read More', 'photo-perfect-pro' );

		// Advanced.
		$defaults['custom_css'] = '';

		// Font.
		$font_keys = photo_perfect_get_font_family_theme_settings_options();
		if ( ! empty( $font_keys ) ) {
			foreach ( $font_keys as $k => $v ) {
			  $defaults[ $k ]  = $v['default'];
			}
		}
		$defaults['reset_font_settings'] = false;

		// Color.
		$colors = photo_perfect_get_default_colors();
		if ( ! empty( $colors ) ) {
		  foreach ( $colors as $key => $val ) {
		    $defaults[$key] = $val;
		  }
		}


		// Pass through filter.
		$defaults = apply_filters( 'photo_perfect_filter_default_theme_options', $defaults );

		return $defaults;

	}

endif;
