<?php
/**
 * Implementation of slider feature.
 *
 * @package Photo_Perfect
 */

// Check slider status.
add_filter( 'photo_perfect_filter_slider_status', 'photo_perfect_check_slider_status' );

// Add slider to the theme.
add_action( 'photo_perfect_action_after_header', 'photo_perfect_add_featured_slider', 15 );

// Slider details.
add_filter( 'photo_perfect_filter_slider_details', 'photo_perfect_get_slider_details' );


if ( ! function_exists( 'photo_perfect_get_slider_details' ) ) :
	/**
	 * Slider details.
	 *
	 * @since 1.0.0
	 *
	 * @param array $input Slider details.
	 */
	function photo_perfect_get_slider_details( $input ) {

		$featured_slider_type   = photo_perfect_get_option( 'featured_slider_type' );
		$featured_slider_number = photo_perfect_get_option( 'featured_slider_number' );

		switch ( $featured_slider_type ) {

			case 'featured-image':
				$slides = array();

				for ( $i = 1; $i <= $featured_slider_number ; $i++) {
					$photo = photo_perfect_get_option( 'featured_slider_image_photo_' . $i );
					if ( ! empty( $photo  ) ) {
						$item = array();
						$item['images'][0] = $photo;

						$title      = photo_perfect_get_option( 'featured_slider_image_title_' . $i );
						$url        = photo_perfect_get_option( 'featured_slider_image_url_' . $i );
						$caption    = photo_perfect_get_option( 'featured_slider_image_caption_' . $i );
						$new_window = photo_perfect_get_option( 'featured_slider_image_new_window_' . $i );

						$item['title']      = esc_html( $title );
						$item['url']        = esc_url( $url );
						$item['excerpt']    = esc_html( $caption );
						$item['new_window'] = esc_attr( $new_window );

						$slides[] = $item;
					}
				}
				if ( ! empty( $slides ) ) {
					$input = $slides;
				}

				break;


			default:
				break;
		}

		return $input;
	}
endif;

if ( ! function_exists( 'photo_perfect_add_featured_slider' ) ) :
	/**
	 * Add featured slider.
	 *
	 * @since 1.0.0
	 */
	function photo_perfect_add_featured_slider() {

		$flag_apply_slider = apply_filters( 'photo_perfect_filter_slider_status', true );
		if ( true !== $flag_apply_slider ) {
			return false;
		}

		$slider_details = array();
		$slider_details = apply_filters( 'photo_perfect_filter_slider_details', $slider_details );

		if ( empty( $slider_details ) ) {
			return;
		}

		// Render slider now.
		photo_perfect_render_featured_slider( $slider_details );

	}
endif;


if ( ! function_exists( 'photo_perfect_render_featured_slider' ) ) :

	/**
	 * Render featured slider.
	 *
	 * @since 1.0.0
	 *
	 * @param array $slider_details Details of slider content.
	 */
	function photo_perfect_render_featured_slider( $slider_details = array() ) {

		if ( empty( $slider_details ) ) {
			return;
		}

		$featured_slider_transition_effect      = photo_perfect_get_option( 'featured_slider_transition_effect' );
		$featured_slider_enable_arrow           = photo_perfect_get_option( 'featured_slider_enable_arrow' );
		$featured_slider_enable_pager           = photo_perfect_get_option( 'featured_slider_enable_pager' );
		$featured_slider_enable_autoplay        = photo_perfect_get_option( 'featured_slider_enable_autoplay' );
		$featured_slider_transition_duration    = photo_perfect_get_option( 'featured_slider_transition_duration' );
		$featured_slider_transition_delay       = photo_perfect_get_option( 'featured_slider_transition_delay' );

		// Cycle data.
		$slide_data = array(
		'fx'             => esc_attr( $featured_slider_transition_effect ),
		'speed'          => esc_attr( $featured_slider_transition_duration ) * 1000,
		'pause-on-hover' => 'true',
		'loader'         => 'true',
		'log'            => 'false',
		'swipe'          => 'true',
		'auto-height'    => 'container',
		);

		if ( $featured_slider_enable_pager ) {
			$slide_data['pager-template'] = '<span class="pager-box"></span>';
		}
		if ( $featured_slider_enable_autoplay ) {
			$slide_data['timeout'] = esc_attr( $featured_slider_transition_delay ) * 1000;
		} else {
			$slide_data['timeout'] = 0;
		}

		$slide_data['slides'] = 'article';

		$slide_attributes_text = '';
		foreach ( $slide_data as $key => $item ) {

			$slide_attributes_text .= ' ';
			$slide_attributes_text .= ' data-cycle-'.esc_attr( $key );
			$slide_attributes_text .= '="'.esc_attr( $item ).'"';

		}

	?>
    <div id="featured-banner" class="featured-banner">
    <div id="featured-slider">
      <div class="container">

        <div class="cycle-slideshow" id="main-slider" <?php echo $slide_attributes_text; ?>>

			<?php if ( $featured_slider_enable_arrow ) :  ?>
            <!-- prev/next links -->
            <div class="cycle-prev"></div>
            <div class="cycle-next"></div>
			<?php endif ?>

            <?php $cnt = 1; ?>
            <?php foreach ( $slider_details as $key => $slide ) : ?>

				<?php $class_text = ( 1 === $cnt ) ? 'first' : ''; ?>
				<?php
				$target = '_self';
				if ( isset( $slide['new_window'] ) && 1 === $slide['new_window'] && ! empty( $slide['url'] ) ) {
					$target = '_blank';
				}
				$url = 'javascript:void(0);';
				if ( ! empty( $slide['url'] ) ) {
					$url = esc_url( $slide['url'] );
				}
				?>
              <article class="<?php echo esc_attr( $class_text ); ?>" data-cycle-url="<?php echo esc_url( $url ); ?>"   data-cycle-target="<?php echo esc_attr( $target ); ?>" >

                <?php if ( ! empty( $slide['url'] ) ) :  ?>
                  <a href="<?php echo esc_url( $slide['url'] ); ?>" target="<?php echo esc_attr( $target ); ?>" >
                <?php endif ?>
                  <img src="<?php echo esc_url( $slide['images'][0] ); ?>" alt="<?php echo esc_attr( $slide['title'] ); ?>"  />
                <?php if ( ! empty( $slide['url'] ) ) :  ?>
                  </a>
                <?php endif ?>

              </article>

				<?php $cnt++; ?>

            <?php endforeach ?>


            <?php if ( $featured_slider_enable_pager ) :  ?>
              <!-- pager -->
              <div class="cycle-pager"></div>
            <?php endif ?>


        </div> <!-- #main-slider -->

      </div><!-- .container -->
    </div><!-- #featured-slider -->
    </div><!-- #featured-banner -->

    <?php

	}

endif;

/**
 * Check status of slider.
 *
 * @since 1.0.0
 */
if( ! function_exists( 'photo_perfect_check_slider_status' ) ):

  function photo_perfect_check_slider_status( $input ){

    global $post, $wp_query;

    // Slider status
    $featured_slider_status = photo_perfect_get_option( 'featured_slider_status' );

    // Get Page ID outside Loop
    $page_id = $wp_query->get_queried_object_id();

    // Front page displays in Reading Settings
    $page_on_front  = get_option( 'page_on_front' ) ;
    $page_for_posts = get_option( 'page_for_posts' );

    if ( 'entire-site' == $featured_slider_status || ( ( is_front_page() || ( is_home() && $page_for_posts !== $page_id ) ) && 'home-page' === $featured_slider_status ) ){

      $input = true;
    }
    else{
      $input = false;
    }
    return $input;

  }

endif;
