<?php
/**
 * WooCommerce support class.
 *
 * @package Photo_Perfect
 */

/**
 * Woocommerce support class.
 *
 * @since 1.0.0
 */
class Photo_Perfect_Woocommerce{

  /**
   * Construcor.
   *
   * @since 1.0.0
   */
  function __construct() {

    $this->setup();
    $this->init();

  }

  /**
   * Initial setup.
   *
   * @since 1.0.0
   *
   */
  function setup(){
  }
  /**
   * Initialize hooks.
   *
   * @since 1.0.0
   *
   */
  function init() {

    // Register widgets.
    add_action( 'widgets_init', array( $this, 'register_woo_sidebars' ) );

    // Wrapper.
    remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
    remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);
    add_action('woocommerce_before_main_content', array( $this, 'woo_wrapper_start' ), 10);
    add_action('woocommerce_after_main_content', array( $this, 'woo_wrapper_end' ), 10);

    // Remove title in single.
    remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_title', 5 );

    // Title in archive.
    add_filter( 'woocommerce_show_page_title', '__return_false' );

    // Breadcrumb.
    add_filter( 'woocommerce_breadcrumb_defaults', array( $this, 'custom_woocommerce_breadcrumbs_defaults' ) );
    add_action( 'wp', array( $this, 'hooking_woo' ) );

    // Breadcrumb.
    add_filter( 'woocommerce_page_title', array( $this, 'custom_woo_page_title' ) );

    // Sidebar.
    add_action( 'woocommerce_sidebar', array( $this, 'add_secondary_sidebar' ), 11 );

    // Sidebar filter.
    add_filter( 'photo_perfect_filter_default_sidebar_id', array( $this, 'sidebar_defaults' ), 10, 2 );

    // Customizer options.
    add_action( 'customize_register', array( $this, 'customizer_fields' ) );

    // Add default options
    add_filter( 'photo_perfect_filter_default_theme_options', array( $this, 'default_options' ) );

    // Modify global layout
    add_filter( 'photo_perfect_filter_theme_global_layout', array( $this, 'modify_global_layout' ), 15 );


  }

  function default_options( $input ){

		$input['woo_page_layout']       = 'right-sidebar';
		$input['woo_sidebar_primary']   = '';
		$input['woo_sidebar_secondary'] = '';

  	return $input;
  }

  /**
   * Hooking Woocommerce.
   *
   * @since 1.0.0
   */
  function hooking_woo(){
    remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0 );
    if ( 'disabled' !== photo_perfect_get_option('breadcrumb_type') && is_woocommerce() ) {
      add_action( 'photo_perfect_action_content', array( $this, 'custom_breadcrumb' ), 12, 1 );
      remove_action( 'photo_perfect_action_content', 'photo_perfect_add_breadcrumb', 12 );
    }

    // Fixing primary sidebar
    $global_layout = photo_perfect_get_option( 'global_layout' );
    $global_layout = apply_filters( 'photo_perfect_filter_theme_global_layout', $global_layout );
    if ( in_array( $global_layout, array( 'no-sidebar', 'no-sidebar-centered' ) ) ) {
      remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10 );
    }

    // Title separator in woo pages.
    add_filter( 'photo_perfect_filter_title_separator_content', array( $this, 'custom_woo_title_separator' ) );

  }

  /**
   * Custom breadcrumb
   *
   * @param array $args Breadcrumb arguments.
   */
  function custom_breadcrumb( $args = array() ){

  	$args = apply_filters( 'woocommerce_breadcrumb_defaults' , array() );

  	$breadcrumbs = new WC_Breadcrumb();

  	if ( $args['home'] ) {
  		$breadcrumbs->add_crumb( $args['home'], apply_filters( 'woocommerce_breadcrumb_home_url', home_url() ) );
  	}

  	$args['breadcrumb'] = $breadcrumbs->generate();

  	if ( empty( $args['breadcrumb'] ) ) {
  		return;
  	}

  	extract( $args );

  	if ( ! empty( $breadcrumb ) ) {

  		echo $wrap_before;

  		$total_crumb_item = count( $breadcrumb );

  		$cnt = 0;

  		foreach ( $breadcrumb as $key => $crumb ) {

  			if ( $cnt === $total_crumb_item - 1 ) {
					$before = str_replace( 'class="', 'class="current ', $before );
				}
				$cnt++;
  			echo $before;

  			if ( ! empty( $crumb[1] ) && sizeof( $breadcrumb ) !== $key + 1 ) {
  				echo '<a href="' . esc_url( $crumb[1] ) . '">' . esc_html( $crumb[0] ) . '</a>';
  			} else {
  				echo esc_html( $crumb[0] );
  			}

  			echo $after;

  			if ( sizeof( $breadcrumb ) !== $key + 1 ) {
  				echo $delimiter;
  			}

  		}

  		echo $wrap_after;

  	}

  }

  /**
   * Modify title separator content.
   *
   * @since 1.0.0
   */
  function custom_woo_title_separator( $content ){

  	if ( is_woocommerce() ) {
  		ob_start();
  		?>
  		<div id="separator-title">
	  		<h1 class="entry-title"><?php woocommerce_page_title(); ?></h1>
  		</div>
  		<?php
  		$content = ob_get_contents();
  		ob_end_clean();
  	}

  	return $content;

  }
  /**
   * Modify global layout.
   *
   * @since 1.0.0
   */
  function modify_global_layout( $layout ){

    $woo_page_layout = photo_perfect_get_option( 'woo_page_layout' );

    if ( is_woocommerce() && ! empty( $woo_page_layout ) ) {
      $layout = esc_attr( $woo_page_layout );
    }

    return $layout;

  }

  /**
   * Add extra customizer options for WooCommerce.
   *
   * @since 1.0.0
   *
   * @param WP_Customize_Manager $wp_customize Theme Customizer object.
   */
  function customizer_fields( $wp_customize ){

  	$default = photo_perfect_get_default_theme_options();

  	// WooCommerce Section.
  	$wp_customize->add_section( 'section_theme_woocommerce',
  		array(
				'title'       => esc_html__( 'WooCommerce Options', 'photo-perfect-pro' ),
				'description' => esc_html__( 'Settings specific to WooCommerce. Note: WooCommerce Page means shop page, product page and product archive page.', 'photo-perfect-pro' ),
				'priority'    => 100,
				'capability'  => 'edit_theme_options',
				'panel'       => 'theme_option_panel',
  		)
  	);
  	// Setting - woo_page_layout.
  	$wp_customize->add_setting( 'theme_options[woo_page_layout]',
  		array(
  			'default'           => $default['woo_page_layout'],
  			'capability'        => 'edit_theme_options',
  			'sanitize_callback' => 'photo_perfect_sanitize_select',
  		)
  	);
  	$wp_customize->add_control( 'theme_options[woo_page_layout]',
  		array(
				'label'   => esc_html__( 'Content Layout', 'photo-perfect-pro' ),
				'section' => 'section_theme_woocommerce',
				'type'    => 'select',
				'choices' => photo_perfect_get_global_layout_options(),
  		)
  	);
  	// Setting - woo_sidebar_primary.
  	$wp_customize->add_setting( 'theme_options[woo_sidebar_primary]',
  		array(
  			'default'           => $default['woo_sidebar_primary'],
  			'capability'        => 'edit_theme_options',
  			'sanitize_callback' => 'sanitize_key',
  		)
  	);
  	$wp_customize->add_control(
  		new Photo_Perfect_Dropdown_Sidebars_Control( $wp_customize, 'theme_options[woo_sidebar_primary]',
  			array(
  				'label'       => esc_html__( 'Primary Sidebar', 'photo-perfect-pro' ),
  				'description' => esc_html__( 'Choose Primary Sidebar for WooCommerce pages. If not selected default sidebar will be displayed.', 'photo-perfect-pro' ),
  				'section'  => 'section_theme_woocommerce',
  				'settings' => 'theme_options[woo_sidebar_primary]',
  			)
  		)
  	);
  	// Setting - woo_sidebar_secondary.
  	$wp_customize->add_setting( 'theme_options[woo_sidebar_secondary]',
  		array(
  			'default'           => $default['woo_sidebar_secondary'],
  			'capability'        => 'edit_theme_options',
  			'sanitize_callback' => 'sanitize_key',
  		)
  	);
  	$wp_customize->add_control(
  		new Photo_Perfect_Dropdown_Sidebars_Control( $wp_customize, 'theme_options[woo_sidebar_secondary]',
  			array(
  				'label'       => esc_html__( 'Secondary Sidebar', 'photo-perfect-pro' ),
  				'description' => esc_html__( 'Choose Secondary Sidebar for WooCommerce pages. If not selected default sidebar will be displayed.', 'photo-perfect-pro' ),
  				'section'  => 'section_theme_woocommerce',
  				'settings' => 'theme_options[woo_sidebar_secondary]',
  			)
  		)
  	);

  }

  /**
   * Register Woocommerce sidebars.
   *
   * @since 1.0.0
   */
  function register_woo_sidebars(){

    register_sidebar( array(
      'name'          => __( 'WooCommerce Primary', 'photo-perfect-pro' ),
      'id'            => 'sidebar-woocommerce-primary',
      'before_widget' => '<aside id="%1$s" class="widget %2$s">',
      'after_widget'  => '</aside>',
      'before_title'  => '<h2 class="widget-title">',
      'after_title'   => '</h2>',
    ) );
    register_sidebar( array(
      'name'          => __( 'WooCommerce Secondary', 'photo-perfect-pro' ),
      'id'            => 'sidebar-woocommerce-secondary',
      'before_widget' => '<aside id="%1$s" class="widget %2$s">',
      'after_widget'  => '</aside>',
      'before_title'  => '<h2 class="widget-title">',
      'after_title'   => '</h2>',
    ) );

  }

  /**
   * Add secondary sidebar in Woocommerce.
   *
   * @since 1.0.0
   */
  function add_secondary_sidebar(){

    $global_layout = photo_perfect_get_option( 'global_layout' );
    $global_layout = apply_filters( 'photo_perfect_filter_theme_global_layout', $global_layout );

    switch ( $global_layout ) {
      case 'three-columns':
      case 'three-columns-pcs':
      case 'three-columns-cps':
      case 'three-columns-psc':
      case 'three-columns-pcs-equal':
      case 'three-columns-scp-equal':
        get_sidebar( 'secondary' );
        break;

      default:
        break;
    }

  }

  /**
   * Woocommerce content wrapper start.
   *
   * @since 1.0.0
   */
  function woo_wrapper_start() {
    echo '<div id="primary">';
    echo '<main role="main" class="site-main" id="main">';
  }

  /**
   * Woocommerce content wrapper end.
   *
   * @since 1.0.0
   */
  function woo_wrapper_end() {
    echo '</main><!-- #main -->';
    echo '</div><!-- #primary -->';
  }

  /**
   * Woocommerce page title.
   *
   * @since 1.0.0
   */
  function custom_woo_page_title( $input ){

  	if ( is_singular( 'product' ) ) {
  		$input = get_the_title();
  	}
  	return $input;

  }
  /**
   * Woocommerce breadcrumb defaults
   *
   * @since 1.0.0
   */
  function custom_woocommerce_breadcrumbs_defaults() {

    return array(
      'delimiter'   => ' ',
      'wrap_before' => '<div id="breadcrumb" itemprop="breadcrumb"><div class="container"><div id="crumbs">',
      'wrap_after'  => '</div></div></div>',
      'before'      => '<span class="crumb-item">',
      'after'       => '</span>',
      'home'        => get_bloginfo( 'name', 'display' ),
    );
  }

  /**
   * Modify woo sidebar id defaults.
   *
   * @param  string $id       Sidebar ID.
   * @param  string $location Sidebar position.
   * @return string           Modified default sidebar id.
   */
  function sidebar_defaults( $id, $location ){
    switch ( $location ) {
      case 'primary':
        $woo_sidebar_primary = photo_perfect_get_option( 'woo_sidebar_primary' );
        if ( ! empty( $woo_sidebar_primary ) ) {
          $id = esc_attr( $woo_sidebar_primary );
        }
        break;
      case 'secondary':
        $woo_sidebar_secondary = photo_perfect_get_option( 'woo_sidebar_secondary' );
        if ( ! empty( $woo_sidebar_secondary ) ) {
          $id = esc_attr( $woo_sidebar_secondary );
        }
        break;

      default:
        break;
    }
    return $id;

  }




} // End class.


// Initialize.
$photo_perfect_woocommerce = new Photo_Perfect_Woocommerce();
