<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Photo_Perfect
 */

?>

  <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

    <div class="archive-content">

      <header class="entry-header">
				<?php if ( 'post' === get_post_type() ) : ?>
	          <?php photo_perfect_show_post_categories(); ?>
				<?php endif; ?>
				<?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
				<?php if ( 'post' === get_post_type() ) : ?>
	          <div class="entry-meta">
	            <?php photo_perfect_posted_on(); ?>
	          </div><!-- .entry-meta -->
				<?php endif; ?>
      </header>
    		<?php if ( has_post_thumbnail() ) :  ?>
          <?php the_post_thumbnail( 'large', array( 'class' => 'aligncenter' ) ); ?>
    		<?php endif ?>

      <div class="entry-content">
				<?php the_content(); ?>
     </div>

    </div>

</article><!-- #post-## -->
