<?php
/**
 * Template part for displaying posts in masonry.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Photo_Perfect
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'masonry-entry' ); ?>>
	<?php
	$featured_image_full_url = '';
	if ( has_post_thumbnail() ) {
		$featured_image_full_url = wp_get_attachment_url( get_post_thumbnail_id( $post->ID ) );
	}
	?>

	<div class="masonry-thumbnail post-item">
		<?php if ( has_post_thumbnail() ) :  ?>
			<?php
			$link_open = '<a href="' . esc_url( $featured_image_full_url ) . '" class="post-thumb popup-link">';
			$link_close = '</a>';
			$disable_masonry_popup_in_image = photo_perfect_get_option( 'disable_masonry_popup_in_image' );
			if ( true === $disable_masonry_popup_in_image ) {
				$link_open = '<a href="' . esc_url( get_permalink() ) . '" class="post-thumb">';
			}
			?>
			<?php echo $link_open; ?>
			<?php the_post_thumbnail( 'large' ); ?>
			<?php echo $link_close; ?>
		<?php else : ?>
			<?php
			$no_image_url = sprintf( '%s/images/no-image-%d.png', get_template_directory_uri(), rand( 1, 2 ) );
			?>
			<a href="<?php the_permalink(); ?>" class="post-thumb">
				<img src="<?php echo esc_url( $no_image_url );?>" alt="<?php the_title_attribute(); ?>" />
			</a>
		<?php endif; ?>
		<div class="post-content">
			<?php $disable_masonry_popup_icon = photo_perfect_get_option( 'disable_masonry_popup_icon' ); ?>
			<?php if ( ! empty( $featured_image_full_url ) && true !== $disable_masonry_popup_icon ) :  ?>
				<a href="<?php echo esc_url( $featured_image_full_url ); ?>" class="popup-link"><i class="fa fa-eye"></i></a>
			<?php endif; ?>
			<?php $disable_masonry_link_icon = photo_perfect_get_option( 'disable_masonry_link_icon' ); ?>
			<?php if ( true !== $disable_masonry_link_icon ) : ?>
				<a href="<?php the_permalink(); ?>"><i class="fa fa-link"></i></a>
			<?php endif; ?>
			<h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
		</div><!-- .post-content -->
	</div><!-- .masonry-thumbnail -->

</article><!-- #post-## -->
