<?php
/**
 * Photo Perfect Theme Customizer.
 *
 * @package Photo_Perfect
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function photo_perfect_customize_register( $wp_customize ) {

	// Load custom controls.
	require get_template_directory() . '/inc/customizer/control.php';

	// Load customize helpers.
	require get_template_directory() . '/inc/helper/options.php';

	// Load customize sanitize.
	require get_template_directory() . '/inc/customizer/sanitize.php';

	// Load customize callback.
	require get_template_directory() . '/inc/customizer/callback.php';

	$wp_customize->get_setting( 'blogname' )->transport        = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport = 'postMessage';

	// Load customize option.
	require get_template_directory() . '/inc/customizer/option.php';

	// Load font family option.
	require get_template_directory() . '/inc/customizer/font.php';

	// Load color option.
	require get_template_directory() . '/inc/customizer/color.php';

	// Load slider customize option.
	require get_template_directory() . '/inc/customizer/slider.php';

	// Load reset option.
	require get_template_directory() . '/inc/customizer/reset.php';

	// Move default color option to bottom.
	$wp_customize->get_section( 'colors' )->priority = 10000;

}
add_action( 'customize_register', 'photo_perfect_customize_register' );

/**
 * Load styles for Customizer.
 *
 * @since 1.0.0
 */
function photo_perfect_load_customizer_styles() {

	global $pagenow;

	if ( 'customize.php' === $pagenow ) {

		$min = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';
		wp_enqueue_style( 'photo-perfect-customizer-style', get_template_directory_uri() . '/css/customizer' . $min . '.css', false, '2.0.0' );

	}

}

add_action( 'admin_enqueue_scripts', 'photo_perfect_load_customizer_styles' );

/**
 * Hide Custom CSS.
 *
 * @since 2.3.0
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function photo_perfect_hide_custom_css( $wp_customize ) {

	// Bail if not WP 4.7.
	if ( ! function_exists( 'wp_get_custom_css_post' ) ) {
		return;
	}

	$wp_customize->remove_control( 'theme_options[custom_css]' );

}

add_action( 'customize_register', 'photo_perfect_hide_custom_css', 99 );

/**
 * Customizer partials.
 *
 * @since 2.4.0
 */
function photo_perfect_customizer_partials( WP_Customize_Manager $wp_customize ) {

	// Abort if selective refresh is not available.
	if ( ! isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->get_setting( 'blogname' )->transport        = 'refresh';
		$wp_customize->get_setting( 'blogdescription' )->transport = 'refresh';
		return;
	}

	// Partial blogname.
	$wp_customize->selective_refresh->add_partial( 'blogname', array(
		'selector'            => '.site-title a',
		'container_inclusive' => false,
		'render_callback'     => 'photo_perfect_customize_partial_blogname',
	) );

	// Partial blogdescription.
	$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
		'selector'            => '.site-description',
		'container_inclusive' => false,
		'render_callback'     => 'photo_perfect_customize_partial_blogdescription',
	) );

}

add_action( 'customize_register', 'photo_perfect_customizer_partials', 99 );

/**
 * Render the site title for the selective refresh partial.
 *
 * @since 2.4.0
 *
 * @return void
 */
function photo_perfect_customize_partial_blogname() {

	bloginfo( 'name' );

}

/**
 * Render the site description for the selective refresh partial.
 *
 * @since 2.4.0
 *
 * @return void
 */
function photo_perfect_customize_partial_blogdescription() {

	bloginfo( 'description' );

}
