<?php
/**
 * Customizer callback functions for active_callback.
 *
 * @package Photo_Perfect
 */

if ( ! function_exists( 'photo_perfect_is_category_navigation_active' ) ) :

	/**
	 * Check if category navigation is active.
	 *
	 * @since 1.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function photo_perfect_is_category_navigation_active( $control ) {

		if ( $control->manager->get_setting( 'theme_options[show_category_dropdown]' )->value() ) {
			return true;
		} else {
			return false;
		}

	}

endif;

if ( ! function_exists( 'photo_perfect_is_simple_breadcrumb_active' ) ) :

	/**
	 * Check if simple breadcrumb is active.
	 *
	 * @since 1.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function photo_perfect_is_simple_breadcrumb_active( $control ) {

		if ( 'simple' === $control->manager->get_setting( 'theme_options[breadcrumb_type]' )->value() ) {
			return true;
		} else {
			return false;
		}

	}

endif;

if ( ! function_exists( 'photo_perfect_is_featured_slider_active' ) ) :

	/**
	 * Check if featured slider is active.
	 *
	 * @since 1.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function photo_perfect_is_featured_slider_active( $control ) {

		if ( 'disabled' !== $control->manager->get_setting( 'theme_options[featured_slider_status]' )->value() ) {
			return true;
		} else {
			return false;
		}

	}

endif;


if ( ! function_exists( 'photo_perfect_is_featured_image_slider_active' ) ) :

	/**
	 * Check if featured image slider is active.
	 *
	 * @since 1.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function photo_perfect_is_featured_image_slider_active( $control ) {

		if (
		'featured-image' === $control->manager->get_setting( 'theme_options[featured_slider_type]' )->value()
		&& 'disabled' !== $control->manager->get_setting( 'theme_options[featured_slider_status]' )->value()
		) {
			return true;
		} else {
			return false;
		}

	}

endif;
