<?php
/**
 * Theme Options.
 *
 * @package Photo_Perfect
 */

$default = photo_perfect_get_default_theme_options();

// Add Theme Options Panel.
$wp_customize->add_panel( 'theme_option_panel',
	array(
		'title'      => esc_html__( 'Theme Options', 'photo-perfect-pro' ),
		'priority'   => 100,
		'capability' => 'edit_theme_options',
	)
);

// Header Section.
$wp_customize->add_section( 'section_header',
	array(
		'title'      => esc_html__( 'Header Options', 'photo-perfect-pro' ),
		'priority'   => 100,
		'capability' => 'edit_theme_options',
		'panel'      => 'theme_option_panel',
	)
);

// Setting - show_title.
$wp_customize->add_setting( 'theme_options[show_title]',
	array(
		'default'           => $default['show_title'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'photo_perfect_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[show_title]',
	array(
		'label'    => esc_html__( 'Show Site Title', 'photo-perfect-pro' ),
		'section'  => 'section_header',
		'type'     => 'checkbox',
		'priority' => 100,
	)
);
// Setting - show_tagline.
$wp_customize->add_setting( 'theme_options[show_tagline]',
	array(
		'default'           => $default['show_tagline'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'photo_perfect_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[show_tagline]',
	array(
		'label'    => esc_html__( 'Show Tagline', 'photo-perfect-pro' ),
		'section'  => 'section_header',
		'type'     => 'checkbox',
		'priority' => 100,
	)
);

// Setting - header_sticky_menu_enabled.
$wp_customize->add_setting( 'theme_options[header_sticky_menu_enabled]',
	array(
		'default'           => $default['header_sticky_menu_enabled'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'photo_perfect_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[header_sticky_menu_enabled]',
	array(
		'label'    => esc_html__( 'Enable Sticky Menu', 'photo-perfect-pro' ),
		'section'  => 'section_header',
		'type'     => 'checkbox',
		'priority' => 100,
	)
);

// Setting - header_menu_text.
$wp_customize->add_setting( 'theme_options[header_menu_text]',
	array(
		'default'           => $default['header_menu_text'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control( 'theme_options[header_menu_text]',
	array(
		'label'    => esc_html__( 'Menu Text', 'photo-perfect-pro' ),
		'section'  => 'section_header',
		'type'     => 'text',
		'priority' => 100,
	)
);

// Setting - show_category_dropdown.
$wp_customize->add_setting( 'theme_options[show_category_dropdown]',
	array(
		'default'           => $default['show_category_dropdown'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'photo_perfect_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[show_category_dropdown]',
	array(
		'label'    => esc_html__( 'Show Category Dropdown', 'photo-perfect-pro' ),
		'section'  => 'section_header',
		'type'     => 'checkbox',
		'priority' => 100,
	)
);

// Setting - show_categories_as_navigation.
$wp_customize->add_setting( 'theme_options[show_categories_as_navigation]',
	array(
		'default'           => $default['show_categories_as_navigation'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'photo_perfect_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[show_categories_as_navigation]',
	array(
			'label'           => esc_html__( 'Show Category as Navigation', 'photo-perfect-pro' ),
			'section'         => 'section_header',
			'type'            => 'checkbox',
			'priority'        => 100,
			'active_callback' => 'photo_perfect_is_category_navigation_active',
	)
);
// Setting - header_category_text.
$wp_customize->add_setting( 'theme_options[header_category_text]',
	array(
		'default'           => $default['header_category_text'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control( 'theme_options[header_category_text]',
	array(
			'label'           => esc_html__( 'Category Text', 'photo-perfect-pro' ),
			'section'         => 'section_header',
			'type'            => 'text',
			'priority'        => 100,
			'active_callback' => 'photo_perfect_is_category_navigation_active',
	)
);

// Setting - header_category_number.
$wp_customize->add_setting( 'theme_options[header_category_number]',
	array(
		'default'           => $default['header_category_number'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'photo_perfect_sanitize_positive_integer',
	)
);
$wp_customize->add_control( 'theme_options[header_category_number]',
	array(
		'label'           => esc_html__( 'No of categories', 'photo-perfect-pro' ),
		'section'         => 'section_header',
		'type'            => 'number',
		'priority'        => 100,
		'active_callback' => 'photo_perfect_is_category_navigation_active',
		'input_attrs'     => array( 'min' => 1, 'max' => 200, 'style' => 'width: 55px;' ),
	)
);

// Setting - header_category_depth.
$wp_customize->add_setting( 'theme_options[header_category_depth]',
	array(
		'default'           => $default['header_category_depth'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'photo_perfect_sanitize_number_range',
	)
);
$wp_customize->add_control( 'theme_options[header_category_depth]',
	array(
		'label'           => esc_html__( 'Level of categories', 'photo-perfect-pro' ),
		'description'     => esc_html__( '1 for showing only top level categories.', 'photo-perfect-pro' ),
		'section'         => 'section_header',
		'type'            => 'number',
		'priority'        => 100,
		'active_callback' => 'photo_perfect_is_category_navigation_active',
		'input_attrs'     => array( 'min' => -1, 'max' => 100, 'style' => 'width: 55px;' ),
	)
);
// Setting - header_category_exclude.
$wp_customize->add_setting( 'theme_options[header_category_exclude]',
	array(
		'default'           => $default['header_category_exclude'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control( 'theme_options[header_category_exclude]',
	array(
		'label'           => esc_html__( 'Exclude categories', 'photo-perfect-pro' ),
		'description'     => esc_html__( 'Enter categories IDs separated by comma to exclude in the category menu', 'photo-perfect-pro' ),
		'section'         => 'section_header',
		'type'            => 'text',
		'priority'        => 100,
		'active_callback' => 'photo_perfect_is_category_navigation_active',
	)
);
// Setting - show_search_form.
$wp_customize->add_setting( 'theme_options[show_search_form]',
	array(
		'default'           => $default['show_search_form'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'photo_perfect_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[show_search_form]',
	array(
		'label'    => esc_html__( 'Show Search Form', 'photo-perfect-pro' ),
		'section'  => 'section_header',
		'type'     => 'checkbox',
		'priority' => 100,
	)
);

// Search Section.
$wp_customize->add_section( 'section_search',
	array(
		'title'      => esc_html__( 'Search Options', 'photo-perfect-pro' ),
		'priority'   => 100,
		'capability' => 'edit_theme_options',
		'panel'      => 'theme_option_panel',
	)
);
// Setting - search_placeholder.
$wp_customize->add_setting( 'theme_options[search_placeholder]',
	array(
		'default'           => $default['search_placeholder'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'wp_filter_nohtml_kses',
	)
);
$wp_customize->add_control( 'theme_options[search_placeholder]',
	array(
		'label'    => esc_html__( 'Search Placeholder', 'photo-perfect-pro' ),
		'section'  => 'section_search',
		'type'     => 'text',
		'priority' => 100,
	)
);

// Layout Section.
$wp_customize->add_section( 'section_layout',
	array(
		'title'      => esc_html__( 'Layout Options', 'photo-perfect-pro' ),
		'priority'   => 100,
		'capability' => 'edit_theme_options',
		'panel'      => 'theme_option_panel',
	)
);

// Setting - global_layout.
$wp_customize->add_setting( 'theme_options[global_layout]',
	array(
		'default'           => $default['global_layout'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'photo_perfect_sanitize_select',
	)
);
$wp_customize->add_control( 'theme_options[global_layout]',
	array(
		'label'    => esc_html__( 'Global Layout', 'photo-perfect-pro' ),
		'section'  => 'section_layout',
		'type'     => 'select',
		'choices'  => photo_perfect_get_global_layout_options(),
		'priority' => 100,
	)
);
// Setting - archive_layout.
$wp_customize->add_setting( 'theme_options[archive_layout]',
	array(
		'default'           => $default['archive_layout'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'photo_perfect_sanitize_select',
	)
);
$wp_customize->add_control( 'theme_options[archive_layout]',
	array(
		'label'    => esc_html__( 'Archive Layout', 'photo-perfect-pro' ),
		'section'  => 'section_layout',
		'type'     => 'select',
		'choices'  => photo_perfect_get_archive_layout_options(),
		'priority' => 100,
	)
);
// Setting - single_image.
$wp_customize->add_setting( 'theme_options[single_image]',
	array(
		'default'           => $default['single_image'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'photo_perfect_sanitize_select',
	)
);
$wp_customize->add_control( 'theme_options[single_image]',
	array(
		'label'    => esc_html__( 'Image in Single Post/Page', 'photo-perfect-pro' ),
		'section'  => 'section_layout',
		'type'     => 'select',
		'choices'  => photo_perfect_get_image_sizes_options(),
		'priority' => 100,
	)
);
// Setting - single_image_alignment.
$wp_customize->add_setting( 'theme_options[single_image_alignment]',
	array(
		'default'           => $default['single_image_alignment'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'photo_perfect_sanitize_select',
	)
);
$wp_customize->add_control( 'theme_options[single_image_alignment]',
	array(
		'label'    => esc_html__( 'Image Alignment in Single Post/Page', 'photo-perfect-pro' ),
		'section'  => 'section_layout',
		'type'     => 'select',
		'choices'  => photo_perfect_get_image_alignment_options(),
		'priority' => 100,
	)
);

// Home page.
$wp_customize->add_section( 'section_home_page',
	array(
		'title'      => esc_html__( 'Home Page Options', 'photo-perfect-pro' ),
		'priority'   => 100,
		'capability' => 'edit_theme_options',
		'panel'      => 'theme_option_panel',
	)
);

// Setting - home_disable_swirl_design.
$wp_customize->add_setting( 'theme_options[home_disable_swirl_design]',
	array(
		'default'           => $default['home_disable_swirl_design'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'photo_perfect_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[home_disable_swirl_design]',
	array(
		'label'       => esc_html__( 'Disable Swirl Design', 'photo-perfect-pro' ),
		'description' => esc_html__( 'This is the separator image in the home page.', 'photo-perfect-pro' ),
		'section'     => 'section_home_page',
		'type'        => 'checkbox',
		'priority'    => 100,
	)
);
// Setting - home_swirl_image.
$wp_customize->add_setting( 'theme_options[home_swirl_image]',
	array(
		'default'           => $default['home_swirl_image'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'photo_perfect_sanitize_image',
	)
);
$wp_customize->add_control(
	new WP_Customize_Image_Control( $wp_customize, 'theme_options[home_swirl_image]',
		array(
			'label'    => esc_html__( 'Change Swirl Image', 'photo-perfect-pro' ),
			'section'  => 'section_home_page',
			'settings' => 'theme_options[home_swirl_image]',
			'priority' => 100,
		)
	)
);
// Setting - home_replace_front_page_title.
$wp_customize->add_setting( 'theme_options[home_replace_front_page_title]',
	array(
		'default'           => $default['home_replace_front_page_title'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'photo_perfect_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[home_replace_front_page_title]',
	array(
		'label'       => esc_html__( 'Replace Static Page Title by Swirl Design', 'photo-perfect-pro' ),
		'description' => esc_html__( 'Only applies to static front page.', 'photo-perfect-pro' ),
		'section'     => 'section_home_page',
		'type'        => 'checkbox',
		'priority'    => 100,
	)
);


// Masonry Section.
$wp_customize->add_section( 'section_masonry',
	array(
		'title'      => esc_html__( 'Masonry Options', 'photo-perfect-pro' ),
		'priority'   => 100,
		'capability' => 'edit_theme_options',
		'panel'      => 'theme_option_panel',
	)
);

// Setting - masonry_column.
$wp_customize->add_setting( 'theme_options[masonry_column]',
	array(
		'default'           => $default['masonry_column'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'photo_perfect_sanitize_select',
	)
);
$wp_customize->add_control( 'theme_options[masonry_column]',
	array(
		'label'    => esc_html__( 'No of Columns', 'photo-perfect-pro' ),
		'section'  => 'section_masonry',
		'type'     => 'radio',
		'priority' => 100,
		'choices'  => photo_perfect_get_masonry_column_options(),
	)
);

// Setting - disable_masonry_popup_icon.
$wp_customize->add_setting( 'theme_options[disable_masonry_popup_icon]',
	array(
		'default'           => $default['disable_masonry_popup_icon'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'photo_perfect_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[disable_masonry_popup_icon]',
	array(
		'label'    => esc_html__( 'Disable Popup Icon', 'photo-perfect-pro' ),
		'section'  => 'section_masonry',
		'type'     => 'checkbox',
		'priority' => 100,
	)
);
// Setting - disable_masonry_link_icon.
$wp_customize->add_setting( 'theme_options[disable_masonry_link_icon]',
	array(
		'default'           => $default['disable_masonry_link_icon'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'photo_perfect_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[disable_masonry_link_icon]',
	array(
		'label'    => esc_html__( 'Disable Link Icon', 'photo-perfect-pro' ),
		'section'  => 'section_masonry',
		'type'     => 'checkbox',
		'priority' => 100,
	)
);
// Setting - disable_masonry_popup_in_image.
$wp_customize->add_setting( 'theme_options[disable_masonry_popup_in_image]',
	array(
		'default'           => $default['disable_masonry_popup_in_image'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'photo_perfect_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[disable_masonry_popup_in_image]',
	array(
		'label'    => esc_html__( 'Disable Popup in Image', 'photo-perfect-pro' ),
		'section'  => 'section_masonry',
		'type'     => 'checkbox',
		'priority' => 100,
	)
);

// Effect Section.
$wp_customize->add_section( 'section_image_effect',
	array(
		'title'      => esc_html__( 'Effect Options', 'photo-perfect-pro' ),
		'priority'   => 100,
		'capability' => 'edit_theme_options',
		'panel'      => 'theme_option_panel',
	)
);

// Setting - disable_zoom_effect.
$wp_customize->add_setting( 'theme_options[disable_zoom_effect]',
	array(
		'default'           => $default['disable_zoom_effect'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'photo_perfect_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[disable_zoom_effect]',
	array(
		'label'       => esc_html__( 'Disable Zoom Effect', 'photo-perfect-pro' ),
		'description' => esc_html__( 'Check this to disable zoom effect in masonry images.', 'photo-perfect-pro' ),
		'section'     => 'section_image_effect',
		'type'        => 'checkbox',
		'priority'    => 100,
	)
);

// Breadcrumb Section.
$wp_customize->add_section( 'section_breadcrumb',
	array(
		'title'      => esc_html__( 'Breadcrumb Options', 'photo-perfect-pro' ),
		'priority'   => 100,
		'capability' => 'edit_theme_options',
		'panel'      => 'theme_option_panel',
	)
);
// Setting - breadcrumb_type.
$wp_customize->add_setting( 'theme_options[breadcrumb_type]',
	array(
		'default'           => $default['breadcrumb_type'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'photo_perfect_sanitize_select',
	)
);
$wp_customize->add_control( 'theme_options[breadcrumb_type]',
	array(
		'label'       => esc_html__( 'Breadcrumb Type', 'photo-perfect-pro' ),
		'description' => sprintf( esc_html__( 'Advanced: Requires %1$sBreadcrumb NavXT%2$s plugin', 'photo-perfect-pro' ), '<a href="https://wordpress.org/plugins/breadcrumb-navxt/" target="_blank">', '</a>' ),
		'section'     => 'section_breadcrumb',
		'type'        => 'select',
		'choices'     => photo_perfect_get_breadcrumb_type_options(),
		'priority'    => 100,
	)
);

// Pagination Section.
$wp_customize->add_section( 'section_pagination',
	array(
		'title'      => esc_html__( 'Pagination Options', 'photo-perfect-pro' ),
		'priority'   => 100,
		'capability' => 'edit_theme_options',
		'panel'      => 'theme_option_panel',
	)
);

// Setting - pagination_type.
$wp_customize->add_setting( 'theme_options[pagination_type]',
	array(
		'default'           => $default['pagination_type'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'photo_perfect_sanitize_select',
	)
);
$wp_customize->add_control( 'theme_options[pagination_type]',
	array(
		'label'       => esc_html__( 'Pagination Type', 'photo-perfect-pro' ),
		'description' => sprintf( esc_html__( 'Numeric: Requires %1$sWP-PageNavi%2$s plugin.', 'photo-perfect-pro' ), '<a href="https://wordpress.org/plugins/wp-pagenavi/" target="_blank">', '</a>' ) . '<br />'. sprintf( __( 'Infinite Scroll: Requires %1$sJetPack - Infinite Scroll%2$s plugin', 'photo-perfect-pro' ), '<a href="https://wordpress.org/plugins/jetpack/" target="_blank">', '</a>' ),
		'section'     => 'section_pagination',
		'type'        => 'select',
		'choices'     => photo_perfect_get_pagination_type_options(),
		'priority'    => 100,
	)
);

// Footer Section.
$wp_customize->add_section( 'section_footer',
	array(
		'title'      => esc_html__( 'Footer Options', 'photo-perfect-pro' ),
		'priority'   => 100,
		'capability' => 'edit_theme_options',
		'panel'      => 'theme_option_panel',
	)
);

// Setting - copyright_text.
$wp_customize->add_setting( 'theme_options[copyright_text]',
	array(
		'default'           => $default['copyright_text'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'photo_perfect_sanitize_footer_content',
	)
);
$wp_customize->add_control( 'theme_options[copyright_text]',
	array(
		'label'    => esc_html__( 'Copyright Text', 'photo-perfect-pro' ),
		'section'  => 'section_footer',
		'type'     => 'textarea',
		'priority' => 100,
	)
);

// Setting - powered_by_text.
$wp_customize->add_setting( 'theme_options[powered_by_text]',
	array(
		'default'           => $default['powered_by_text'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'photo_perfect_sanitize_footer_content',
	)
);
$wp_customize->add_control( 'theme_options[powered_by_text]',
	array(
		'label'    => esc_html__( 'Powered By Text', 'photo-perfect-pro' ),
		'section'  => 'section_footer',
		'type'     => 'textarea',
		'priority' => 100,
	)
);

// Setting - go_to_top.
$wp_customize->add_setting( 'theme_options[go_to_top]',
	array(
		'default'           => $default['go_to_top'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'photo_perfect_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[go_to_top]',
	array(
		'label'    => esc_html__( 'Show Go To Top', 'photo-perfect-pro' ),
		'section'  => 'section_footer',
		'type'     => 'checkbox',
		'priority' => 100,
	)
);

// Blog Section.
$wp_customize->add_section( 'section_blog',
	array(
		'title'      => esc_html__( 'Blog Options', 'photo-perfect-pro' ),
		'priority'   => 100,
		'capability' => 'edit_theme_options',
		'panel'      => 'theme_option_panel',
	)
);

// Setting - excerpt_length.
$wp_customize->add_setting( 'theme_options[excerpt_length]',
	array(
		'default'           => $default['excerpt_length'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'photo_perfect_sanitize_positive_integer',
	)
);
$wp_customize->add_control( 'theme_options[excerpt_length]',
	array(
		'label'       => esc_html__( 'Excerpt Length (words)', 'photo-perfect-pro' ),
		'description' => esc_html__( 'Default is 40 words', 'photo-perfect-pro' ),
		'section'     => 'section_blog',
		'type'        => 'number',
		'priority'    => 100,
		'input_attrs' => array( 'min' => 1, 'max' => 200, 'style' => 'width: 55px;' ),
	)
);
// Setting - read_more_text.
$wp_customize->add_setting( 'theme_options[read_more_text]',
	array(
		'default'           => $default['read_more_text'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control( 'theme_options[read_more_text]',
	array(
		'label'    => esc_html__( 'Read More Text', 'photo-perfect-pro' ),
		'section'  => 'section_blog',
		'type'     => 'text',
		'priority' => 100,
	)
);

// Advanced Section.
$wp_customize->add_section( 'section_advanced',
	array(
		'title'      => esc_html__( 'Advanced Options', 'photo-perfect-pro' ),
		'priority'   => 100,
		'capability' => 'edit_theme_options',
		'panel'      => 'theme_option_panel',
	)
);

// Setting - custom_css.
$wp_customize->add_setting( 'theme_options[custom_css]',
	array(
		'default'              => $default['custom_css'],
		'capability'           => 'edit_theme_options',
		'sanitize_callback'    => 'wp_filter_nohtml_kses',
		'sanitize_js_callback' => 'wp_filter_nohtml_kses',
	)
);
$wp_customize->add_control( 'theme_options[custom_css]',
	array(
		'label'    => esc_html__( 'Custom CSS', 'photo-perfect-pro' ),
		'section'  => 'section_advanced',
		'type'     => 'textarea',
		'priority' => 100,
	)
);


// Custom header settings.
// Setting - ch_status.
$wp_customize->add_setting( 'theme_options[ch_status]',
	array(
		'default'              => $default['ch_status'],
		'capability'           => 'edit_theme_options',
		'sanitize_callback'    => 'photo_perfect_sanitize_select',
	)
);
$wp_customize->add_control( 'theme_options[ch_status]',
	array(
		'label'    => esc_html__( 'Enable Header Image', 'photo-perfect-pro' ),
		'section'  => 'header_image',
		'type'     => 'select',
		'priority' => 100,
		'choices'  => photo_perfect_get_custom_header_status_options(),
	)
);

// Setting - ch_image_alt.
$wp_customize->add_setting( 'theme_options[ch_image_alt]',
	array(
		'default'           => $default['ch_image_alt'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control( 'theme_options[ch_image_alt]',
	array(
		'label'    => esc_html__( 'Alt Text', 'photo-perfect-pro' ),
		'section'  => 'header_image',
		'type'     => 'text',
		'priority' => 100,
	)
);

// Setting - ch_link_url.
$wp_customize->add_setting( 'theme_options[ch_link_url]',
	array(
		'default'           => $default['ch_link_url'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'esc_url_raw',
	)
);
$wp_customize->add_control( 'theme_options[ch_link_url]',
	array(
		'label'    => esc_html__( 'Link URL', 'photo-perfect-pro' ),
		'section'  => 'header_image',
		'type'     => 'text',
		'priority' => 100,
	)
);

// Setting - ch_link_url_open.
$wp_customize->add_setting( 'theme_options[ch_link_url_open]',
	array(
		'default'           => $default['ch_link_url_open'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'photo_perfect_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[ch_link_url_open]',
	array(
		'label'    => esc_html__( 'Open Link in New Window', 'photo-perfect-pro' ),
		'section'  => 'header_image',
		'type'     => 'checkbox',
		'priority' => 100,
	)
);

// Setting - enable_shrunk_header.
$wp_customize->add_setting( 'theme_options[enable_shrunk_header]',
	array(
		'default'           => $default['enable_shrunk_header'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'photo_perfect_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[enable_shrunk_header]',
	array(
		'label'       => esc_html__( 'Enable Shrunk Header', 'photo-perfect-pro' ),
		'description' => esc_html__( 'This applies to all inner pages except home page.', 'photo-perfect-pro' ),
		'section'     => 'header_image',
		'type'        => 'checkbox',
		'priority'    => 100,
	)
);

// Setting - ch_shrunk_header_image.
$wp_customize->add_setting( 'theme_options[ch_shrunk_header_image]',
	array(
		'default'           => $default['ch_shrunk_header_image'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'photo_perfect_sanitize_image',
	)
);

$wp_customize->add_control(
	new WP_Customize_Image_Control( $wp_customize, 'theme_options[ch_shrunk_header_image]',
		array(
			'label'       => esc_html__( 'Default Shrinked Image for Inner pages', 'photo-perfect-pro' ),
			'description' => sprintf( __( 'Recommended size: %1$dpx x %2$dpx ', 'photo-perfect-pro' ), 1600, 350 ),
			'section'     => 'header_image',
			'settings'    => 'theme_options[ch_shrunk_header_image]',
			'priority'    => 100,
		)
	)
);
