<?php
/**
 * CSS related functions.
 *
 * This file contains hook functions which are related to CSS.
 *
 * @package Photo_Perfect
 */

if ( ! function_exists( 'photo_perfect_trigger_custom_css_action' ) ) :

	/**
	 * Do action theme custom CSS.
	 *
	 * @since 1.0.0
	 */
	function photo_perfect_trigger_custom_css_action() {

		do_action( 'photo_perfect_action_theme_custom_css' );

	}

endif;

add_action( 'wp_head', 'photo_perfect_trigger_custom_css_action', 99 );

if ( ! function_exists( 'photo_perfect_add_masonry_style' ) ) :

	/**
	 * Add masonry CSS.
	 *
	 * @since 1.0.0
	 */
	function photo_perfect_add_masonry_style() {

		$masonry_column = photo_perfect_get_option( 'masonry_column' );

		$custom_css = '';
		switch ( $masonry_column ) {
			case 4:
				$custom_css = '.masonry-entry{width:25%;}';
				break;
			case 3:
				$custom_css = '.masonry-entry{width:33.33%;}';
				break;
			default:
				break;
		}
		if ( ! empty( $custom_css ) ) {
			wp_add_inline_style( 'photo-perfect-style', $custom_css );
		}

	}
endif;

add_action( 'wp_enqueue_scripts', 'photo_perfect_add_masonry_style', 20 );

if ( ! function_exists( 'photo_perfect_add_theme_custom_font_css' ) ) :

	/**
	 * Inject theme custom font CSS.
	 *
	 * @since 1.0.0
	 */
	function photo_perfect_add_theme_custom_font_css() {

		$custom_css = '';

		$font_settings = photo_perfect_get_font_family_theme_settings_options();

		$required_fonts = array();

		if ( ! empty( $font_settings ) ) {
			foreach ( $font_settings as $key => $val ) {
				$option_value = photo_perfect_get_option( $key );
				if ( ! empty( $option_value ) && $val['default'] !== $option_value ) {
					$required_fonts[ $key ] = $option_value;
				}
			}
		}
		if ( empty( $required_fonts ) ) {
			// We do not need extra CSS.
			return;
		}

		foreach ( $required_fonts as $key => $font ) {

			$family = photo_perfect_get_font_family_from_key( $font );

			if ( ! empty( $family ) ) {

				switch ( $key ) {
					case 'font_site_default':
						$custom_css .= 'body{font-family:' . $family . '}' . "\n";
					break;

					case 'font_site_title':
						$custom_css .= '.site-title{font-family:' . $family . '}' . "\n";
					break;

					case 'font_site_tagline':
						$custom_css .= '.site-description{font-family:' . $family . '}' . "\n";
					break;

					case 'font_heading_tags':
						$custom_css .= 'h1,h2,h3,h4,h5,h6{font-family:' . $family . '}' . "\n";
					break;

					case 'font_content_title':
						$custom_css .= '.entry-header .entry-title{font-family:' . $family . '}' . "\n";
					break;

					case 'font_content_body':
						$custom_css .= '#content,#content p{font-family:' . $family . '}' . "\n";
					break;

					case 'font_navigation':
						$custom_css .= '#site-navigation ul li a,#secondary-navigation ul li a{font-family:' . $family . '}' . "\n";
					break;

					default:
					break;
				}
			}
		}

		// Render style.
		if ( ! empty( $custom_css ) ) {
			echo '<style type="text/css">';
			echo $custom_css;
			echo '</style>';
		}

	}

endif;

add_action( 'photo_perfect_action_theme_custom_css', 'photo_perfect_add_theme_custom_font_css', 20 );

if ( ! function_exists( 'photo_perfect_add_theme_custom_color_css' ) ) :

	/**
	 * Inject theme custom color CSS.
	 *
	 * @since 1.0.0
	 */
	function photo_perfect_add_theme_custom_color_css() {

		$custom_css = '';

		$color_settings = photo_perfect_get_color_theme_settings_options();

		$default = photo_perfect_get_default_colors();

		$required_colors = array();

		if ( ! empty( $color_settings ) ) {
		  foreach ($color_settings as $key => $val ) {
		    $option_value = photo_perfect_get_option( $key );
		    if ( ! empty( $option_value ) && $default[$key] != $option_value ) {
		      $required_colors[ $key ] = $option_value;
		    }
		  }
		}
		if ( empty( $required_colors ) ) {
		  // We do not need extra CSS.
		  return;
		}

		foreach ( $required_colors as $key => $color ) {

			switch ( $key ){

				// Basic.
						case 'color_basic_background':
				  $custom_css .= 'body{background-color:' . $color . '}' . "\n";
				  $custom_css .= '#crumbs > span::before{border-left-color:' . $color . '}' . "\n";
				  break;
				case 'color_basic_text':
				  $custom_css .= 'body,p{color:' . $color . '}' . "\n";
				  break;
				case 'color_basic_link':
				  $custom_css .= 'a{color:' . $color . '}' . "\n";
				  break;
				case 'color_basic_link_hover':
				  $custom_css .= 'a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_basic_heading':
				  $custom_css .= 'h1,h2,h3,h4,h5,h6{color:' . $color . '}' . "\n";
				  break;
				case 'color_basic_button_text':
				  $custom_css .= '.comment-reply-link,button, input[type="button"], input[type="reset"], input[type="submit"],#infinite-handle span button, #infinite-handle span button{color:' . $color . '}' . "\n";
				  $custom_css .= '.woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button{color:' . $color . '}' . "\n";

				  break;

				case 'color_basic_button_text_hover':
				  $custom_css .= '.comment-reply-link:hover,button:hover, input[type="button"]:hover, input[type="reset"]:hover, input[type="submit"]:hover, #infinite-handle span button:hover{color:' . $color . '}' . "\n";
				  $custom_css .= '.woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button.woocommerce:hover #respond input#submit.alt.disabled, .woocommerce #respond input#submit.alt.disabled:hover, .woocommerce #respond input#submit.alt:disabled, .woocommerce #respond input#submit.alt:disabled:hover, .woocommerce #respond input#submit.alt[disabled]:disabled, .woocommerce #respond input#submit.alt[disabled]:disabled:hover, .woocommerce a.button.alt.disabled, .woocommerce a.button.alt.disabled:hover, .woocommerce a.button.alt:disabled, .woocommerce a.button.alt:disabled:hover, .woocommerce a.button.alt[disabled]:disabled, .woocommerce a.button.alt[disabled]:disabled:hover, .woocommerce button.button.alt.disabled, .woocommerce button.button.alt.disabled:hover, .woocommerce button.button.alt:disabled, .woocommerce button.button.alt:disabled:hover, .woocommerce button.button.alt[disabled]:disabled, .woocommerce button.button.alt[disabled]:disabled:hover, .woocommerce input.button.alt.disabled, .woocommerce input.button.alt.disabled:hover, .woocommerce input.button.alt:disabled, .woocommerce input.button.alt:disabled:hover, .woocommerce input.button.alt[disabled]:disabled, .woocommerce input.button.alt[disabled]:disabled:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover:hover{color:' . $color . '}' . "\n";

				  break;
				case 'color_basic_button_background':
				  $custom_css .= '.woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button{background-color:' . $color . '}' . "\n";
				  $custom_css .= '.comment-reply-link,button, input[type="button"], input[type="reset"], input[type="submit"],#infinite-handle span button{background-color:' . $color . '}' . "\n";

				  break;
				case 'color_basic_button_background_hover':
				  $custom_css .= '.comment-reply-link:hover,button:hover, input[type="button"]:hover, input[type="reset"]:hover, input[type="submit"]:hover,#infinite-handle span button{background-color:' . $color . '}' . "\n";
				  $custom_css .= '.woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button.woocommerce:hover #respond input#submit.alt.disabled, .woocommerce #respond input#submit.alt.disabled:hover, .woocommerce #respond input#submit.alt:disabled, .woocommerce #respond input#submit.alt:disabled:hover, .woocommerce #respond input#submit.alt[disabled]:disabled, .woocommerce #respond input#submit.alt[disabled]:disabled:hover, .woocommerce a.button.alt.disabled, .woocommerce a.button.alt.disabled:hover, .woocommerce a.button.alt:disabled, .woocommerce a.button.alt:disabled:hover, .woocommerce a.button.alt[disabled]:disabled, .woocommerce a.button.alt[disabled]:disabled:hover, .woocommerce button.button.alt.disabled, .woocommerce button.button.alt.disabled:hover, .woocommerce button.button.alt:disabled, .woocommerce button.button.alt:disabled:hover, .woocommerce button.button.alt[disabled]:disabled, .woocommerce button.button.alt[disabled]:disabled:hover, .woocommerce input.button.alt.disabled, .woocommerce input.button.alt.disabled:hover, .woocommerce input.button.alt:disabled, .woocommerce input.button.alt:disabled:hover, .woocommerce input.button.alt[disabled]:disabled, .woocommerce input.button.alt[disabled]:disabled:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover{background-color:' . $color . '}' . "\n";
				  break;
				// Header.
				case 'color_header_title':
				  $custom_css .= '.site-title > a{color:' . $color . '}' . "\n";
				  break;
				case 'color_header_title_hover':
				  $custom_css .= '.site-title > a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_header_tagline':
				  $custom_css .= '.site-description{color:' . $color . '}' . "\n";
				  break;
				case 'color_header_title_border':
				  $custom_css .= '.site-title{color:' . $color . '}' . "\n";
				  break;
				case 'color_header_identity_background':
				  $custom_css .= '#site-identity{color:' . $color . '}' . "\n";
				  break;
				case 'color_header_search_form_background':
				  $custom_css .= '#header-extra .search-form{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_header_search_button_background':
				  $custom_css .= '.search-form input[type="submit"]{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_header_search_button_background_hover':
				  $custom_css .= '.search-form input[type="submit"]:hover{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_header_search_button_text':
				  $custom_css .= '.search-form input[type="submit"]{color:' . $color . '}' . "\n";
				  break;
				case 'color_header_search_button_text_hover':
				  $custom_css .= '.search-form input[type="submit"]:hover{color:' . $color . '}' . "\n";
				  break;

				// Content.
				case 'color_content_background':
				  $custom_css .= '.site-content{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_content_title':
				  $custom_css .= '.site-content .entry-title a{color:' . $color . '}' . "\n";
				  break;
				case 'color_content_text':
				  $custom_css .= '.entry-content p,.entry-content{color:' . $color . '}' . "\n";
				  break;
				case 'color_content_link':
				  $custom_css .= '.content-area a,.content-area {color:' . $color . '}' . "\n";
				  break;
				case 'color_content_link_hover':
				  $custom_css .= '.content-area  a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_content_meta_text':
				  $custom_css .= '.entry-meta span{color:' . $color . '}' . "\n";
				  break;
				case 'color_content_meta_link':
				  $custom_css .= '.entry-meta > span a{color:' . $color . '}' . "\n";
				  break;
				case 'color_content_meta_link_hover':
				  $custom_css .= '.entry-meta > span a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_content_meta_icon':
				  $custom_css .= '.entry-meta > span::before, .entry-footer > span::before, .single-post-meta > span::before{color:' . $color . '}' . "\n";
				  break;

				// Content Masonry.
				case 'color_content_masonry_title':
				  $custom_css .= '.post-content h2 a{color:' . $color . '}' . "\n";
				  break;
				case 'color_content_masonry_icon':
				  $custom_css .= '.post-content a i{color:' . $color . '}' . "\n";
				  break;
				case 'color_content_masonry_icon_hover':
				  $custom_css .= '.post-content a i:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_content_masonry_icon_background_hover':
				  $custom_css .= '.post-content a i:hover{color:' . $color . '}' . "\n";
				  break;

				// Content excerpt.
				case 'color_content_excerpt_thumbnail_border':
				  $custom_css .= '.archive-layout-excerpt .thumb-archive, .archive-layout-excerpt .archive-content{box-shadow:0 0 1px ' . $color . '}' . "\n";
				  break;
				case 'color_content_excerpt_content_background':
				  $custom_css .= '.archive-layout-excerpt .archive-content{background-color:' . $color . '}' . "\n";
				  break;
				// Sidebar.
				case 'color_sidebar_background':
				  $custom_css .= '.area-wrapper{color:' . $color . '}' . "\n";
				  break;
				case 'color_sidebar_widget_title':
				  $custom_css .= '.widget-area .widget-title{color:' . $color . '}' . "\n";
				  break;
				case 'color_sidebar_widget_text':
				  $custom_css .= '.widget-area p{color:' . $color . '}' . "\n";
				  break;
				case 'color_sidebar_widget_link':
				  $custom_css .= '.widget-area ul li a{color:' . $color . '}' . "\n";
				  break;
				case 'color_sidebar_widget_link_hover':
				  $custom_css .= '.widget-area ul li a:hover{color:' . $color . '}' . "\n";
				  break;

				// Home Page Widgets.
				case 'color_home_widgets_title':
				  $custom_css .= '#sidebar-front-page-widget-area .widget-title{color:' . $color . '}' . "\n";
				  break;
				case 'color_home_widgets_area_background':
				  $custom_css .= '#sidebar-front-page-widget-area{background-color:' . $color . '}' . "\n";
				  break;

				// Footer area.
				case 'color_footer_area_background':
				  $custom_css .= '#colophon{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_area_text':
				  $custom_css .= '#colophon p, .site-footer{color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_area_link':
				  $custom_css .= '#colophon a, #footer-navigation li a{color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_area_link_hover':
				  $custom_css .= '#colophon a:hover,#footer-navigation li a:hover{color:' . $color . '}' . "\n";
				  break;

				// Go To Top.
			    case 'color_goto_top_icon':
				  $custom_css .= '#btn-scrollup i.fa{color:' . $color . '}' . "\n";
				  break;
				case 'color_goto_top_icon_hover':
				  $custom_css .= '#btn-scrollup i.fa:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_goto_top_background':
				  $custom_css .= '#btn-scrollup{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_goto_top_background_hover':
				  $custom_css .= '#btn-scrollup:hover{background-color:' . $color . '}' . "\n";
				  break;


				// Pagination.
				case 'color_pagination_link':
				  $custom_css .= '.pagination .nav-links > a, .pagination .nav-links > span, .wp-pagenavi a, .wp-pagenavi span{color:' . $color . '}' . "\n";
				  break;
				case 'color_pagination_link_hover':
				  $custom_css .= '.pagination .nav-links > span.current, .pagination .nav-links > a:hover, .wp-pagenavi span.current, .wp-pagenavi a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_pagination_link_background':
				  $custom_css .= '.pagination .nav-links > a, .pagination .nav-links > span, .wp-pagenavi a, .wp-pagenavi span{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_pagination_link_background_hover':
				  $custom_css .= '.pagination .nav-links > span.current, .pagination .nav-links > a:hover, .wp-pagenavi span.current, .wp-pagenavi a:hover{background-color:' . $color . '}' . "\n";
				  break;

				// Breadcrumb.
				case 'color_breadcrumb_link':
				  $custom_css .= '#crumbs a{color:' . $color . '}' . "\n";
				  break;
				case 'color_breadcrumb_link_hover':
				  $custom_css .= '#crumbs a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_breadcrumb_link_background':
				  $custom_css .= '#crumbs span{background-color:' . $color . '}' . "\n";
				  $custom_css .= '#crumbs > span:after{border-left:20px solid' . $color . '}' . "\n";
				  break;
				case 'color_breadcrumb_link_background_hover':
				  $custom_css .= '#crumbs span.current,#crumbs span:hover{background-color:' . $color . '}' . "\n";
				   $custom_css .= '#crumbs > span.current::after,#crumbs > span:hover::after{border-left:20px solid ' . $color . '}' . "\n";

				  break;

				// Footer Widgets.
				case 'color_footer_widgets_background':
				  $custom_css .= '#footer-widgets{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_widgets_title':
				  $custom_css .= '#footer-widgets .widget-title{color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_widgets_text':
				  $custom_css .= '#footer-widgets p,#footer-widgets {color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_widgets_link':
				  $custom_css .= '#footer-widgets a{color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_widgets_link_hover':
				  $custom_css .= '#footer-widgets a:hover{color:' . $color . '}' . "\n";
				  break;

				// Primary Menu.
				case 'color_primary_menu_main_background':
				  $custom_css .= '#main-nav,.sticky-menu-enabled #main-nav{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_primary_menu_button_text':
				  $custom_css .= '.menu-toggle{color:' . $color . '}' . "\n";
				  break;
				case 'color_primary_menu_button_text_hover':
				  $custom_css .= '.menu-toggle:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_primary_menu_button_background':
				  $custom_css .= '.menu-toggle{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_primary_menu_button_background_hover':
				  $custom_css .= '.menu-toggle:hover{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_primary_menu_link':
				  $custom_css .= '#main-nav ul li a,.dropdown-toggle::after{color:' . $color . '}' . "\n";
				  break;
				case 'color_primary_menu_link_hover':
				  $custom_css .= '#main-nav ul li a:hover,#main-nav ul li:hover .dropdown-toggle:after,#main-nav li.current-menu-item > a,
				  #main-nav li.current_page_item > a{color:' . $color . '}' . "\n";
				  break;
				case 'color_primary_menu_link_background_hover':
				  $custom_css .= '#main-nav ul li a:hover{background-color:' . $color . '}' . "\n";
				  break;

			  // Category Menu.
			  case 'color_category_menu_main_background':
			    $custom_css .= '#category-menu,#category-menu.nav-cat{background-color:' . $color . '}' . "\n";
			    break;
			  case 'color_category_menu_button_text':
			    $custom_css .= '.nav-list-btn{color:' . $color . '}' . "\n";
			    break;
			  case 'color_category_menu_button_text_hover':
			    $custom_css .= '.nav-list-btn:hover{color:' . $color . '}' . "\n";
			    break;
			  case 'color_category_menu_button_background':
			    $custom_css .= '.nav-list-btn{background-color:' . $color . '}' . "\n";
			    break;
			  case 'color_category_menu_button_background_hover':
			    $custom_css .= '.nav-list-btn:hover{background-color:' . $color . '}' . "\n";
			    break;
			  case 'color_category_menu_link':
			    $custom_css .= '#category-menu ul li a,#category-menu .dropdown-toggle::after{color:' . $color . '}' . "\n";
			    break;
			  case 'color_category_menu_link_hover':
			    $custom_css .= '#category-menu ul li a:hover,#category-menu ul li:hover .dropdown-toggle:after,#category-menu ul li.current-cat a {color:' . $color . '}' . "\n";
			    break;
			  case 'color_category_menu_link_background_hover':
			    $custom_css .= '#category-menu ul li a:hover{background-color:' . $color . '}' . "\n";
			    break;

			  default:
			    break;

			}

		}

		// Render style.
		if ( ! empty( $custom_css ) ) {
		  echo '<style type="text/css">';
		  echo $custom_css;
		  echo '</style>';
		}

	}

endif;

add_action( 'photo_perfect_action_theme_custom_css', 'photo_perfect_add_theme_custom_color_css', 25 );
