<?php
/**
 * Jetpack Compatibility File.
 *
 * @link https://jetpack.me/
 *
 * @package Photo_Perfect
 */

/**
 * Add theme support for Infinite Scroll.
 * See: https://jetpack.me/support/infinite-scroll/
 */
function photo_perfect_jetpack_setup() {

	$pagination_type = photo_perfect_get_option( 'pagination_type' );
	if ( in_array( $pagination_type, array( 'infinite-scroll-click', 'infinite-scroll' ) ) ) {
	  $type = ( 'infinite-scroll-click' === $pagination_type ) ? 'click' : 'scroll' ;
	  add_theme_support( 'infinite-scroll', array(
			'type'           => $type,
			'container'      => 'main',
			'footer'         => 'page',
			'wrapper'        => false,
			'render'         => 'photo_perfect_infinite_scroll_render',
			'footer_widgets' => array( 'footer-1', 'footer-2', 'footer-3', 'footer-4' )
	  ) );
	}

}

add_action( 'after_setup_theme', 'photo_perfect_jetpack_setup' );

/**
 * Custom render function for Infinite Scroll.
 */
function photo_perfect_infinite_scroll_render() {
	while ( have_posts() ) {
		the_post();
		$archive_layout = photo_perfect_get_option( 'archive_layout' );
		if ( 'masonry' === $archive_layout ) {
			get_template_part( 'template-parts/content', 'masonry' );
		} else if ( 'full' === $archive_layout ) {
			get_template_part( 'template-parts/content', 'full' );
		} else {
			get_template_part( 'template-parts/content', get_post_format() );
		}
	}
} // end function photo_perfect_infinite_scroll_render
