/**
 * custom.js
 *
 * Custom scripts.
 */

( function( $ ) {



	//Masonry blocks
	jQuery(document).ready(function($) {


		if ( $( 'body').hasClass( 'archive-layout-masonry' ) && $( '#masonry-loop' ).length > 0 ) {
			//Masonry blocks
			$blocks = $("#main");

			$blocks.imagesLoaded(function(){
				$blocks.masonry({
					"columnWidth": ".hentry",
					"itemSelector": ".hentry",
					"percentPosition": true
				});

				// Fade blocks in after images are ready (prevents jumping and re-rendering)
				$(".hentry").fadeIn();
			});

			$(window).on( 'resize', function () {
				$blocks.masonry();
			});


			// When Jetpack Infinite scroll posts have loaded
			$( document.body ).on( 'post-load', function () {

				var $container = $('#main');
				// $container.masonry( 'reloadItems' );

				$blocks.imagesLoaded(function(){
					$blocks.masonry({
						"columnWidth": ".hentry",
						"itemSelector": ".hentry",
						"percentPosition": true
					});

					// Fade blocks in after images are ready (prevents jumping and re-rendering)
					$(".hentry").fadeIn();
				});

				$container.masonry( 'reloadItems' );

			});

		}; //End if masnory is activated


	});



	$( document ).ready( function( $ ) {

		// Implment popup for image in masonry.
		$( '#main' ).photobox( 'a.popup-link', {
			time:0,
			zoomable:false,
			single: true
		});

		// Implment popup for image in gallery shortcode.
		$( 'div.featured-posts-widget-wrap' ).photobox( "a.popup-link",{
			zoomable:false
		});

		// Implment popup for images in single page.
		$( 'div.entry-content' ).photobox("a[href$=\'jpg\'],a[href$=\'jpeg\'],a[href$=\'png\'],a[href$=\'bmp\'],a[href$=\'gif\'],a[href$=\'JPG\'],a[href$=\'JPEG\'],a[href$=\'PNG\'],a[href$=\'BMP\'],a[href$=\'GIF\']",{
			zoomable:false
		});

		// Implement go to top.
		var $scroll_obj = $( '#btn-scrollup' );
		if ( $scroll_obj.length > 0 ) {

			$( window ).on( 'scroll',function(){
				if ($( this ).scrollTop() > 100) {
					$scroll_obj.fadeIn();
				} else {
					$scroll_obj.fadeOut();
				}
			});

			$scroll_obj.on( 'click',function(){
				$( 'html, body' ).animate( { scrollTop: 0 }, 600 );
				return false;
			});
		}

		// sticky main menu

		if ( $('body').hasClass( 'sticky-menu-enabled' ) && $( '#main-nav' ).length > 0 ) {
			$(window).on( 'scroll',function () {
				var scrolled = $('#main-nav').outerHeight() + $('#main-nav').offset().top;
			    if( $(window).scrollTop() > scrolled && !($('#main-nav').hasClass('fixed'))){
			      $('#main-nav').addClass('fixed');
			    }
			    else if ( 0 === $(window).scrollTop() ) {

			      $('#main-nav').removeClass('fixed');
			    }
			});
		};




	});


} )( jQuery );


