<?php
/**
 * Easy Digital Downloads Theme Updater
 *
 * @package Photo Perfect
 */

// Includes the files needed for the theme updater
if ( ! class_exists( 'EDD_Theme_Updater_Admin' ) ) {
	include dirname( __FILE__ ) . '/theme-updater-admin.php';
}

$theme = wp_get_theme( get_template() );

// Loads the updater classes
$updater = new EDD_Theme_Updater_Admin(
	// Config settings
	array(
		'remote_api_url' => 'https://themepalace.com', // Site where EDD is hosted
		'item_name'      => $theme->get( 'Name' ), // Name of theme
		'theme_slug'     => $theme->get( 'TextDomain' ), // Theme slug
		'version'        => $theme->get( 'Version' ), // The current version of this theme
		'author'         => $theme->get( 'Author' ), // The author of this theme
		'download_id'    => '', // Optional, used for generating a license renewal link
		'renew_url'      => 'https://themepalace.com/my-account/', // Optional, allows for a custom license renewal link
		'beta'           => false, // Optional, set to true to opt into beta versions
		'item_id'        => '',
	),
	// Strings
	array(
		'theme-license'             => __( 'Theme License', 'photo-perfect-pro' ),
		'enter-key'                 => __( 'Enter your theme license key.', 'photo-perfect-pro' ),
		'license-key'               => __( 'License Key', 'photo-perfect-pro' ),
		'license-action'            => __( 'License Action', 'photo-perfect-pro' ),
		'deactivate-license'        => __( 'Deactivate License', 'photo-perfect-pro' ),
		'activate-license'          => __( 'Activate License', 'photo-perfect-pro' ),
		'status-unknown'            => __( 'License status is unknown.', 'photo-perfect-pro' ),
		'renew'                     => __( 'Renew?', 'photo-perfect-pro' ),
		'unlimited'                 => __( 'unlimited', 'photo-perfect-pro' ),
		'license-key-is-active'     => __( 'License key is active.', 'photo-perfect-pro' ),
		/* translators: the license expiration date */
		'expires%s'                 => __( 'Expires %s.', 'photo-perfect-pro' ),
		'expires-never'             => __( 'Lifetime License.', 'photo-perfect-pro' ),
		/* translators: 1. the number of sites activated 2. the total number of activations allowed. */
		'%1$s/%2$-sites'            => __( 'You have %1$s / %2$s sites activated.', 'photo-perfect-pro' ),
		'activation-limit'          => __( 'Your license key has reached its activation limit.', 'photo-perfect-pro' ),
		/* translators: the license expiration date */
		'license-key-expired-%s'    => __( 'License key expired %s.', 'photo-perfect-pro' ),
		'license-key-expired'       => __( 'License key has expired.', 'photo-perfect-pro' ),
		/* translators: the license expiration date */
		'license-expired-on'        => __( 'Your license key expired on %s.', 'photo-perfect-pro' ),
		'license-keys-do-not-match' => __( 'License keys do not match.', 'photo-perfect-pro' ),
		'license-is-inactive'       => __( 'License is inactive.', 'photo-perfect-pro' ),
		'license-key-is-disabled'   => __( 'License key is disabled.', 'photo-perfect-pro' ),
		'license-key-invalid'       => __( 'Invalid license.', 'photo-perfect-pro' ),
		'site-is-inactive'          => __( 'Site is inactive.', 'photo-perfect-pro' ),
		/* translators: the theme name */
		'item-mismatch'             => __( 'This appears to be an invalid license key for %s.', 'photo-perfect-pro' ),
		'license-status-unknown'    => __( 'License status is unknown.', 'photo-perfect-pro' ),
		'update-notice'             => __( "Updating this theme will lose any customizations you have made. 'Cancel' to stop, 'OK' to update.", 'photo-perfect-pro' ),
		'error-generic'             => __( 'An error occurred, please try again.', 'photo-perfect-pro' ),
		'key-not-activated'         => __( '%1$s License Key has not been activated, so the theme is inactive. %2$sClick here%3$s to activate the license key and the theme.', 'photo-perfect-pro' ),
		'get-license-key'           => __( 'Get API key from %s.', 'photo-perfect-pro' ),
		'theme-palace'              => __( 'Theme Palace', 'photo-perfect-pro' ),
	)
);
