<?php

function kelsey_header_social_block_assets() {
	wp_register_script(
		'kelsey-pro-header-social-custom-script',
		get_theme_file_uri() . '/assets/js/header-social.js',
		array(),
		filemtime( get_theme_file_path() . '/assets/js/header-social.js' ),
		true
	);

	$script_asset = require get_theme_file_path() . '/inc/blocks/dist/header-social.asset.php';

	wp_enqueue_script(
		'kelsey-pro-header-social-script',
		get_theme_file_uri() . '/inc/blocks/dist/header-social.js',
		isset( $script_asset['dependencies'] ) ? $script_asset['dependencies'] : array(),
		filemtime( get_theme_file_path() . '/inc/blocks/dist/header-social.js' ),
		true
	);

	wp_register_style(
		'kelsey-pro-header-social-style',
		get_theme_file_uri() . '/inc/blocks/dist/style-header-social.css',
		array(),
		filemtime( get_theme_file_path() . '/inc/blocks/dist/style-header-social.css' ),
		'all'
	);

	register_block_type_from_metadata( __DIR__ , array(
		'render_callback' => 'kelsey_render_header_social'
	) );

}
add_action( 'init', 'kelsey_header_social_block_assets' );

function kelsey_render_header_social( $attr, $content ) {
	ob_start();
    ?>
    <div class="wp-block-kelsey-pro-header-social">
		<button class="social-controller">
			<svg class="social svg" width="20" height="20" viewBox="0 0 458.624 458.624" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
				<path d="M339.588,314.529c-14.215,0-27.456,4.133-38.621,11.239l-112.682-78.67c1.809-6.315,2.798-12.976,2.798-19.871 c0-6.896-0.989-13.557-2.798-19.871l109.64-76.547c11.764,8.356,26.133,13.286,41.662,13.286c39.79,0,72.047-32.257,72.047-72.047 C411.634,32.258,379.378,0,339.588,0c-39.79,0-72.047,32.257-72.047,72.047c0,5.255,0.578,10.373,1.646,15.308l-112.424,78.491 c-10.974-6.759-23.892-10.666-37.727-10.666c-39.79,0-72.047,32.257-72.047,72.047s32.256,72.047,72.047,72.047 c13.834,0,26.753-3.907,37.727-10.666l113.292,79.097c-1.629,6.017-2.514,12.34-2.514,18.872c0,39.79,32.257,72.047,72.047,72.047 c39.79,0,72.047-32.257,72.047-72.047C411.635,346.787,379.378,314.529,339.588,314.529z"></path>
			</svg>

			<svg class="cross svg" width="20" height="20" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg">
				<path fill-rule="evenodd" d="M11.2929,3.29289 C11.6834,2.90237 12.3166,2.90237 12.7071,3.29289 C13.0976,3.68342 13.0976,4.31658 12.7071,4.70711 L9.41421,8 L12.7071,11.2929 C13.0976,11.6834 13.0976,12.3166 12.7071,12.7071 C12.3166,13.0976 11.6834,13.0976 11.2929,12.7071 L8,9.41421 L4.70711,12.7071 C4.31658,13.0976 3.68342,13.0976 3.29289,12.7071 C2.90237,12.3166 2.90237,11.6834 3.29289,11.2929 L6.58579,8 L3.29289,4.70711 C2.90237,4.31658 2.90237,3.68342 3.29289,3.29289 C3.68342,2.90237 4.31658,2.90237 4.70711,3.29289 L8,6.58579 L11.2929,3.29289 Z"/>
			</svg>
		</button>

		<?php echo $content; ?>
    </div><!-- .wp-block-kelsey-pro-header-social -->
	<?php
    return ob_get_clean();
}
