/**
 * React hook that is used to mark the block wrapper element.
 * It provides all the necessary props like the class name.
 *
 * @see https://developer.wordpress.org/block-editor/packages/packages-block-editor/#useBlockProps
 */
import { useBlockProps, useInnerBlocksProps } from "@wordpress/block-editor";

import { useEffect } from "@wordpress/element";

/**
 * The edit function describes the structure of your block in the context of the
 * editor. This represents what the editor will render when the block is used.
 *
 * @see https://developer.wordpress.org/block-editor/developers/block-api/block-edit-save/#edit
 *
 * @return {WPElement} Element to render.
 */
export default function Edit(props) {
  const blockProps = useBlockProps();

  const TEMPLATE = [
    [
      "core/group",
      { className: "social-container" },
      [["core/social-links", {}]],
    ],
  ];

  const innerBlocksProps = useInnerBlocksProps(blockProps, {
    allowedBlocks: ["core/group", "core/social-links", "core/social-link"],
    orientation: "",
    renderAppender: false,
    template: TEMPLATE,
    templateLock: "all",
  });

  function header_social_click_event() {
    document.querySelectorAll(".social-controller").forEach((value) => {
      value.addEventListener("click", function (e) {
        e.preventDefault();
        e.stopImmediatePropagation();
        const displayTarget = value.nextElementSibling;

        document.querySelectorAll(".social-controller").forEach((item) => {
          if (item !== value) {
            item.querySelector(".social").style.display = "block";
            item.querySelector(".cross").style.display = "none";
            const itemTarget = item.nextElementSibling;
            itemTarget.style.display = "none";
          }
        });

        document.querySelectorAll(".search-controller").forEach((item) => {
          item.querySelector(".search").style.display = "block";
          item.querySelector(".cross").style.display = "none";
          const itemTarget = item.nextElementSibling;
          itemTarget.style.display = "none";
        });

        value.querySelector(".social").style.display = "none";
        value.querySelector(".cross").style.display = "none";

        if (
          !displayTarget.style.display ||
          displayTarget.style.display === "none"
        ) {
          displayTarget.style.display = "block";
          value.querySelector(".social").style.display = "none";
          value.querySelector(".cross").style.display = "block";
        } else {
          displayTarget.style.display = "none";
          value.querySelector(".social").style.display = "block";
          value.querySelector(".cross").style.display = "none";
        }
      });
    });

    document.addEventListener("click", function (e) {
      document.querySelectorAll(".social-controller").forEach((value) => {
        var displayTarget = value.nextElementSibling;

        if (!displayTarget.contains(e.target)) {
          displayTarget.style.display = "none";
          value.querySelector(".social").style.display = "block";
          value.querySelector(".cross").style.display = "none";
        }
      });
    });
  }

  useEffect(() => {
    header_social_click_event();
  }, []);
  return (
    <>
      <div {...blockProps}>
        <button className="social-controller">
          <svg
            className="social svg"
            width="20"
            height="20"
            viewBox="0 0 458.624 458.624"
            xmlns="http://www.w3.org/2000/svg"
            aria-hidden="true"
            focusable="false"
          >
            <path d="M339.588,314.529c-14.215,0-27.456,4.133-38.621,11.239l-112.682-78.67c1.809-6.315,2.798-12.976,2.798-19.871 c0-6.896-0.989-13.557-2.798-19.871l109.64-76.547c11.764,8.356,26.133,13.286,41.662,13.286c39.79,0,72.047-32.257,72.047-72.047 C411.634,32.258,379.378,0,339.588,0c-39.79,0-72.047,32.257-72.047,72.047c0,5.255,0.578,10.373,1.646,15.308l-112.424,78.491 c-10.974-6.759-23.892-10.666-37.727-10.666c-39.79,0-72.047,32.257-72.047,72.047s32.256,72.047,72.047,72.047 c13.834,0,26.753-3.907,37.727-10.666l113.292,79.097c-1.629,6.017-2.514,12.34-2.514,18.872c0,39.79,32.257,72.047,72.047,72.047 c39.79,0,72.047-32.257,72.047-72.047C411.635,346.787,379.378,314.529,339.588,314.529z"></path>
          </svg>

          <svg
            className="cross svg"
            width="20"
            height="20"
            viewBox="0 0 16 16"
            xmlns="http://www.w3.org/2000/svg"
          >
            <path
              fillRule="evenodd"
              d="M11.2929,3.29289 C11.6834,2.90237 12.3166,2.90237 12.7071,3.29289 C13.0976,3.68342 13.0976,4.31658 12.7071,4.70711 L9.41421,8 L12.7071,11.2929 C13.0976,11.6834 13.0976,12.3166 12.7071,12.7071 C12.3166,13.0976 11.6834,13.0976 11.2929,12.7071 L8,9.41421 L4.70711,12.7071 C4.31658,13.0976 3.68342,13.0976 3.29289,12.7071 C2.90237,12.3166 2.90237,11.6834 3.29289,11.2929 L6.58579,8 L3.29289,4.70711 C2.90237,4.31658 2.90237,3.68342 3.29289,3.29289 C3.68342,2.90237 4.31658,2.90237 4.70711,3.29289 L8,6.58579 L11.2929,3.29289 Z"
            />
          </svg>
        </button>

        {innerBlocksProps.children}
      </div>
    </>
  );
}
