/**
 * React hook that is used to mark the block wrapper element.
 * It provides all the necessary props like the class name.
 *
 * @see https://developer.wordpress.org/block-editor/packages/packages-block-editor/#useBlockProps
 */
 import { useBlockProps, useInnerBlocksProps } from "@wordpress/block-editor";

/**
 * The save function defines the way in which the different attributes should
 * be combined into the final markup, which is then serialized by the block
 * editor into `post_content`.
 *
 * @see https://developer.wordpress.org/block-editor/developers/block-api/block-edit-save/#save
 *
 * @return {WPElement} Element to render.
 */
export default function save({attributes}) {

	const blockProps = useBlockProps.save();
	
	const TEMPLATE = [
		[ 'core/group', {className: "social-container"},
			[
				[ 'core/social-links', {}]
			]
		]
	];
	
	const innerBlocksProps = useInnerBlocksProps.save(blockProps, {
        allowedBlocks: [ 'core/group', 'core/social-links', 'core/social-link' ],
        orientation: '',
        renderAppender: false,
		template:TEMPLATE,
		templateLock: 'all'
    });
	
	return innerBlocksProps.children;
}
