<?php

function kelsey_video_popup_block_assets() {

	$script_asset = require get_theme_file_path() . '/inc/blocks/dist/popup-video.asset.php';
	wp_register_script(
        'kelsey-pro-popup-script',
        get_theme_file_uri() . '/assets/js/popup.js',
        array(),
        '1.0.0',
        true
    );

	wp_register_script(
		'kelsey-pro-popup-video-script',
		get_theme_file_uri() . '/inc/blocks/dist/popup-video.js',
		isset( $script_asset['dependencies'] ) ? $script_asset['dependencies'] : array(),
		'0.0.1',
		false
	);

	wp_register_style(
		'kelsey-pro-popup-video-style',
		get_theme_file_uri() . '/inc/blocks/dist/style-popup-video.css',
		array(),
		'0.0.1',
		'all'
	);

	wp_register_style(
		'kelsey-pro-popup-video-editor-style',
		get_theme_file_uri() . '/inc/blocks/dist/popup-video.css',
		array(),
		'0.0.1',
		'all'
	);

	register_block_type_from_metadata( __DIR__,
		array(
			'attributes' => array(
				'domain' => [
					'default' => '',
					'type'    => 'string'
				],
				'mediaId' => [
					'default' => '',
					'type'    => 'string'
				],
				'mediaUrl' => [
					'default' => '',
					'type'    => 'string'
				],
				'alignment' => [
					'default' => 'center',
					'type'    => 'string'
				],
				'content' => [
					'default' => 'Watch Now',
					'type'    => 'string'
				],
				'className' => [
					'default' => 'is-style-default',
					'type'    => 'string'
				],
				'iconSize' => [
					'default' => 56,
					'type'    => 'number'
				],
			),
			'render_callback' => 'kelsey_video_popup_block_save'
		)
	);
}

function kelsey_video_popup_block_save( $attr ) {
	$mediaUrl  = $attr['mediaUrl'];
	$id        = $attr['mediaId'];
	$alignment = $attr[ 'alignment' ];
	$className = $attr[ 'className' ];
	$content   = $attr[ 'content' ];
	$iconSize  = $attr[ 'iconSize' ];
	$domain    = ($attr['domain']) ? $attr['domain'] : '';

	$url = $mediaUrl;
	ob_start();
	if( '' !== $domain ) {
		switch( $domain ) {
			case 'youtube.com':
				$url = "http://www.youtube.com/embed/{$id}?autoplay=1&rel=0&modestbranding=1&iv_load_policy=2&enablejsapi=1";
				break;
			case 'vimeo.com':
				$url = "https://player.vimeo.com/video/{$id}?autoplay=1&loop=1&title=0&byline=0";
				break;

		}
	}

	if( '' !== $url ) :
	?>
	<div class="wp-block-kelsey-pro-popup-video">
		<div class="content<?php echo ' has-text-align-' . $alignment; ?>">
			<a id="myBtn" href="javascript:void(0)" class="video-play">
				<?php if ( 'is-style-alt' === $className ) : ?>
					<svg xmlns="http://www.w3.org/2000/svg" width="<?php  esc_html( $iconSize ); ?>" height="<?php  esc_html( $iconSize ); ?>" viewBox="0 0 1200 1200">
						<path d="M600,1200C268.6,1200,0,931.3,0,600S268.6,0,600,0  s600,268.6,600,600S931.3,1200,600,1200z M450,300.4v599.1L900,600L450,300.4z"/>
					</svg>
				<?php else: ?>
					<svg xmlns="http://www.w3.org/2000/svg" width="<?php  esc_html( $iconSize ); ?>" height="<?php  esc_html( $iconSize ); ?>" viewBox="0 0 485 485">
						<g>
							<path d="M414,71C368.2,25.2,307.3,0,242.5,0S116.8,25.2,71,71C25.2,116.8,0,177.7,0,242.5S25.2,368.2,71,414   c45.8,45.8,106.7,71,171.5,71s125.7-25.2,171.5-71c45.8-45.8,71-106.7,71-171.5S459.8,116.8,414,71z M242.5,455   C125.3,455,30,359.7,30,242.5S125.3,30,242.5,30S455,125.3,455,242.5S359.7,455,242.5,455z"/>
							<polygon points="181.1,336.6 343.9,242.5 181.1,148.4  "/>
							</g>
					</svg>
				<?php endif; ?>
			<?php if( '' !== $content ): ?>
				<span><?php  esc_html( $content ); ?></span>
			<?php endif; ?>
			</a>
		</div>
		<div style="position: relative;">
			<section id="modal" class="modal">
				<span class="close">x</span>
				<?php if( 'youtube.com' === $domain ) : ?>
				<iframe class="player" width="1200" height="800" src="<?php echo esc_url( $url ); ?>" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
				<?php elseif( 'vimeo.com' === $domain ) : ?>
				<iframe class="player" width="1200" height="800" src="<?php echo esc_url( $url ); ?>" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen></iframe><script src="https://player.vimeo.com/api/player.js"></script>
				<?php else: ?>
					<video controls class="player" src="<?php echo $url; ?>"></video>
				<?php endif; ?>
			</section>
		</div>
	</div>
	<?php
	endif;
	return ob_get_clean();
}

add_action( 'init', 'kelsey_video_popup_block_assets' );
