/**
 * Registers a new block provided a unique name and an object defining its behavior.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
 */
 import { registerBlockType } from '@wordpress/blocks';

 const icon = wp.element.createElement('svg', 
 { 
   width: "24", 
      height: "24",
      viewBox: "0 0 24 24",
      className: "kelsey-pro-icon"
 },
 wp.element.createElement( 'path',
   { 
     d: "M3,2.8275 C3,2.37083333 3.39555556,2 3.88266667,2 L18.1173333,2 C18.6044444,2 19,2.37083333 19,2.8275 L19,16.1725 C18.99951,16.6293252 18.6046136,16.9995406 18.1173333,17 L3.88266667,17 C3.39538643,16.9995406 3.00048998,16.6293252 3,16.1725 L3,2.8275 Z M4.77777778,3.66666667 L4.77777778,15.3333333 L17.2222222,15.3333333 L17.2222222,3.66666667 L4.77777778,3.66666667 Z M9.77511111,6.5125 L14.112,9.2225 C14.2110536,9.28429976 14.2705689,9.38845313 14.2705689,9.5 C14.2705689,9.61154687 14.2110536,9.71570024 14.112,9.7775 L9.77422222,12.4875 C9.6652531,12.5552176 9.52543397,12.5614097 9.41014093,12.503624 C9.29484788,12.4458382 9.22268095,12.333397 9.22222222,12.2108333 L9.22222222,6.78916667 C9.22246453,6.66632401 9.29475599,6.55356236 9.41035222,6.49571779 C9.52594845,6.43787321 9.66611192,6.444322 9.77511111,6.5125 Z" 
   }
 )
);

 /**
  * Lets webpack process CSS, SASS or SCSS files referenced in JavaScript files.
  * All files containing `style` keyword are bundled together. The code used
  * gets applied both to the front of your site and to the editor.
  *
  * @see https://www.npmjs.com/package/@wordpress/scripts#using-css
  */
 import './style.scss';
 
 /**
  * Internal dependencies
  */
 import Edit from './edit';
 
 /**
  * Every block starts by registering a new block type definition.
  *
  * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
  */
 registerBlockType( 'kelsey-pro/popup-video', {
     title: 'Popup Video',
     icon,
	 /**
	  * @see ./edit.js
	  */
	 edit: Edit,
 
	 /**
	  * @see ./save.js
	  */
	  save: props => {
			return null;
		}
 } );
 