<?php

function kelsey_slider_block_assets()
{
    wp_register_script(
        'kelsey-pro-slider-script',
        get_theme_file_uri() . '/inc/blocks/dist/slider-front.js',
        array(),
        filemtime(get_theme_file_path() . '/inc/blocks/dist/slider-front.js'),
        true
    );

    wp_register_style(
        'kelsey-pro-slider-editor-style',
        get_theme_file_uri() . '/inc/blocks/dist/slider.css',
        array(),
        filemtime(get_theme_file_path() . '/inc/blocks/dist/slider.css'),
        'all'
    );

    $script_asset = require get_theme_file_path() . '/inc/blocks/dist/slider.asset.php';
    $script_asset['dependencies'][] = 'kelsey-pro-slider-script';
    wp_register_script(
        'kelsey-pro-slider-editor-script',
        get_theme_file_uri() . '/inc/blocks/dist/slider.js',
        isset($script_asset['dependencies']) ? $script_asset['dependencies'] : array(),
        filemtime(get_theme_file_path() . '/inc/blocks/dist/slider.js'),
        true
    );

    wp_register_style(
        'kelsey-pro-swiper-style',
        get_theme_file_uri() . '/inc/blocks/dist/slider-front.css',
        array(),
        filemtime(get_theme_file_path() . '/inc/blocks/dist/slider-front.css'),
        'all'
    );

    wp_register_style(
        'kelsey-pro-slider-style',
        get_theme_file_uri() . '/assets/css/slider-style.css',
        array('kelsey-pro-swiper-style'),
        filemtime(get_theme_file_path() . '/assets/css/slider-style.css'),
        'all'
    );

    /**
     * Register Gutenberg block on server-side.
     *
     * Register the block on server-side to ensure that the block
     * scripts and styles for both frontend and backend are
     * enqueued when the editor loads.
     *
     * @link https://wordpress.org/gutenberg/handbook/blocks/writing-your-first-block-type#enqueuing-block-scripts
     * @since 1.16.0
     */
    register_block_type_from_metadata(
        __DIR__,
        array(
            'render_callback' => 'kelsey_slider_block_save'
        )
    );
}
add_action('init', 'kelsey_slider_block_assets');

function kelsey_slider_block_save($attr, $content)
{

    $align = isset($attr['align']) ? $attr['align'] : '';

    $alignClass = ('full' === $align) ? " alignfull" : (('wide' === $align) ? " alignwide" : "");

    // $effects = isset($attr['enableEffect']) ? $attr['enableEffect'] : 'null';

    // $effectTypes = $effects ? $attr['effectType'] : null;

    // echo "<script>console.log('this is a Variable: " . $attr['enableEffect']. "' );</script>";

    $block_id = isset($attr['blockId']) ? $attr['blockId'] : '';

    $slider_id = wp_unique_id('slider-');

    $main_wrapper_class = "kelsey-slider-wrapper {$alignClass} {$attr['axis']}";


    if (isset($attr['controls']) && $attr['controls']) {
        $main_wrapper_class .= ' navigation-enabled';
    }

    if (isset($attr['dot']) && $attr['dot']) {
        $main_wrapper_class .= ' pagination-enabled';

        if (isset($attr['dotPosition'])) {
            $main_wrapper_class .= ' ' .  $attr['dotPosition'];
        }


        if ($attr['dotPosition'] === 'horizontal-outside-slider-bottom-right' || $attr['dotPosition'] === 'horizontal-outside-slider-bottom-left' || $attr['dotPosition'] === 'horizontal-outside-slider-bottom-center') {
            $main_wrapper_class .= ' ' .  'pagination-outside';
        }

        if ($attr['dotPosition'] === 'vertical-left-top' || $attr['dotPosition'] === 'vertical-left-center' || $attr['dotPosition'] === 'vertical-left-bottom' || $attr['dotPosition'] === 'vertical-right-center' || $attr['dotPosition'] === 'vertical-right-top' || $attr['dotPosition'] === 'vertical-right-bottom') {
            $main_wrapper_class .= ' ' .  'pagination-vertical';
        }
    }

    $content = str_replace('wp-block-kelsey-pro-slider', "wp-block-kelsey-pro-slider swiper-wrapper", $content);
    $content = str_replace('wp-block-kelsey-pro-slides', 'wp-block-kelsey-pro-slides swiper-slide', $content);
    ob_start();
?>
    <div class="<?php echo esc_attr($main_wrapper_class); ?>" id="<?php echo esc_attr($slider_id); ?>">
        <?php echo $content; ?>
        <?php if (isset($attr['controls']) && $attr['controls']) : ?>
            <div class="navigation-wrap">
                <div class="swiper-button swiper-button-prev"></div>
                <div class="swiper-button swiper-button-next"></div>
            </div>
        <?php endif; ?>


        <?php if (isset($attr['dot']) && $attr['dot']) : ?>
            <div class="swiper-pagination"></div>
        <?php endif; ?>

        <!-- If we need scrollbar -->
        <!-- <div class="swiper-scrollbar"></div> -->
    </div>
<?php
    return ob_get_clean();
}
