// import Swiper bundle with all modules installed
import { Swiper, EffectCreative } from "swiper/bundle";

// import styles bundle
import "swiper/css/bundle";

const sliders = document.querySelectorAll(".kelsey-slider-wrapper");

// Convert array to JSX items
const items = [...sliders].map(function (item, index) {
  var sliderData = {};

  if (item.getElementsByClassName("swiper-wrapper")[0].dataset.slider) {
    var sliderData = JSON.parse(
      item.getElementsByClassName("swiper-wrapper")[0].dataset.slider
    );
  }

  if (item.getElementsByClassName("swiper-wrapper")[0].dataset.tinySlider) {
    var sliderData = JSON.parse(
      item.getElementsByClassName("swiper-wrapper")[0].dataset.tinySlider
    );
  }

  if (!sliderData.spaceBetween) {
    sliderData.spaceBetween = 0;
  }

  const paginationSelector = "#" + item.id + " .swiper-pagination";
  const navNext = "#" + item.id + " .swiper-button-next";
  const navPrev = "#" + item.id + " .swiper-button-prev";
  const paginationBar =
    sliderData.paginationStyle === "fraction"
      ? "fraction"
      : sliderData.paginationStyle === "progressbar"
      ? "progressbar"
      : "bullets";

  const sliderEffect = sliderData.enableEffect;
  const sliderType = sliderEffect && sliderData.effectType;
  var sliderOptions = {
    // Optional parameters
    direction: sliderData.axis,
    slidesPerView: 1,
    ...(sliderData.enableEffect && {
      effect: sliderType,
    }),
    creativeEffect: {
      prev: {
        // shadow: true,
        translate: [0, 0, -400],
      },
      next: {
        translate: ["100%", 0, 0],
      },
    },

    loop: true,
    spaceBetween: sliderData.spaceBetween,
    //autoHeight: true,
    // If we need pagination
    pagination: {
      el: paginationSelector,
      clickable: true,
      type: paginationBar,
    },
    // pagination: {
    //   el: paginationSelector,
    //   clickable: true,
    // },

    // Navigation arrows
    navigation: {
      nextEl: navNext,
      prevEl: navPrev,
    },
    breakpoints: {
      640: {
        slidesPerView:
          sliderData.slidesPerPage > 1 ? 2 : sliderData.slidesPerPage,
      },
      900: {
        slidesPerView: sliderData.slidesPerPage,
      },
    },
  };
  if (sliderData.autoplay) {
    sliderOptions["autoplay"] = {
      delay: sliderData.autoplayDelay ? sliderData.autoplayDelay : 3000,
    };
  }

  // if (sliderType === "creative") {
  //   (sliderOptions["grabCursor"] = true),
  //     (sliderOptions[EffectCreative] = {
  //       prev: {
  //         shadow: true,
  //         translate: [0, 0, -400],
  //       },
  //       next: {
  //         translate: ["100%", 0, 0],
  //       },
  //     });
  // }

  const swiper = new Swiper(item, sliderOptions);
});
