<?php
/**
 * The template for displaying archive pages.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Bizroot
 */

get_header(); ?>

	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">

			<?php $jetpack_options = get_theme_mod( 'jetpack_testimonials' ); ?>
			<?php if ( isset( $jetpack_options['page-content'] ) && ! empty( $jetpack_options['page-content'] ) ) : ?>
				<div class="jetpack-testimonial-page-content">
					<div class="entry-content">
						<?php echo convert_chars( convert_smilies( wptexturize( stripslashes( wp_filter_post_kses( addslashes( $jetpack_options['page-content'] ) ) ) ) ) ); ?>
					</div><!-- .entry-content -->
				</div><!-- .jetpack-testimonial-page-content -->
			<?php endif; ?>

		<?php if ( have_posts() ) : ?>

			<?php /* Start the Loop */ ?>
			<?php while ( have_posts() ) : the_post(); ?>

				<?php get_template_part( 'template-parts/content', 'testimonial' ); ?>

			<?php endwhile; ?>

		<?php
		/**
		 * Hook - bizroot_action_posts_navigation.
		 *
		 * @hooked: bizroot_custom_posts_navigation - 10
		 */
		do_action( 'bizroot_action_posts_navigation' );?>


		<?php else : ?>

			<?php get_template_part( 'template-parts/content', 'none' ); ?>

		<?php endif; ?>

		</main><!-- #main -->
	</div><!-- #primary -->

<?php
	/**
	 * Hook - bizroot_action_sidebar.
	 *
	 * @hooked: bizroot_add_sidebar - 10
	 */
	do_action( 'bizroot_action_sidebar' );
?>
<?php get_footer(); ?>
