<?php
/**
 * Default theme options.
 *
 * @package Bizroot
 */

if ( ! function_exists( 'bizroot_get_default_theme_options' ) ) :

	/**
	 * Get default theme options
	 *
	 * @since 1.0.0
	 *
	 * @return array Default theme options.
	 */
	function bizroot_get_default_theme_options() {

		$defaults = array();

		// Header.
		$defaults['show_title']                 = true;
		$defaults['show_tagline']               = true;
		$defaults['enable_sticky_primary_menu'] = false;
		$defaults['search_in_header']           = true;

		// Search.
		$defaults['search_placeholder'] = esc_html__( 'Search...', 'bizroot-pro' );

		// Layout.
		$defaults['global_layout']           = 'right-sidebar';
		$defaults['archive_layout']          = 'excerpt';
		$defaults['archive_image']           = 'large';
		$defaults['archive_image_alignment'] = 'center';
		$defaults['single_image']            = 'large';
		$defaults['single_image_alignment']  = 'center';

		// Home Page.
		$defaults['home_content_status'] = true;

		// Pagination.
		$defaults['pagination_type'] = 'numeric';

		// Content Meta.
		$defaults['show_meta_date']       = true;
		$defaults['show_meta_author']     = true;
		$defaults['show_meta_categories'] = true;
		$defaults['show_meta_tags']       = true;
		$defaults['show_meta_comment']    = true;

		// Footer contact.
		$defaults['show_footer_contact']                    = true;
		$defaults['enable_footer_contact_background_image'] = true;
		$defaults['footer_contact_background_image']        = get_template_directory_uri() . '/images/footer-contact-bg.jpg';
		$defaults['enable_footer_contact_background_overlay'] = true;
		$defaults['footer_contact_email']                   = esc_html__( 'demo@wenthemes.com', 'bizroot-pro' );
		$defaults['footer_contact_address']                 = esc_html__( 'Kathmandu, Nepal', 'bizroot-pro' );
		$defaults['footer_contact_map_url']                 = '';
		$defaults['footer_contact_phone']                   = '234-235-5678';

		// Footer.
		$defaults['copyright_text']        = esc_html__( 'Copyright &copy; [the-year] [the-site-link]. All rights reserved.', 'bizroot-pro' );
		$defaults['powered_by_text']       = esc_html__( 'Bizroot Pro by ', 'bizroot-pro' ) . '<a target="_blank" rel="designer" href="https://wenthemes.com/">WEN Themes</a>';
		$defaults['reset_footer_content']  = false;
		$defaults['show_social_in_footer'] = false;
		$defaults['go_to_top']             = true;

		// Blog.
		$defaults['blog_title']         = esc_html__( 'Blog', 'bizroot-pro' );
		$defaults['excerpt_length']     = 40;
		$defaults['read_more_text']     = esc_html__( 'READ MORE', 'bizroot-pro' );
		$defaults['exclude_categories'] = '';

		// Author Bio.
		$defaults['author_bio_in_single']           = true;
		$defaults['author_bio_show_recent_posts']   = false;
		$defaults['author_bio_recent_posts_number'] = 3;

		// Breadcrumb.
		$defaults['breadcrumb_type'] = 'simple';

		// Advanced.
		$defaults['custom_css'] = '';

		// Font.
		$font_keys = bizroot_get_font_family_theme_settings_options();
		if ( ! empty( $font_keys ) ) {
			foreach ( $font_keys as $k => $v ) {
			  $defaults[ $k ]  = $v['default'];
			}
		}
		$defaults['load_font_cdn'] = false;
		$defaults['reset_font_settings'] = false;

		// Clients Options.
		$defaults['featured_clients_number'] = 6;

		// Slider Options.
		$defaults['featured_slider_status']              = 'home-page';
		$defaults['featured_slider_transition_effect']   = 'fadeout';
		$defaults['featured_slider_transition_delay']    = 3;
		$defaults['featured_slider_transition_duration'] = 1;
		$defaults['featured_slider_enable_caption']      = true;
		$defaults['featured_slider_enable_arrow']        = true;
		$defaults['featured_slider_enable_pager']        = true;
		$defaults['featured_slider_enable_autoplay']     = true;
		$defaults['featured_slider_enable_overlay']      = true;
		$defaults['featured_slider_type']                = 'demo-slider';
		$defaults['featured_slider_number']              = 3;
		$defaults['featured_slider_category']            = '';
		$defaults['featured_slider_tag']                 = '';
		$defaults['featured_slider_read_more_text']      = esc_html__( 'Read More', 'bizroot-pro' );

		// Color.
		$colors = bizroot_get_default_colors();
		if ( ! empty( $colors ) ) {
		  foreach ( $colors as $key => $val ) {
		    $defaults[ $key ] = $val;
		  }
		}

		// Pass through filter.
		$defaults = apply_filters( 'bizroot_filter_default_theme_options', $defaults );
		return $defaults;
	}

endif;
