<?php
/**
 * Theme Options.
 *
 * @package Bizroot
 */

$default = bizroot_get_default_theme_options();

// Add Panel.
$wp_customize->add_panel( 'theme_option_panel',
	array(
	'title'      => __( 'Theme Options', 'bizroot-pro' ),
	'priority'   => 100,
	'capability' => 'edit_theme_options',
	)
);

// Header Section.
$wp_customize->add_section( 'section_header',
	array(
	'title'      => __( 'Header Options', 'bizroot-pro' ),
	'priority'   => 100,
	'capability' => 'edit_theme_options',
	'panel'      => 'theme_option_panel',
	)
);

// Setting show_title.
$wp_customize->add_setting( 'theme_options[show_title]',
	array(
	'default'           => $default['show_title'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'bizroot_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[show_title]',
	array(
	'label'    => __( 'Show Site Title', 'bizroot-pro' ),
	'section'  => 'section_header',
	'type'     => 'checkbox',
	'priority' => 100,
	)
);
// Setting show_tagline.
$wp_customize->add_setting( 'theme_options[show_tagline]',
	array(
	'default'           => $default['show_tagline'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'bizroot_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[show_tagline]',
	array(
	'label'    => __( 'Show Tagline', 'bizroot-pro' ),
	'section'  => 'section_header',
	'type'     => 'checkbox',
	'priority' => 100,
	)
);

// Setting enable_sticky_primary_menu.
$wp_customize->add_setting( 'theme_options[enable_sticky_primary_menu]',
	array(
		'default'           => $default['enable_sticky_primary_menu'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'bizroot_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[enable_sticky_primary_menu]',
	array(
		'label'    => __( 'Make Primary Menu Sticky', 'bizroot-pro' ),
		'section'  => 'section_header',
		'type'     => 'checkbox',
		'priority' => 100,
	)
);

$wp_customize->add_setting( 'theme_options[search_in_header]',
	array(
		'default'           => $default['search_in_header'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'bizroot_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[search_in_header]',
	array(
		'label'    => __( 'Enable Search Form', 'bizroot-pro' ),
		'section'  => 'section_header',
		'type'     => 'checkbox',
		'priority' => 100,
	)
);

// Search Section.
$wp_customize->add_section( 'section_search',
	array(
	'title'      => __( 'Search Options', 'bizroot-pro' ),
	'priority'   => 100,
	'capability' => 'edit_theme_options',
	'panel'      => 'theme_option_panel',
	)
);

// Setting search_placeholder.
$wp_customize->add_setting( 'theme_options[search_placeholder]',
	array(
	'default'           => $default['search_placeholder'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'wp_filter_nohtml_kses',
	)
);
$wp_customize->add_control( 'theme_options[search_placeholder]',
	array(
	'label'    => __( 'Search Placeholder', 'bizroot-pro' ),
	'section'  => 'section_search',
	'type'     => 'text',
	'priority' => 100,
	)
);

// Layout Section.
$wp_customize->add_section( 'section_layout',
	array(
	'title'      => __( 'Layout Options', 'bizroot-pro' ),
	'priority'   => 100,
	'capability' => 'edit_theme_options',
	'panel'      => 'theme_option_panel',
	)
);

// Setting global_layout.
$wp_customize->add_setting( 'theme_options[global_layout]',
	array(
	'default'           => $default['global_layout'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'bizroot_sanitize_select',
	)
);
$wp_customize->add_control( 'theme_options[global_layout]',
	array(
	'label'    => __( 'Global Layout', 'bizroot-pro' ),
	'section'  => 'section_layout',
	'type'     => 'select',
	'choices'  => bizroot_get_global_layout_options(),
	'priority' => 100,
	)
);
// Setting archive_layout.
$wp_customize->add_setting( 'theme_options[archive_layout]',
	array(
	'default'           => $default['archive_layout'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'bizroot_sanitize_select',
	)
);
$wp_customize->add_control( 'theme_options[archive_layout]',
	array(
	'label'    => __( 'Archive Layout', 'bizroot-pro' ),
	'section'  => 'section_layout',
	'type'     => 'select',
	'choices'  => bizroot_get_archive_layout_options(),
	'priority' => 100,
	)
);
// Setting archive_image.
$wp_customize->add_setting( 'theme_options[archive_image]',
	array(
	'default'           => $default['archive_image'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'bizroot_sanitize_select',
	)
);
$wp_customize->add_control( 'theme_options[archive_image]',
	array(
	'label'    => __( 'Image in Archive', 'bizroot-pro' ),
	'section'  => 'section_layout',
	'type'     => 'select',
	'choices'  => bizroot_get_image_sizes_options(),
	'priority' => 100,
	)
);
// Setting archive_image_alignment.
$wp_customize->add_setting( 'theme_options[archive_image_alignment]',
	array(
	'default'           => $default['archive_image_alignment'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'bizroot_sanitize_select',
	)
);
$wp_customize->add_control( 'theme_options[archive_image_alignment]',
	array(
	'label'           => __( 'Image Alignment in Archive', 'bizroot-pro' ),
	'section'         => 'section_layout',
	'type'            => 'select',
	'choices'         => bizroot_get_image_alignment_options(),
	'priority'        => 100,
	'active_callback' => 'bizroot_is_image_in_archive_active',
	)
);
// Setting single_image.
$wp_customize->add_setting( 'theme_options[single_image]',
	array(
	'default'           => $default['single_image'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'bizroot_sanitize_select',
	)
);
$wp_customize->add_control( 'theme_options[single_image]',
	array(
	'label'    => __( 'Image in Single Post/Page', 'bizroot-pro' ),
	'section'  => 'section_layout',
	'type'     => 'select',
	'choices'  => bizroot_get_image_sizes_options(),
	'priority' => 100,
	)
);
// Setting single_image_alignment.
$wp_customize->add_setting( 'theme_options[single_image_alignment]',
	array(
	'default'           => $default['single_image_alignment'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'bizroot_sanitize_select',
	)
);
$wp_customize->add_control( 'theme_options[single_image_alignment]',
	array(
	'label'           => __( 'Image Alignment in Single Post/Page', 'bizroot-pro' ),
	'section'         => 'section_layout',
	'type'            => 'select',
	'choices'         => bizroot_get_image_alignment_options(),
	'priority'        => 100,
	'active_callback' => 'bizroot_is_image_in_single_active',
	)
);
// Home Page Section.
$wp_customize->add_section( 'section_home_page',
	array(
	'title'      => __( 'Home Page Options', 'bizroot-pro' ),
	'priority'   => 100,
	'capability' => 'edit_theme_options',
	'panel'      => 'theme_option_panel',
	)
);
// Setting home_content_status.
$wp_customize->add_setting( 'theme_options[home_content_status]',
	array(
	'default'           => $default['home_content_status'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'bizroot_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[home_content_status]',
	array(
	'label'       => __( 'Show Home Content', 'bizroot-pro' ),
	'description' => __( 'Check this to show page content in Home page.', 'bizroot-pro' ),
	'section'     => 'section_home_page',
	'type'        => 'checkbox',
	'priority'    => 100,
	)
);

// Pagination Section.
$wp_customize->add_section( 'section_pagination',
	array(
	'title'      => __( 'Pagination Options', 'bizroot-pro' ),
	'priority'   => 100,
	'capability' => 'edit_theme_options',
	'panel'      => 'theme_option_panel',
	)
);

// Setting pagination_type.
$wp_customize->add_setting( 'theme_options[pagination_type]',
	array(
	'default'           => $default['pagination_type'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'bizroot_sanitize_select',
	)
);
$wp_customize->add_control( 'theme_options[pagination_type]',
	array(
	'label'       => __( 'Pagination Type', 'bizroot-pro' ),
	'description' => sprintf( __( 'Infinite Scroll: Requires %1$sJetPack - Infinite Scroll%2$s plugin', 'bizroot-pro' ), '<a href="https://wordpress.org/plugins/jetpack/" target="_blank">', '</a>' ),
	'section'     => 'section_pagination',
	'type'        => 'select',
	'choices'     => bizroot_get_pagination_type_options(),
	'priority'    => 100,
	)
);

// Content Meta Section.
$wp_customize->add_section( 'section_content_meta',
	array(
	'title'      => __( 'Content Meta Options', 'bizroot-pro' ),
	'priority'   => 100,
	'capability' => 'edit_theme_options',
	'panel'      => 'theme_option_panel',
	)
);

// Setting show_meta_date.
$wp_customize->add_setting( 'theme_options[show_meta_date]',
	array(
	'default'           => $default['show_meta_date'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'bizroot_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[show_meta_date]',
	array(
		'label'           => __( 'Show Date', 'bizroot-pro' ),
		'section'         => 'section_content_meta',
		'type'            => 'checkbox',
		'priority'        => 100,
	)
);

// Setting show_meta_author.
$wp_customize->add_setting( 'theme_options[show_meta_author]',
	array(
	'default'           => $default['show_meta_author'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'bizroot_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[show_meta_author]',
	array(
		'label'           => __( 'Show Author', 'bizroot-pro' ),
		'section'         => 'section_content_meta',
		'type'            => 'checkbox',
		'priority'        => 100,
	)
);

// Setting show_meta_categories.
$wp_customize->add_setting( 'theme_options[show_meta_categories]',
	array(
	'default'           => $default['show_meta_categories'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'bizroot_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[show_meta_categories]',
	array(
		'label'           => __( 'Show Categories', 'bizroot-pro' ),
		'section'         => 'section_content_meta',
		'type'            => 'checkbox',
		'priority'        => 100,
	)
);

// Setting show_meta_tags.
$wp_customize->add_setting( 'theme_options[show_meta_tags]',
	array(
	'default'           => $default['show_meta_tags'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'bizroot_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[show_meta_tags]',
	array(
		'label'           => __( 'Show Tags', 'bizroot-pro' ),
		'section'         => 'section_content_meta',
		'type'            => 'checkbox',
		'priority'        => 100,
	)
);

// Setting show_meta_comment.
$wp_customize->add_setting( 'theme_options[show_meta_comment]',
	array(
	'default'           => $default['show_meta_comment'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'bizroot_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[show_meta_comment]',
	array(
		'label'           => __( 'Show Comment', 'bizroot-pro' ),
		'section'         => 'section_content_meta',
		'type'            => 'checkbox',
		'priority'        => 100,
	)
);

// Footer Contact Section.
$wp_customize->add_section( 'section_footer_contact',
	array(
	'title'      => __( 'Footer Contact Options', 'bizroot-pro' ),
	'priority'   => 100,
	'capability' => 'edit_theme_options',
	'panel'      => 'theme_option_panel',
	)
);

// Setting show_footer_contact.
$wp_customize->add_setting( 'theme_options[show_footer_contact]',
	array(
	'default'           => $default['show_footer_contact'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'bizroot_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[show_footer_contact]',
	array(
		'label'    => __( 'Show Footer Contact', 'bizroot-pro' ),
		'section'  => 'section_footer_contact',
		'type'     => 'checkbox',
		'priority' => 100,
	)
);

// Setting enable_footer_contact_background_image.
$wp_customize->add_setting( 'theme_options[enable_footer_contact_background_image]',
	array(
	'default'           => $default['enable_footer_contact_background_image'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'bizroot_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[enable_footer_contact_background_image]',
	array(
		'label'           => __( 'Enable Background Image', 'bizroot-pro' ),
		'section'         => 'section_footer_contact',
		'type'            => 'checkbox',
		'priority'        => 100,
		'active_callback' => 'bizroot_is_footer_contact_active',
	)
);

// Setting footer_contact_background_image.
$wp_customize->add_setting( 'theme_options[footer_contact_background_image]',
	array(
	'default'           => $default['footer_contact_background_image'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'bizroot_sanitize_image',
	)
);
$wp_customize->add_control(
	new WP_Customize_Image_Control( $wp_customize, 'theme_options[footer_contact_background_image]',
		array(
		'label'           => __( 'Background Image', 'bizroot-pro' ),
		'description'     => sprintf( __( 'Recommended Size: %1$dpx x %2$dpx', 'bizroot-pro' ), 1940, 200 ),
		'section'         => 'section_footer_contact',
		'priority'        => 100,
		'settings'        => 'theme_options[footer_contact_background_image]',
		'active_callback' => 'bizroot_is_footer_contact_and_background_image_active',
		)
	)
);

// Setting enable_footer_contact_background_overlay.
$wp_customize->add_setting( 'theme_options[enable_footer_contact_background_overlay]',
	array(
	'default'           => $default['enable_footer_contact_background_overlay'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'bizroot_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[enable_footer_contact_background_overlay]',
	array(
		'label'           => __( 'Enable Background Overlay', 'bizroot-pro' ),
		'section'         => 'section_footer_contact',
		'type'            => 'checkbox',
		'priority'        => 100,
		'active_callback' => 'bizroot_is_footer_contact_and_background_image_active',
	)
);

// Setting footer_contact_email.
$wp_customize->add_setting( 'theme_options[footer_contact_email]',
	array(
		'default'           => $default['footer_contact_email'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_email',
		'transport'         => 'postMessage',
	)
);
$wp_customize->add_control( 'theme_options[footer_contact_email]',
	array(
		'label'           => __( 'Contact Email', 'bizroot-pro' ),
		'section'         => 'section_footer_contact',
		'type'            => 'text',
		'priority'        => 100,
		'active_callback' => 'bizroot_is_footer_contact_active',
	)
);

// Setting footer_contact_address.
$wp_customize->add_setting( 'theme_options[footer_contact_address]',
	array(
		'default'           => $default['footer_contact_address'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
		'transport'         => 'postMessage',
	)
);
$wp_customize->add_control( 'theme_options[footer_contact_address]',
	array(
		'label'           => __( 'Contact Address', 'bizroot-pro' ),
		'section'         => 'section_footer_contact',
		'type'            => 'text',
		'priority'        => 100,
		'active_callback' => 'bizroot_is_footer_contact_active',
	)
);

// Setting footer_contact_map_url.
$wp_customize->add_setting( 'theme_options[footer_contact_map_url]',
	array(
		'default'           => $default['footer_contact_map_url'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'esc_url_raw',
		'transport'         => 'postMessage',
	)
);
$wp_customize->add_control( 'theme_options[footer_contact_map_url]',
	array(
		'label'           => __( 'Address Map URL', 'bizroot-pro' ),
		'section'         => 'section_footer_contact',
		'type'            => 'url',
		'priority'        => 100,
		'active_callback' => 'bizroot_is_footer_contact_active',
	)
);

// Setting footer_contact_phone.
$wp_customize->add_setting( 'theme_options[footer_contact_phone]',
	array(
		'default'           => $default['footer_contact_phone'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
		'transport'         => 'postMessage',
	)
);
$wp_customize->add_control( 'theme_options[footer_contact_phone]',
	array(
		'label'           => __( 'Contact Phone', 'bizroot-pro' ),
		'section'         => 'section_footer_contact',
		'type'            => 'text',
		'priority'        => 100,
		'active_callback' => 'bizroot_is_footer_contact_active',
	)
);

// Footer Section.
$wp_customize->add_section( 'section_footer',
	array(
	'title'      => __( 'Footer Options', 'bizroot-pro' ),
	'priority'   => 100,
	'capability' => 'edit_theme_options',
	'panel'      => 'theme_option_panel',
	)
);

// Setting copyright_text.
$wp_customize->add_setting( 'theme_options[copyright_text]',
	array(
	'default'           => $default['copyright_text'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'bizroot_sanitize_textarea_content',
	'transport'         => 'postMessage',
	)
);
$wp_customize->add_control( 'theme_options[copyright_text]',
	array(
	'label'    => __( 'Copyright Text', 'bizroot-pro' ),
	'section'  => 'section_footer',
	'type'     => 'textarea',
	'priority' => 100,
	)
);
// Setting - powered_by_text.
$wp_customize->add_setting( 'theme_options[powered_by_text]',
	array(
		'default'           => $default['powered_by_text'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'bizroot_sanitize_textarea_content',
		'transport'         => 'postMessage',
	)
);
$wp_customize->add_control( 'theme_options[powered_by_text]',
	array(
		'label'    => esc_html__( 'Powered By Text', 'bizroot-pro' ),
		'section'  => 'section_footer',
		'type'     => 'textarea',
		'priority' => 100,
	)
);
// Setting reset_footer_content.
$wp_customize->add_setting( 'theme_options[reset_footer_content]',
	array(
		'default'           => $default['reset_footer_content'],
		'capability'        => 'edit_theme_options',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'bizroot_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[reset_footer_content]',
	array(
		'label'       => __( 'Reset Footer Content', 'bizroot-pro' ),
		'description' => __( 'Refresh the page after save to view full effects.', 'bizroot-pro' ),
		'section'     => 'section_footer',
		'type'        => 'checkbox',
		'priority'    => 100,
	)
);

// Setting show_social_in_footer.
$wp_customize->add_setting( 'theme_options[show_social_in_footer]',
	array(
		'default'           => $default['show_social_in_footer'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'bizroot_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[show_social_in_footer]',
	array(
		'label'    => __( 'Show Social Icons', 'bizroot-pro' ),
		'section'  => 'section_footer',
		'type'     => 'checkbox',
		'priority' => 100,
	)
);

// Setting go_to_top.
$wp_customize->add_setting( 'theme_options[go_to_top]',
	array(
		'default'           => $default['go_to_top'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'bizroot_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[go_to_top]',
	array(
		'label'    => __( 'Show Go To Top', 'bizroot-pro' ),
		'section'  => 'section_footer',
		'type'     => 'checkbox',
		'priority' => 100,
	)
);


// Blog Section.
$wp_customize->add_section( 'section_blog',
	array(
	'title'      => __( 'Blog Options', 'bizroot-pro' ),
	'priority'   => 100,
	'capability' => 'edit_theme_options',
	'panel'      => 'theme_option_panel',
	)
);

// Setting blog_title.
$wp_customize->add_setting( 'theme_options[blog_title]',
	array(
	'default'           => $default['blog_title'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control( 'theme_options[blog_title]',
	array(
	'label'    => __( 'Blog Title', 'bizroot-pro' ),
	'section'  => 'section_blog',
	'type'     => 'text',
	'priority' => 100,
	)
);


// Setting excerpt_length.
$wp_customize->add_setting( 'theme_options[excerpt_length]',
	array(
	'default'           => $default['excerpt_length'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'bizroot_sanitize_positive_integer',
	)
);
$wp_customize->add_control( 'theme_options[excerpt_length]',
	array(
	'label'       => __( 'Excerpt Length', 'bizroot-pro' ),
	'description' => __( 'in words', 'bizroot-pro' ),
	'section'     => 'section_blog',
	'type'        => 'number',
	'priority'    => 100,
	'input_attrs' => array( 'min' => 1, 'max' => 200, 'style' => 'width: 55px;' ),
	)
);

// Setting read_more_text.
$wp_customize->add_setting( 'theme_options[read_more_text]',
	array(
	'default'           => $default['read_more_text'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control( 'theme_options[read_more_text]',
	array(
	'label'    => __( 'Read More Text', 'bizroot-pro' ),
	'section'  => 'section_blog',
	'type'     => 'text',
	'priority' => 100,
	)
);

// Setting exclude_categories.
$wp_customize->add_setting( 'theme_options[exclude_categories]',
	array(
	'default'           => $default['exclude_categories'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control( 'theme_options[exclude_categories]',
	array(
	'label'       => __( 'Exclude Categories in Blog', 'bizroot-pro' ),
	'description' => __( 'Enter category ID to exclude in Blog Page. Separate with comma if more than one', 'bizroot-pro' ),
	'section'     => 'section_blog',
	'type'        => 'text',
	'priority'    => 100,
	)
);

// Author Bio Section.
$wp_customize->add_section( 'section_author_bio',
	array(
		'title'       => __( 'Author Bio Options', 'bizroot-pro' ),
		'description' => __( 'Author Box will be displayed in the single post article.', 'bizroot-pro' ),
		'priority'    => 100,
		'capability'  => 'edit_theme_options',
		'panel'       => 'theme_option_panel',
	)
);
// Setting author_bio_in_single.
$wp_customize->add_setting( 'theme_options[author_bio_in_single]',
	array(
		'default'           => $default['author_bio_in_single'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'bizroot_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[author_bio_in_single]',
	array(
		'label'    => __( 'Show Author Bio', 'bizroot-pro' ),
		'section'  => 'section_author_bio',
		'type'     => 'checkbox',
		'priority' => 100,
	)
);
// Setting author_bio_show_recent_posts.
$wp_customize->add_setting( 'theme_options[author_bio_show_recent_posts]',
	array(
		'default'           => $default['author_bio_show_recent_posts'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'bizroot_sanitize_checkbox',
	)
);
$wp_customize->add_control( 'theme_options[author_bio_show_recent_posts]',
	array(
		'label'    => __( 'Show Recent Posts by Author in Bio', 'bizroot-pro' ),
		'section'  => 'section_author_bio',
		'type'     => 'checkbox',
		'priority' => 100,
		'active_callback' => 'bizroot_is_author_bio_active',
	)
);

// Setting author_bio_recent_posts_number.
$wp_customize->add_setting( 'theme_options[author_bio_recent_posts_number]',
	array(
		'default'           => $default['author_bio_recent_posts_number'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'bizroot_sanitize_positive_integer',
	)
);
$wp_customize->add_control( 'theme_options[author_bio_recent_posts_number]',
	array(
		'label'           => __( 'No of Recent Posts', 'bizroot-pro' ),
		'section'         => 'section_author_bio',
		'type'            => 'number',
		'priority'        => 100,
		'active_callback' => 'bizroot_is_author_bio_recent_posts_active',
		'input_attrs'     => array( 'min' => 1, 'max' => 20, 'style' => 'width: 55px;' ),
	)
);


// Breadcrumb Section.
$wp_customize->add_section( 'section_breadcrumb',
	array(
	'title'      => __( 'Breadcrumb Options', 'bizroot-pro' ),
	'priority'   => 100,
	'capability' => 'edit_theme_options',
	'panel'      => 'theme_option_panel',
	)
);

// Setting breadcrumb_type.
$wp_customize->add_setting( 'theme_options[breadcrumb_type]',
	array(
	'default'           => $default['breadcrumb_type'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'bizroot_sanitize_select',
	)
);
$wp_customize->add_control( 'theme_options[breadcrumb_type]',
	array(
	'label'       => __( 'Breadcrumb Type', 'bizroot-pro' ),
	'description' => sprintf( __( 'Advanced: Requires %1$sBreadcrumb NavXT%2$s plugin', 'bizroot-pro' ), '<a href="https://wordpress.org/plugins/breadcrumb-navxt/" target="_blank">', '</a>' ),
	'section'     => 'section_breadcrumb',
	'type'        => 'select',
	'choices'     => bizroot_get_breadcrumb_type_options(),
	'priority'    => 100,
	)
);

// Advanced Section.
$wp_customize->add_section( 'section_advanced',
	array(
	'title'      => __( 'Advanced Options', 'bizroot-pro' ),
	'priority'   => 100,
	'capability' => 'edit_theme_options',
	'panel'      => 'theme_option_panel',
	)
);

// Setting custom_css.
$wp_customize->add_setting( 'theme_options[custom_css]',
	array(
	'default'              => $default['custom_css'],
	'capability'           => 'edit_theme_options',
	'sanitize_callback'    => 'wp_strip_all_tags',
	)
);
$wp_customize->add_control( 'theme_options[custom_css]',
	array(
	'label'    => __( 'Custom CSS', 'bizroot-pro' ),
	'section'  => 'section_advanced',
	'type'     => 'textarea',
	'priority' => 100,
	)
);

// Clients Section.
$wp_customize->add_section( 'section_clients',
	array(
	'title'      => __( 'Clients Options', 'bizroot-pro' ),
	'priority'   => 100,
	'capability' => 'edit_theme_options',
	'panel'      => 'theme_option_panel',
	)
);

// Setting featured_clients_number.
$wp_customize->add_setting( 'theme_options[featured_clients_number]',
	array(
	'default'           => $default['featured_clients_number'],
	'capability'        => 'edit_theme_options',
	'transport'         => 'postMessage',
	'sanitize_callback' => 'bizroot_sanitize_number_range',
	)
);
$wp_customize->add_control( 'theme_options[featured_clients_number]',
	array(
	'label'           => __( 'No of Clients', 'bizroot-pro' ),
	'description'     => __( 'Enter number between 1 and 10. Save and refresh the page if No of Clients is changed.', 'bizroot-pro' ),
	'section'         => 'section_clients',
	'type'            => 'number',
	'priority'        => 100,
	'input_attrs'     => array( 'min' => 1, 'max' => 10, 'step' => 1, 'style' => 'width: 55px;' ),
	)
);

$featured_clients_number = absint( bizroot_get_option( 'featured_clients_number' ) );

// For multiple clients.
if ( $featured_clients_number > 0 ) {
	for ( $i = 1; $i <= $featured_clients_number; $i++ ) {

		// Image.
		$wp_customize->add_setting( "theme_options[featured_clients_image_$i]",
			array(
			'default'           => isset( $default[ 'featured_clients_image_' .$i ] ) ? $default[ 'featured_clients_image_' .$i ] : '',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'bizroot_sanitize_image',
			)
		);
		$wp_customize->add_control(
			new WP_Customize_Image_Control( $wp_customize, "theme_options[featured_clients_image_$i]",
				array(
					'label'           => __( 'Image', 'bizroot-pro' ) . ' #' . $i,
					'section'         => 'section_clients',
					'settings'        => "theme_options[featured_clients_image_$i]",
					'priority'        => 100,
				)
			)
		);

		// Link.
		$wp_customize->add_setting( "theme_options[featured_clients_link_$i]",
			array(
			'default'           => isset( $default[ 'featured_clients_link_' .$i ] ) ? $default[ 'featured_clients_link_' .$i ] : '',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'esc_url_raw',
			)
		);
		$wp_customize->add_control( "theme_options[featured_clients_link_$i]",
			array(
			'label'           => __( 'Link', 'bizroot-pro' ) . ' #' . $i,
			'section'         => 'section_clients',
			'type'            => 'url',
			'priority'        => 100,
			)
		);

	} // End for loop.
}
