<?php
/**
 * Helper functions related to customizer and options.
 *
 * @package Bizroot
 */

if ( ! function_exists( 'bizroot_get_global_layout_options' ) ) :

	/**
	 * Returns global layout options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function bizroot_get_global_layout_options() {

		$choices = array(
			'left-sidebar'            => esc_html__( 'Primary Sidebar - Content', 'bizroot-pro' ),
			'right-sidebar'           => esc_html__( 'Content - Primary Sidebar', 'bizroot-pro' ),
			'three-columns'           => esc_html__( 'Three Columns ( Secondary - Content - Primary )', 'bizroot-pro' ),
			'three-columns-pcs'       => esc_html__( 'Three Columns ( Primary - Content - Secondary )', 'bizroot-pro' ),
			'three-columns-cps'       => esc_html__( 'Three Columns ( Content - Primary - Secondary )', 'bizroot-pro' ),
			'three-columns-psc'       => esc_html__( 'Three Columns ( Primary - Secondary - Content )', 'bizroot-pro' ),
			'three-columns-pcs-equal' => esc_html__( 'Three Columns ( Equal Primary - Content - Secondary )', 'bizroot-pro' ),
			'three-columns-scp-equal' => esc_html__( 'Three Columns ( Equal Secondary - Content - Primary )', 'bizroot-pro' ),
			'no-sidebar'              => esc_html__( 'No Sidebar', 'bizroot-pro' ),
		);
		$output = apply_filters( 'bizroot_filter_layout_options', $choices );
		return $output;

	}

endif;

if ( ! function_exists( 'bizroot_get_pagination_type_options' ) ) :

	/**
	 * Returns pagination type options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function bizroot_get_pagination_type_options() {

		$choices = array(
			'default'               => esc_html__( 'Default (Older / Newer Post)', 'bizroot-pro' ),
			'numeric'               => esc_html__( 'Numeric', 'bizroot-pro' ),
			'infinite-scroll'       => esc_html__( 'Infinite Scroll - Scroll', 'bizroot-pro' ),
			'infinite-scroll-click' => esc_html__( 'Infinite Scroll - Click', 'bizroot-pro' ),
		);
		return $choices;

	}

endif;

if ( ! function_exists( 'bizroot_get_breadcrumb_type_options' ) ) :

	/**
	 * Returns breadcrumb type options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function bizroot_get_breadcrumb_type_options() {

		$choices = array(
			'disabled' => esc_html__( 'Disabled', 'bizroot-pro' ),
			'simple'   => esc_html__( 'Simple', 'bizroot-pro' ),
			'advanced' => esc_html__( 'Advanced', 'bizroot-pro' ),
		);
		return $choices;

	}

endif;


if ( ! function_exists( 'bizroot_get_archive_layout_options' ) ) :

	/**
	 * Returns archive layout options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function bizroot_get_archive_layout_options() {

		$choices = array(
			'full'    => esc_html__( 'Full Post', 'bizroot-pro' ),
			'excerpt' => esc_html__( 'Post Excerpt', 'bizroot-pro' ),
		);
		$output = apply_filters( 'bizroot_filter_archive_layout_options', $choices );
		if ( ! empty( $output ) ) {
			ksort( $output );
		}
		return $output;

	}

endif;

if ( ! function_exists( 'bizroot_get_image_sizes_options' ) ) :

	/**
	 * Returns image sizes options.
	 *
	 * @since 1.0.0
	 *
	 * @param bool  $add_disable True for adding No Image option.
	 * @param array $allowed Allowed image size options.
	 * @return array Image size options.
	 */
	function bizroot_get_image_sizes_options( $add_disable = true, $allowed = array(), $show_dimension = true ) {

		global $_wp_additional_image_sizes;
		$get_intermediate_image_sizes = get_intermediate_image_sizes();
		$choices = array();
		if ( true === $add_disable ) {
			$choices['disable'] = esc_html__( 'No Image', 'bizroot-pro' );
		}
		$choices['thumbnail'] = esc_html__( 'Thumbnail', 'bizroot-pro' );
		$choices['medium']    = esc_html__( 'Medium', 'bizroot-pro' );
		$choices['large']     = esc_html__( 'Large', 'bizroot-pro' );
		$choices['full']      = esc_html__( 'Full (original)', 'bizroot-pro' );

		if ( true === $show_dimension ) {
			foreach ( array( 'thumbnail', 'medium', 'large' ) as $key => $_size ) {
				$choices[ $_size ] = $choices[ $_size ] . ' (' . get_option( $_size . '_size_w' ) . 'x' . get_option( $_size . '_size_h' ) . ')';
			}
		}

		if ( ! empty( $_wp_additional_image_sizes ) && is_array( $_wp_additional_image_sizes ) ) {
			foreach ( $_wp_additional_image_sizes as $key => $size ) {
				$choices[ $key ] = $key;
				if ( true === $show_dimension ){
					$choices[ $key ] .= ' ('. $size['width'] . 'x' . $size['height'] . ')';
				}
			}
		}

		if ( ! empty( $allowed ) ) {
			foreach ( $choices as $key => $value ) {
				if ( ! in_array( $key, $allowed ) ) {
					unset( $choices[ $key ] );
				}
			}
		}

		return $choices;

	}

endif;


if ( ! function_exists( 'bizroot_get_image_alignment_options' ) ) :

	/**
	 * Returns image options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function bizroot_get_image_alignment_options() {

		$choices = array(
			'none'   => _x( 'None', 'Alignment', 'bizroot-pro' ),
			'left'   => _x( 'Left', 'Alignment', 'bizroot-pro' ),
			'center' => _x( 'Center', 'Alignment', 'bizroot-pro' ),
			'right'  => _x( 'Right', 'Alignment', 'bizroot-pro' ),
		);
		return $choices;

	}

endif;

if ( ! function_exists( 'bizroot_get_featured_slider_transition_effects' ) ) :

	/**
	 * Returns the featured slider transition effects.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function bizroot_get_featured_slider_transition_effects() {

		$choices = array(
			'fade'       => _x( 'fade', 'Transition Effect', 'bizroot-pro' ),
			'fadeout'    => _x( 'fadeout', 'Transition Effect', 'bizroot-pro' ),
			'none'       => _x( 'none', 'Transition Effect', 'bizroot-pro' ),
			'scrollHorz' => _x( 'scrollHorz', 'Transition Effect', 'bizroot-pro' ),
			'tileSlide'  => _x( 'tileSlide', 'Transition Effect', 'bizroot-pro' ),
			'tileBlind'  => _x( 'tileBlind', 'Transition Effect', 'bizroot-pro' ),
			'flipHorz'   => _x( 'flipHorz', 'Transition Effect', 'bizroot-pro' ),
			'flipVert'   => _x('flipVert','Transition Effect', 'bizroot-pro'),
			'shuffle'    => _x('shuffle','Transition Effect', 'bizroot-pro'),
		);
		$output = apply_filters( 'bizroot_filter_featured_slider_transition_effects', $choices );
		if ( ! empty( $output ) ) {
			ksort( $output );
		}
		return $output;

	}

endif;

if ( ! function_exists( 'bizroot_get_featured_slider_content_options' ) ) :

	/**
	 * Returns the featured slider content options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function bizroot_get_featured_slider_content_options() {

		$choices = array(
			'home-page' => esc_html__( 'Static Front Page Only', 'bizroot-pro' ),
			'disabled'  => esc_html__( 'Disabled', 'bizroot-pro' ),
		);
		$output = apply_filters( 'bizroot_filter_featured_slider_content_options', $choices );
		if ( ! empty( $output ) ) {
			ksort( $output );
		}
		return $output;

	}

endif;

if ( ! function_exists( 'bizroot_get_featured_slider_type' ) ) :

	/**
	 * Returns the featured slider type.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function bizroot_get_featured_slider_type() {

		$choices = array(
			'featured-page'     => __( 'Featured Pages', 'bizroot-pro' ),
			'featured-category' => __( 'Featured Category', 'bizroot-pro' ),
			'featured-post'     => __( 'Featured Posts', 'bizroot-pro' ),
			'featured-image'    => __( 'Featured Images', 'bizroot-pro' ),
			'featured-tag'      => __( 'Featured Tag', 'bizroot-pro' ),
			'demo-slider'       => __( 'Demo Slider', 'bizroot-pro' ),
		);
		$output = apply_filters( 'bizroot_filter_featured_slider_type', $choices );
		if ( ! empty( $output ) ) {
			ksort( $output );
		}
		return $output;

	}

endif;

if ( ! function_exists( 'bizroot_get_featured_content_status_options' ) ) :

	/**
	 * Returns the featured content options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function bizroot_get_featured_content_status_options() {

		$choices = array(
			'home-page' => esc_html__( 'Home Page Only', 'bizroot-pro' ),
			'disabled'  => esc_html__( 'Disabled', 'bizroot-pro' ),
		);
		$output = apply_filters( 'bizroot_filter_featured_content_status_options', $choices );
		if ( ! empty( $output ) ) {
			ksort( $output );
		}
		return $output;

	}

endif;

if ( ! function_exists( 'bizroot_get_featured_content_type' ) ) :

	/**
	 * Returns the featured content type.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function bizroot_get_featured_content_type() {

		$choices = array(
			'featured-page' => esc_html__( 'Featured Pages', 'bizroot-pro' ),
			'featured-post' => esc_html__( 'Featured Posts', 'bizroot-pro' ),
			'demo-content'  => esc_html__( 'Demo Content', 'bizroot-pro' ),
		);
		$output = apply_filters( 'bizroot_filter_featured_content_type', $choices );
		if ( ! empty( $output ) ) {
			ksort( $output );
		}
		return $output;

	}

endif;

if( ! function_exists( 'bizroot_get_customizer_font_options' ) ) :

	/**
	 * Returns customizer font options.
	 *
	 * @since 1.0.0
	 */
	function bizroot_get_customizer_font_options(){

		$web_fonts = bizroot_get_web_fonts();
		$os_fonts  = bizroot_get_os_fonts();

		$web_fonts = array_merge( $web_fonts, $os_fonts );

		if ( ! empty( $web_fonts ) ) {
			ksort( $web_fonts );
		}

		$choices = array();

		if ( ! empty( $web_fonts ) ) {
			foreach ( $web_fonts as $k => $v ) {
				$choices[$k] = esc_html( $v['label'] );
			}
		}
		return $choices;

	}

endif;

if( ! function_exists( 'bizroot_get_web_fonts' ) ) :

	/**
	 * Returns web font options.
	 *
	 * @since 1.0.0
	 */
	function bizroot_get_web_fonts(){

		$choices = array(
			'philosopher' => array(
				'name'  => 'Philosopher',
				'label' => "'Philosopher', sans-serif",
				),
			'open-sans' => array(
				'name'  => 'Open Sans',
				'label' => "'Open Sans', sans-serif",
				),
			'pt-sans' => array(
				'name'  => 'PT Sans',
				'label' => "'PT Sans', sans-serif",
				),
			'merriweather-sans' => array(
				'name'  => 'Merriweather Sans',
				'label' => "'Merriweather Sans', sans-serif",
				),
			'roboto' => array(
				'name'  => 'Roboto',
				'label' => "'Roboto', sans-serif",
				),
			'arizonia' => array(
				'name'  => 'Arizonia',
				'label' => "'Arizonia', cursive",
				),
			'raleway' => array(
				'name'  => 'Raleway',
				'label' => "'Raleway', sans-serif",
				),
			'droid-sans' => array(
				'name'  => 'Droid Sans',
				'label' => "'Droid Sans', sans-serif",
				),
			'lato' => array(
				'name'  => 'Lato',
				'label' => "'Lato', sans-serif",
				),
			'dosis' => array(
				'name'  => 'Dosis',
				'label' => "'Dosis', sans-serif",
				),
			'slabo-27px' => array(
				'name'  => 'Slabo 27px',
				'label' => "'Slabo 27px', serif",
				),
			'oswald' => array(
				'name'  => 'Oswald',
				'label' => "'Oswald', sans-serif",
				),
			'pt-sans-narrow' => array(
				'name'  => 'PT Sans Narrow',
				'label' => "'PT Sans Narrow', sans-serif",
				),
			'josefin-slab' => array(
				'name'  => 'Josefin Slab',
				'label' => "'Josefin Slab', serif",
				),
			'alegreya' => array(
				'name'  => 'Alegreya',
				'label' => "'Alegreya', serif",
				),
			'exo' => array(
				'name'  => 'Exo',
				'label' => "'Exo', sans-serif",
				),
			'signika' => array(
				'name'  => 'Signika',
				'label' => "'Signika', sans-serif",
				),
			'lobster' => array(
				'name'  => 'Lobster',
				'label' => "'Lobster', cursive",
				),
			'indie-flower' => array(
				'name'  => 'Indie Flower',
				'label' => "'Indie Flower', cursive",
				),
			'shadows-into-light' => array(
				'name'  => 'Shadows Into Light',
				'label' => "'Shadows Into Light', cursive",
				),
			'kaushan-script' => array(
				'name'  => 'Kaushan Script',
				'label' => "'Kaushan Script', cursive",
				),
			'dancing-script' => array(
				'name'  => 'Dancing Script',
				'label' => "'Dancing Script', cursive",
				),
			'fredericka-the-great' => array(
				'name'  => 'Fredericka the Great',
				'label' => "'Fredericka the Great', cursive",
				),
			'covered-by-your-grace' => array(
				'name'  => 'Covered By Your Grace',
				'label' => "'Covered By Your Grace', cursive",
				),
			);
		$choices = apply_filters( 'bizroot_filter_web_fonts', $choices );

		if ( ! empty( $choices ) ) {
			ksort( $choices );
		}

		return $choices;

	}

endif;

if( ! function_exists( 'bizroot_get_os_fonts' ) ) :

	/**
	 * Returns OS font options.
	 *
	 * @since 1.0.0
	 */
	function bizroot_get_os_fonts(){

		$choices = array(
			'arial' => array(
				'name'  => 'Arial',
				'label' => "'Arial', sans-serif",
				),
			'georgia' => array(
				'name'  => 'Georgia',
				'label' => "'Georgia', serif",
				),
			'cambria' => array(
				'name'  => 'Cambria',
				'label' => "'Cambria', Georgia, serif",
				),
			'tahoma' => array(
				'name'  => 'Tahoma',
				'label' => "'Tahoma', Geneva, sans-serif",
				),
			'sans-serif' => array(
				'name'  => 'Sans Serif',
				'label' => "'Sans Serif', Arial",
				),
			'verdana' => array(
				'name'  => 'Verdana',
				'label' => "'Verdana', Geneva, sans-serif",
				),
			);
		$choices = apply_filters( 'bizroot_filter_os_fonts', $choices );

		if ( ! empty( $choices ) ) {
			ksort( $choices );
		}
		return $choices;

	}

endif;

if( ! function_exists( 'bizroot_get_font_family_from_key' ) ) :

	/**
	 * Return font family from font slug.
	 *
	 * @since 1.0.0
	 *
	 * @param string $key Font slug.
	 * @return string Font name.
	 */
	function bizroot_get_font_family_from_key( $key ){

		$output = '';

		$web_fonts = bizroot_get_web_fonts();
		$os_fonts  = bizroot_get_os_fonts();

		$fonts = array_merge( $web_fonts, $os_fonts );

		if ( isset( $fonts[ $key ] ) ) {
			$output = $fonts[ $key ]['label'];
		}
		return $output;

	}

endif;

if( ! function_exists( 'bizroot_get_font_family_theme_settings_options' ) ) :

	/**
	 * Returns font family theme settings options.
	 *
	 * @since 1.0.0
	 */
	function bizroot_get_font_family_theme_settings_options(){

		$choices = array(
			'font_site_title' => array(
				'label'   => __( 'Site Title', 'bizroot-pro' ),
				'default' => 'pt-sans',
				),
			'font_site_tagline' => array(
				'label'   => __( 'Site Tagline', 'bizroot-pro' ),
				'default' => 'pt-sans',
				),
			'font_site_default' => array(
				'label'   => __( 'Default', 'bizroot-pro' ),
				'default' => 'pt-sans',
				),

			'font_content_title' => array(
				'label'   => __( 'Content Title', 'bizroot-pro' ),
				'default' => 'pt-sans',
				),
			'font_content_body' => array(
				'label'   => __( 'Content Body', 'bizroot-pro' ),
				'default' => 'pt-sans',
				),
			'font_heading_tags' => array(
				'label'   => __( 'Heading Tags', 'bizroot-pro' ),
				'default' => 'pt-sans',
				),
			'font_navigation' => array(
				'label'   => __( 'Navigation', 'bizroot-pro' ),
				'default' => 'pt-sans',
				),
			);
		return $choices;

	}

endif;

if( ! function_exists( 'bizroot_get_default_colors' ) ) :

  /**
   * Returns default colors.
   *
   * @since 1.0.0
   *
   * @param string $scheme Color scheme.
   * @return array Color values based on scheme.
   */
	function bizroot_get_default_colors( $scheme = 'default' ){

		$output = array();

		switch ( $scheme ) {

			case 'default':
			default:
			$output = array(
				// Basic.
				'color_basic_text'                    => '#49616b',
				'color_basic_link'                    => '#357fe2',
				'color_basic_link_hover'              => '#001837',
				'color_basic_heading'                 => '#000000',
				'color_basic_page_title'              => '#ffffff',
				'color_basic_page_title_separator'    => '#ffffff',
				'color_basic_button_background'       => '#357fe2',
				'color_basic_button_text'             => '#ffffff',
				'color_basic_button_background_hover' => '#001837',
				'color_basic_button_text_hover'       => '#ffffff',

				// Header.
				'color_header_background'                     => '#001837',
				'color_header_title'                          => '#ffffff',
				'color_header_title_hover'                    => '#357fe2',
				'color_header_tagline'                        => '#ffffff',

				// Primary Menu.
				'color_primary_menu_link'                => '#ffffff',
				'color_primary_menu_link_hover'          => '#ffffff',
				'color_primary_submenu_background'       => '#546c8b',
				'color_primary_submenu_background_hover' => '#455d7c',

				// Slider.
				'color_slider_overlay'                 => '#001837',
				'color_slider_caption_text'            => '#49616b',
				'color_slider_caption_link'            => '#ffffff',
				'color_slider_caption_link_hover'      => '#357fe2',
				'color_slider_icon'                    => '#ffffff',
				'color_slider_icon_hover'              => '#ffffff',
				'color_slider_icon_background'         => '#357fe2',
				'color_slider_icon_background_hover'   => '#357fe2',
				'color_slider_pager'                   => '#ffffff',
				'color_slider_pager_active'            => '#357fe2',
				'color_slider_button'                  => '#ffffff',
				'color_slider_button_hover'            => '#ffffff',
				'color_slider_button_background'       => '#357fe2',
				'color_slider_button_background_hover' => '#357fe2',

				// Content.
				'color_content_background'      => '#ffffff',
				'color_content_title'           => '#000000',
				'color_content_text'            => '#49616b',
				'color_content_link'            => '#357fe2',
				'color_content_link_hover'      => '#001837',
				'color_content_meta_link'       => '#49616b',
				'color_content_meta_link_hover' => '#357fe2',
				'color_content_meta_icon'       => '#49616b',

				// Sidebar.
				'color_sidebar_title'      => '#000000',
				'color_sidebar_text'       => '#49616b',
				'color_sidebar_link'       => '#49616b',
				'color_sidebar_link_hover' => '#357fe2',
				'color_sidebar_list_icon'  => '#49616b',

				// Home Page Widgets.
				'color_home_widgets_background' => '#ffffff',
				'color_home_widgets_title'      => '#00132c',
				'color_home_widgets_subtitle'   => '#49616b',
				'color_home_widgets_separator'  => '#dddddd',
				'color_home_widgets_text'       => '#49616b',
				'color_home_widgets_link'       => '#357fe2',
				'color_home_widgets_link_hover' => '#001837',

				// CTA Widget.
				'color_cta_widget_background'              => '#001837',
				'color_cta_main_widget_title'              => '#ffffff',
				'color_cta_widget_text'                    => '#49616b',
				'color_cta_widget_button'                  => '#ffffff',
				'color_cta_widget_button_hover'            => '#ffffff',
				'color_cta_widget_button_background'       => '#001837',
				'color_cta_widget_button_background_hover' => '#357fe2',

				// Portfolio Widget.
				'color_portfolio_widget_background'              => '#f1f7ff',
				'color_portfolio_main_widget_title'              => '#00132c',
				'color_portfolio_main_widget_subtitle'           => '#49616b',
				'color_portfolio_main_widget_separator'          => '#dddddd',
				'color_portfolio_widget_title'                   => '#357fe2',
				'color_portfolio_widget_title_hover'             => '#00132c',
				'color_portfolio_widget_text'                    => '#49616b',
				'color_portfolio_widget_link'                    => '#357fe2',
				'color_portfolio_widget_link_hover'              => '#00132c',
				'color_portfolio_category_background'            => '#ffffff',
				'color_portfolio_category_link'                  => '#000000',
				'color_portfolio_category_link_hover'            => '#ffffff',
				'color_portfolio_category_link_background_hover' => '#00132c',
				'color_portfolio_arrow'                          => '#357fe2',
				'color_portfolio_arrow_hover'                    => '#ffffff',
				'color_portfolio_arrow_background'               => '#ffffff',
				'color_portfolio_arrow_background_hover'         => '#357fe2',

				// Widget Testimonial.
				'color_testimonial_widget_background'     => '#001837',
				'color_testimonial_main_widget_title'     => '#ffffff',
				'color_testimonial_main_widget_subtitle'  => '#49616b',
				'color_testimonial_main_widget_separator' => '#ffffff',
				'color_testimonial_widget_content'        => '#ffffff',
				'color_testimonial_pager'                 => '#ffffff',
				'color_testimonial_widget_pager_active'   => '#357fe2',

				// Widget Team.
				'color_team_widget_background'     => '#ffffff',
				'color_team_main_widget_title'     => '#00132c',
				'color_team_main_widget_subtitle'  => '#49616b',
				'color_team_main_widget_separator' => '#dddddd',
				'color_team_widget_title'          => '#000000',
				'color_team_widget_title_hover'    => '#357fe2',
				'color_team_widget_content'        => '#49616b',

				// Widget skills.
				'color_skills_widget_background'     => '#f1f7ff',
				'color_skills_main_widget_title'     => '#00132c',
				'color_skills_main_widget_subtitle'  => '#49616b',
				'color_skills_main_widget_separator' => '#dddddd',

				// Widget clients.
				'color_clients_widget_background'     => '#f1f7ff',
				'color_clients_main_widget_title'     => '#00132c',
				'color_clients_main_widget_subtitle'  => '#49616b',
				'color_clients_main_widget_separator' => '#dddddd',

				// Widget Service.
				'color_service_widget_background'              => '#ffffff',
				'color_service_main_widget_title'              => '#00132c',
				'color_service_main_widget_subtitle'           => '#49616b',
				'color_service_main_widget_separator'          => '#dddddd',
				'color_service_widget_title'                   => '#000000',
				'color_service_widget_title_hover'             => '#357fe2',
				'color_service_widget_text'                    => '#49616b',
				'color_service_widget_button'                  => '#357fe2',
				'color_service_widget_button_hover'            => '#ffffff',
				'color_service_widget_button_background'       => '#ffffff',
				'color_service_widget_button_background_hover' => '#357fe2',

				// Widget pricing table.
				'color_pricing_table_widget_background'              => '#f1f7ff',
				'color_pricing_table_main_widget_title'              => '#00132c',
				'color_pricing_table_main_widget_subtitle'           => '#49616b',
				'color_pricing_table_main_widget_separator'          => '#dddddd',
				'color_pricing_table_widget_title'                   => '#ffffff',
				'color_pricing_table_widget_text'                    => '#49616b',
				'color_pricing_table_widget_text_dimmed'             => '#7c7c7c',
				'color_pricing_table_widget_content_background'      => '#ffffff',
				'color_pricing_table_widget_button'                  => '#ffffff',
				'color_pricing_table_widget_button_hover'            => '#ffffff',
				'color_pricing_table_widget_button_background'       => '#333333',
				'color_pricing_table_widget_button_background_hover' => '#357fe2',
				'color_pricing_table_featured'                       => '#357fe2',

				// Widget Latest News.
				'color_latest_news_widget_background'              => '#ffffff',
				'color_latest_news_main_widget_title'              => '#00132c',
				'color_latest_news_main_widget_subtitle'           => '#49616b',
				'color_latest_news_main_widget_separator'          => '#dddddd',
				'color_latest_news_widget_title'                   => '#000000',
				'color_latest_news_widget_title_hover'             => '#357fe2',
				'color_latest_news_widget_text'                    => '#49616b',
				'color_latest_news_widget_border'                  => '#dddddd',
				'color_latest_news_widget_button'                  => '#ffffff',
				'color_latest_news_widget_button_hover'            => '#ffffff',
				'color_latest_news_widget_button_background'       => '#ffffff',
				'color_latest_news_widget_button_background_hover' => '#357fe2',

				// Footer Widgets.
				'color_footer_widgets_background' => '#00132c',
				'color_footer_widgets_title'      => '#7188a7',
				'color_footer_widgets_separator'   => '#dddddd',
				'color_footer_widgets_text'       => '#7188a7',
				'color_footer_widgets_link'       => '#7188a7',
				'color_footer_widgets_link_hover' => '#ffffff',

				// Footer contact area.
				'color_footer_contact_background' => '#001837',
				'color_footer_contact_overlay'    => '#00132c',
				'color_footer_contact_icon'       => '#7188a7',
				'color_footer_contact_text'       => '#7188a7',
				'color_footer_contact_link'       => '#7188a7',
				'color_footer_contact_link_hover' => '#ffffff',

				// Footer area.
				'color_footer_area_background' => '#00132c',
				'color_footer_area_text'       => '#7188a7',
				'color_footer_area_link'       => '#7188a7',
				'color_footer_area_link_hover' => '#ffffff',

				// Go To Top.
				'color_goto_top_icon'             => '#ffffff',
				'color_goto_top_icon_hover'       => '#ffffff',
				'color_goto_top_background'       => '#001837',
				'color_goto_top_background_hover' => '#001837',

				// Pagination.
				'color_pagination_link'                  => '#347fe1',
				'color_pagination_link_hover'            => '#ffffff',
				'color_pagination_link_background'       => '#ffffff',
				'color_pagination_link_background_hover' => '#347fe1',

				// Breadcrumb.
				'color_breadcrumb_background' => '#347fe1',
				'color_breadcrumb_link'       => '#ffffff',
				'color_breadcrumb_link_hover' => '#ffffff',
				'color_breadcrumb_text'       => '#ffffff',



			);
			break;

		} // End switch.

	return $output;

	}

endif;


if( ! function_exists( 'bizroot_get_color_theme_settings_options' ) ) :

  /**
   * Returns color theme settings options.
   *
   * @since 1.0.0
   */
  function bizroot_get_color_theme_settings_options(){

  	$choices = array(

		// Basic.
  		'color_basic_text' => array(
  			'label'   => __( 'Text Color', 'bizroot-pro' ),
  			'section' => 'color_section_basic',
  			),
  		'color_basic_link' => array(
  			'label'   => __( 'Link Color', 'bizroot-pro' ),
  			'section' => 'color_section_basic',
  			),
  		'color_basic_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_basic',
  			),
  		'color_basic_heading' => array(
  			'label'   => __( 'Heading Color', 'bizroot-pro' ),
  			'section' => 'color_section_basic',
  			),
  		'color_basic_page_title' => array(
  			'label'   => __( 'Page Title Color', 'bizroot-pro' ),
  			'section' => 'color_section_basic',
  			),
  		'color_basic_page_title_separator' => array(
  			'label'   => __( 'Page Title Separator Color Color', 'bizroot-pro' ),
  			'section' => 'color_section_basic',
  			),
  		'color_basic_button_text' => array(
  			'label'   => __( 'Button Text Color', 'bizroot-pro' ),
  			'section' => 'color_section_basic',
  			),
  		'color_basic_button_background' => array(
  			'label'   => __( 'Button Background Color', 'bizroot-pro' ),
  			'section' => 'color_section_basic',
  			),
  		'color_basic_button_text_hover' => array(
  			'label'   => __( 'Button Text Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_basic',
  			),
  		'color_basic_button_background_hover' => array(
  			'label'   => __( 'Button Background Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_basic',
  			),

		// Header.
  		'color_header_background' => array(
  			'label'   => __( 'Background Color', 'bizroot-pro' ),
  			'section' => 'color_section_header',
  			),
  		'color_header_title' => array(
  			'label'   => __( 'Site Title Color', 'bizroot-pro' ),
  			'section' => 'color_section_header',
  			),
  		'color_header_title_hover' => array(
  			'label'   => __( 'Site Title Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_header',
  			),
  		'color_header_tagline' => array(
  			'label'   => __( 'Site Tagline Color', 'bizroot-pro' ),
  			'section' => 'color_section_header',
  			),

		// Primary Menu.
  		'color_primary_menu_link' => array(
  			'label'   => __( 'Link Color', 'bizroot-pro' ),
  			'section' => 'color_section_primary_menu',
  			),
  		'color_primary_menu_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_primary_menu',
  			),
  		'color_primary_submenu_background' => array(
  			'label'   => __( 'Submenu Background Color', 'bizroot-pro' ),
  			'section' => 'color_section_primary_menu',
  			),
  		'color_primary_submenu_background_hover' => array(
  			'label'   => __( 'Submenu Background Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_primary_menu',
  			),

		// Content.
  		'color_content_background' => array(
  			'label'   => __( 'Background Color', 'bizroot-pro' ),
  			'section' => 'color_section_content',
  			),
  		'color_content_title' => array(
  			'label'   => __( 'Title Color', 'bizroot-pro' ),
  			'section' => 'color_section_content',
  			),
  		'color_content_text' => array(
  			'label'   => __( 'Text Color', 'bizroot-pro' ),
  			'section' => 'color_section_content',
  			),
  		'color_content_link' => array(
  			'label'   => __( 'Link Color', 'bizroot-pro' ),
  			'section' => 'color_section_content',
  			),
  		'color_content_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_content',
  			),
  		'color_content_meta_link' => array(
  			'label'   => __( 'Meta Link Color', 'bizroot-pro' ),
  			'section' => 'color_section_content',
  			),
  		'color_content_meta_link_hover' => array(
  			'label'   => __( 'Meta Link Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_content',
  			),
  		'color_content_meta_icon' => array(
  			'label'   => __( 'Meta Icon Color', 'bizroot-pro' ),
  			'section' => 'color_section_content',
  			),

		// Slider.
  		'color_slider_overlay' => array(
			'label'   => __( 'Overlay Color', 'bizroot-pro' ),
			'section' => 'color_section_slider',
  			),
  		'color_slider_caption_text' => array(
  			'label'   => __( 'Caption Color', 'bizroot-pro' ),
  			'section' => 'color_section_slider',
  			),
  		'color_slider_caption_link' => array(
  			'label'   => __( 'Link Color', 'bizroot-pro' ),
  			'section' => 'color_section_slider',
  			),
  		'color_slider_caption_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_slider',
  			),
  		'color_slider_icon' => array(
  			'label'   => __( 'Icon Color', 'bizroot-pro' ),
  			'section' => 'color_section_slider',
  			),
  		'color_slider_icon_hover' => array(
  			'label'   => __( 'Icon Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_slider',
  			),
  		'color_slider_icon_background' => array(
  			'label'   => __( 'Icon Background Color', 'bizroot-pro' ),
  			'section' => 'color_section_slider',
  			),
  		'color_slider_icon_background_hover' => array(
  			'label'   => __( 'Icon Background Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_slider',
  			),
  		'color_slider_pager' => array(
  			'label'   => __( 'Pager Color', 'bizroot-pro' ),
  			'section' => 'color_section_slider',
  			),
  		'color_slider_pager_active' => array(
  			'label'   => __( 'Pager Active Color', 'bizroot-pro' ),
  			'section' => 'color_section_slider',
  			),
  		'color_slider_button' => array(
  			'label'   => __( 'Button Color', 'bizroot-pro' ),
  			'section' => 'color_section_slider',
  			),
  		'color_slider_button_hover' => array(
  			'label'   => __( 'Button Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_slider',
  			),
  		'color_slider_button_background' => array(
  			'label'   => __( 'Button Background Color', 'bizroot-pro' ),
  			'section' => 'color_section_slider',
  			),
  		'color_slider_button_background_hover' => array(
  			'label'   => __( 'Button Background Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_slider',
  			),

		// Home Page Widgets.
  		'color_home_widgets_background' => array(
  			'label'   => __( 'Widget Background Color', 'bizroot-pro' ),
  			'section' => 'color_section_home_widgets',
  			),
  		'color_home_widgets_title' => array(
  			'label'   => __( 'Widget Title Color', 'bizroot-pro' ),
  			'section' => 'color_section_home_widgets',
  			),
  		'color_home_widgets_subtitle' => array(
  			'label'   => __( 'Widget Subtitle Color', 'bizroot-pro' ),
  			'section' => 'color_section_home_widgets',
  			),
  		'color_home_widgets_separator' => array(
  			'label'   => __( 'Separator Color', 'bizroot-pro' ),
  			'section' => 'color_section_home_widgets',
  			),
  		'color_home_widgets_text' => array(
  			'label'   => __( 'Text Color', 'bizroot-pro' ),
  			'section' => 'color_section_home_widgets',
  			),
  		'color_home_widgets_link' => array(
  			'label'   => __( 'Link Color', 'bizroot-pro' ),
  			'section' => 'color_section_home_widgets',
  			),
  		'color_home_widgets_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_home_widgets',
  			),

		// Sidebar.
  		'color_sidebar_title' => array(
  			'label'   => __( 'Title Color', 'bizroot-pro' ),
  			'section' => 'color_section_sidebar',
		),
  		'color_sidebar_text' => array(
  			'label'   => __( 'Text Color', 'bizroot-pro' ),
  			'section' => 'color_section_sidebar',
		),
  		'color_sidebar_link' => array(
  			'label'   => __( 'Link Color', 'bizroot-pro' ),
  			'section' => 'color_section_sidebar',
		),
  		'color_sidebar_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_sidebar',
		),
  		'color_sidebar_list_icon' => array(
  			'label'   => __( 'List Icon Color', 'bizroot-pro' ),
  			'section' => 'color_section_sidebar',
		),

		// Footer area.
  		'color_footer_area_background' => array(
  			'label'   => __( 'Background Color', 'bizroot-pro' ),
  			'section' => 'color_section_footer_area',
  			),
  		'color_footer_area_text' => array(
  			'label'   => __( 'Text Color', 'bizroot-pro' ),
  			'section' => 'color_section_footer_area',
  			),
  		'color_footer_area_link' => array(
  			'label'   => __( 'Link Color', 'bizroot-pro' ),
  			'section' => 'color_section_footer_area',
  			),
  		'color_footer_area_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_footer_area',
  			),

		// Go To Top.
  		'color_goto_top_icon' => array(
  			'label'   => __( 'Icon Color', 'bizroot-pro' ),
  			'section' => 'color_section_goto_top',
  			),
  		'color_goto_top_icon_hover' => array(
  			'label'   => __( 'Icon Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_goto_top',
  			),
  		'color_goto_top_background' => array(
  			'label'   => __( 'Background Color', 'bizroot-pro' ),
  			'section' => 'color_section_goto_top',
  			),
  		'color_goto_top_background_hover' => array(
  			'label'   => __( 'Background Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_goto_top',
  			),

		// Pagination.
  		'color_pagination_link' => array(
  			'label'   => __( 'Link Color', 'bizroot-pro' ),
  			'section' => 'color_section_pagination',
  			),
  		'color_pagination_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_pagination',
  			),
  		'color_pagination_link_background' => array(
  			'label'   => __( 'Link Background Color', 'bizroot-pro' ),
  			'section' => 'color_section_pagination',
  			),
  		'color_pagination_link_background_hover' => array(
  			'label'   => __( 'Link Background Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_pagination',
  			),

		// Breadcrumb.
  		'color_breadcrumb_background' => array(
  			'label'   => __( 'Background Color', 'bizroot-pro' ),
  			'section' => 'color_section_breadcrumb',
  			),
  		'color_breadcrumb_link' => array(
  			'label'   => __( 'Link Color', 'bizroot-pro' ),
  			'section' => 'color_section_breadcrumb',
  			),
  		'color_breadcrumb_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_breadcrumb',
  			),
  		'color_breadcrumb_text' => array(
  			'label'   => __( 'Text Color', 'bizroot-pro' ),
  			'section' => 'color_section_breadcrumb',
  			),

  		//Specific widget portfolio
  		'color_portfolio_widget_background' => array(
  			'label'   => __( 'Widget Background Color', 'bizroot-pro' ),
  			'section' => 'color_section_portfolio_widget',
  			),
  		'color_portfolio_main_widget_title' => array(
  			'label'   => __( 'Main Widget Title Color', 'bizroot-pro' ),
  			'section' => 'color_section_portfolio_widget',
  			),
  		'color_portfolio_main_widget_subtitle' => array(
  			'label'   => __( 'Widget Subtitle Color', 'bizroot-pro' ),
  			'section' => 'color_section_portfolio_widget',
  			),
  		'color_portfolio_main_widget_separator' => array(
  			'label'   => __( 'Separator Color', 'bizroot-pro' ),
  			'section' => 'color_section_portfolio_widget',
  			),
  		'color_portfolio_widget_title' => array(
  			'label'   => __( 'Title Color', 'bizroot-pro' ),
  			'section' => 'color_section_portfolio_widget',
  			),
  		'color_portfolio_widget_title_hover' => array(
  			'label'   => __( 'Title Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_portfolio_widget',
  			),
  		'color_portfolio_widget_text' => array(
  			'label'   => __( 'Text Color', 'bizroot-pro' ),
  			'section' => 'color_section_portfolio_widget',
  			),
  		'color_portfolio_widget_link' => array(
  			'label'   => __( 'Link Color', 'bizroot-pro' ),
  			'section' => 'color_section_portfolio_widget',
  			),
  		'color_portfolio_widget_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_portfolio_widget',
  			),
  		'color_portfolio_category_background' => array(
  			'label'   => __( 'Category Background Color', 'bizroot-pro' ),
  			'section' => 'color_section_portfolio_widget',
  			),
  		'color_portfolio_category_link' => array(
  			'label'   => __( 'Category Link Color', 'bizroot-pro' ),
  			'section' => 'color_section_portfolio_widget',
  			),
  		'color_portfolio_category_link_hover' => array(
  			'label'   => __( 'Category Link Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_portfolio_widget',
  			),
  		'color_portfolio_category_link_background_hover' => array(
  			'label'   => __( 'Category Link Background Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_portfolio_widget',
  			),
  		'color_portfolio_arrow' => array(
  			'label'   => __( 'Arrow Color', 'bizroot-pro' ),
  			'section' => 'color_section_portfolio_widget',
  			),
  		'color_portfolio_arrow_hover' => array(
  			'label'   => __( 'Arrow Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_portfolio_widget',
  			),
  		'color_portfolio_arrow_background' => array(
  			'label'   => __( 'Arrow Background Color', 'bizroot-pro' ),
  			'section' => 'color_section_portfolio_widget',
  			),
  		'color_portfolio_arrow_background_hover' => array(
  			'label'   => __( 'Arrow Background Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_portfolio_widget',
  			),

  		// Specific widget testimonial.
  		'color_testimonial_widget_background' => array(
  			'label'   => __( 'Widget Background Color', 'bizroot-pro' ),
  			'section' => 'color_section_testimonial_widget',
  			),
  		'color_testimonial_main_widget_title' => array(
  			'label'   => __( 'Widget Title Color', 'bizroot-pro' ),
  			'section' => 'color_section_testimonial_widget',
  			),
  		'color_testimonial_main_widget_subtitle' => array(
  			'label'   => __( 'Widget Subtitle Color', 'bizroot-pro' ),
  			'section' => 'color_section_testimonial_widget',
  			),
  		'color_testimonial_main_widget_separator' => array(
  			'label'   => __( 'Widget Separator Color', 'bizroot-pro' ),
  			'section' => 'color_section_testimonial_widget',
  			),
  		'color_testimonial_widget_content' => array(
  			'label'   => __( 'Content Color', 'bizroot-pro' ),
  			'section' => 'color_section_testimonial_widget',
  			),
  		'color_testimonial_pager' => array(
  			'label'   => __( 'Pager Color', 'bizroot-pro' ),
  			'section' => 'color_section_testimonial_widget',
  			),
  		'color_testimonial_widget_pager_active' => array(
  			'label'   => __( 'Pager Active Color', 'bizroot-pro' ),
  			'section' => 'color_section_testimonial_widget',
  			),

  		// Specific widget service.
  		'color_service_widget_background' => array(
  			'label'   => __( 'Widget Background Color', 'bizroot-pro' ),
  			'section' => 'color_section_service_widget',
  			),
  		'color_service_main_widget_title' => array(
  			'label'   => __( 'Main Widget Title Color', 'bizroot-pro' ),
  			'section' => 'color_section_service_widget',
  			),
  		'color_service_main_widget_subtitle' => array(
  			'label'   => __( 'Widget Subtitle Color', 'bizroot-pro' ),
  			'section' => 'color_section_service_widget',
  			),
  		'color_service_main_widget_separator' => array(
  			'label'   => __( 'Separator Color', 'bizroot-pro' ),
  			'section' => 'color_section_service_widget',
  			),
  		'color_service_widget_title' => array(
  			'label'   => __( 'Title Color', 'bizroot-pro' ),
  			'section' => 'color_section_service_widget',
  			),
  		'color_service_widget_title_hover' => array(
  			'label'   => __( 'Title Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_service_widget',
  			),
  		'color_service_widget_text' => array(
  			'label'   => __( 'Text Color', 'bizroot-pro' ),
  			'section' => 'color_section_service_widget',
  			),
  		'color_service_widget_button' => array(
  			'label'   => __( 'Button Color', 'bizroot-pro' ),
  			'section' => 'color_section_service_widget',
  			),
  		'color_service_widget_button_hover' => array(
  			'label'   => __( 'Button Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_service_widget',
  			),
  		'color_service_widget_button_background' => array(
  			'label'   => __( 'Button Background Color', 'bizroot-pro' ),
  			'section' => 'color_section_service_widget',
  			),
  		'color_service_widget_button_background_hover' => array(
  			'label'   => __( 'Button Background Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_service_widget',
  			),

  		// Specific widget pricing table.
  		'color_pricing_table_widget_background' => array(
  			'label'   => __( 'Widget Background Color', 'bizroot-pro' ),
  			'section' => 'color_section_pricing_table_widget',
  			),
  		'color_pricing_table_main_widget_title' => array(
  			'label'   => __( 'Main Widget Title Color', 'bizroot-pro' ),
  			'section' => 'color_section_pricing_table_widget',
  			),
  		'color_pricing_table_main_widget_subtitle' => array(
  			'label'   => __( 'Widget Subtitle Color', 'bizroot-pro' ),
  			'section' => 'color_section_pricing_table_widget',
  			),
  		'color_pricing_table_main_widget_separator' => array(
  			'label'   => __( 'Separator Color', 'bizroot-pro' ),
  			'section' => 'color_section_pricing_table_widget',
  			),
  		'color_pricing_table_widget_title' => array(
  			'label'   => __( 'Title Color', 'bizroot-pro' ),
  			'section' => 'color_section_pricing_table_widget',
  			),
  		'color_pricing_table_widget_text' => array(
  			'label'   => __( 'Text Color', 'bizroot-pro' ),
  			'section' => 'color_section_pricing_table_widget',
  			),
  		'color_pricing_table_widget_text_dimmed' => array(
  			'label'   => __( 'Text Dimmed Color', 'bizroot-pro' ),
  			'section' => 'color_section_pricing_table_widget',
  			),
  		'color_pricing_table_widget_content_background' => array(
  			'label'   => __( 'Content Background Color', 'bizroot-pro' ),
  			'section' => 'color_section_pricing_table_widget',
  			),
  		'color_pricing_table_widget_button' => array(
  			'label'   => __( 'Button Color', 'bizroot-pro' ),
  			'section' => 'color_section_pricing_table_widget',
  			),
  		'color_pricing_table_widget_button_hover' => array(
  			'label'   => __( 'Button Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_pricing_table_widget',
  			),
  		'color_pricing_table_widget_button_background' => array(
  			'label'   => __( 'Button Background Color', 'bizroot-pro' ),
  			'section' => 'color_section_pricing_table_widget',
  			),
  		'color_pricing_table_widget_button_background_hover' => array(
  			'label'   => __( 'Button Background Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_pricing_table_widget',
  			),
  		'color_pricing_table_featured' => array(
  			'label'   => __( 'Featured Color', 'bizroot-pro' ),
  			'section' => 'color_section_pricing_table_widget',
  			),

  		// Specific widget latest news.
  		'color_latest_news_widget_background' => array(
  			'label'   => __( 'Widget Background Color', 'bizroot-pro' ),
  			'section' => 'color_section_latest_news_widget',
  			),
  		'color_latest_news_main_widget_title' => array(
  			'label'   => __( 'Main Widget Title Color', 'bizroot-pro' ),
  			'section' => 'color_section_latest_news_widget',
  			),
  		'color_latest_news_main_widget_subtitle' => array(
  			'label'   => __( 'Widget Subtitle Color', 'bizroot-pro' ),
  			'section' => 'color_section_latest_news_widget',
  			),
  		'color_latest_news_main_widget_separator' => array(
  			'label'   => __( 'Separator Color', 'bizroot-pro' ),
  			'section' => 'color_section_latest_news_widget',
  			),
  		'color_latest_news_widget_title' => array(
  			'label'   => __( 'Title Color', 'bizroot-pro' ),
  			'section' => 'color_section_latest_news_widget',
  			),
  		'color_latest_news_widget_title_hover' => array(
  			'label'   => __( 'Title Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_latest_news_widget',
  			),
  		'color_latest_news_widget_text' => array(
  			'label'   => __( 'Text Color', 'bizroot-pro' ),
  			'section' => 'color_section_latest_news_widget',
  			),
  		'color_latest_news_widget_border' => array(
  			'label'   => __( 'Border Color', 'bizroot-pro' ),
  			'section' => 'color_section_latest_news_widget',
  			),
  		'color_latest_news_widget_button' => array(
  			'label'   => __( 'Button Color', 'bizroot-pro' ),
  			'section' => 'color_section_latest_news_widget',
  			),
  		'color_latest_news_widget_button_hover' => array(
  			'label'   => __( 'Button Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_latest_news_widget',
  			),
  		'color_latest_news_widget_button_background' => array(
  			'label'   => __( 'Button Background Color', 'bizroot-pro' ),
  			'section' => 'color_section_latest_news_widget',
  			),
  		'color_latest_news_widget_button_background_hover' => array(
  			'label'   => __( 'Button Background Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_latest_news_widget',
  			),

  		// Specific widget CTA.
  		'color_cta_widget_background' => array(
  			'label'   => __( 'Widget Background Color', 'bizroot-pro' ),
  			'section' => 'color_section_cta_widget',
  			),
  		'color_cta_main_widget_title' => array(
  			'label'   => __( 'Main Widget Title Color', 'bizroot-pro' ),
  			'section' => 'color_section_cta_widget',
  			),
  		'color_cta_widget_text' => array(
  			'label'   => __( 'Text Color', 'bizroot-pro' ),
  			'section' => 'color_section_cta_widget',
  			),
  		'color_cta_widget_button' => array(
  			'label'   => __( 'Button Color', 'bizroot-pro' ),
  			'section' => 'color_section_cta_widget',
  			),
  		'color_cta_widget_button_hover' => array(
  			'label'   => __( 'Button Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_cta_widget',
  			),
  		'color_cta_widget_button_background' => array(
  			'label'   => __( 'Button Background Color', 'bizroot-pro' ),
  			'section' => 'color_section_cta_widget',
  			),
  		'color_cta_widget_button_background_hover' => array(
  			'label'   => __( 'Button Background Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_cta_widget',
  			),

  		// Specific widget team.
  		'color_team_widget_background' => array(
  			'label'   => __( 'Widget Background Color', 'bizroot-pro' ),
  			'section' => 'color_section_team_widget',
  			),
  		'color_team_main_widget_title' => array(
  			'label'   => __( 'Main Widget Title Color', 'bizroot-pro' ),
  			'section' => 'color_section_team_widget',
  			),
  		'color_team_main_widget_subtitle' => array(
  			'label'   => __( 'Widget Subtitle Color', 'bizroot-pro' ),
  			'section' => 'color_section_team_widget',
  			),
  		'color_team_main_widget_separator' => array(
  			'label'   => __( 'Separator Color', 'bizroot-pro' ),
  			'section' => 'color_section_team_widget',
  			),
  		'color_team_widget_title' => array(
  			'label'   => __( 'Title Color', 'bizroot-pro' ),
  			'section' => 'color_section_team_widget',
  			),
  		'color_team_widget_title_hover' => array(
  			'label'   => __( 'Title Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_team_widget',
  			),
  		'color_team_widget_content' => array(
  			'label'   => __( 'Content Color', 'bizroot-pro' ),
  			'section' => 'color_section_team_widget',
  			),

  		// Specific widget skills.
  		'color_skills_widget_background' => array(
  			'label'   => __( 'Widget Background Color', 'bizroot-pro' ),
  			'section' => 'color_section_skills_widget',
  			),
  		'color_skills_main_widget_title' => array(
  			'label'   => __( 'Widget Title Color', 'bizroot-pro' ),
  			'section' => 'color_section_skills_widget',
  			),
  		'color_skills_main_widget_subtitle' => array(
  			'label'   => __( 'Widget Subtitle Color', 'bizroot-pro' ),
  			'section' => 'color_section_skills_widget',
  			),
  		'color_skills_main_widget_separator' => array(
  			'label'   => __( 'Separator Color', 'bizroot-pro' ),
  			'section' => 'color_section_skills_widget',
  			),

  		// Specific widget clients.
  		'color_clients_widget_background' => array(
  			'label'   => __( 'Widget Background Color', 'bizroot-pro' ),
  			'section' => 'color_section_clients_widget',
  			),
  		'color_clients_main_widget_title' => array(
  			'label'   => __( 'Widget Title Color', 'bizroot-pro' ),
  			'section' => 'color_section_clients_widget',
  			),
  		'color_clients_main_widget_subtitle' => array(
  			'label'   => __( 'Widget Subtitle Color', 'bizroot-pro' ),
  			'section' => 'color_section_clients_widget',
  			),
  		'color_clients_main_widget_separator' => array(
  			'label'   => __( 'Separator Color', 'bizroot-pro' ),
  			'section' => 'color_section_clients_widget',
  			),


		// Footer widgets.
  		'color_footer_widgets_background' => array(
  			'label'   => __( 'Background Color', 'bizroot-pro' ),
  			'section' => 'color_section_footer_widgets',
  			),
  		'color_footer_widgets_title' => array(
  			'label'   => __( 'Title Color', 'bizroot-pro' ),
  			'section' => 'color_section_footer_widgets',
  			),
  		'color_footer_widgets_separator' => array(
  			'label'   => __( 'Separator Color', 'bizroot-pro' ),
  			'section' => 'color_section_footer_widgets',
  			),

  		'color_footer_widgets_text' => array(
  			'label'   => __( 'Text Color', 'bizroot-pro' ),
  			'section' => 'color_section_footer_widgets',
  			),
  		'color_footer_widgets_link' => array(
  			'label'   => __( 'Link Color', 'bizroot-pro' ),
  			'section' => 'color_section_footer_widgets',
  			),
  		'color_footer_widgets_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_footer_widgets',
  			),

		// Footer contact.
  		'color_footer_contact_background' => array(
  			'label'   => __( 'Background Color', 'bizroot-pro' ),
  			'section' => 'color_section_footer_contact',
  			),
  		'color_footer_contact_overlay' => array(
  			'label'   => __( 'Overlay Color', 'bizroot-pro' ),
  			'section' => 'color_section_footer_contact',
  			),
  		'color_footer_contact_icon' => array(
  			'label'   => __( 'Icon Color', 'bizroot-pro' ),
  			'section' => 'color_section_footer_contact',
  			),
  		'color_footer_contact_text' => array(
  			'label'   => __( 'Text Color', 'bizroot-pro' ),
  			'section' => 'color_section_footer_contact',
  			),
  		'color_footer_contact_link' => array(
  			'label'   => __( 'Link Color', 'bizroot-pro' ),
  			'section' => 'color_section_footer_contact',
  			),
  		'color_footer_contact_link_hover' => array(
  			'label'   => __( 'Link Hover Color', 'bizroot-pro' ),
  			'section' => 'color_section_footer_contact',
  			),

  		);

    return $choices;

  }

endif;

if ( ! function_exists( 'bizroot_get_color_panels_options' ) ) :

  /**
   * Returns color panels options.
   *
   * @since 1.0.0
   */
	function bizroot_get_color_panels_options() {

		$choices = array(
			'color_panel_main' => array(
				'label' => __( 'Color Options', 'bizroot-pro' ),
				),
			'color_panel_widget' => array(
				'label' => __( 'Home Widget Color Options', 'bizroot-pro' ),
				),
			);
		return $choices;
	}

endif;
if ( ! function_exists( 'bizroot_get_color_sections_options' ) ) :

  /**
   * Returns color sections options.
   *
   * @since 1.0.0
   */
	function bizroot_get_color_sections_options() {

		$choices = array(
			'color_section_basic' => array(
				'label' => __( 'Basic Color Options', 'bizroot-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_header' => array(
				'label' => __( 'Header Color Options', 'bizroot-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_primary_menu' => array(
				'label' => __( 'Primary Menu Color Options', 'bizroot-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_slider' => array(
				'label' => __( 'Slider Color Options', 'bizroot-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_featured_content' => array(
				'label' => __( 'Featured Content Color Options', 'bizroot-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_content' => array(
				'label' => __( 'Content Color Options', 'bizroot-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_sidebar' => array(
				'label' => __( 'Sidebar Color Options', 'bizroot-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_breadcrumb' => array(
				'label' => __( 'Breadcrumb Color Options', 'bizroot-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_goto_top' => array(
				'label' => __( 'Go To Top Color Options', 'bizroot-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_pagination' => array(
				'label' => __( 'Pagination Color Options', 'bizroot-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_footer_widgets' => array(
				'label' => __( 'Footer Widgets Color Options', 'bizroot-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_footer_contact' => array(
				'label' => __( 'Footer Contact Color Options', 'bizroot-pro' ),
				'panel' => 'color_panel_main',
				),
			'color_section_footer_area' => array(
				'label' => __( 'Footer Area Color Options', 'bizroot-pro' ),
				'panel' => 'color_panel_main',
				),
			// 'color_section_fwidget_default' => array(
			// 	'label' => __( 'Default Options', 'bizroot-pro' ),
			// 	'panel' => 'color_panel_widget',
			// 	),
			'color_section_home_widgets' => array(
				'label' => __( 'Default Options', 'bizroot-pro' ),
				'panel' => 'color_panel_widget',
				),
			'color_section_testimonial_widget' => array(
				'label' => __( 'Testimonial Widget Color Options', 'bizroot-pro' ),
				'panel' => 'color_panel_widget',
				),
			'color_section_service_widget' => array(
				'label' => __( 'Service Widget Color Options', 'bizroot-pro' ),
				'panel' => 'color_panel_widget',
				),
			'color_section_latest_news_widget' => array(
				'label' => __( 'Latest News Widget Color Options', 'bizroot-pro' ),
				'panel' => 'color_panel_widget',
				),
			'color_section_team_widget' => array(
				'label' => __( 'Team Widget Color Options', 'bizroot-pro' ),
				'panel' => 'color_panel_widget',
				),
			'color_section_skills_widget' => array(
				'label' => __( 'Skills Widget Color Options', 'bizroot-pro' ),
				'panel' => 'color_panel_widget',
				),
			'color_section_clients_widget' => array(
				'label' => __( 'Clients Widget Color Options', 'bizroot-pro' ),
				'panel' => 'color_panel_widget',
				),
			'color_section_cta_widget' => array(
				'label' => __( 'CTA Widget Color Options', 'bizroot-pro' ),
				'panel' => 'color_panel_widget',
				),
			'color_section_portfolio_widget' => array(
				'label' => __( 'Portfolio Widget Color Options', 'bizroot-pro' ),
				'panel' => 'color_panel_widget',
				),
			'color_section_pricing_table_widget' => array(
				'label' => __( 'Pricing Table Widget Color Options', 'bizroot-pro' ),
				'panel' => 'color_panel_widget',
				),
			);
		return $choices;
	}

endif;

if ( ! function_exists( 'bizroot_get_featured_content_column_options' ) ) :

	/**
	 * Returns the featured content column.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function bizroot_get_featured_content_column_options() {

		$choices = array(
			'3' => sprintf( esc_html__( '%d Columns', 'bizroot-pro' ), 3 ),
			'4' => sprintf( esc_html__( '%d Columns', 'bizroot-pro' ), 4 ),
		);
		$output = apply_filters( 'bizroot_filter_featured_content_column_options', $choices );
		return $output;

	}

endif;

if ( ! function_exists( 'bizroot_get_numbers_dropdown_options' ) ) :

	/**
	 * Returns numbers dropdown options.
	 *
	 * @since 1.0.0
	 *
	 * @param int $min Min.
	 * @param int $max Max.
	 *
	 * @return array Options array.
	 */
	function bizroot_get_numbers_dropdown_options( $min = 1, $max = 4 ) {

		$output = array();

		if ( $min <= $max ) {
			for ( $i = $min; $i <= $max; $i++ ) {
				$output[ $i ] = $i;
			}
		}

		return $output;

	}

endif;

if ( ! function_exists( 'bizroot_get_contact_form_options' ) ) :

	/**
	 * Returns the contact form options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function bizroot_get_contact_form_options() {

		$output = array();
		$output[] = __( '&mdash; Select &mdash;', 'bizroot-pro' );

		if ( defined( 'WPCF7_VERSION' ) ) {
			$qargs = array(
				'post_type'      => 'wpcf7_contact_form',
				'posts_per_page' => 100,
				'no_found_rows'  => true,
				);
			$all_posts = get_posts( $qargs );
			if ( ! empty( $all_posts ) ) {
				foreach ( $all_posts as $p ) {
					$output[ $p->ID ] = esc_html( $p->post_title );
				}
			}
		}
		return $output;

	}

endif;

if ( ! function_exists( 'bizroot_get_skills_options' ) ) :

	/**
	 * Returns the skills options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function bizroot_get_skills_options() {

		$output = array();
		$output[] = __( '&mdash; Select &mdash;', 'bizroot-pro' );

		if ( class_exists( 'WEN_Skill_Charts' ) ) {
			$qargs = array(
				'post_type'      => 'wen_skill',
				'posts_per_page' => 100,
				'no_found_rows'  => true,
				);
			$all_posts = get_posts( $qargs );
			if ( ! empty( $all_posts ) ) {
				foreach ( $all_posts as $p ) {
					$output[ $p->ID ] = esc_html( $p->post_title );
				}
			}
		}
		return $output;

	}

endif;

if ( ! function_exists( 'bizroot_get_pricing_table_options' ) ) :

	/**
	 * Returns the pricing table options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function bizroot_get_pricing_table_options() {

		$output = array();
		$output[] = __( '&mdash; Select &mdash;', 'bizroot-pro' );

		$qargs = array(
			'post_type'      => 'rpt_pricing_table',
			'posts_per_page' => 100,
			'no_found_rows'  => true,
			);
		$all_posts = get_posts( $qargs );
		if ( ! empty( $all_posts ) ) {
			foreach ( $all_posts as $p ) {
				$output[ $p->ID ] = esc_html( $p->post_title );
			}
		}

		return $output;

	}

endif;

if ( ! function_exists( 'bizroot_get_widget_animation_fields' ) ) :

	/**
	 * Returns widget animation fields.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function bizroot_get_widget_animation_fields() {

		$output = array();

		$output['animation_heading'] = array(
			'label' => __( 'ANIMATION OPTIONS', 'bizroot-pro' ),
			'type'  => 'heading',
			'class' => 'widefat',
			);
		$output['animation_effect'] = array(
			'label'       => __( 'Effect:', 'bizroot-pro' ),
			'description' => __( 'Choose an animation style.', 'bizroot-pro' ),
			'type'        => 'select',
			'options'     => bizroot_get_wow_animation_effects_options(),
			);
		$output['animation_duration'] = array(
			'label'       => __( 'Duration:', 'bizroot-pro' ),
			'description' => __( 'Change animation duration.', 'bizroot-pro' ),
			'type'        => 'select',
			'options'     => bizroot_get_wow_animation_duration_options(),
			);
		$output['animation_delay'] = array(
			'label'       => __( 'Delay:', 'bizroot-pro' ),
			'description' => __( 'Delay before the animation starts', 'bizroot-pro' ),
			'type'        => 'select',
			'options'     => bizroot_get_wow_animation_delay_options(),
			);
		$output['animation_iteration'] = array(
			'label'       => __( 'Iteration:', 'bizroot-pro' ),
			'description' => __( 'Number of times the animation is repeated', 'bizroot-pro' ),
			'type'        => 'select',
			'options'     => bizroot_get_wow_animation_iteration_options(),
			);
		$output['animation_offset'] = array(
			'label'       => __( 'Offset:', 'bizroot-pro' ),
			'description' => __( 'Distance in pixel to start the animation', 'bizroot-pro' ),
			'type'        => 'text',
			'css'         => 'max-width:60px;',
			);

		return $output;

	}

endif;

if ( ! function_exists( 'bizroot_get_wow_animation_effects_options' ) ) :

	/**
	 * Returns WOW animation effects options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function bizroot_get_wow_animation_effects_options() {

		$choices = array(
			'bounce'             => _x( 'bounce', 'Animation Effect', 'bizroot-pro' ),
			'flash'              => _x( 'flash', 'Animation Effect', 'bizroot-pro' ),
			'pulse'              => _x( 'pulse', 'Animation Effect', 'bizroot-pro' ),
			'rubberBand'         => _x( 'rubberBand', 'Animation Effect', 'bizroot-pro' ),
			'shake'              => _x( 'shake', 'Animation Effect', 'bizroot-pro' ),
			'headShake'          => _x( 'headShake', 'Animation Effect', 'bizroot-pro' ),
			'swing'              => _x( 'swing', 'Animation Effect', 'bizroot-pro' ),
			'tada'               => _x( 'tada', 'Animation Effect', 'bizroot-pro' ),
			'wobble'             => _x( 'wobble', 'Animation Effect', 'bizroot-pro' ),
			'jello'              => _x( 'jello', 'Animation Effect', 'bizroot-pro' ),
			'bounceIn'           => _x( 'bounceIn', 'Animation Effect', 'bizroot-pro' ),
			'bounceInDown'       => _x( 'bounceInDown', 'Animation Effect', 'bizroot-pro' ),
			'bounceInLeft'       => _x( 'bounceInLeft', 'Animation Effect', 'bizroot-pro' ),
			'bounceInRight'      => _x( 'bounceInRight', 'Animation Effect', 'bizroot-pro' ),
			'bounceInUp'         => _x( 'bounceInUp', 'Animation Effect', 'bizroot-pro' ),
			'bounceOut'          => _x( 'bounceOut', 'Animation Effect', 'bizroot-pro' ),
			'bounceOutDown'      => _x( 'bounceOutDown', 'Animation Effect', 'bizroot-pro' ),
			'bounceOutLeft'      => _x( 'bounceOutLeft', 'Animation Effect', 'bizroot-pro' ),
			'bounceOutRight'     => _x( 'bounceOutRight', 'Animation Effect', 'bizroot-pro' ),
			'bounceOutUp'        => _x( 'bounceOutUp', 'Animation Effect', 'bizroot-pro' ),
			'fadeIn'             => _x( 'fadeIn', 'Animation Effect', 'bizroot-pro' ),
			'fadeInDown'         => _x( 'fadeInDown', 'Animation Effect', 'bizroot-pro' ),
			'fadeInDownBig'      => _x( 'fadeInDownBig', 'Animation Effect', 'bizroot-pro' ),
			'fadeInLeft'         => _x( 'fadeInLeft', 'Animation Effect', 'bizroot-pro' ),
			'fadeInLeftBig'      => _x( 'fadeInLeftBig', 'Animation Effect', 'bizroot-pro' ),
			'fadeInRight'        => _x( 'fadeInRight', 'Animation Effect', 'bizroot-pro' ),
			'fadeInRightBig'     => _x( 'fadeInRightBig', 'Animation Effect', 'bizroot-pro' ),
			'fadeInUp'           => _x( 'fadeInUp', 'Animation Effect', 'bizroot-pro' ),
			'fadeInUpBig'        => _x( 'fadeInUpBig', 'Animation Effect', 'bizroot-pro' ),
			'fadeOut'            => _x( 'fadeOut', 'Animation Effect', 'bizroot-pro' ),
			'fadeOutDown'        => _x( 'fadeOutDown', 'Animation Effect', 'bizroot-pro' ),
			'fadeOutDownBig'     => _x( 'fadeOutDownBig', 'Animation Effect', 'bizroot-pro' ),
			'fadeOutLeft'        => _x( 'fadeOutLeft', 'Animation Effect', 'bizroot-pro' ),
			'fadeOutLeftBig'     => _x( 'fadeOutLeftBig', 'Animation Effect', 'bizroot-pro' ),
			'fadeOutRight'       => _x( 'fadeOutRight', 'Animation Effect', 'bizroot-pro' ),
			'fadeOutRightBig'    => _x( 'fadeOutRightBig', 'Animation Effect', 'bizroot-pro' ),
			'fadeOutUp'          => _x( 'fadeOutUp', 'Animation Effect', 'bizroot-pro' ),
			'fadeOutUpBig'       => _x( 'fadeOutUpBig', 'Animation Effect', 'bizroot-pro' ),
			'flipInX'            => _x( 'flipInX', 'Animation Effect', 'bizroot-pro' ),
			'flipInY'            => _x( 'flipInY', 'Animation Effect', 'bizroot-pro' ),
			'flipOutX'           => _x( 'flipOutX', 'Animation Effect', 'bizroot-pro' ),
			'flipOutY'           => _x( 'flipOutY', 'Animation Effect', 'bizroot-pro' ),
			'lightSpeedIn'       => _x( 'lightSpeedIn', 'Animation Effect', 'bizroot-pro' ),
			'lightSpeedOut'      => _x( 'lightSpeedOut', 'Animation Effect', 'bizroot-pro' ),
			'rotateIn'           => _x( 'rotateIn', 'Animation Effect', 'bizroot-pro' ),
			'rotateInDownLeft'   => _x( 'rotateInDownLeft', 'Animation Effect', 'bizroot-pro' ),
			'rotateInDownRight'  => _x( 'rotateInDownRight', 'Animation Effect', 'bizroot-pro' ),
			'rotateInUpLeft'     => _x( 'rotateInUpLeft', 'Animation Effect', 'bizroot-pro' ),
			'rotateInUpRight'    => _x( 'rotateInUpRight', 'Animation Effect', 'bizroot-pro' ),
			'rotateOut'          => _x( 'rotateOut', 'Animation Effect', 'bizroot-pro' ),
			'rotateOutDownLeft'  => _x( 'rotateOutDownLeft', 'Animation Effect', 'bizroot-pro' ),
			'rotateOutDownRight' => _x( 'rotateOutDownRight', 'Animation Effect', 'bizroot-pro' ),
			'rotateOutUpLeft'    => _x( 'rotateOutUpLeft', 'Animation Effect', 'bizroot-pro' ),
			'rotateOutUpRight'   => _x( 'rotateOutUpRight', 'Animation Effect', 'bizroot-pro' ),
			'hinge'              => _x( 'hinge', 'Animation Effect', 'bizroot-pro' ),
			'rollIn'             => _x( 'rollIn', 'Animation Effect', 'bizroot-pro' ),
			'rollOut'            => _x( 'rollOut', 'Animation Effect', 'bizroot-pro' ),
			'zoomIn'             => _x( 'zoomIn', 'Animation Effect', 'bizroot-pro' ),
			'zoomInDown'         => _x( 'zoomInDown', 'Animation Effect', 'bizroot-pro' ),
			'zoomInLeft'         => _x( 'zoomInLeft', 'Animation Effect', 'bizroot-pro' ),
			'zoomInRight'        => _x( 'zoomInRight', 'Animation Effect', 'bizroot-pro' ),
			'zoomInUp'           => _x( 'zoomInUp', 'Animation Effect', 'bizroot-pro' ),
			'zoomOut'            => _x( 'zoomOut', 'Animation Effect', 'bizroot-pro' ),
			'zoomOutDown'        => _x( 'zoomOutDown', 'Animation Effect', 'bizroot-pro' ),
			'zoomOutLeft'        => _x( 'zoomOutLeft', 'Animation Effect', 'bizroot-pro' ),
			'zoomOutRight'       => _x( 'zoomOutRight', 'Animation Effect', 'bizroot-pro' ),
			'zoomOutUp'          => _x( 'zoomOutUp', 'Animation Effect', 'bizroot-pro' ),
			'slideInDown'        => _x( 'slideInDown', 'Animation Effect', 'bizroot-pro' ),
			'slideInLeft'        => _x( 'slideInLeft', 'Animation Effect', 'bizroot-pro' ),
			'slideInRight'       => _x( 'slideInRight', 'Animation Effect', 'bizroot-pro' ),
			'slideInUp'          => _x( 'slideInUp', 'Animation Effect', 'bizroot-pro' ),
			'slideOutDown'       => _x( 'slideOutDown', 'Animation Effect', 'bizroot-pro' ),
			'slideOutLeft'       => _x( 'slideOutLeft', 'Animation Effect', 'bizroot-pro' ),
			'slideOutRight'      => _x( 'slideOutRight', 'Animation Effect', 'bizroot-pro' ),
			'slideOutUp'         => _x( 'slideOutUp', 'Animation Effect', 'bizroot-pro' ),
		);
		$output = apply_filters( 'bizroot_filter_wow_animation_effects_options', $choices );
		if ( ! empty( $output ) ) {
			ksort( $output );
		}
		$output = array( 'no-animation' => __( 'No Animation', 'bizroot-pro' ) ) + $output;
		return $output;

	}

endif;

if ( ! function_exists( 'bizroot_get_wow_animation_duration_options' ) ) :

	/**
	 * Returns WOW animation duration options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function bizroot_get_wow_animation_duration_options() {

		$choices = array(
			'' => __( 'Default', 'bizroot-pro' ),
			1  => sprintf( __( '%d Second', 'bizroot-pro' ), 1 ),
			2  => sprintf( __( '%d Seconds', 'bizroot-pro' ), 2 ),
			3  => sprintf( __( '%d Seconds', 'bizroot-pro' ), 3 ),
			4  => sprintf( __( '%d Seconds', 'bizroot-pro' ), 4 ),
			5  => sprintf( __( '%d Seconds', 'bizroot-pro' ), 5 ),
		);
		$output = apply_filters( 'bizroot_filter_wow_animation_duration_options', $choices );
		return $output;
	}

endif;

if ( ! function_exists( 'bizroot_get_wow_animation_delay_options' ) ) :

	/**
	 * Returns WOW animation delay options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function bizroot_get_wow_animation_delay_options() {

		$choices = array(
			'' => __( 'Default', 'bizroot-pro' ),
			1  => sprintf( __( '%d Second', 'bizroot-pro' ), 1 ),
			2  => sprintf( __( '%d Seconds', 'bizroot-pro' ), 2 ),
			3  => sprintf( __( '%d Seconds', 'bizroot-pro' ), 3 ),
			4  => sprintf( __( '%d Seconds', 'bizroot-pro' ), 4 ),
			5  => sprintf( __( '%d Seconds', 'bizroot-pro' ), 5 ),
		);
		$output = apply_filters( 'bizroot_filter_wow_animation_delay_options', $choices );
		return $output;
	}

endif;

if ( ! function_exists( 'bizroot_get_wow_animation_iteration_options' ) ) :

	/**
	 * Returns WOW animation iteration options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function bizroot_get_wow_animation_iteration_options() {

		$choices = array(
			1 => __( 'Don\'t Repeat', 'bizroot-pro' ),
			2 => sprintf( __( 'Repeat %dx', 'bizroot-pro' ), 2 ),
			3 => sprintf( __( 'Repeat %dx', 'bizroot-pro' ), 3 ),
			4 => sprintf( __( 'Repeat %dx', 'bizroot-pro' ), 4 ),
			5 => sprintf( __( 'Repeat %dx', 'bizroot-pro' ), 5 ),
		);
		$output = apply_filters( 'bizroot_filter_wow_animation_iteration_options', $choices );
		return $output;
	}

endif;
