<?php
/**
 * CSS related hooks.
 *
 * This file contains hook functions which are related to CSS.
 *
 * @package Bizroot
 */

if ( ! function_exists( 'bizroot_trigger_custom_css_action' ) ) :

	/**
	 * Do action theme custom CSS.
	 *
	 * @since 1.0.0
	 */
	function bizroot_trigger_custom_css_action() {

		/**
		 * Hook - bizroot_action_theme_custom_css.
		 *
		 * @hooked bizroot_add_option_custom_css - 99
		 */
		do_action( 'bizroot_action_theme_custom_css' );

	}

endif;

add_action( 'wp_head', 'bizroot_trigger_custom_css_action', 99 );

if ( ! function_exists( 'bizroot_add_option_custom_css' ) ) :

	/**
	 * Add custom CSS.
	 *
	 * @since 1.0.0
	 */
	function bizroot_add_option_custom_css() {

		$custom_css = bizroot_get_option( 'custom_css' );
		$output = '';
		if ( ! empty( $custom_css ) ) {
			$output = "\n" . '<style type="text/css">' . "\n";
			$output .= $custom_css;
			$output .= "\n" . '</style>' . "\n" ;
		}
		echo $output;

	}

endif;

add_action( 'bizroot_action_theme_custom_css', 'bizroot_add_option_custom_css', 99 );

if ( ! function_exists( 'bizroot_add_theme_custom_font_css' ) ) :

	/**
	 * Inject theme custom font CSS.
	 *
	 * @since 1.0.0
	 */
	function bizroot_add_theme_custom_font_css() {

		$custom_css = '';

		$font_settings = bizroot_get_font_family_theme_settings_options();

		$required_fonts = array();

		if ( ! empty( $font_settings ) ) {
			foreach ( $font_settings as $key => $val ) {
				$option_value = bizroot_get_option( $key );
				if ( ! empty( $option_value ) && $val['default'] !== $option_value ) {
					$required_fonts[ $key ] = $option_value;
				}
			}
		}
		if ( empty( $required_fonts ) ) {
			// We do not need extra CSS.
			return;
		}

		foreach ( $required_fonts as $key => $font ) {

			$family = bizroot_get_font_family_from_key( $font );

			if ( ! empty( $family ) ) {

				switch ( $key ) {
					case 'font_site_default':
						$custom_css .= 'body{font-family:' . $family . '}' . "\n";
					break;

					case 'font_site_title':
						$custom_css .= '.site-title{font-family:' . $family . '}' . "\n";
					break;

					case 'font_site_tagline':
						$custom_css .= '.site-description{font-family:' . $family . '}' . "\n";
					break;

					case 'font_heading_tags':
						$custom_css .= 'h1,h2,h3,h4,h5,h6{font-family:' . $family . '}' . "\n";
					break;

					case 'font_content_title':
						$custom_css .= '.entry-header .entry-title{font-family:' . $family . '}' . "\n";
					break;

					case 'font_content_body':
						$custom_css .= '#content{font-family:' . $family . '}' . "\n";
					break;

					case 'font_navigation':
						$custom_css .= '#site-navigation ul li a{font-family:' . $family . '}' . "\n";
					break;

					default:
					break;
				}
			}
		}

		// Render style.
		if ( ! empty( $custom_css ) ) {
			echo '<style type="text/css">';
			echo $custom_css;
			echo '</style>';
		}

	}

endif;

add_action( 'bizroot_action_theme_custom_css', 'bizroot_add_theme_custom_font_css' );


if ( ! function_exists( 'bizroot_add_theme_custom_color_css' ) ) :

	/**
	 * Inject theme custom color CSS.
	 *
	 * @since 1.0.0
	 */
	function bizroot_add_theme_custom_color_css() {

		$custom_css = '';

		$color_settings = bizroot_get_color_theme_settings_options();

		$default = bizroot_get_default_colors();

		$required_colors = array();

		if ( ! empty( $color_settings ) ) {
		  foreach ($color_settings as $key => $val ) {
		    $option_value = bizroot_get_option( $key );
		    if ( ! empty( $option_value ) && $default[$key] != $option_value ) {
		      $required_colors[ $key ] = $option_value;
		    }
		  }
		}
		if ( empty( $required_colors ) ) {
		  // We do not need extra CSS.
		  return;
		}

		foreach ( $required_colors as $key => $color ) {

			switch ( $key ) {

				// Basic.
				case 'color_basic_text':
				  $custom_css .= 'body{color:' . $color . '}' . "\n";
				  break;
				case 'color_basic_link':
				  $custom_css .= 'a,a:visited{color:' . $color . '}' . "\n";
				  $custom_css .= '#mobile-trigger i{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_basic_link_hover':
				  $custom_css .= 'a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_basic_heading':
				  $custom_css .= 'h1,h2,h3,h4,h5,h6{color:' . $color . '}' . "\n";
				  break;
				case 'color_basic_page_title':
				  $custom_css .= '.page-title{color:' . $color . '}' . "\n";
				  $custom_css .= '.header-content .separator{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_basic_page_title_separator':
				  $custom_css .= '.header-content .separator{color:' . $color . '}' . "\n";
				  $custom_css .= '.header-content .separator::after,.header-content .separator::before{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_basic_button_text':
				$custom_css .= '#infinite-handle span,.search-box > a,a.button,.search-form .search-submit,.nav-links a,a.cta-button-primary,button, input[type="button"], input[type="reset"], input[type="submit"],#infinite-handle span button, #infinite-handle span button{color:' . $color . '}' . "\n";
				$custom_css .= '.woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button{color:' . $color . '}' . "\n";
				 break;
				case 'color_basic_button_text_hover':
				  $custom_css .= '#infinite-handle span:hover.search-box > a:hover,a.button:hover,.search-form .search-submit:hover,a.cta-button-primary:hover,.nav-links a:hover,button:hover, input[type="button"]:hover, input[type="reset"]:hover, input[type="submit"]:hover, #infinite-handle span button:hover{color:' . $color . '}' . "\n";
				  $custom_css .= '.woocommerce #respond input#submit.alt:hover,.woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button.woocommerce:hover #respond input#submit.alt.disabled, .woocommerce #respond input#submit.alt.disabled:hover, .woocommerce #respond input#submit.alt:disabled, .woocommerce #respond input#submit.alt:disabled:hover, .woocommerce #respond input#submit.alt[disabled]:disabled, .woocommerce #respond input#submit.alt[disabled]:disabled:hover, .woocommerce a.button.alt.disabled, .woocommerce a.button.alt.disabled:hover, .woocommerce a.button.alt:disabled, .woocommerce a.button.alt:disabled:hover, .woocommerce a.button.alt[disabled]:disabled, .woocommerce a.button.alt[disabled]:disabled:hover, .woocommerce button.button.alt.disabled, .woocommerce button.button.alt.disabled:hover, .woocommerce button.button.alt:disabled, .woocommerce button.button.alt:disabled:hover, .woocommerce button.button.alt[disabled]:disabled, .woocommerce button.button.alt[disabled]:disabled:hover, .woocommerce input.button.alt.disabled, .woocommerce input.button.alt.disabled:hover, .woocommerce input.button.alt:disabled, .woocommerce input.button.alt:disabled:hover, .woocommerce input.button.alt[disabled]:disabled, .woocommerce input.button.alt[disabled]:disabled:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_basic_button_background':
				  $custom_css .= '#infinite-handle span,.search-box > a,a.button,a.links-btn::after,.search-form .search-submit,.woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button{background-color:' . $color . '}' . "\n";
				  $custom_css .= 'a.cta-button-primary,button, input[type="button"], input[type="reset"], input[type="submit"],#infinite-handle span button{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_basic_button_background_hover':
				  $custom_css .= '#infinite-handle span:hover,.search-box > a:hover,a.button:hover,a.links-btn:hover::after,.search-form .search-submit:hover,a.cta-button-primary:hover,.nav-links a:hover,button:hover, input[type="button"]:hover, input[type="reset"]:hover, input[type="submit"]:hover,#infinite-handle span button{background-color:' . $color . '}' . "\n";
				  $custom_css .= '.woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button.woocommerce:hover #respond input#submit.alt.disabled, .woocommerce #respond input#submit.alt.disabled:hover, .woocommerce #respond input#submit.alt:disabled, .woocommerce #respond input#submit.alt:disabled:hover, .woocommerce #respond input#submit.alt[disabled]:disabled, .woocommerce #respond input#submit.alt[disabled]:disabled:hover, .woocommerce a.button.alt.disabled, .woocommerce a.button.alt.disabled:hover, .woocommerce a.button.alt:disabled, .woocommerce a.button.alt:disabled:hover, .woocommerce a.button.alt[disabled]:disabled, .woocommerce a.button.alt[disabled]:disabled:hover, .woocommerce button.button.alt.disabled, .woocommerce button.button.alt.disabled:hover, .woocommerce button.button.alt:disabled, .woocommerce button.button.alt:disabled:hover, .woocommerce button.button.alt[disabled]:disabled, .woocommerce button.button.alt[disabled]:disabled:hover, .woocommerce input.button.alt.disabled, .woocommerce input.button.alt.disabled:hover, .woocommerce input.button.alt:disabled, .woocommerce input.button.alt:disabled:hover, .woocommerce input.button.alt[disabled]:disabled, .woocommerce input.button.alt[disabled]:disabled:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover{background-color:' . $color . '}' . "\n";
				  break;

				// Header.
				case 'color_header_background':
				  $custom_css .= '#masthead {background-color:' . $color . '}' . "\n";
				  break;
				case 'color_header_title':
				  $custom_css .= '#site-identity .site-title > a{color:' . $color . '}' . "\n";
		        break;
				case 'color_header_title_hover':
				  $custom_css .= '#site-identity .site-title > a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_header_tagline':
				  $custom_css .= '.site-description{color:' . $color . '}' . "\n";
				  break;

			   // Primary Menu.
				case 'color_primary_menu_link':
				  $custom_css .= '#main-nav ul li a,.dropdown-toggle::after{color:' . $color . '}' . "\n";
				  break;
				case 'color_primary_menu_link_hover':
				  $custom_css .= '#main-nav ul li a:hover,#main-nav li.current-menu-item > a,
				  #main-nav li.current_page_item > a,#main-nav ul li:hover > a{color:' . $color . '}' . "\n";
				  break;
				case 'color_primary_submenu_background':
				    $custom_css .= '.main-navigation ul ul{background-color:' . $color . '}' . "\n";
				    break;
				case 'color_primary_submenu_background_hover':
				    $custom_css .= '#main-nav ul li li:hover > a{background-color:' . $color . '}' . "\n";
				    break;

				// Slider.
				case 'color_slider_overlay':
				  $custom_css .= '#featured-slider .overlay-enabled .cycle-slide::after,#custom-header::after,#featured-slider .overlay-disabled .cycle-caption::after{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_slider_caption_text':
				  $custom_css .= '#main-slider p{color:' . $color . '}' . "\n";
				  break;
				case 'color_slider_caption_link':
				  $custom_css .= '#main-slider h3 a{color:' . $color . '}' . "\n";
				  break;
				case 'color_slider_caption_link_hover':
				  $custom_css .= '#main-slider  h3 a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_slider_icon':
				  $custom_css .= '#main-slider .cycle-prev, #main-slider .cycle-next{color:' . $color . '}' . "\n";
				  break;
				case 'color_slider_icon_hover':
				  $custom_css .= '#main-slider .cycle-prev:hover, #main-slider .cycle-next:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_slider_icon_background':
				  $custom_css .= '#main-slider .cycle-prev, #main-slider .cycle-next{background-color:' . $color . '}' . "\n";

				  break;
				case 'color_slider_icon_background_hover':
				  $custom_css .= '#main-slider .cycle-prev:hover, #main-slider .cycle-next:hover{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_slider_pager':
				  $custom_css .= '#main-slider .pager-box{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_slider_pager_active':
				  $custom_css .= '#main-slider .pager-box:hover,#main-slider .pager-box.cycle-pager-active{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_slider_button':
				  $custom_css .= '#main-slider .slider-buttons a{color:' . $color . '}' . "\n";
				  break;
				case 'color_slider_button_hover':
				  $custom_css .= '#main-slider .slider-buttons a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_slider_button_background':
				  $custom_css .= '#main-slider .slider-buttons a{background-color:' . $color . '}' . "\n";
				  $custom_css .= '#main-slider .slider-buttons a{border-color:' . $color . '}' . "\n";

				  break;
				case 'color_slider_button_background_hover':
				  $custom_css .= '#main-slider .slider-buttons a:hover{background-color:' . $color . '}' . "\n";
				  $custom_css .= '#main-slider .slider-buttons a:hover{border-color:' . $color . '}' . "\n";

				  break;
				// Content.
				case 'color_content_background':
				  $custom_css .= '#content{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_content_title':
				  $custom_css .= '#content .entry-title{color:' . $color . '}' . "\n";
				  break;
				case 'color_content_text':
				  $custom_css .= '#content {color:' . $color . '}' . "\n";
				  break;
				case 'color_content_link':
				  $custom_css .= '#content a{color:' . $color . '}' . "\n";
				  break;
				case 'color_content_link_hover':
				  $custom_css .= '#content  a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_content_meta_link':
				  $custom_css .= '#content .entry-meta > span a,#content .entry-footer > span a{color:' . $color . '}' . "\n";
				  break;
				case 'color_content_meta_link_hover':
				  $custom_css .= '#content .entry-meta > span a:hover,#content  .entry-footer > span a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_content_meta_icon':
				  $custom_css .= '#content .entry-meta > span::before,#content  .entry-footer > span::before{color:' . $color . '}' . "\n";
				  break;

				// Sidebar.
				case 'color_sidebar_title':
				  $custom_css .= '.sidebar .widget-title{color:' . $color . '}' . "\n";
				  break;
				case 'color_sidebar_text':
				  $custom_css .= '.sidebar{color:' . $color . '}' . "\n";
				  break;
				case 'color_sidebar_link':
				  $custom_css .= '.sidebar .widget a{color:' . $color . '}' . "\n";

				  break;
				case 'color_sidebar_link_hover':
				  $custom_css .= '.sidebar .widget a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_sidebar_list_icon':
				  $custom_css .= '.sidebar ul li::before{color:' . $color . '}' . "\n";
				  break;


				// Footer contact.
				case 'color_footer_contact_background':
				  $custom_css .= '#footer-contact-section{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_contact_overlay':
				  $custom_css .= '#footer-contact-section.footer-contact-overlay-enabled::before{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_contact_icon':
				  $custom_css .= '#footer-contact-section .quick-contact li::before{color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_contact_text':
				  $custom_css .= '#footer-contact-section .quick-contact li{color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_contact_link':
				  $custom_css .= '#footer-contact-section .quick-contact a{color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_contact_link_hover':
				  $custom_css .= '#footer-contact-section .quick-contact a:hover{color:' . $color . '}' . "\n";
				  break;

				// Footer area.
				case 'color_footer_area_background':
				  $custom_css .= '#colophon{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_area_text':
				  $custom_css .= '#colophon{color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_area_link':
				  $custom_css .= '#colophon a{color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_area_link_hover':
				  $custom_css .= '#colophon a:hover{color:' . $color . '}' . "\n";
				  break;

				// Go To Top.
			    case 'color_goto_top_icon':
				  $custom_css .= '#btn-scrollup i.fa{color:' . $color . '}' . "\n";
				  break;
				case 'color_goto_top_icon_hover':
				  $custom_css .= '#btn-scrollup i.fa:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_goto_top_background':
				  $custom_css .= '#btn-scrollup{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_goto_top_background_hover':
				  $custom_css .= '#btn-scrollup:hover{background-color:' . $color . '}' . "\n";
				  break;


				// Pagination.
				case 'color_pagination_link':
				  $custom_css .= '.navigation .nav-links a{color:' . $color . '}' . "\n";
				  break;
				case 'color_pagination_link_hover':
				  $custom_css .= '.navigation .nav-links .page-numbers.current,  .navigation .nav-links a:hovercolor:' . $color . '}' . "\n";
				  break;
				case 'color_pagination_link_background':
				  $custom_css .= '.navigation .nav-links a{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_pagination_link_background_hover':
				  $custom_css .= '.navigation .nav-links .page-numbers.current,  .navigation .nav-links a:hover{background-color:' . $color . '}' . "\n";
				  break;

				// Breadcrumb.
				case 'color_breadcrumb_background':
				  $custom_css .= '#breadcrumb{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_breadcrumb_link':
				  $custom_css .= '#crumbs a,#breadcrumb a{color:' . $color . '}' . "\n";
				  break;
				case 'color_breadcrumb_link_hover':
				  $custom_css .= '#crumbs a:hover,#breadcrumb a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_breadcrumb_text':
				  $custom_css .= '#breadcrumb{color:' . $color . '}' . "\n";
				  break;

				// Footer Widgets.
				case 'color_footer_widgets_background':
				  $custom_css .= '#footer-widgets{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_widgets_title':
				  $custom_css .= '#footer-widgets .widget-title{color:' . $color . '}' . "\n";
				  $custom_css .= '#footer-widgets .separator{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_widgets_separator':
				  $custom_css .= '#footer-widgets .separator::after,#footer-widgets .separator::before{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_widgets_text':
				  $custom_css .= '#footer-widgets {color:' . $color . '}' . "\n";
				  break;
				case 'color_footer_widgets_link':
				  $custom_css .= '#footer-widgets a{color:' . $color . '}' . "\n";
				  $custom_css .= '#footer-widgets h3.widget-title::after{background-color:' . $color . '}' . "\n";
			      $custom_css .= '#footer-widgets  break;{border-color:' . $color . '}' . "\n";
				break;

				case 'color_footer_widgets_link_hover':
				  $custom_css .= '#footer-widgets a:hover{color:' . $color . '}' . "\n";
				  break;

				// Home Page Widgets.
				case 'color_home_widgets_background':
				  $custom_css .= '#sidebar-front-page-widget-area .widget{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_home_widgets_title':
				  $custom_css .= '#sidebar-front-page-widget-area .widget-title{color:' . $color . '}' . "\n";
				   $custom_css .= '#sidebar-front-page-widget-area .separator{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_home_widgets_subtitle':
				  $custom_css .= '#sidebar-front-page-widget-area .widget-subtitle{color:' . $color . '}' . "\n";
				  break;
				case 'color_home_widgets_separator':
				  $custom_css .= '#sidebar-front-page-widget-area .separator::before,#sidebar-front-page-widget-area .separator::after{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_home_widgets_text':
				  $custom_css .= '#sidebar-front-page-widget-area,#sidebar-front-page-widget-area p{color:' . $color . '}' . "\n";
				  break;
				case 'color_home_widgets_link':
				  $custom_css .= '#sidebar-front-page-widget-area a{color:' . $color . '}' . "\n";
				  break;
				case 'color_home_widgets_link_hover':
				  $custom_css .= '#sidebar-front-page-widget-area a:hover{color:' . $color . '}' . "\n";
				  break;


				// Specific widget CTA.
				case 'color_cta_widget_background':
				  $custom_css .= '#sidebar-front-page-widget-area  .bizroot_widget_call_to_action{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_cta_main_widget_title':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_call_to_action .widget-title{color:' . $color . '}' . "\n";
				  break;
				case 'color_cta_widget_text':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_call_to_action .call-to-action-description p{color:' . $color . '}' . "\n";
				  break;
				case 'color_cta_widget_button':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_call_to_action .call-to-action-buttons .custom-button{color:' . $color . '}' . "\n";
				  break;
				case 'color_cta_widget_button_hover':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_call_to_action .call-to-action-buttons .custom-button:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_cta_widget_button_background':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_call_to_action .call-to-action-buttons .custom-button{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_cta_widget_button_background_hover':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_call_to_action .call-to-action-buttons .custom-button:hover{background-color:' . $color . '}' . "\n";
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_call_to_action .call-to-action-buttons .custom-button:hover{border-color:' . $color . '}' . "\n";
				  break;

				// Specific widget Latest News Widget.
				case 'color_latest_news_widget_background':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_latest_news{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_latest_news_main_widget_title':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_latest_news .widget-title {color:' . $color . '}' . "\n";
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_latest_news .separator{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_latest_news_main_widget_subtitle':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_latest_news .widget-subtitle{color:' . $color . '}' . "\n";
				  break;
				case 'color_latest_news_main_widget_separator':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_latest_news .separator::after,#sidebar-front-page-widget-area .bizroot_widget_latest_news .separator::before{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_latest_news_widget_title':
				  $custom_css .= '#sidebar-front-page-widget-area .latest-news-text-wrap .latest-news-title a{color:' . $color . '}' . "\n";
				  break;
				case 'color_latest_news_widget_title_hover':
				  $custom_css .= '#sidebar-front-page-widget-area .latest-news-text-wrap .latest-news-title a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_latest_news_widget_text':
				  $custom_css .= '#sidebar-front-page-widget-area .latest-news-text-wrap p,#sidebar-front-page-widget-area .latest-news-widget{color:' . $color . '}' . "\n";
				  break;
				case 'color_latest_news_widget_border':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_latest_news .latest-news-text-wrap,#sidebar-front-page-widget-area .bizroot_widget_latest_news .latest-news-meta li,#sidebar-front-page-widget-area .bizroot_widget_latest_news .latest-news-text-content{border-color:' . $color . '}' . "\n";
				  break;
				case 'color_latest_news_widget_button':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_latest_news .custom-button{color:' . $color . '}' . "\n";
				  break;
				case 'color_latest_news_widget_button_hover':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_latest_news .custom-button:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_latest_news_widget_button_background':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_latest_news .custom-button{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_latest_news_widget_button_background_hover':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_latest_news .custom-button:hover{background-color:' . $color . '}' . "\n";
				  break;

				// Specific widget Portfolio Widget.
				case 'color_portfolio_widget_background':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_portfolio_slider{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_portfolio_main_widget_title':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_portfolio_slider .widget-title{color:' . $color . '}' . "\n";
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_portfolio_slider .separator{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_portfolio_main_widget_subtitle':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_portfolio_slider .widget-subtitle{color:' . $color . '}' . "\n";
				  break;
				case 'color_portfolio_main_widget_separator':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_portfolio_slider .separator::after,
				  #sidebar-front-page-widget-area .bizroot_widget_portfolio_slider .separator::before{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_portfolio_widget_title':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_portfolio_slider .portfolio-content > h3 a{color:' . $color . '}' . "\n";
				  break;
				case 'color_portfolio_widget_title_hover':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_portfolio_slider  .portfolio-content > h3 a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_portfolio_widget_text':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_portfolio_slider  .portfolio-content{color:' . $color . '}' . "\n";
				  break;
				case 'color_portfolio_widget_link':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_portfolio_slider .portfolio-meta a,#sidebar-front-page-widget-area .bizroot_widget_portfolio_slider .portfolio-excerpt a{color:' . $color . '}' . "\n";
				  break;
				case 'color_portfolio_widget_link_hover':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_portfolio_slider .portfolio-meta a:hover,#sidebar-front-page-widget-area .bizroot_widget_portfolio_slider  .portfolio-excerpt a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_portfolio_category_background':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_portfolio_slider .portfolio-category-list,#sidebar-front-page-widget-area .bizroot_widget_portfolio_slider .portfolio-content{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_portfolio_category_link':
				  $custom_css .= '#sidebar-front-page-widget-area  .bizroot_widget_portfolio_slider .portfolio-category-list li a{color:' . $color . '}' . "\n";
				  break;
				case 'color_portfolio_category_link_hover':
				  $custom_css .= '#sidebar-front-page-widget-area  .bizroot_widget_portfolio_slider .portfolio-category-list li a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_portfolio_category_link_background_hover':
				  $custom_css .= '#sidebar-front-page-widget-area  .bizroot_widget_portfolio_slider .portfolio-category-list li a:hover{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_portfolio_arrow':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_portfolio_slider .cycle-prev, #sidebar-front-page-widget-area .bizroot_widget_portfolio_slider .cycle-next{color:' . $color . '}' . "\n";
				  break;
				case 'color_portfolio_arrow_hover':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_portfolio_slider .cycle-prev:hover, #sidebar-front-page-widget-area .bizroot_widget_portfolio_slider .cycle-next:hover{color:' . $color . '}' . "\n";
				 break;
				case 'color_portfolio_arrow_background':
			     $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_portfolio_slider .cycle-prev, #sidebar-front-page-widget-area .bizroot_widget_portfolio_slider .cycle-next{background-color:' . $color . '}' . "\n";
			     $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_portfolio_slider .cycle-prev, #sidebar-front-page-widget-area .bizroot_widget_portfolio_slider .cycle-next{border-color:' . $color . '}' . "\n";
				  break;
				case 'color_portfolio_arrow_background_hover':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_portfolio_slider .cycle-prev:hover, #sidebar-front-page-widget-area .bizroot_widget_portfolio_slider .cycle-next:hover{background-color:' . $color . '}' . "\n";
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_portfolio_slider .cycle-prev:hover, #sidebar-front-page-widget-area .bizroot_widget_portfolio_slider .cycle-next:hover{border-color:' . $color . '}' . "\n";
				  break;

				// Specific widget Testimonial .
				case 'color_testimonial_widget_background':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_testimonials,#sidebar-front-page-widget-area .overlay-enabled.bizroot_widget_testimonial_slider::before{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_testimonial_main_widget_title':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_testimonials .widget-title {color:' . $color . '}' . "\n";
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_testimonials .separator {background-color:' . $color . '}' . "\n";
				  break;
				case 'color_testimonial_main_widget_subtitle':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_testimonials .widget-subtitle{color:' . $color . '}' . "\n";
				  break;
				case 'color_testimonial_main_widget_separator':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_testimonial_slider .separator::before, #sidebar-front-page-widget-area .bizroot_widget_testimonial_slider .separator::after{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_testimonial_widget_content':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_testimonial_slider .testimonial-excerpt,
				  #sidebar-front-page-widget-area .bizroot_widget_testimonial_slider .testimonial-content-area p::before,#sidebar-front-page-widget-area .bizroot_widget_testimonial_slider .testimonial-content-area > h4{color:' . $color . '}' . "\n";
				  break;
				case 'color_testimonial_pager':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_testimonial_slider .cycle-pager span img{border-color:' . $color . '}' . "\n";
				  break;
				case 'color_testimonial_widget_pager_active':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_testimonial_slider .cycle-pager span.cycle-pager-active img,#sidebar-front-page-widget-area .bizroot_widget_testimonial_slider .cycle-pager span:hover img {border-color:' . $color . '}' . "\n";
				  break;

				// Specific widget Team.
				case 'color_team_widget_background':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_teams{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_team_main_widget_title':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_teams .widget-title {color:' . $color . '}' . "\n";
				   $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_teams .separator {background-color:' . $color . '}' . "\n";
				  break;
				case 'color_team_main_widget_subtitle':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_teams .widget-subtitle {color:' . $color . '}' . "\n";
				  break;
				case 'color_team_main_widget_separator':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_teams .separator::after,#sidebar-front-page-widget-area .bizroot_widget_teams .separator::before {background-color:' . $color . '}' . "\n";
				  break;
				case 'color_team_widget_title':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_teams .team-title a{color:' . $color . '}' . "\n";
				  break;
				case 'color_team_widget_title_hover':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_teams .team-title a:hover{color:' . $color . '}' . "\n";
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_teams .team-item:hover img{border-color:' . $color . '}' . "\n";
				  break;

				case 'color_team_widget_content':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_team .our-team-summary{color:' . $color . '}' . "\n";
				  break;

				// Specific widget skills.
				case 'color_skills_widget_background':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_skills{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_skills_main_widget_title':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_skills .widget-title{color:' . $color . '}' . "\n";
				   $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_skills .separator{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_skills_main_widget_subtitle':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_skills .widget-subtitle{color:' . $color . '}' . "\n";
				  break;
				case 'color_skills_main_widget_separator':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_skills .separator::after,#sidebar-front-page-widget-area .bizroot_widget_skills .separator::before{background-color:' . $color . '}' . "\n";
				  break;

				// Specific widget clients.
				case 'color_clients_widget_background':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_clients{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_clients_main_widget_title':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_clients .widget-title {color:' . $color . '}' . "\n";
				 $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_clients .separator {background-color:' . $color . '}' . "\n";
				  break;
				case 'color_clients_main_widget_subtitle':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_clients .widget-subtitle{color:' . $color . '}' . "\n";
				  break;
				case 'color_clients_main_widget_separator':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_clients .separator::before,#sidebar-front-page-widget-area .bizroot_widget_clients .separator::after{background-color:' . $color . '}' . "\n";
				  break;

				// Specific widget Service.
				case 'color_service_widget_background':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_services .widget{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_service_main_widget_title':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_services .widget-title {color:' . $color . '}' . "\n";
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_services .separator{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_service_main_widget_subtitle':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_services .widget-subtitle{color:' . $color . '}' . "\n";
				  break;
				case 'color_service_main_widget_separator':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_services .separator::after,#sidebar-front-page-widget-area .bizroot_widget_services .separator::before{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_service_widget_title':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_services .service-item-title a{color:' . $color . '}' . "\n";
				  break;
				case 'color_service_widget_title_hover':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_services .service-item-title a:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_service_widget_text':
				  $custom_css .= '.bizroot_widget_services .service-block-item {color:' . $color . '}' . "\n";
				  break;
				case 'color_service_widget_button':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_services .service-block-item .custom-button,#sidebar-front-page-widget-area .bizroot_widget_services .service-block-item i{color:' . $color . '}' . "\n";
				  break;
				case 'color_service_widget_button_hover':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_services .service-block-item .custom-button:hover,#sidebar-front-page-widget-area .bizroot_widget_services .service-block-item a:hover i{color:' . $color . '}' . "\n";
				  break;
				case 'color_service_widget_button_background':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_services .service-block-item .custom-button,#sidebar-front-page-widget-area .bizroot_widget_services .service-block-item  i{background-color:' . $color . '}' . "\n";
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_services .service-block-item a i,#sidebar-front-page-widget-area .bizroot_widget_services .service-block-item .custom-button{border-color:' . $color . '}' . "\n";
				  break;
				case 'color_service_widget_button_background_hover':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_services .service-block-item .custom-button:hover,#sidebar-front-page-widget-area .bizroot_widget_services .service-block-item a:hover i{background-color:' . $color . '}' . "\n";
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_services .service-block-item a:hover i,#sidebar-front-page-widget-area .bizroot_widget_services .service-block-item .custom-button:hover{border-color:' . $color . '}' . "\n";
				  break;

				// Specific widget pricing table.
				case 'color_pricing_table_widget_background':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_pricing_table{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_pricing_table_main_widget_title':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_pricing_table .widget-title{color:' . $color . '}' . "\n";
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_pricing_table .separator{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_pricing_table_main_widget_subtitle':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_pricing_table .widget-subtitle{color:' . $color . '}' . "\n";
				  break;
				case 'color_pricing_table_main_widget_separator':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_pricing_table .separator::before,#sidebar-front-page-widget-area .bizroot_widget_pricing_table .separator::after{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_pricing_table_widget_title':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_pricing_table .pricing-plan-header .pricing-plan-title h4,#sidebar-front-page-widget-area .bizroot_widget_pricing_table .pricing-plan-header{color:' . $color . '}' . "\n";
				  break;
				case 'color_pricing_table_widget_text':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_pricing_table .pricing-plan-item{color:' . $color . '}' . "\n";
				  break;
				case 'color_pricing_table_widget_text_dimmed':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_pricing_table .pricing-plan-feature.pricing-plan-feature-dim{color:' . $color . '}' . "\n";
				  break;
				case 'color_pricing_table_widget_button':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_pricing_table a.custom-button{color:' . $color . '}' . "\n";
				  break;
				case 'color_pricing_table_widget_content_background':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_pricing_table .pricing-plan-item{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_pricing_table_widget_button_hover':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_pricing_table a.custom-button:hover{color:' . $color . '}' . "\n";
				  break;
				case 'color_pricing_table_widget_button_background':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_pricing_table a.custom-button,#sidebar-front-page-widget-area .bizroot_widget_pricing_table .pricing-plan-header::after,#sidebar-front-page-widget-area .bizroot_widget_pricing_table .pricing-plan-header .pricing-plan-title h4{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_pricing_table_widget_button_background_hover':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_pricing_table a.custom-button:hover{background-color:' . $color . '}' . "\n";
				  break;
				case 'color_pricing_table_featured':
				  $custom_css .= '#sidebar-front-page-widget-area .bizroot_widget_pricing_table .pricing-plan-recommended .pricing-plan-header::after,#sidebar-front-page-widget-area .bizroot_widget_pricing_table .pricing-plan-recommended .pricing-plan-title h4{background-color:' . $color . '}' . "\n";
				  break;

			  default:
			    break;

			}

		}

		// Render style.
		if ( ! empty( $custom_css ) ) {
		  echo '<style type="text/css">';
		  echo $custom_css;
		  echo '</style>';
		}

	}

endif;

add_action( 'bizroot_action_theme_custom_css', 'bizroot_add_theme_custom_color_css', 25 );
