<?php
/**
 * Jetpack Compatibility File.
 *
 * @link https://jetpack.me/
 *
 * @package Bizroot
 */

/**
 * Add theme support for Jetpack.
 *
 * @since 1.0.0
 */
function bizroot_jetpack_setup() {
	$pagination_type = bizroot_get_option( 'pagination_type' );
	if ( in_array( $pagination_type, array( 'infinite-scroll-click', 'infinite-scroll' ) ) ) {
		$type = ( 'infinite-scroll-click' === $pagination_type ) ? 'click' : 'scroll' ;
		add_theme_support( 'infinite-scroll', array(
			'type'           => $type,
			'container'      => 'main',
			'footer'         => 'page',
			'wrapper'        => false,
			'render'         => 'bizroot_infinite_scroll_render',
			'footer_widgets' => array( 'footer-1', 'footer-2', 'footer-3', 'footer-4' )
		) );
	}
	// Add theme support for Responsive Videos.
	add_theme_support( 'jetpack-responsive-videos' );
	// Add theme support for Jetpack Portfolios.
	add_theme_support( 'jetpack-portfolio' );
	// Add theme support for Jetpack Testimonials.
	add_theme_support( 'jetpack-testimonial' );
}
add_action( 'after_setup_theme', 'bizroot_jetpack_setup' );

/**
 * Custom render function for Infinite Scroll.
 *
 * @since 1.0.0
 */
function bizroot_infinite_scroll_render() {
	while ( have_posts() ) {
		the_post();
		if ( is_search() ) :
		    get_template_part( 'template-parts/content', 'search' );
		else :
		    get_template_part( 'template-parts/content', get_post_format() );
		endif;
	}
}

if ( ! function_exists( 'bizroot_custom_page_title_for_jetpack' ) ) :

	/**
	 * Custom title in Custom Header for Jetpack.
	 *
	 * @since 1.0.0
	 *
	 * @param string $title Title.
	 * @return string Modified title.
	 */
	function bizroot_custom_page_title_for_jetpack( $title ) {

		if ( is_post_type_archive( 'jetpack-testimonial' ) ) {
			$jetpack_options = get_theme_mod( 'jetpack_testimonials' );
			if ( isset( $jetpack_options['page-title'] ) && ! empty( $jetpack_options['page-title'] ) ) {
				$title = $jetpack_options['page-title'];
			}
		} else if ( is_post_type_archive( 'jetpack-portfolio' ) ) {
			$title = __( 'Projects', 'bizroot-pro' );
		}
		return $title;
	}

endif;

add_filter( 'bizroot_filter_custom_page_title', 'bizroot_custom_page_title_for_jetpack', 20 );

if ( ! function_exists( 'bizroot_custom_supported_infinite_scroll' ) ) :

	/**
	 * Custom supported infinite scroll.
	 *
	 * @since 1.0.0
	 *
	 * @param string $input Active status.
	 * @return string Modified active status.
	 */
	function bizroot_custom_supported_infinite_scroll( $input ) {

		$val = false;
		if ( is_home() || is_category() || is_tag() || is_author() || is_date() ) {
			$val = true;
		}
		return $val;

	}
endif;

add_filter( 'infinite_scroll_archive_supported', 'bizroot_custom_supported_infinite_scroll' );

if ( ! function_exists( 'bizroot_custom_banner_image_for_jetpack_testimonial' ) ) :

	/**
	 * Custom image for Jetpack testimonial.
	 *
	 * @since 1.0.0
	 *
	 * @param string $attribute Style attribute.
	 * @return string Modified Style attribute.
	 */
	function bizroot_custom_banner_image_for_jetpack_testimonial( $attribute ) {

		if ( is_post_type_archive( 'jetpack-testimonial' ) ) {
			$jetpack_options = get_theme_mod( 'jetpack_testimonials' );
			if ( isset( $jetpack_options['featured-image'] ) && absint( $jetpack_options['featured-image'] ) > 0 ) {
				$image_id = absint( $jetpack_options['featured-image'] );
				$image_details = wp_get_attachment_image_src( $image_id, 'bizroot-featured-banner' );
				if ( ! empty( $image_details ) ) {
					$attribute .= 'background-image:url(' . esc_url( $image_details[0] ) . ');';
					$attribute .= 'background-size:cover;';
				}
			}
		}

		return $attribute;
	}

endif;

add_filter( 'bizroot_filter_custom_header_style_attribute', 'bizroot_custom_banner_image_for_jetpack_testimonial', 20 );
