<?php
/**
 * Easy Digital Downloads Theme Updater
 *
 * @package Bizroot
 */

// Includes the files needed for the theme updater
if ( ! class_exists( 'EDD_Theme_Updater_Admin' ) ) {
	include dirname( __FILE__ ) . '/theme-updater-admin.php';
}

$theme = wp_get_theme( get_template() );

// Loads the updater classes
$updater = new EDD_Theme_Updater_Admin(
	// Config settings
	array(
		'remote_api_url' => 'https://themepalace.com', // Site where EDD is hosted
		'item_name'      => $theme->get( 'Name' ), // Name of theme
		'theme_slug'     => $theme->get( 'TextDomain' ), // Theme slug
		'version'        => $theme->get( 'Version' ), // The current version of this theme
		'author'         => $theme->get( 'Author' ), // The author of this theme
		'download_id'    => '', // Optional, used for generating a license renewal link
		'renew_url'      => 'https://themepalace.com/my-account/', // Optional, allows for a custom license renewal link
		'beta'           => false, // Optional, set to true to opt into beta versions
		'item_id'        => '',
	),
	// Strings
	array(
		'theme-license'             => __( 'Theme License', 'bizroot-pro' ),
		'enter-key'                 => __( 'Enter your theme license key.', 'bizroot-pro' ),
		'license-key'               => __( 'License Key', 'bizroot-pro' ),
		'license-action'            => __( 'License Action', 'bizroot-pro' ),
		'deactivate-license'        => __( 'Deactivate License', 'bizroot-pro' ),
		'activate-license'          => __( 'Activate License', 'bizroot-pro' ),
		'status-unknown'            => __( 'License status is unknown.', 'bizroot-pro' ),
		'renew'                     => __( 'Renew?', 'bizroot-pro' ),
		'unlimited'                 => __( 'unlimited', 'bizroot-pro' ),
		'license-key-is-active'     => __( 'License key is active.', 'bizroot-pro' ),
		/* translators: the license expiration date */
		'expires%s'                 => __( 'Expires %s.', 'bizroot-pro' ),
		'expires-never'             => __( 'Lifetime License.', 'bizroot-pro' ),
		/* translators: 1. the number of sites activated 2. the total number of activations allowed. */
		'%1$s/%2$-sites'            => __( 'You have %1$s / %2$s sites activated.', 'bizroot-pro' ),
		'activation-limit'          => __( 'Your license key has reached its activation limit.', 'bizroot-pro' ),
		/* translators: the license expiration date */
		'license-key-expired-%s'    => __( 'License key expired %s.', 'bizroot-pro' ),
		'license-key-expired'       => __( 'License key has expired.', 'bizroot-pro' ),
		/* translators: the license expiration date */
		'license-expired-on'        => __( 'Your license key expired on %s.', 'bizroot-pro' ),
		'license-keys-do-not-match' => __( 'License keys do not match.', 'bizroot-pro' ),
		'license-is-inactive'       => __( 'License is inactive.', 'bizroot-pro' ),
		'license-key-is-disabled'   => __( 'License key is disabled.', 'bizroot-pro' ),
		'license-key-invalid'       => __( 'Invalid license.', 'bizroot-pro' ),
		'site-is-inactive'          => __( 'Site is inactive.', 'bizroot-pro' ),
		/* translators: the theme name */
		'item-mismatch'             => __( 'This appears to be an invalid license key for %s.', 'bizroot-pro' ),
		'license-status-unknown'    => __( 'License status is unknown.', 'bizroot-pro' ),
		'update-notice'             => __( "Updating this theme will lose any customizations you have made. 'Cancel' to stop, 'OK' to update.", 'bizroot-pro' ),
		'error-generic'             => __( 'An error occurred, please try again.', 'bizroot-pro' ),
	)
);
