<?php
/**
 * Class for Demo Import
 *
 * @package Busyness
 */

/**
 * Demo Import class.
 *
 * @since 1.1
 */
class Busyness_Demo_Import {

	function __construct() {
		add_filter( 'cp-ctdi/import_files', array( $this, 'import_files' ) );
		add_action( 'cp-ctdi/after_import', array( $this, 'after_import_setup' ) );
	}
	function import_files() {
		return array(
			array(
				'import_file_name'           => esc_html__( 'Busyness Pro Demo', 'busyness-pro' ),
				'import_file_url'            => get_template_directory_uri() . '/inc/ctdi/busyness-pro.xml',
				'import_widget_file_url'     => get_template_directory_uri() . '/inc/ctdi/busyness-pro.wie',
				'import_customizer_file_url' => get_template_directory_uri() . '/inc/ctdi/busyness-pro.dat',
				'import_preview_image_url'   => get_template_directory_uri() . '/screenshot.png',
				'preview_url'                => 'https://wenthemes.com/item/wordpress-themes/busyness-pro/',
			),
		);
	}

	function after_import_setup() {
		// Assign menus to their locations.
		$main_menu = get_term_by( 'name', 'Header Menu', 'nav_menu' );
		$social = get_term_by('name', 'Social Menu', 'nav_menu');

	    set_theme_mod( 'nav_menu_locations', array(
	            'primary' => $main_menu->term_id,
	            'social' => $social->term_id,
	        )
	    );
		// Assign front page and posts page (blog page).
		$front_page_id = get_page_by_title( 'Home' );
		$blog_page_id  = get_page_by_title( 'Blog' );

		update_option( 'show_on_front', 'page' );
		update_option( 'page_on_front', $front_page_id->ID );
		update_option( 'page_for_posts', $blog_page_id->ID );
	}
}

// Initialize.
$Busyness_ctdi = new Busyness_Demo_Import();
