<?php
/**
 * Customizer active callbacks
 *
 * @package Busyness
 */

if ( ! function_exists( 'busyness_is_loader_enable' ) ) :
	/**
	 * Check if loader is enabled.
	 *
	 * @since Busyness Pro 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function busyness_is_loader_enable( $control ) {
		return $control->manager->get_setting( 'busyness_theme_options[loader_enable]' )->value();
	}
endif;

if ( ! function_exists( 'busyness_is_breadcrumb_enable' ) ) :
	/**
	 * Check if breadcrumb is enabled.
	 *
	 * @since Busyness Pro 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function busyness_is_breadcrumb_enable( $control ) {
		return $control->manager->get_setting( 'busyness_theme_options[breadcrumb_enable]' )->value();
	}
endif;

if ( ! function_exists( 'busyness_is_pagination_enable' ) ) :
	/**
	 * Check if pagination is enabled.
	 *
	 * @since Busyness Pro 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function busyness_is_pagination_enable( $control ) {
		return $control->manager->get_setting( 'busyness_theme_options[pagination_enable]' )->value();
	}
endif;

/**
 * Front Page Active Callbacks
 */

/**
 * Check if login_register_meta section is enabled.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_login_register_meta_section_enable( $control ) {
	return ( $control->manager->get_setting( 'busyness_theme_options[topbar_login_register_enable]' )->value() );
}

/**
 * Check if slider section is enabled.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_slider_section_enable( $control ) {
	return ( $control->manager->get_setting( 'busyness_theme_options[slider_section_enable]' )->value() );
}

/**
 * Check if slider section content type is category.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_slider_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[slider_content_type]' )->value();
	return busyness_is_slider_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if slider section content type is page.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_slider_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[slider_content_type]' )->value();
	return busyness_is_slider_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if slider section content type is post.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_slider_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[slider_content_type]' )->value();
	return busyness_is_slider_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if service section is enabled.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_service_section_enable( $control ) {
	return ( $control->manager->get_setting( 'busyness_theme_options[service_section_enable]' )->value() );
}

/**
 * Check if service section content type is post.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_service_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[service_content_type]' )->value();
	return busyness_is_service_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if service section seperator.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_service_section_content_seperator_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[service_content_type]' )->value();
	return busyness_is_service_section_enable( $control ) && ( in_array( $content_type, array( 'page', 'post' ) ) );
}

/**
 * Check if service section content type is page.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_service_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[service_content_type]' )->value();
	return busyness_is_service_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if service section content type is category.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_service_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[service_content_type]' )->value();
	return busyness_is_service_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if about section is enabled.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_about_section_enable( $control ) {
	return ( $control->manager->get_setting( 'busyness_theme_options[about_section_enable]' )->value() );
}

/**
 * Check if about section content type is post.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_about_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[about_content_type]' )->value();
	return busyness_is_about_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if about section seperator.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_about_section_content_seperator_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[about_content_type]' )->value();
	return busyness_is_about_section_enable( $control ) && ( in_array( $content_type, array( 'page', 'post' ) ) );
}

/**
 * Check if about section content type is page.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_about_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[about_content_type]' )->value();
	return busyness_is_about_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if about section content type is category.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_about_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[about_content_type]' )->value();
	return busyness_is_about_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if video section is enabled.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_video_section_enable( $control ) {
	return ( $control->manager->get_setting( 'busyness_theme_options[video_section_enable]' )->value() );
}

/**
 * Check if video section content type is post.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_video_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[video_content_type]' )->value();
	return busyness_is_video_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if video section content type is page.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_video_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[video_content_type]' )->value();
	return busyness_is_video_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if video section content type is custom.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_video_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[video_content_type]' )->value();
	return busyness_is_video_section_enable( $control ) && ( 'custom' == $content_type );
}

/**
 * Check if feature section is enabled.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_feature_section_enable( $control ) {
	return ( $control->manager->get_setting( 'busyness_theme_options[feature_section_enable]' )->value() );
}

/**
 * Check if feature section content type is category.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_feature_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[feature_content_type]' )->value();
	return busyness_is_feature_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if feature section content type is page.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_feature_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[feature_content_type]' )->value();
	return busyness_is_feature_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if feature section content type is post.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_feature_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[feature_content_type]' )->value();
	return busyness_is_feature_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if feature section content type is custom.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_feature_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[feature_content_type]' )->value();
	return busyness_is_feature_section_enable( $control ) && ( 'custom' == $content_type );
}


/**
 * Check if portfolio section is enabled.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_portfolio_section_enable( $control ) {
	return ( $control->manager->get_setting( 'busyness_theme_options[portfolio_section_enable]' )->value() );
}

/**
 * Check if portfolio section content type is category.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_portfolio_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[portfolio_content_type]' )->value();
	return busyness_is_portfolio_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if portfolio section content type is page.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_portfolio_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[portfolio_content_type]' )->value();
	return busyness_is_portfolio_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if portfolio section content type is post.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_portfolio_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[portfolio_content_type]' )->value();
	return busyness_is_portfolio_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if team section is enabled.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_team_section_enable( $control ) {
	return ( $control->manager->get_setting( 'busyness_theme_options[team_section_enable]' )->value() );
}

/**
 * Check if team section content type is post.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_team_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[team_content_type]' )->value();
	return busyness_is_team_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if team section content type is page.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_team_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[team_content_type]' )->value();
	return busyness_is_team_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if team section content type is category.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_team_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[team_content_type]' )->value();
	return busyness_is_team_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if team section content type is custom.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_team_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[team_content_type]' )->value();
	return busyness_is_team_section_enable( $control ) && ( 'custom' == $content_type );
}

/**
 * Check if client section is enabled.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_client_section_enable( $control ) {
	return ( $control->manager->get_setting( 'busyness_theme_options[client_section_enable]' )->value() );
}


/**
 * Check if blog section is enabled.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_blog_section_enable( $control ) {
	return ( $control->manager->get_setting( 'busyness_theme_options[blog_section_enable]' )->value() );
}

/**
 * Check if blog section content type is post.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_blog_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[blog_content_type]' )->value();
	return busyness_is_blog_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if blog section content type is page.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_blog_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[blog_content_type]' )->value();
	return busyness_is_blog_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if blog section content type is category.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_blog_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[blog_content_type]' )->value();
	return busyness_is_blog_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if blog section content type is recent.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_blog_section_content_recent_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[blog_content_type]' )->value();
	return busyness_is_blog_section_enable( $control ) && ( 'recent' == $content_type );
}

/**
 * Check if counter section is enabled.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_counter_section_enable( $control ) {
	return ( $control->manager->get_setting( 'busyness_theme_options[counter_section_enable]' )->value() );
}

/**
 * Check if cta section is enabled.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_cta_section_enable( $control ) {
	return ( $control->manager->get_setting( 'busyness_theme_options[cta_section_enable]' )->value() );
}

/**
 * Check if cta section content type is post.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_cta_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[cta_content_type]' )->value();
	return busyness_is_cta_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if cta section content type is page.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_cta_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[cta_content_type]' )->value();
	return busyness_is_cta_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if cta section content type is custom.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_cta_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[cta_content_type]' )->value();
	return busyness_is_cta_section_enable( $control ) && ( 'custom' == $content_type );
}

/**
 * Check if testimonial section is enabled.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_testimonial_section_enable( $control ) {
	return ( $control->manager->get_setting( 'busyness_theme_options[testimonial_section_enable]' )->value() );
}

/**
 * Check if testimonial section seperator.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_testimonial_section_content_seperator_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[testimonial_content_type]' )->value();
	return busyness_is_testimonial_section_enable( $control ) && ( 'category' !== $content_type );
}

/**
 * Check if testimonial section content type is post.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_testimonial_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[testimonial_content_type]' )->value();
	return busyness_is_testimonial_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if testimonial section content type is page.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_testimonial_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[testimonial_content_type]' )->value();
	return busyness_is_testimonial_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if testimonial section content type is category.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_testimonial_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[testimonial_content_type]' )->value();
	return busyness_is_testimonial_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if testimonial section content type is position.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_testimonial_section_content_position_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[testimonial_content_type]' )->value();
	return busyness_is_testimonial_section_enable( $control ) && ( 'category' !== $content_type );
}

/**
 * Check if testimonial section content type is custom.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_testimonial_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[testimonial_content_type]' )->value();
	return busyness_is_testimonial_section_enable( $control ) && ( 'custom' == $content_type );
}

/**
 * Check if pricing section is enabled.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_pricing_section_enable( $control ) {
	return ( $control->manager->get_setting( 'busyness_theme_options[pricing_section_enable]' )->value() );
}

/**
 * Check if promotion section is enabled.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_promotion_section_enable( $control ) {
	return ( $control->manager->get_setting( 'busyness_theme_options[promotion_section_enable]' )->value() );
}

/**
 * Check if promotion section content type is post.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_promotion_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[promotion_content_type]' )->value();
	return busyness_is_promotion_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if promotion section content type is page.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_promotion_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[promotion_content_type]' )->value();
	return busyness_is_promotion_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if promotion section content type is custom.
 *
 * @since Busyness Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function busyness_is_promotion_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'busyness_theme_options[promotion_content_type]' )->value();
	return busyness_is_promotion_section_enable( $control ) && ( 'custom' == $content_type );
}