<?php
/**
 * Busyness Pro Customizer.
 *
 * @package Busyness
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function busyness_customize_register( $wp_customize ) {
	$options = busyness_get_theme_options();

	// Load custom control functions.
	require get_template_directory() . '/inc/customizer/custom-controls.php';

	// Load customize active callback functions.
	require get_template_directory() . '/inc/customizer/active-callback.php';

	// Load partial callback functions.
	require get_template_directory() . '/inc/customizer/partial.php';

	// Load validation callback functions.
	require get_template_directory() . '/inc/customizer/validation.php';

	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport  = 'postMessage';

	// Remove the core header textcolor control, as it shares the main text color.
	$wp_customize->remove_control( 'header_textcolor' );

	// Header title color setting and control.
	$wp_customize->add_setting( 'busyness_theme_options[header_title_color]', array(
		'default'           => $options['header_title_color'],
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'			=> 'postMessage'
	) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'busyness_theme_options[header_title_color]', array(
		'priority'			=> 5,
		'label'             => esc_html__( 'Header Title Color', 'busyness-pro' ),
		'section'           => 'colors',
	) ) );

	// Header tagline color setting and control.
	$wp_customize->add_setting( 'busyness_theme_options[header_tagline_color]', array(
		'default'           => $options['header_tagline_color'],
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'			=> 'postMessage'
	) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'busyness_theme_options[header_tagline_color]', array(
		'priority'			=> 6,
		'label'             => esc_html__( 'Header Tagline Color', 'busyness-pro' ),
		'section'           => 'colors',
	) ) );

	// Site identity extra options.
	$wp_customize->add_setting( 'busyness_theme_options[header_txt_logo_extra]', array(
		'default'           => $options['header_txt_logo_extra'],
		'sanitize_callback' => 'busyness_sanitize_select',
		'transport'			=> 'refresh'
	) );

	$wp_customize->add_control( 'busyness_theme_options[header_txt_logo_extra]', array(
		'priority'			=> 50,
		'type'				=> 'radio',
		'label'             => esc_html__( 'Site Identity Extra Options', 'busyness-pro' ),
		'section'           => 'title_tagline',
		'choices'				=> array(
			'hide-all'     => esc_html__( 'Hide All', 'busyness-pro' ),
			'show-all'     => esc_html__( 'Show All', 'busyness-pro' ),
			'title-only'   => esc_html__( 'Title Only', 'busyness-pro' ),
			'tagline-only' => esc_html__( 'Tagline Only', 'busyness-pro' ),
			'logo-title'   => esc_html__( 'Logo + Title', 'busyness-pro' ),
			'logo-tagline' => esc_html__( 'Logo + Tagline', 'busyness-pro' ),
			)
	) );

	$wp_customize->add_setting( 'busyness_theme_options[theme_version]', array(
		'default'           => $options['theme_version'],
		'sanitize_callback' => 'busyness_sanitize_select',
	) );

	$wp_customize->add_control( 'busyness_theme_options[theme_version]', array(
		'type'    => 'radio',
		'label'    => esc_html__( 'Theme Version', 'busyness-pro' ),
		'choices'  => array(
			'lite-version'      => esc_html__( 'Lite Version', 'busyness-pro' ),
			'dark-version'      => esc_html__( 'Dark Version', 'busyness-pro' ),
			'knowledge-version' => esc_html__( 'Knowledge Version', 'busyness-pro' ),
		),
		'section'  => 'colors',
	) );

	/**
	 * Custom colors.
	 */
	$wp_customize->add_setting( 'busyness_theme_options[colorscheme]', array(
		'default'           => $options['colorscheme'],
		'sanitize_callback' => 'busyness_sanitize_select',
	) );

	$wp_customize->add_control( 'busyness_theme_options[colorscheme]', array(
		'type'    => 'radio',
		'label'    => esc_html__( 'Color Scheme', 'busyness-pro' ),
		'choices'  => array(
            'default'   => esc_html__( 'Default', 'busyness-pro' ),
            'blue'      => esc_html__( 'Blue', 'busyness-pro' ),
            'green'     => esc_html__( 'Green', 'busyness-pro' ),
            'red'       => esc_html__( 'Red', 'busyness-pro' ),
            'yellow'    => esc_html__( 'Yellow', 'busyness-pro' ),
            'custom'    => esc_html__( 'Custom', 'busyness-pro' ),
		),
		'section'  => 'colors',
	) );

	$wp_customize->add_setting( 'busyness_theme_options[colorscheme_hue]', array(
		'default'           => $options['colorscheme_hue'],
		'sanitize_callback' => 'sanitize_hex_color', // The hue is stored as a positive integer.
	) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'busyness_theme_options[colorscheme_hue]', array(
		'label'    => esc_html__( 'Primary Color', 'busyness-pro' ),
		'section'  => 'colors',
	) ) );

	$wp_customize->add_setting( 'busyness_theme_options[secondary_colorscheme_hue]', array(
		'default'           => $options['secondary_colorscheme_hue'],
		'sanitize_callback' => 'sanitize_hex_color', // The hue is stored as a positive integer.
	) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'busyness_theme_options[secondary_colorscheme_hue]', array(
		'label'    => esc_html__( 'Secondary Color', 'busyness-pro' ),
		'section'  => 'colors',
	) ) );

	// Add panel for common theme options
	$wp_customize->add_panel( 'busyness_theme_options_panel' , array(
	    'title'      => esc_html__( 'Theme Options','busyness-pro' ),
	    'description'=> esc_html__( 'Busyness Pro Theme Options.', 'busyness-pro' ),
	    'priority'   => 150,
	) );

	// homepage sortable
	require get_template_directory() . '/inc/customizer/theme-options/sortable.php';

	// loader
	require get_template_directory() . '/inc/customizer/theme-options/loader.php';

	// Header
	require get_template_directory() . '/inc/customizer/theme-options/header.php';

	// breadcrumb
	require get_template_directory() . '/inc/customizer/theme-options/breadcrumb.php';

	// typography
	require get_template_directory() . '/inc/customizer/theme-options/typography.php';

	// load layout
	require get_template_directory() . '/inc/customizer/theme-options/layout.php';

	// load static homepage option
	require get_template_directory() . '/inc/customizer/theme-options/homepage-static.php';

	// load archive option
	require get_template_directory() . '/inc/customizer/theme-options/excerpt.php';

	// load archive option
	require get_template_directory() . '/inc/customizer/theme-options/archive.php';

	// load single post option
	require get_template_directory() . '/inc/customizer/theme-options/single-posts.php';

	// load pagination option
	require get_template_directory() . '/inc/customizer/theme-options/pagination.php';

	// load footer option
	require get_template_directory() . '/inc/customizer/theme-options/footer.php';

	// load reset option
	require get_template_directory() . '/inc/customizer/theme-options/reset.php';

	// Add panel for front page theme options.
	$wp_customize->add_panel( 'busyness_home_page_panel' , array(
	    'title'      => esc_html__( 'Homepage Sections','busyness-pro' ),
	    'description'=> esc_html__( 'Homepage Theme Options.', 'busyness-pro' ),
	    'priority'   => 140,
	) );

	// load slider option
	require get_template_directory() . '/inc/customizer/sections/slider.php';

	// load service option
	require get_template_directory() . '/inc/customizer/sections/service.php';

	// load about option
	require get_template_directory() . '/inc/customizer/sections/about.php';

	// load video option
	require get_template_directory() . '/inc/customizer/sections/video.php';



	// load portfolio option
	require get_template_directory() . '/inc/customizer/sections/portfolio.php';

	// load team option
	require get_template_directory() . '/inc/customizer/sections/team.php';

	// load counter option
	require get_template_directory() . '/inc/customizer/sections/counter.php';

	// load testimonial option
	require get_template_directory() . '/inc/customizer/sections/testimonial.php';

	// load cta option
	require get_template_directory() . '/inc/customizer/sections/cta.php';

	// load feature option
	require get_template_directory() . '/inc/customizer/sections/feature.php';

	// load blog option
	require get_template_directory() . '/inc/customizer/sections/blog.php';

	// load pricing option
	require get_template_directory() . '/inc/customizer/sections/pricing.php';

	// load promotion option
	require get_template_directory() . '/inc/customizer/sections/promotion.php';

	// load client option
	require get_template_directory() . '/inc/customizer/sections/client.php';


}
add_action( 'customize_register', 'busyness_customize_register' );

/*
 * Load customizer sanitization functions.
 */
require get_template_directory() . '/inc/customizer/sanitize.php';

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function busyness_customize_preview_js() {
	wp_enqueue_script( 'busyness-pro-customizer', get_template_directory_uri() . '/assets/js/customizer' . busyness_min() . '.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'busyness_customize_preview_js' );

/**
 * Load dynamic logic for the customizer controls area.
 */
function busyness_customize_control_js() {
	// fontawesome
	wp_enqueue_style( 'font-awesome-css', get_template_directory_uri() . '/assets/css/font-awesome' . busyness_min() . '.css' );

	// Choose from select jquery.
	wp_enqueue_style( 'chosen-css', get_template_directory_uri() . '/assets/css/chosen' . busyness_min() . '.css' );
	wp_enqueue_script( 'jquery-chosen', get_template_directory_uri() . '/assets/js/chosen.jquery' . busyness_min() . '.js', array( 'jquery' ), '1.4.2', true );

	// simple icon picker
	wp_enqueue_style( 'simple-iconpicker-css', get_template_directory_uri() . '/assets/css/simple-iconpicker' . busyness_min() . '.css' );
	wp_enqueue_script( 'jquery-simple-iconpicker', get_template_directory_uri() . '/assets/js/simple-iconpicker' . busyness_min() . '.js', array( 'jquery' ), '', true );

	wp_enqueue_style( 'busyness-pro-customize-controls-css', get_template_directory_uri() . '/assets/css/customize-controls' . busyness_min() . '.css' );
	wp_enqueue_script( 'busyness-pro-customize-controls', get_template_directory_uri() . '/assets/js/customize-controls' . busyness_min() . '.js', array(), '1.0', true );
	$busyness_reset_data = array(
		'reset_message' => esc_html__( 'Refresh the customizer page after saving to view reset effects', 'busyness-pro' )
	);
	// Send list of color variables as object to custom customizer js
	wp_localize_script( 'busyness-pro-customize-controls', 'busyness_reset_data', $busyness_reset_data );
}
add_action( 'customize_controls_enqueue_scripts', 'busyness_customize_control_js' );

if ( ! function_exists( 'busyness_reset_options' ) ) :
	/**
	 * Reset all options
	 *
	 * @since Busyness Pro 1.0.0
	 *
	 * @param bool $checked Whether the reset is checked.
	 * @return bool Whether the reset is checked.
	 */
	function busyness_reset_options() {
		$options = busyness_get_theme_options();
		if ( true === $options['reset_options'] ) {
			remove_theme_mods();
	    }
	  	elseif ( $options['reset_footer'] ) {
	  		$options = get_theme_mod( 'busyness_theme_options' );

	  		unset( $options['powered_by_text'] );
		    unset( $options['copyright_text'] );
		    unset( $options['footer_social_menu'] );
		    unset( $options['scroll_top_visible'] );
		    unset( $options['reset_footer'] );

		    set_theme_mod( 'busyness_theme_options', $options );
	  	} else{
	  		return false;
	  	}
	}
endif;
add_action( 'customize_save_after', 'busyness_reset_options' );
