<?php
/**
 * Customizer default options
 *
 * @package Busyness
 * @return array An array of default values
 */

function busyness_get_default_theme_options() {
	$theme_data = wp_get_theme();
	$busyness_default_options = array(
		'header_media_image_opacity'	=> '0',

		// Color Options
		'header_title_color'			=> '#fff',
		'header_tagline_color'			=> '#fff',
		'header_txt_logo_extra'			=> 'show-all',
		'colorscheme_hue'				=> '#5031a9',
		'secondary_colorscheme_hue'		=> '#f14b59',
		'colorscheme'					=> 'default',
		'theme_version'					=> 'lite-version',

		// typography Options
		'theme_typography' 				=> 'default',
		'body_theme_typography' 		=> 'default',

		// loader
		'loader_enable'         		=> false,
		'loader_icon'         			=> 'default',

		// breadcrumb
		'breadcrumb_enable'				=> true,
		'breadcrumb_separator'			=> '/',

		// layout
		'site_layout'         			=> 'wide',
		'sidebar_position'         		=> 'right-sidebar',
		'post_sidebar_position' 		=> 'right-sidebar',
		'page_sidebar_position' 		=> 'right-sidebar',
		'menu_sticky'					=> true,

		// excerpt options
		'long_excerpt_length'           => 25,
		'read_more_text'           		=> esc_html__( 'Read More', 'busyness-pro' ),

		// pagination options
		'pagination_enable'         	=> true,
		'pagination_type'         		=> 'default',

		// footer options
		'copyright_text'           		=> sprintf( esc_html_x( 'Copyright &copy; %1$s %2$s. All rights reserved.', '1: Year, 2: Site Title with home URL', 'busyness-pro' ), '[the-year]', '[the-site-link]' ),

		'powered_by_text'				=> esc_html__( 'Busyness Pro by ', 'busyness-pro' ) . '<a target="_blank" rel="designer" href="https://wenthemes.com/">WEN Themes</a>',

		'reset_footer'      			=> false,


		'scroll_top_visible'        	=> true,
		'footer_social_menu'			=> false,


		// reset options
		'reset_options'      			=> false,

		//load fonts from cdn
		'load_font_cdn'      			=> false,

		// homepage options
		'enable_frontpage_content' 		=> true,

		// homepage sections sortable
		'sortable' 						=> 'slider,service,about,video,portfolio,team,counter,testimonial,cta,feature,blog,pricing,promotion,client',

		// blog/archive options
		'your_latest_posts_title' 		=> esc_html__( 'Blogs', 'busyness-pro' ),
		'hide_date' 					=> false,
		'hide_category'					=> false,

		// single post theme options
		'single_post_hide_date' 		=> false,
		'single_post_hide_author'		=> false,
		'single_post_hide_category'		=> false,
		'single_post_hide_tags'			=> false,

		/* Front Page */

		// topbar
		'topbar_login_register_enable'	=> false,
		'topbar_login_label'			=> esc_html__( 'Download', 'busyness-pro' ),

		// Slider
		'slider_section_enable'			=> true,
		'slider_content_type'			=> 'page',
		'slider_autoplay_enable'		=> true,
		'slider_section_social_nav_enable'	=> true,
		'slider_count'					=> 3,
		'slider_btn_label'				=> esc_html__( 'Read More', 'busyness-pro' ),
		'slider_alt_btn_label'			=> esc_html__( 'Contact Us', 'busyness-pro' ),


		// service
		'service_section_enable'		=> true,
		'service_content_type'			=> 'category',
		'service_count'					=> 3,
		'service_column'				=> 'col3',
		'service_sub_title'				=> esc_html__( 'We consider all the drivers of change from the ground up and we\'ll motivate you to make the change.', 'busyness-pro' ),
		'service_title'					=> esc_html__( 'The best business solutions', 'busyness-pro' ),
		'service_btn_title'				=> esc_html__( 'View All Services', 'busyness-pro' ),

		// About
		'about_section_enable'			=> true,
		'about_count'					=> 2,
		'about_content_type'			=> 'page',
		'about_btn_title'				=> esc_html__( 'Read More', 'busyness-pro' ),
		'about_sub_title'				=> esc_html__( 'We are true to ourselves, and commit to always perform at our best', 'busyness-pro' ),

		// Video
		'video_section_enable'			=> true,
		'video_content_type'				=> 'page',
		'video_title'						=> esc_html__( 'Discover the World of Business and Modern Design', 'busyness-pro' ),
		'video_btn_title'					=> esc_html__( 'WATCH VIDEO NOW!!', 'busyness-pro' ),

		// Portfolio
		'portfolio_section_enable'		=> true,
		'portfolio_content_type'		=> 'page',
		'portfolio_count'				=> 8,
		'portfolio_autoplay_enable'		=> false,
		'portfolio_sub_title'			=> esc_html__( 'We consider all the drivers of change from the ground up and we\'ll motivate you to make the change.', 'busyness-pro' ),
		'portfolio_title'				=> esc_html__( 'Our Best Portfolio', 'busyness-pro' ),
		'portfolio_btn_title'			=> esc_html__( 'View all porfolio', 'busyness-pro' ),

		//team
		'team_section_enable'			=> true,
		'team_content_type'				=> 'page',
		'team_count'					=> 4,
		'team_btn_title'				=> esc_html__( 'More Info', 'busyness-pro' ),
		'team_title'					=> esc_html__( 'Our Creative Team', 'busyness-pro' ),
		'team_sub_title'				=> esc_html__( 'We consider all the drivers of change from the ground up and we\'ll motivate you to make the change.', 'busyness-pro' ),

		// counter
		'counter_section_enable'		=> true,
		'counter_count'					=> 4,
		'counter_column'				=> 'col4',

		// testimonial
		'testimonial_section_enable'	=> true,
		'testimonial_content_type'		=> 'category',
		'testimonial_count'				=> 4,
		'testimonial_sub_title'			=> esc_html__( 'We consider all the drivers of change from the ground up and we\'ll motivate you to make the change.', 'busyness-pro' ),
		'testimonial_title'				=> esc_html__( 'Our Creative Team', 'busyness-pro' ),

		// call to action
		'cta_section_enable'			=> true,
		'cta_content_type'				=> 'page',
		'cta_title'						=> esc_html__( 'For the Next Generation', 'busyness-pro' ),
		'cta_btn_title'					=> esc_html__( 'Call To Action', 'busyness-pro' ),
		'cta_description'				=> esc_html__( 'Our clients entrust us to solve difficult problems in a manner that is secure and confidential from our first contact with them. Trust is the first attribute our clients recognize when we discuss solutions rather than problems.', 'busyness-pro' ),

		//feature
		'feature_section_enable'		=> true,
		'feature_content_type'			=> 'page',
		'feature_count'					=> 8,
		'feature_title'					=> esc_html__( 'Our Key Features', 'busyness-pro' ),
		'feature_sub_title'				=> esc_html__( 'We consider all the drivers of change from the ground up and we\'ll motivate you to make the change.', 'busyness-pro' ),

		// blog
		'blog_section_enable'			=> true,
		'blog_content_type'				=> 'recent',
		'blog_column'					=>'col3',
		'blog_count'					=> 3,
		'blog_title'					=> esc_html__( 'Check Our Latest Blog', 'busyness-pro' ),
		'blog_sub_title'				=> esc_html__( 'We consider all the drivers of change from the ground up and we\'ll motivate you to make the change.', 'busyness-pro' ),

		//pricing
		'pricing_section_enable'		=> true,
		'pricing_count'					=> 3,
		'pricing_title'					=> esc_html( 'Our Best Pricing', 'busyness-pro' ),
		'pricing_sub_title'				=> esc_html( 'We consider all the drivers of change from the ground up and we\'ll motivate you to make the change.', 'busyness-pro' ),

		//promotion
		'promotion_section_enable'		=> true,
		'promotion_title'				=> esc_html__( 'Start Your Business Now!', 'busyness-pro' ),
		'promotion_description'				=> esc_html__( 'Start Your Business Now!', 'busyness-pro' ),
		'promotion_btn_title'			=> esc_html__( 'Start Now!', 'busyness-pro' ),
		'promotion_content_type'		=> 'page',

		//client
		'client_section_enable'			=> true,
		'client_count'					=> 6,





	);

	$output = apply_filters( 'busyness_default_theme_options', $busyness_default_options );

	// Sort array in ascending order, according to the key:
	if ( ! empty( $output ) ) {
		ksort( $output );
	}

	return $output;
}
